<?php
/* -*- mode: php; tab-width: 4; indent-tabs-mode: t; coding: utf-8 -*- */

/**
 * vbulletin add-on fussball-tippspiele
 *
 * php version 5
 * vbulletin version >= 4.0.2
 *         _
 *  __   _| |__  ___  ___   ___ ___ ___ _ __
 *  \ \ / / '_ \/ __|/ _ \ / __/ __/ _ \ '__|
 *   \ V /| |_) \__ \ (_) | (_| (_|  __/ |
 *    \_/ |_.__/|___/\___/ \___\___\___|_|
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @author  xwing <xwing@geb-team.de>
 * @version SVN: $Id: vbsoccer.php 5 2010-05-15 23:32:06Z aa $
 */

// ######################## SET PHP ENVIRONMENT ################################
error_reporting(E_ALL & ~E_NOTICE & ~8192);

// ####################### DEFINE IMPORTANT CONSTANTS ##########################
/** @var string */
define('THIS_SCRIPT', 'vbsoccer');

/** @var bool */
define('CSRF_PROTECTION', true);

/** @var string */
define('VB_ENTRY', 'vbsoccer.php');

// ###################### PRE-CACHE TEMPLATES AND DATA #########################
// get special phrase groups
$phrasegroups = array('vbsoccer', 'vbsoccernames');

if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'settings')
{
	$phrasegroups[] = 'vbsoccerup';
}

// get special data templates from the datastore
$specialtemplates = array('vbsoccer_leaguecache');

// pre-cache templates used by all actions
$globaltemplates = array(
	'vbsoccer.css',
	'usercp.css',
	'vbsoccer_shell',
	'vbsoccer_league_menu_bit',
	'optgroup',
	'vbsoccer_leaguebit',
	'ad_vbsoccer_first',
	'ad_vbsoccer_sidebar_start',
	'ad_vbsoccer_sidebar_end',
	'ad_vbsoccer_below_content',
	'vbsoccer_navtab_bit',
	'vbsoccer_leaguegroup_menu_bit',
	);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'schedule' => array(
		'vbsoccer_schedule',
		'vbsoccer_matchbit',
		'vbsoccer_betinput',
		'vbsoccer_matches_head',
		'vbsoccer_leaguefooter',
		'vbsoccer_betbit',
		),
	'bet' => array(
		'vbsoccer_bet',
		'vbsoccer_matchbit',
		'vbsoccer_matches_head',
		'vbsoccer_betinput',
		'vbsoccer_betbit',
		'vbsoccer_matchgroupbit',
		'vbsoccer_leaguefooter',
		),
	'tab' => array(
		'vbsoccer_tab',
		'vbsoccer_tab_standard_bit',
		'vbsoccer_tab_standard_head',
		'vbsoccer_tab_cross_head',
		'vbsoccer_tab_cross_head_bit',
		'vbsoccer_tab_cross_results_bit',
		'vbsoccer_tab_cross_results',
		'vbsoccer_matchgroupbit',
		'vbsoccer_leaguefooter',
		),
	'settings' => array(
		'vbsoccer_settings',
		'vbsoccer_league_abo_bit',
		'vbsoccer_prefs_headinclude',
		'vbsoccer_prefs_pointcolor_bit',
		'colorpicker.css',
		),
	'ranking' => array(
		'vbsoccer_ranking',
		'vbsoccer_rankingbit',
		'vbsoccer_rankinghead',
		'vbsoccer_leaguefooter',
		),
	'live' => array(
		'vbsoccer_live',
		'vbsoccer_livebit',
		'vbsoccer_resultinput',
		'vbsoccer_resultlogbit',
		'forumdisplay_loggedinuser',
		'vbsoccer_betbit',
		),
	'report' => array(
		'newpost_usernamecode',
		'vbsoccer_reportitem',
		),
	'matchinfo' => array(
		'vbsoccer_matchinfo',
		'vbsoccer_matches_head',
		'vbsoccer_matchbit',
		'vbsoccer_betbit',
		'vbsoccer_betinput',
		'vbsoccer_stats_nomatches',
		'vbsoccer_leaguefooter',
		),
	'reportranking' => array(
		'vbsoccer_reportranking',
		'vbsoccer_reportrankingbit',
		),
	'overallranking' => array(
		'vbsoccer_overallranking',
		'vbsoccer_overallrankingbit',
		'vbsoccer_overallrankinghead',
		'forumdisplay_sortarrow',
		),
	'hall_of_fame' => array(
		'vbsoccer_halloffamesaisonbit',
		'vbsoccer_halloffamebit',
		'vbsoccer_halloffame',
		),
	'forumblock' => array(
		'block_vbsoccer_rankings',
		'block_vbsoccer_table',
		),
	);

$actiontemplates['crosstab'] =& $actiontemplates['tab'];

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'schedule';
}

// ########################## REQUIRE BACK-END #################################
/** vbulletin back-end */
require './global.php';

// custom-css
if (!isset($includecss) or empty($includecss))
{
	$includecss = array();
}

if (!empty($vbulletin->options['storecssasfile']))
{
	$includecss[] = 'vbsoccer-rollup';
}
else
{
	if (empty($header))
	{
		// headinclude wurde noch nicht gerendert. templatehook kann genutzt werden!
		if (empty($GLOBALS['template_hook']['custom_css_list']))
		{
			$GLOBALS['template_hook']['custom_css_list'] = '';
		}

		$GLOBALS['template_hook']['custom_css_list'] .= ',usercp.css';

		if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'settings')
		{
			$GLOBALS['template_hook']['custom_css_list'] .= ',colorpicker.css';
		}

		$GLOBALS['template_hook']['custom_css_list'] .= ',vbsoccer.css';
	}
	else
	{
		// headinclude wurde schon nicht gerendert. templatehook kann NICHT genutzt werden!
		$includecss[] = 'usercp';
		if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'settings')
		{
			$includecss[] = 'colorpicker';
		}
		$includecss[] = 'vbsoccer';
	}
}

if (empty($vbulletin->products['vbsoccer']))
{
	exec_header_redirect($vbulletin->options['forumhome'] . '.php');
}

$vbulletin->vbsoccer = array();
$onload = '';

if (!$vbulletin->options['enablehooks'] OR defined('DISABLE_HOOKS'))
{
	standard_error(fetch_error('product_requires_plugin_system'));
}

$vbsoccerperms =& $vbulletin->bf_ugp['vbsoccer_general_permissions'];

/** vbsoccer funktionen */
require_once DIR . '/includes/functions_vbsoccer.php';

($hook = vBulletinHook::fetch_hook('vbsoccer_start')) ? eval($hook) : false;

if (!empty($_POST['ajax']) AND $_POST['do'] == 'forumblock')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'l'         => TYPE_UINT,
		'entrytype' => TYPE_UINT,
		));

	$output = '';
	switch ($vbulletin->GPC['entrytype'])
	{
		case 1:
		case 2:
		case 3:
			$output = fetch_soccerblock_saison_rankings(array('id' => $vbulletin->GPC['l']), $vbulletin->GPC['entrytype']);
			break;
		case 4:
		case 5:
		case 6:
			$output  = fetch_soccerblock_saison_rankings(array('id' => $vbulletin->GPC['l']), $vbulletin->GPC['entrytype']);
			$output .= fetch_soccerblock_saison_table($vbulletin->GPC['l']);
			break;
		case 7:
			$output = fetch_soccerblock_saison_table($vbulletin->GPC['l']);
	}

	echo $output;
	exit;
}

// eingerichtetes vbsoccer-forum ermitteln und 'canview'-rechte dafuer pruefen
foreach ($vbulletin->forumcache AS &$forumvalue)
{
	if (empty($forumvalue['link']))
	{
		continue;
	}

	if (strpos($forumvalue['link'], 'vbsoccer.php') !== false)
	{
		$forumperms = fetch_permissions($forumvalue['forumid']);

		if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']))
		{
			print_no_permission();
		}

		// get forum info
		$forum = fetch_foruminfo($forumvalue['forumid']);
		$foruminfo =& $forum;

		break; // das erste gefundene als tippspiel verwendete forum wird benutzt!
	}
}

if (empty($foruminfo))
{
	// kein eingerichtetes forum gefunden, vbsoccer-gruppenrechte 'canview' pruefen
	if (!($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canview']))
	{
		print_no_permission();
	}
}

if (!empty($foruminfo['password']))
{
	verify_forum_password($foruminfo['forumid'], $foruminfo['password']);
}

$vbulletin->options['vbsoccer_points'] = @unserialize($vbulletin->options['vbsoccer_points']);

if (!$vbulletin->options['vbsoccer_points'])
{
	// kein punktesystem gefunden
	standard_error(fetch_error('soccer_misconfiguration_pointsystem'));
}

// #############################################################################
$vbsoccerDefaults = array();
$pointcolorkeys = array('nb', 'wr', 'rw', 'rd', 'rr');

foreach ($pointcolorkeys AS &$key)
{
	$vbsoccerDefaults['color'][$key] = vB_Template_Runtime::fetchStyleVar('vbsoccer_points_' . $key . '_color.color');
}

$vbsoccerDefaults['smallfont']   = (bool) $vbulletin->options['vbsoccer_smallfont'];
$vbsoccerDefaults['schedstyle']  = $vbulletin->options['vbsoccer_schedstyle'];

if (!is_null($vbulletin->userinfo['vbsoccerprefs']))
{
	$vbulletin->userinfo['vbsoccerprefs'] = @unserialize($vbulletin->userinfo['vbsoccerprefs']);
	if (isset($vbulletin->userinfo['vbsoccerprefs']['color']))
	{
		$vbulletin->userinfo['vbsoccerprefs']['color'] = array_merge($vbsoccerDefaults['color'], $vbulletin->userinfo['vbsoccerprefs']['color']);
	}
	$vbulletin->userinfo['vbsoccerprefs'] = array_merge($vbsoccerDefaults, $vbulletin->userinfo['vbsoccerprefs']);

	foreach ($pointcolorkeys AS &$key)
	{
		vB_Template_Runtime::addStyleVar('vbsoccer_points_' . $key . '_color', $vbulletin->userinfo['vbsoccerprefs']['color'][$key]);
	}
}
else
{
	$vbulletin->userinfo['vbsoccerprefs'] = $vbsoccerDefaults;
}

unset($vbsoccerDefaults, $pointcolorkeys);

$show['mainfontclass'] = !empty($vbulletin->userinfo['vbsoccerprefs']['smallfont']) ? ' smallfont' : '';

$notsubscribed = array();

// #############################################################################
if (isset($_POST['do']) AND $_POST['do'] == 'updateoptions')
{
	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'pref'       => TYPE_ARRAY_ARRAY,
		'option'     => TYPE_ARRAY_ARRAY,
		'emailabo'   => TYPE_UINT,
		'notify'     => TYPE_BOOL,
		'smallfont'  => TYPE_BOOL,
		'schedstyle' => TYPE_BOOL,
		));

	$prefArray = array();

	if (isset($vbulletin->GPC['option']['l']) AND is_array($vbulletin->GPC['option']['l']))
	{
		foreach (array_keys($vbulletin->GPC['option']['l']) AS $l)
		{
			if (!isset($vbulletin->GPC['pref']['l'][$l]))
			{
				$prefArray['lhide'][] = $l;
			}
		}
	}

	if (isset($vbulletin->GPC['pref']['c']) AND is_array($vbulletin->GPC['pref']['c']))
	{
		foreach ($vbulletin->GPC['pref']['c'] AS $colorcode => $value)
		{
			if (!isset($vbulletin->userinfo['vbsoccerprefs']['color'][(string) $colorcode]))
			{
				// unbekannter farbschluessel!
				continue;
			}

			if (preg_match("/^(#[a-f0-9]{6}|#[a-f0-9]{3})$/i", trim($value), $match))
			{
				// farbcode fuer legende etc
				$prefArray['color'][$colorcode] = trim($match[1]);
			}
			else
			{
				require_once DIR . '/includes/html_color_names.php';
				$value = strtolower(trim($value));

				if (isset($html_color_names[$value]))
				{
					$prefArray['color'][$colorcode] = $value;
				}
			}
		}
	}

	$prefArray['smallfont']  = $vbulletin->GPC['smallfont'];
	$prefArray['schedstyle'] = $vbulletin->GPC['schedstyle'];

	// init user data manager
	$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
	$userdata->set_existing($vbulletin->userinfo);
	$userdata->set('vbsoccerprefs', serialize($prefArray));
	$userdata->set('vbsoccerunbet', '');
	$userdata->set('vbsoccernotify', (int) $vbulletin->GPC['notify']);
	$userdata->save();

	// email-abonnements
	if ($vbulletin->GPC['emailabo'] == 0)
	{
		$vbulletin->db->query_write("
			DELETE FROM `" . TABLE_PREFIX . "soccer_league_subscribe`
			WHERE `userid`=" . $vbulletin->userinfo['userid'] . "
			");
	}
	else
	{
		$vbulletin->db->query_write("
			INSERT INTO `" . TABLE_PREFIX . "soccer_league_subscribe`
			SET `userid`=" . $vbulletin->userinfo['userid'] . ",
				`abo_type`=" . (int) $vbulletin->GPC['emailabo'] . "
			ON DUPLICATE KEY UPDATE
				`abo_type`=" . (int) $vbulletin->GPC['emailabo'] . "
			");
	}

	// weiterleitung zur einstellungsseite
	$vbulletin->options['useheaderredirect'] = false;
	$vbulletin->url = $vbulletin->script . '?' . $vbulletin->session->vars['sessionurl'] . 'do=settings';
	eval(print_standard_redirect("soccer_setprefs_successfully"));
}

// #############################################################################

if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'sdupdate')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'l'       => TYPE_UINT,
		'm'       => TYPE_UINT,
		'matchid' => TYPE_UINT,
		'redo'    => TYPE_NOHTML,
		));

	if (!$vbulletin->userinfo['userid'] OR !isset($vbulletin->vbsoccer_leaguecache[$vbulletin->GPC['l']]))
	{
		print_no_permission();
	}

	/** soccerclient functions */
	require_once DIR . '/includes/vbsoccer_services.php';

	$services = new vbsoccer_Services($vbulletin);
	$services->check_fixtures($vbulletin->vbsoccer_leaguecache[$vbulletin->GPC['l']]['sd_id']);
	unset($services);

	$urlparams = array(
		'do'      => ($vbulletin->GPC['redo'] != 'schedule' ? $vbulletin->GPC['redo'] : ''),
		's'       => (!empty($vbulletin->session->vars['sessionurl']) ? $vbulletin->session->vars['dbsessionhash'] : ''),
		'l'       => $vbulletin->GPC['l'],
		'm'       => $vbulletin->GPC['m'],
		'matchid' => $vbulletin->GPC['matchid'],
		);

	exec_header_redirect(sprintf('%s?%s', $vbulletin->script, urlimplode($urlparams, true, true)));
}


// #############################################################################
if (isset($_POST['do']) AND $_POST['do'] == 'liveupdate')
{
	if (!($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canpostresults']) OR
		!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'r'    => TYPE_ARRAY_ARRAY,
		'ctrl' => TYPE_ARRAY_ARRAY,
		'fin'  => TYPE_ARRAY_BOOL,
		));

	if (empty($vbulletin->GPC['ctrl']['home']) OR
		empty($vbulletin->GPC['r']['home']) OR
		!is_array($vbulletin->GPC['ctrl']['home']) OR
		!is_array($vbulletin->GPC['r']['home']))
	{
		exit;
	}

	$matchids = array();

	foreach ($vbulletin->GPC['ctrl']['home'] AS $id => $val)
	{
		if (!isset($vbulletin->GPC['r']['home'][$id]) OR
			!isset($vbulletin->GPC['r']['away'][$id]) OR
			!isset($vbulletin->GPC['ctrl']['away']))
		{
			// baeh! kein regulaeres formular abgesendet. eintrag ignorieren
			continue;
		}

		if ($vbulletin->GPC['r']['home'][$id] == $val AND
			$vbulletin->GPC['r']['away'][$id] == $vbulletin->GPC['ctrl']['away'][$id])
		{
			if ((isset($vbulletin->GPC['fin'][$id]) AND $vbulletin->GPC['ctrl']['fin'][$id] == 1)
				OR (empty($vbulletin->GPC['fin'][$id]) AND $vbulletin->GPC['ctrl']['fin'][$id] == 0))
			{
				// keine aenderungen in den feldern (incl. abpfiff-status)
				continue;
			}
		}

		$matchids[] = (int) $id;
	}

	if (!empty($matchids))
	{
		$userlogs = $vbulletin->db->query_read_slave("
			SELECT `id`, `result`, `finished`, `match_id`
			FROM `" . TABLE_PREFIX . "soccer_postresult_log`
			WHERE `userid`=" . $vbulletin->userinfo['userid'] . "
				AND `match_id` IN(" . implode(',', $matchids) . ")
			");

		$postloghistory = array();

		while (($userlog = $vbulletin->db->fetch_array($userlogs)))
		{
			$postloghistory[$userlog['match_id']] = $userlog;
		}

		$vbulletin->db->free_result($userlogs);

		// alle zu aendernden spiele auslesen
		// ergebnis von spielen ohne ergebnis (-1) auf leeren string setzen
		$matches = $vbulletin->db->query_read_slave("
			SELECT *,
				IF(`points_home`=-1, '', `points_home`) AS `points_home`,
				IF(`points_away`=-1, '', `points_away`) AS `points_away`
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE `id` IN(" . implode(',', $matchids) . ")
			");

		unset($matchids);
		$changes = $changedleagues = array();

		// abbruch durch anwender ignorieren
		@ignore_user_abort(true);

		while (($match = $vbulletin->db->fetch_array($matches)))
		{
			if (TIMENOW < $match['dateline'])
			{
				// oeh?! spiel laeuft doch noch gar nicht?!
				continue;
			}

			if (!isset($vbulletin->vbsoccer_leaguecache['current'][$match['league_id']]))
			{
				// spiel ist nicht in einer aktuellen saison (archiv?)
				continue;
			}

			if (!isset($vbulletin->GPC['r']['home'][$match['id']]) OR
				!isset($vbulletin->GPC['r']['away'][$match['id']]))
			{
				// formularfelder nicht vollstaendig
				continue;
			}

			if ($vbulletin->GPC['r']['home'][$match['id']] == $match['points_home'] AND
				$vbulletin->GPC['r']['away'][$match['id']] == $match['points_away'] AND
				(isset($vbulletin->GPC['fin'][$match['id']]) AND $match['match_is_finished'] == 2))
			{
				// ergebnis und spiel-ende unveraendert.
				continue;
			}

			if (trim($vbulletin->GPC['r']['home'][$match['id']]) == '' OR
				trim($vbulletin->GPC['r']['away'][$match['id']]) == '')
			{
				// ist nur eines von beiden feldern leer?
				if (trim($vbulletin->GPC['r']['home'][$match['id']]) != trim($vbulletin->GPC['r']['away'][$match['id']]))
				{
					// ergebnis-meldung unvollstaendig (beide felder muessen
					// ausgefuellt sein. ein feld ist jedoch leer). ignorieren.
					continue;
				}

				if ($match['points_home'] == '' AND $match['points_away'] == '')
				{
					// kein ergebnis vorhanden fuer das spiel. da der anwender
					// nichts eingegeben hat: ignorieren statt automatisch 0:0
					// immerhin besteht die moeglichkeit, dass das spiel ver-
					// schoben wurde, aber dies vom datendienst nocht nicht ge-
					// updatet wurde.
					continue;
				}

				if (trim($vbulletin->GPC['ctrl']['home'][$match['id']]) == '' OR
					trim($vbulletin->GPC['ctrl']['away'][$match['id']]) == '')
				{
					// keine aenderung zu den kontrollfeldern. eingabe ignorieren
					continue;
				}

				// hier aus dem leeren string ein -1 machen, sonst wird das ein 0:0
				$vbulletin->GPC['r']['home'][$match['id']] = -1;
				$vbulletin->GPC['r']['away'][$match['id']] = -1;
			}

			// werte zum versand an datendienst merken
			$changes['home'][(int) $match['sd_id']] = (int) $vbulletin->GPC['r']['home'][$match['id']];
			$changes['away'][(int) $match['sd_id']] = (int) $vbulletin->GPC['r']['away'][$match['id']];
			$changes['fin'][(int) $match['sd_id']]  = isset($vbulletin->GPC['fin'][$match['id']]) ? 1 : 0;

			$vbulletin->db->query_write("
				UPDATE `" . TABLE_PREFIX . "soccer_match`
				SET `points_home`=" . (int) $vbulletin->GPC['r']['home'][$match['id']] . ",
					`points_away`=" . (int) $vbulletin->GPC['r']['away'][$match['id']] . ",
					`last_update_timestamp`=" . TIMENOW . ",
					`score_key`=CASE
						WHEN `points_home`=-1 AND `points_away`=-1 THEN 0
						WHEN `points_home`=`points_away` THEN 2
						WHEN `points_home`>`points_away` THEN 1
						WHEN `points_home`<`points_away` THEN 3
					END, `match_is_finished`=" . (isset($vbulletin->GPC['fin'][$match['id']]) ? 2 : 0) . "
				WHERE `id`=" . $match['id'] . "
				");

			// postlog
			$postresult = $vbulletin->GPC['r']['home'][$match['id']] . ':' . $vbulletin->GPC['r']['away'][$match['id']];

			$changedleagues[$match['league_id']] = $match['league_id'];

			if ($vbulletin->GPC['r']['home'][$match['id']] == $match['points_home'] AND
				$vbulletin->GPC['r']['away'][$match['id']] == $match['points_away'])
			{
				continue;
			}

			$ipaddress = ($vbulletin->options['logip'] ? IPADDRESS : '');

			if (isset($postloghistory[$match['id']]))
			{
				// anwender hat bereits eine meldung zu diesem spiel gemacht
				if ($postloghistory[$match['id']]['result'] == $postresult AND
					$postloghistory[$match['id']]['finished'] == (int) $vbulletin->GPC['fin'][$match['id']])
				{

					// ergebnis und spiel-ende wurden bereits gemeldet.
					// hier nur den zeitstempel aktualisieren
					$postresultresult = $vbulletin->db->query_write("
						UPDATE `" . TABLE_PREFIX . "soccer_postresult_log`
						SET `dateline`=" . TIMENOW . ",
							`ipaddress`='" . $vbulletin->db->escape_string($ipaddress) . "'
						WHERE `id`=" . $postloghistory[$match['id']]['id'] . "
						");

					continue;
				}
			}

			$postresultresult = $vbulletin->db->shutdown_query("
				INSERT INTO `" . TABLE_PREFIX . "soccer_postresult_log`
				SET
					`userid`   =" . $vbulletin->userinfo['userid'] . ",
					`match_id` =" . $match['id'] . ",
					`dateline` =" . TIMENOW . ",
					`result`   ='" . $vbulletin->db->escape_string($postresult) . "',
					`finished` =" . (int) $vbulletin->GPC['fin'][$match['id']] . ",
					`ipaddress`='" . $vbulletin->db->escape_string($ipaddress) . "'
				");

			if ($vbulletin->db->affected_rows($postresultresult))
			{
				$vbulletin->db->shutdown_query("
					INSERT INTO `" . TABLE_PREFIX . "soccer_postresult_stats`
					SET
						`userid`    =" . $vbulletin->userinfo['userid'] . ",
						`league_id` =" . $match['league_id'] . ",
						`count`     =1,
						`lastupdate`=" . TIMENOW . "
					ON DUPLICATE KEY UPDATE
						`userid`    =" . $vbulletin->userinfo['userid'] . ",
						`league_id` =" . $match['league_id'] . ",
						`count`     =`count`+1,
						`lastupdate`=" . TIMENOW . "
					");
			}
		} // end while

		$vbulletin->db->free_result($matches);

		try
		{
			require_once DIR . '/includes/vbsoccer_services.php';
			$services = new vbsoccer_Services($vbulletin);
			$services->updateMatches($changes);
		}
		catch (Exception $e)
		{
			// nothing
		}
	}

	if (!empty($changedleagues))
	{
		if (!$servicesClient)
		{
			require_once DIR . '/includes/vbsoccer_services.php';
			$services = new vbsoccer_Services($vbulletin);
		}

		$services->check_livescores();

		unset($services);
	}

	$vbulletin->url = 'vbsoccer.php?'
	                . $vbulletin->session->vars['sessionurl']
	                . 'do=live';

	$vbulletin->options['useheaderredirect'] = true;
	eval(print_standard_redirect('redirect_soccer_sdupdate_successfully'));
}


// #############################################################################
if (isset($_POST['do']) AND $_POST['do'] == 'dobet')
{
	if (!($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canbet'])
		OR !$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'b'       => TYPE_ARRAY_ARRAY,
		'l'       => TYPE_UINT,
		'm'       => TYPE_UINT,
		'redo'    => TYPE_STR,
		'list'    => TYPE_UINT,
		'matchid' => TYPE_UINT,
		));

	if (empty($vbulletin->GPC['b']['home']) OR empty($vbulletin->GPC['b']['away']))
	{
		// TODO fehlermeldung
		exit;
	}

	// anzeige von nachricht beim weiterleiten erzwingen
	$vbulletin->options['useheaderredirect'] = false;

	@ignore_user_abort(true);

	foreach ($vbulletin->GPC['b']['home'] AS $matchid => $value)
	{
		if (!isset($vbulletin->GPC['b']['away'][$matchid]))
		{
			// tipp unvollstaendig. es muessen beide felder ausgefuellt sein.
			// diesen eintrag ignorieren und ueberspringen
			continue;
		}

		$betHome = trim($value);
		$betAway = trim($vbulletin->GPC['b']['away'][$matchid]);

		// spielansetzung gueltig und tippen noch erlaubt?

		if (!($matchinfo = $vbulletin->db->query_first("
			SELECT *
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE `id`=" . (int) $matchid . "
			")))
		{
			// spiel ist nicht vorhanden! ueberspringen
			continue;
		}

		if (!isset($vbulletin->vbsoccer_leaguecache['current'][$matchinfo['league_id']]))
		{
			// spiel ist nicht in einer aktuellen saison (archiv?)
			continue;
		}

		if (!empty($vbulletin->vbsoccer_leaguecache[$matchinfo['league_id']]['readonly']))
		{
			// spiel darf nicht getippt werden (readonly)
			continue;
		}

		if (TIMENOW > $matchinfo['dateline'])
		{
			// aenderungen nicht mehr erlaubt nach spielbeginn
			continue;
		}

		if ((!preg_match('/^\d+$/', $betHome) OR $betHome == '') OR
			(!preg_match('/^\d+$/', $betAway) OR $betAway == ''))
		{
			// tipp war ungueltig oder wurde entfernt. eintrag loeschen.
			$vbulletin->db->query_write("
				DELETE FROM `" . TABLE_PREFIX . "soccer_user_bet`
				WHERE `userid`=" . $vbulletin->userinfo['userid'] . "
					AND `match_id`=" . (int) $matchid . "
				");

			continue;
		}

		// TODO ersetzen durch sql-case-statements
		$bet_score_key = fetch_soccer_score_key($betHome, $betAway);

		// tipp eintragen oder aktualisieren
		$vbulletin->db->query_write("
			INSERT INTO `" . TABLE_PREFIX . "soccer_user_bet`
			SET `userid`=" . $vbulletin->userinfo['userid'] . ",
				`match_id`=" . (int) $matchid . ",
				`bet_home`=" . (int) $betHome . ",
				`bet_away`=" . (int) $betAway . ",
				`bet_score_key`=" . (int) $bet_score_key . "
			ON DUPLICATE KEY UPDATE
				`bet_home`=" . (int) $betHome . ",
				`bet_away`=" . (int) $betAway . ",
				`bet_score_key`=" . (int) $bet_score_key . "
			");
	}

	if ($vbulletin->userinfo['vbsoccernotify'])
	{
		$vbulletin->db->shutdown_query("
			UPDATE `" . TABLE_PREFIX . "usertextfield`
			SET `vbsoccerunbet`=''
			WHERE `userid`=" . $vbulletin->userinfo['userid'] . "
			");
	}

	$params = array('do' => 'bet');

	if ($vbulletin->GPC['redo'] == 'schedule')
	{
		unset($params['do']);

		if ($vbulletin->GPC['list'] != $vbulletin->userinfo['vbsoccerprefs']['schedstyle'])
		{
			switch ($vbulletin->GPC['list'])
			{
				case 0: $params['list'] = 'kickoff'; break;
				case 1: $params['list'] = 'grouped'; break;
				default: break;
			}
		}
	}
	elseif ($vbulletin->GPC['redo'] == 'matchinfo')
	{
		$params['do']      = 'matchinfo';
		$params['l']       = $matchinfo['league_id'];
		$params['matchid'] = $vbulletin->GPC['matchid'];
	}

	if ($vbulletin->GPC['l'] > 0)
	{
		$params['l'] = $vbulletin->GPC['l'];
	}

	if ($vbulletin->GPC['m'] > 0)
	{
		$params['m'] = $vbulletin->GPC['m'];
	}

	$uri = http_build_query($params);

	$vbulletin->url = 'vbsoccer.php'
	                . ($uri != ''
	                ? '?' . $vbulletin->session->vars['sessionurl'] . $uri
	                : ((!empty($vbulletin->session->vars['sessionurl'])
	                ? '?' . $vbulletin->session->vars['sessionurl']
	                : '')));

	eval(print_standard_redirect('redirect_soccer_setresult_successfully'));
}


// #############################################################################
$vbulletin->input->clean_gpc('r', 'l', TYPE_UINT);

if (!empty($vbulletin->GPC['l']))
{
	if (!isset($vbulletin->vbsoccer_leaguecache[$vbulletin->GPC['l']]))
	{
		standard_error(fetch_error('invalidid', 'league', $vbulletin->options['contactuslink']));
	}
}

// liga-eintraege fuer main-menue
$league_menu_bits = $league_readonly_menu_bits = '';

if (empty($vbulletin->vbsoccer_leaguecache))
{
	$vbulletin->vbsoccer_leaguecache = array(
		'current' => array(),
		'archiv'  => array(),
		);
}

$leaguegroups = array();

$tplObj = new stdClass;
$tplObj->vbsoccer_league_menu_bit      = vB_Template::create('vbsoccer_league_menu_bit');
$tplObj->vbsoccer_leaguegroup_menu_bit = vB_Template::create('vbsoccer_leaguegroup_menu_bit');

foreach ($vbulletin->vbsoccer_leaguecache['current'] AS $leagueid)
{
	$leagueinfo = $vbulletin->vbsoccer_leaguecache[$leagueid];

	if (!empty($vbulletin->userinfo['vbsoccerprefs']['lhide']))
	{
		if (in_array(strtolower($leagueinfo['sd_shortname']), $vbulletin->userinfo['vbsoccerprefs']['lhide']))
		{
			continue;
		}
	}

	$tplObj->vbsoccer_league_menu_bit->quickRegister(array(
		'leagueinfo'  => $leagueinfo,
		'region'      => strtolower($leagueinfo['region']),
		'league_name' => $leagueinfo['phrase'],
		'navclass'    => (($vbulletin->GPC['l'] == $leagueid AND in_array($_REQUEST['do'], array('bet', 'tab', 'crosstab', 'matchinfo', 'report'))) ? 'active' : 'inactive')
		));

	if (!empty($leagueinfo['readonly']))
	{
		$leagueinfo['groupid'] = -1;
	}

	$leaguegroups[$leagueinfo['groupid']][] = $tplObj->vbsoccer_league_menu_bit->render();
}

$cpnav = array('readonly' => '', 'current' => '');

foreach ($leaguegroups AS $groupid => $leaguenavs)
{
	$group = 'current';

	switch ($groupid)
	{
		case -1:
			$navgroupnamephrase = 'soccer_current_readonly_saison';
			$group = 'readonly';
			break;
		case 0:
			$navgroupnamephrase = 'soccer_current_saison';
			break;
		default:
			$navgroupnamephrase = 'soccer_navgroup_' . $groupid;
	}

	$tplObj->vbsoccer_leaguegroup_menu_bit->quickRegister(array(
		'navgroup_name' => htmlspecialchars_uni($vbphrase[(string) $navgroupnamephrase]),
		'leaguebits'    => implode("\n", $leaguenavs),
		));

	$cpnav[(string) $group] .= $tplObj->vbsoccer_leaguegroup_menu_bit->render();
}

unset($tplObj->vbsoccer_leaguegroup_menu_bit, $tplObj->vbsoccer_league_menu_bit);

if (isset($leagueinfo))
{
	unset($leagueinfo, $leaguegroups);
}


// #############################################################################
if ((isset($_REQUEST['do']) AND $_REQUEST['do'] == 'report') OR
	(isset($_POST['do']) AND $_POST['do'] == 'submitreport'))
{
	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	/** reportfunktionen */
	require DIR . '/includes/class_reportitem_vbsoccer.php';

	$leagueinfo = array();

	if ($vbulletin->GPC['l'])
	{
		$leagueinfo = $vbulletin->vbsoccer_leaguecache[$vbulletin->GPC['l']];
	}

	$reportobj = new vB_ReportItem_vbsoccer($vbulletin);
	$perform_floodcheck = $reportobj->need_floodcheck();
	$iteminfo = array('league' => $leagueinfo);
	$forminfo = $reportobj->set_forminfo($iteminfo);

	if ($perform_floodcheck)
	{
		$reportobj->perform_floodcheck_precommit();
	}

	if ($_REQUEST['do'] == 'report')
	{
		/** editor funktionen */
		require DIR . '/includes/functions_editor.php';

		$templatename = 'vbsoccer_reportitem';

		vB_Template::preRegister($templatename, array(
			'forminfo'     => $forminfo,
			'iteminfo'     => $iteminfo,
			'url'          => '',
			'usernamecode' => vB_Template::create('newpost_usernamecode')->render(),
			'headtitle'    => $forminfo['itemname'],
			));
	}

	if ($_POST['do'] == 'submitreport')
	{

		$vbulletin->input->clean_array_gpc('p', array(
			'reason' => TYPE_STR,
		));

		if ($vbulletin->GPC['reason'] == '')
		{
			eval(standard_error(fetch_error('soccer_noreason')));
		}

		if ($perform_floodcheck)
		{
			$reportobj->perform_floodcheck_commit();
		}


		$reportobj->do_report($vbulletin->GPC['reason'], $iteminfo);

		$vbulletin->url = 'vbsoccer.php' . $vbulletin->session->vars['sessionurl_q'];
		eval(print_standard_redirect('redirect_reportthanks'));
	}
}


// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'settings')
{
	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$headtitle = $vbphrase['soccer_settings_and_options'];

	$templater = vB_Template::create('vbsoccer_prefs_headinclude');
	$templater->register('usercss_string', $usercss_string);
	$headinclude .= $templater->render();

	$league_abo_bits = '';

	// email-abonnement
	$emailabo = array('type0' => '', 'type1' => '', 'type2' => '');

	if (($abonnements = $vbulletin->db->query_first("
		SELECT `userid`, `abo_type`
		FROM `" . TABLE_PREFIX . "soccer_league_subscribe`
		WHERE `userid`=" . $vbulletin->userinfo['userid'] . "
		")))
	{
		if ($abonnements['abo_type'] == 1)
		{
			$emailabo['type1'] = ' checked="checked"';
		}
		else
		{
			$emailabo['type2'] = ' checked="checked"';
		}
	}
	else
	{
		$emailabo['type0'] = ' checked="checked"';
	}

	// liga-abonnement
	$leaguetypes = array();
	$templater = vB_Template::create('vbsoccer_league_abo_bit');

	foreach ($vbulletin->vbsoccer_leaguecache AS $leagueid => $leagueinfo)
	{
		if (in_array($leagueid, array('current', 'archiv')))
		{
			continue;
		}

		if (isset($leaguetypes[$leagueinfo['phrase']]))
		{
			continue;
		}

		$leaguetypes[$leagueinfo['phrase']] = true;

		$leagueinfo['league_name'] = htmlspecialchars_uni($vbphrase[$leagueinfo['phrase']]);
		$region = strtolower($leagueinfo['region']);
		$leaguetype = strtolower($leagueinfo['sd_shortname']);
		$checked = ' checked="checked"';

		if (isset($vbulletin->userinfo['vbsoccerprefs']['lhide']))
		{
			if (!empty($vbulletin->userinfo['vbsoccerprefs']['lhide']) AND in_array($leaguetype, $vbulletin->userinfo['vbsoccerprefs']['lhide']))
			{
				$checked = '';
			}
		}

		$show['archivedleaguetype'] = isset($vbulletin->vbsoccer_leaguecache['archiv'][$leagueid]) ? true : false;

		$templater->register('leagueinfo', $leagueinfo);
		$templater->register('leaguetype', $leaguetype);
		$templater->register('checked', $checked);
		$templater->register('region', $region);
		$league_abo_bits .= $templater->render();
	}

	// farbeinstellungen
	$pointcolor_bits = '';
	$selectorinvalid = array();
	$selector        = array();

	$templater = vB_Template::create('vbsoccer_prefs_pointcolor_bit');

	foreach (array_merge(array('nb' => 0), $vbulletin->options['vbsoccer_points']) AS $selectorname => $val)
	{
		$selector['name'] = $selectorname;
		$selectorinvalid['color'] = ''; //'usercsserror';
		$selector['desc'] = construct_phrase($vbphrase['soccer_pointcolor_'. $selectorname .'_x'], $val);

		if (isset($vbulletin->userinfo['vbsoccerprefs']['color'][$selectorname]))
		{
			$selector['value'] = $vbulletin->userinfo['vbsoccerprefs']['color'][$selectorname];
		}

		$templater->register('selector', $selector);
		$templater->register('selectorinvalid', $selectorinvalid);
		$pointcolor_bits .= $templater->render();
	}

	unset($templater);

	$templatename = 'vbsoccer_settings';

	vB_Template::preRegister($templatename, array(
		'league_abo_bits' => $league_abo_bits,
		'emailabo'        => $emailabo,
		'vbsoccerprefs'   => $vbulletin->userinfo['vbsoccerprefs'],
		'pointcolor_bits' => $pointcolor_bits,
		));
}


// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'archive')
{
	if (!empty($vbulletin->vbsoccer_leaguecache['archiv']))
	{
		reset($vbulletin->vbsoccer_leaguecache['archiv']);
		$leagueid = key($vbulletin->vbsoccer_leaguecache['archiv']);
		$vbulletin->url = 'vbsoccer.php?' . $vbulletin->session->vars['sessionurl'] . 'do=bet&amp;l=' . intval($leagueid);
		exec_header_redirect($vbulletin->url);
	}

	// vbulletin-fehlermeldung (der link zum archiv existiert im menue nur
	// dann, wenn es archivierte eintraege gibt.)
	standard_error(fetch_error('soccer_no_archives'));
}


// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'betinfo')
{
	if (!$vbulletin->userinfo['userid'] OR
		!$vbulletin->options['vbsoccer_betspymode'])
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'matchid' => TYPE_UINT,
		));
}


// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'matchinfo')
{
	$vbulletin->input->clean_gpc('r', 'matchid', TYPE_UINT);

	if (empty($vbulletin->GPC['matchid']))
	{
		standard_error(fetch_error('invalidid', 'matchid', $vbulletin->options['contactuslink']));
	}

	if (!($matchinfo = $vbulletin->db->query_first("
		SELECT m.*, m.`id` AS `matchid`,
			CONCAT('soccer_team_', t1.`sd_id`) AS `t1_phrase`,
			CONCAT('soccer_team_', t2.`sd_id`) AS `t2_phrase`,
			IF(t1.`custom_homepage`!='', t1.`custom_homepage`, t1.`sd_homepage`) AS `team_home_homepage`,
			IF(t2.`custom_homepage`!='', t2.`custom_homepage`, t2.`sd_homepage`) AS `team_away_homepage`,
			t1.`logo` AS `team_home_logo`,
			t2.`logo` AS `team_away_logo`,
			t1.`logo_size_html` AS `team_home_logo_size_html`,
			t2.`logo_size_html` AS `team_away_logo_size_html`,
			IF(m.`points_home`=-1, '-', m.`points_home`) AS `team_home_goals`,
			IF(m.`points_away`=-1, '-', m.`points_away`) AS `team_away_goals`,
			IFNULL(b.`bet_home`, '') AS `bet_home`,
			IFNULL(b.`bet_away`, '') AS `bet_away`,
			b.`bet_score_key`, m.`score_key`
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t1 ON (m.`team_home_id`=t1.`id`)
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t2 ON (m.`team_away_id`=t2.`id`)
		LEFT  JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.id = b.`match_id` AND b.`userid`=" . $vbulletin->userinfo['userid'] . ")
		WHERE m.id=" . $vbulletin->GPC['matchid'] . "
		")))
	{
		standard_error(fetch_error('invalidid', 'matchid', $vbulletin->options['contactuslink']));
	}

	$lastmatcheslimit = 5;

	$matchstatistics = $vbulletin->db->query_read_slave("
		(
			SELECT id, '" . $matchinfo['team_home_id'] . "' AS `teammatches`
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE (`team_home_id`=" . $matchinfo['team_home_id'] . "
				OR `team_away_id`=" . $matchinfo['team_home_id'] . ")
				AND `match_is_finished`=1 AND id<>" . $matchinfo['matchid'] . "
			ORDER BY dateline DESC
			LIMIT " . $lastmatcheslimit . "
		)
		UNION ALL
		(
			SELECT id, '" . $matchinfo['team_away_id'] . "' AS `teammatches`
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE (`team_home_id`=" . $matchinfo['team_away_id'] . "
				OR `team_away_id`=" . $matchinfo['team_away_id'] . ")
				AND `match_is_finished`=1 AND id<>" . $matchinfo['matchid'] . "
			ORDER BY dateline DESC
			LIMIT " . $lastmatcheslimit . "
		)
		UNION ALL
		(
			SELECT id, 'both' AS `teammatches`
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE (`team_home_id` IN(" . $matchinfo['team_home_id'] . ", " . $matchinfo['team_away_id'] . ")
				AND `team_away_id` IN(" . $matchinfo['team_home_id'] . ", " . $matchinfo['team_away_id'] . "))
				AND match_is_finished=1 AND id<>" . $matchinfo['matchid'] . "
			ORDER BY dateline DESC
			LIMIT " . $lastmatcheslimit . "
		)");

	$matchids = $teamids = $matches = array();

	while (($matchstatistic = $vbulletin->db->fetch_array($matchstatistics)))
	{
		$matches[$matchstatistic['teammatches']][] = $matchstatistic;
		$matchids[$matchstatistic['id']]           = $matchstatistic['id'];
		$teamids[$matchstatistic['team_home_id']]  = $matchstatistic['team_home_id'];
		$teamids[$matchstatistic['team_away_id']]  = $matchstatistic['team_away_id'];
	}

	$vbulletin->db->free_result($matchstatistics);

	// anzeige der angeklickten begegnung mit tippabgabemoeglichkeit
	$show['allowbet']       = false;
	$show['canbet']         = false;
	$show['match_result']   = true;
	$show['reportlink']     = true;
	$show['leaguehortname'] = true;

	$colspan = 6;

	if ($vbulletin->userinfo['userid'] AND ($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canbet']))
	{
		$show['canbet'] = true;
	}

	$leagueinfo = $vbulletin->vbsoccer_leaguecache[$matchinfo['league_id']];
	$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
	build_vbsoccer_lastupdate_info($leagueinfo);

	// ligainformationen und spaltenueberschriften
	$templater = vB_Template::create('vbsoccer_leaguebit');
	$templater->register('leagueinfo', $leagueinfo);
	$templater->register('colspan', $colspan);
	$nextmatchbits = $templater->render();

	$nextmatchbits .= vB_Template::create('vbsoccer_matches_head')->render();

	$show['matchinfolnk'] = false;
	$show['showpoints'] = true;

	$matchinfo['team_home_name'] = htmlspecialchars_uni($vbphrase[$matchinfo['t1_phrase']]);
	$matchinfo['team_away_name'] = htmlspecialchars_uni($vbphrase[$matchinfo['t2_phrase']]);
	$nextmatchbits .= construct_matchbit($leagueinfo, $matchinfo);

	$templater = vB_Template::create('vbsoccer_leaguefooter');
	$show['result_column'] = ($show['canbet'] AND $show['allowbet']) ? true : false;
	$templater->register('colspan', ($show['canbet'] AND $show['allowbet']) ? ($colspan -2) : $colspan);
	$urlparams = array('do' => 'sdupdate', 'l' => $leagueinfo['id'], 'redo' => 'matchinfo', 'matchid' => $matchinfo['id']);
	$templater->register('urlparams', http_build_query($urlparams, '', '&amp;'));
	$nextmatchbits .= $templater->render();

	// tipps anderer benutzer
	if ($vbulletin->userinfo['userid'] AND (
		(TIMENOW < $matchinfo['dateline'] AND $vbulletin->options['vbsoccer_betspymode'] == 1) OR
		(TIMENOW > $matchinfo['dateline'] AND $vbulletin->options['vbsoccer_betspymode'] == 2) OR
		$vbulletin->options['vbsoccer_betspymode'] == 3 OR
		$vbulletin->options['vbsoccer_betforecast'] == 1
		))
	{
		$userbetList = array();
		$selectSql = $joinSql = $whereSql = $orderSql = "";

		if ($vbulletin->options['vbsoccer_betspymode'] != 0)
		{
			if (LANGUAGE_DIRECTION == 'rtl')
			{
				$selectSql = "u.`userid`, u.`username`, b.`bet_home`, b.`bet_away`, CONCAT_WS(':', `bet_away`, `bet_home`) AS userbet, ";
			}
			else
			{
				$selectSql = "u.`userid`, u.`username`, b.`bet_home`, b.`bet_away`, CONCAT_WS(':', `bet_home`, `bet_away`) AS userbet, ";
			}

			$joinSql   = " INNER JOIN  `" . TABLE_PREFIX . "user` AS u USING(userid)";
			$orderSql  = " ORDER BY u.`username`";
		}

		$userbets = $vbulletin->db->query_read("
			SELECT " . $selectSql . "b.`bet_score_key`
			FROM  `" . TABLE_PREFIX . "soccer_user_bet` AS b" . $joinSql . "
			WHERE b.`match_id`=" . $vbulletin->GPC['matchid'] .
				" AND b.`userid`!=" . $vbulletin->userinfo['userid']
			. $whereSql . $orderSql . "
			");

		$count = 0;
		$scoreKeyCounter = array(1 => 0, 2 => 0, 3 => 0);

		while (($userbet = $vbulletin->db->fetch_array($userbets)))
		{
			if ($vbulletin->options['vbsoccer_betforecast'])
			{
				$count++;
				$scoreKeyCounter[(int) $userbet['bet_score_key']]++;
			}

			if (TIMENOW > $matchinfo['dateline'])
			{
				// abgeschlossenes oder laufendes spiel mit anzeige eingefaerbter
				// tipps je nach erreichter punktezahl
				if ($vbulletin->options['vbsoccer_betspymode'] > 1)
				{
					$matchinfo['bet_score_key'] = $userbet['bet_score_key'];
					$matchinfo['bet_home']      = $userbet['bet_home'];
					$matchinfo['bet_away']      = $userbet['bet_away'];

					$pointkey   = soccer_fetch_pointkey($matchinfo);
					$pointcolor = $GLOBALS['vbsoccerprefs']['color'][$pointkey];

					$userbetList[] = '<a href="member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $userbet['userid'] . '">' . $userbet['username'] . '</a> <span style="color:' . $pointcolor . ';">' . $userbet['userbet'] . '</span>';
				}
			}
			else
			{
				// tipps des offenen spiels ohne einfaerbung der tipps
				if ($vbulletin->options['vbsoccer_betspymode'] == 1 OR
					$vbulletin->options['vbsoccer_betspymode'] == 3)
				{
					$userbetList[] = '<a href="member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $userbet['userid'] . '">' . $userbet['username'] . '</a> ' . $userbet['userbet'];
				}
			}
		}

		$vbulletin->db->free_result($userbets);

		if (!empty($userbetList))
		{
			$show['userbetlistcount'] = count($userbetList);
			$show['userbetlist']      = implode(', ', $userbetList);
			unset($userbetList);
		}

		if ($vbulletin->options['vbsoccer_betforecast'] AND (TIMENOW < $matchinfo['dateline']))
		{
			if (array_sum($scoreKeyCounter) > 0)
			{
				$maxCount = max($scoreKeyCounter);
				$bethints = construct_phrase($vbphrase['soccer_betforecast_summary'],
											 $matchinfo['team_home_name'],
											 ($scoreKeyCounter[1] > 0 ? ($scoreKeyCounter[1] == $maxCount ? '<b>'. $scoreKeyCounter[1] .'</b>' : $scoreKeyCounter[1]) : '-'),
											 ($scoreKeyCounter[2] > 0 ? ($scoreKeyCounter[2] == $maxCount ? '<b>'. $scoreKeyCounter[2] .'</b>' : $scoreKeyCounter[2]) : '-'),
											 $matchinfo['team_away_name'],
											 ($scoreKeyCounter[3] > 0 ? ($scoreKeyCounter[3] == $maxCount ? '<b>'. $scoreKeyCounter[3] .'</b>' : $scoreKeyCounter[3]) : '-'));
			}
		}
	}

	$matchinfos = array();

	if (!empty($matchids))
	{
		$matchinfodetails = $vbulletin->db->query_read_slave("
			SELECT m.*, m.id AS matchid,
				CONCAT('soccer_team_', t1.`sd_id`) AS t1_phrase,
				CONCAT('soccer_team_', t2.`sd_id`) AS t2_phrase,
				t1.`logo` AS `team_home_logo`,
				t2.`logo` AS `team_away_logo`,
				t1.`logo_size_html` AS `team_home_logo_size_html`,
				t2.`logo_size_html` AS `team_away_logo_size_html`,
				IF(t1.`custom_homepage`!='', t1.`custom_homepage`, t1.`sd_homepage`) AS `team_home_homepage`,
				IF(t2.`custom_homepage`!='', t2.`custom_homepage`, t2.`sd_homepage`) AS `team_away_homepage`,
				IF(m.`points_home`=-1, '-', m.`points_home`) AS `team_home_goals`,
				IF(m.`points_away`=-1, '-', m.`points_away`) AS `team_away_goals`,
				IFNULL(b.`bet_home`, '') AS `bet_home`,
				IFNULL(b.`bet_away`, '') AS `bet_away`,
				b.bet_score_key, m.score_key
			FROM `" . TABLE_PREFIX . "soccer_match` AS m
			INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t1 ON (m.`team_home_id`=t1.`id`)
			INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t2 ON (m.`team_away_id`=t2.`id`)
			LEFT  JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.id = b.match_id AND b.userid=" . $vbulletin->userinfo['userid'] . ")
			WHERE m.id IN(" . implode(',', $matchids) . ")
			");

		while (($matchinfodetail = $vbulletin->db->fetch_array($matchinfodetails)))
		{
			$matchinfodetail['team_home_name'] = htmlspecialchars_uni($vbphrase[$matchinfodetail['t1_phrase']]);
			$matchinfodetail['team_away_name'] = htmlspecialchars_uni($vbphrase[$matchinfodetail['t2_phrase']]);
			$matchinfos[$matchinfodetail['matchid']] = $matchinfodetail;
		}

		$vbulletin->db->free_result($matchinfodetails);
	}

	$show['leaguehortname'] = true;
	$show['matchinfolnk']   = true;

	$foundmatches = false;
	// $homestatsbits
	// die letzten x abgeschlossenen begegnungen von team 1
	// $matches[$matchinfo['team_home_id']]
	if (!empty($matches[$matchinfo['team_home_id']]))
	{
		$homestatstitle = construct_phrase($vbphrase['soccer_last_x_matches_from_y'], count($matches[$matchinfo['team_home_id']]), $matchinfo['team_home_name']);
		$homestatsbits = '';
		foreach ($matches[$matchinfo['team_home_id']] AS $match)
		{
			$leagueinfo = $vbulletin->vbsoccer_leaguecache[$matchinfos[$match['id']]['league_id']];
			$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
			$homestatsbits .= construct_matchbit($leagueinfo, $matchinfos[$match['id']]);
			$foundmatches = true;
		}
	}
	else
	{
		$homestatstitle = construct_phrase($vbphrase['soccer_last_matches_from_x'], $matchinfo['team_home_name']);
		$homestatsbits = vB_Template::create('vbsoccer_stats_nomatches')->render();
	}

	// $awaystatsbits
	// die letzten x abgeschlossenen begegnungen von team 2
	// $matches[$matchinfo['team_away_id']]
	if (!empty($matches[$matchinfo['team_away_id']]))
	{
		$awaystatstitle = construct_phrase($vbphrase['soccer_last_x_matches_from_y'], count($matches[$matchinfo['team_away_id']]), $matchinfo['team_away_name']);
		$awaystatsbits = '';
		foreach ($matches[$matchinfo['team_away_id']] AS $match)
		{
			$leagueinfo = $vbulletin->vbsoccer_leaguecache[$matchinfos[$match['id']]['league_id']];
			$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
			$awaystatsbits .= construct_matchbit($leagueinfo, $matchinfos[$match['id']]);
			$foundmatches = true;
		}
	}
	else
	{
		$awaystatstitle = construct_phrase($vbphrase['soccer_last_matches_from_x'], $matchinfo['team_away_name']);
		$awaystatsbits = vB_Template::create('vbsoccer_stats_nomatches')->render();
	}

	// $bothstatsbits
	// die letzten x abgeschlossenen begegnungen von team1 vs. team 2
	// $matches['both']
	if (!empty($matches['both']))
	{
		$bothstatstitle = construct_phrase($vbphrase['soccer_last_x_matches_from_y_and_z'], count($matches['both']), $matchinfo['team_home_name'], $matchinfo['team_away_name']);
		$bothstatsbits = '';
		foreach ($matches['both'] AS $match)
		{
			$leagueinfo = $vbulletin->vbsoccer_leaguecache[$matchinfos[$match['id']]['league_id']];
			$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
			$bothstatsbits .= construct_matchbit($leagueinfo, $matchinfos[$match['id']]);
			$foundmatches = true;
		}
	}
	else
	{
		$bothstatstitle = construct_phrase($vbphrase['soccer_last_matches_from_x_and_y'], $matchinfo['team_home_name'], $matchinfo['team_away_name']);
		$bothstatsbits = vB_Template::create('vbsoccer_stats_nomatches')->render();
	}

	// spaltenueberschrift, wenn mindestens 1 ansetzung gefunden wurde
	$statsmatchheader = '';
	if ($foundmatches)
	{
		$statsmatchheader = vB_Template::create('vbsoccer_matches_head')->render();
	}

	$headtitle = construct_phrase($vbphrase['soccer_matchinfo_x_vs_y_on_x'],
								  $matchinfo['team_home_name'],
								  $matchinfo['team_away_name'],
								  vbdate($vbulletin->options['dateformat'], $matchinfo['dateline'], true));

	$templatename = 'vbsoccer_matchinfo';
	vB_Template::preRegister($templatename, array(
		'headtitle'        => $headtitle,
		'matchinfo'        => $matchinfo,
		'homestatstitle'   => $homestatstitle,
		'awaystatstitle'   => $awaystatstitle,
		'bothstatstitle'   => $bothstatstitle,
		'nextmatchbits'    => $nextmatchbits,
		'homestatsbits'    => $homestatsbits,
		'awaystatsbits'    => $awaystatsbits,
		'bothstatsbits'    => $bothstatsbits,
		'statsmatchheader' => $statsmatchheader,
		));
}


// #############################################################################
// anzeige der spiele-vorschau
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'schedule')
{
	$vbulletin->input->clean_gpc('r', 'list', TYPE_STR);

	switch ($vbulletin->GPC['list'])
	{
		case 'grouped':
			$show['schedstyle'] = 1;
			break;
		case 'kickoff':
			$show['schedstyle'] = 0;
			break;
		default:
			unset($vbulletin->GPC['list']);
			$show['schedstyle'] = $vbulletin->userinfo['vbsoccerprefs']['schedstyle'];
			break;
	}

	$show['reportlink']   = true;
	$show['matchinfolnk'] = true;
	$show['allowbet'] = $show['canbet'] = $show['sdupdate'] = false;
	$matchbits = '';

	if (!empty($vbulletin->options['vbsoccer_previewdays']) AND
		!empty($vbulletin->vbsoccer_leaguecache['current']))
	{
		$headtitle = construct_phrase($vbphrase['soccer_schedule_previewdays_x'],
									  $vbulletin->options['vbsoccer_previewdays']);

		$show['match_result'] = false;

		$hideleagues = fetch_invisible_leagues();

		$matches = $vbulletin->db->query_read_slave("
			SELECT SQL_NO_CACHE
				m.`dateline`, m.`league_id`, m.`match_day`, m.id AS matchid,
				m.match_is_finished,
				t1.`logo` AS `team_home_logo`,
				t2.`logo` AS `team_away_logo`,
				t1.`logo_size_html` AS `team_home_logo_size_html`,
				t2.`logo_size_html` AS `team_away_logo_size_html`,
				IF(t1.`custom_homepage`!='', t1.`custom_homepage`, t1.`sd_homepage`) AS `team_home_homepage`,
				IF(t2.`custom_homepage`!='', t2.`custom_homepage`, t2.`sd_homepage`) AS `team_away_homepage`,
				CONCAT('soccer_team_', t1.`sd_id`) AS t1_phrase,
				CONCAT('soccer_team_', t2.`sd_id`) AS t2_phrase,
				IFNULL(b.bet_home, '') AS bet_home, IFNULL(b.bet_away, '') AS bet_away
			FROM `" . TABLE_PREFIX . "soccer_match` AS m
			INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t1 ON (m.`team_home_id`=t1.`id`)
			INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t2 ON (m.`team_away_id`=t2.`id`)
			LEFT  JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.id = b.match_id AND b.userid=" . $vbulletin->userinfo['userid'] . ")
			WHERE m.league_id IN(" . implode(',', $vbulletin->vbsoccer_leaguecache['current']) . ")
				" . ((!empty($hideleagues) ? "AND m.league_id NOT IN(" . implode(',', $hideleagues) . ")" : "")) . "
				AND m.`dateline` BETWEEN " . TIMENOW . " AND " . (TIMENOW + ($vbulletin->options['vbsoccer_previewdays'] * 86400)) . "
			ORDER BY m.`dateline`;
			");

		$colspan = 4;

		if (!$vbulletin->db->num_rows($matches))
		{
			// keine spiele in den kommenden xx tagen
			$show['nomatches'] = construct_phrase($vbphrase['soccer_schedule_nomatches_previewdays_x'], $vbulletin->options['vbsoccer_previewdays']);
		}
		else
		{
			$leaguematchinfo = $legacymatchinfo = array();

			while (($matchinfo = $vbulletin->db->fetch_array($matches)))
			{
				$matchinfo['team_home_name'] = htmlspecialchars_uni($vbphrase[$matchinfo['t1_phrase']]);
				$matchinfo['team_away_name'] = htmlspecialchars_uni($vbphrase[$matchinfo['t2_phrase']]);

				if ($show['schedstyle'] == 1)
				{
					$leaguematchinfo[$matchinfo['league_id']][] = $matchinfo;
				}
				else
				{
					$legacymatchinfo[] = $matchinfo;
				}
			}

			$vbulletin->db->free_result($matches);

			unset($matches, $matchinfo);

			$matchbetbit = '';



			$show['leaguehortname'] = ($show['schedstyle'] == 1 ? false : true);

			if ($show['schedstyle'] == 1)
			{
				$count = 0;
				foreach ($vbulletin->vbsoccer_leaguecache['current'] AS $leagueid)
				{
					if (!isset($leaguematchinfo[$leagueid]))
					{
						continue;
					}

					if ((++$count) > 1)
					{
						$show['leaguebitspacer'] = true;
					}

					if ($vbulletin->userinfo['userid'] AND ($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canbet']))
					{
						$show['canbet'] = true;
					}

					$showSaveButton = 0;

					$leagueinfo =& $vbulletin->vbsoccer_leaguecache[$leagueid];
					$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);

					if ((int)$leagueinfo['readonly'] == 0)
					{
						$showSaveButton = 1;
					}
					else
					{
						$show['canbet'] = false;
					}

					$templater = vB_Template::create('vbsoccer_leaguebit');
					$templater->register('leagueinfo', $leagueinfo);
					$templater->register('colspan', $colspan);
					$matchbits .= $templater->render();

					/*
					if ($count == 1)
					{
						$templater = vB_Template::create('vbsoccer_matches_head');
						$matchbits .= $templater->render();
					}
					*/

					$matchbits .= vB_Template::create('vbsoccer_matches_head')->render();

					foreach ($leaguematchinfo[$leagueid] AS $id => $matchinfo)
					{
						$matchbits .= construct_matchbit($leagueinfo, $matchinfo);
					}

					unset($leaguematchinfo[$leagueid]);

					build_vbsoccer_lastupdate_info($leagueinfo);

					$templater = vB_Template::create('vbsoccer_leaguefooter');
					$show['result_column'] = false;
					$templater->register('leagueinfo', $leagueinfo);
					$templater->register('colspan', (($vbulletin->userinfo['userid'] AND $show['canbet'] AND $show['allowbet'] AND $showSaveButton) ? ($colspan - 1) : $colspan));
					$urlparams = array('do' => 'sdupdate', 'l' => $leagueinfo['id'], 'redo' => 'schedule');
					$templater->register('urlparams', http_build_query($urlparams, '', '&amp;'));
					$matchbits .= $templater->render();
				} // end foreach
			}
			else
			{
				$colspan = 5;

				if ($vbulletin->userinfo['userid'] AND ($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canbet']))
				{
					$show['canbet'] = true;
				}

				$templater = vB_Template::create('vbsoccer_matches_head');
				$matchbits .= $templater->render();
				$showSaveButton = 0;
				foreach ($legacymatchinfo AS $matchinfo)
				{
					$leagueinfo =& $vbulletin->vbsoccer_leaguecache[$matchinfo['league_id']];
					if ((int)$leagueinfo['readonly'] == 0)
					{
						$showSaveButton = 1;
					}
					$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
					$matchbits .= construct_matchbit($leagueinfo, $matchinfo);
				}

				unset($legacymatchinfo);

				if ($showSaveButton == 0)
				{
					$show['canbet'] = false;
				}

				$templater = vB_Template::create('vbsoccer_leaguefooter');
				$templater->register('colspan', (($vbulletin->userinfo['userid'] AND $show['canbet'] AND $show['allowbet'] AND $showSaveButton) ? ($colspan - 1) : $colspan));
				$matchbits .= $templater->render();
			}
		}
	}
	else
	{
		$headtitle = $vbphrase['soccer_note'];

		if (empty($vbulletin->options['vbsoccer_previewdays']))
		{
			$show['nomatches'] = $vbphrase['soccer_schedule_preview_disabled'];
		}
		else
		{
			$show['nomatches'] = $vbphrase['soccer_no_leagues_enabled'];
		}
	}

	$templatename = 'vbsoccer_schedule';
	vB_Template::preRegister($templatename, array(
		'colspan'   => $colspan,
		'matchbits' => $matchbits,
		'headtitle' => $headtitle,
		));
}


// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'hall_of_fame')
{
	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$result = $vbulletin->db->query_read("
		SELECT `id`, `x_ranking`, `sd_saison`
		FROM `" . TABLE_PREFIX . "soccer_league`
		WHERE `visible`!=0
		ORDER BY `sd_saison` DESC, `displayorder`
		");

	$rankingusers = array();
	$ltype = array();
	$lcache = array();

	while (($row = $vbulletin->db->fetch_array($result)))
	{
		if ($row['x_ranking'] == '')
		{
			$serialized_ranks = construct_saison_rankings($row['id']);

			$vbulletin->db->query_write("
				UPDATE `" . TABLE_PREFIX . "soccer_league`
				SET `x_ranking`='" . $vbulletin->db->escape_string($serialized_ranks) . "'
				WHERE `id`=" . $row['id'] . "
				");

			$row['x_ranking'] = $serialized_ranks;
		}

		$x_ranking = unserialize($row['x_ranking']);

		if (empty($x_ranking))
		{
			continue;
		}

		$ltype[$row['sd_saison']][$row['id']] = $row['id'];

		foreach ($x_ranking AS $data)
		{
			foreach ($data AS $uids)
			{
				foreach ($uids AS $uid)
				{
					$rankingusers[$uid] = $uid;
				}
			}
		}

		$lcache[$row['id']]['x_ranking'] = $x_ranking;
	}

	$vbulletin->db->free_result($result);

	if (!empty($rankingusers))
	{
		$result = $vbulletin->db->query_read("
			SELECT `userid`, `username`
			FROM `" . TABLE_PREFIX . "user`
			WHERE `userid` IN(" . implode(',', $rankingusers) . ")
			");

		while (($row = $vbulletin->db->fetch_array($result)))
		{
			$rankingusers[$row['userid']] = $row['username'];
		}

		$vbulletin->db->free_result($result);

		$oldsaison = '';
		$halloffame_bits = '';

		foreach ($lcache AS $id => &$values)
		{
			$values['sd_saison'] = $vbulletin->vbsoccer_leaguecache[$id]['sd_saison'];

			if (!isset($ltype[$values['sd_saison']]))
			{
				continue;
			}

			if ($oldsaison == $values['sd_saison'])
			{
				continue;
			}

			$templater = vB_Template::create('vbsoccer_halloffamesaisonbit');
			$templater->register('saison', $values['sd_saison']);
			$halloffame_bits .= $templater->render();

			foreach ($ltype[$values['sd_saison']] as $i)
			{
				unset($ltype[$values['sd_saison']][$i]);

				$show['league_name'] = $vbphrase[$vbulletin->vbsoccer_leaguecache[$i]['phrase']];
				$show['region'] = $vbulletin->vbsoccer_leaguecache[$i]['region'];
				$region = strtolower($show['region']);

				foreach (range(1, 3) AS $pos)
				{
					$show['pos' . $pos . 'users'] = array();
					$show['pos' . $pos . 'pts']   = '';

					if (isset($lcache[$i]['x_ranking'][$pos]))
					{
						foreach ($lcache[$i]['x_ranking'][$pos] AS $_points => $_users)
						{
							$show['pos' . $pos . 'pts'] = $_points;
							foreach ($_users as $u)
							{
								if (isset($rankingusers[$u]))
								{
									$rankuser = $rankingusers[$u];

									if ($vbulletin->userinfo['userid'] == $u)
									{
										$rankuser = '<span class="highlight">' . $rankingusers[$u] . '</span>';
									}

									$show['pos' . $pos . 'users'][] = '<a href="member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $u . '">' . $rankuser . '</a>';
								}
								else
								{
									$show['pos' . $pos . 'users'][] = htmlspecialchars_uni($vbphrase['soccer_deleted_user']);
								}
							}
						}

						$show['pos' . $pos . 'users'] = implode(', ', $show['pos' . $pos . 'users']);
					}
					else
					{
						$show['pos' . $pos . 'users'] = '-';
					}
				}

				$templater = vB_Template::create('vbsoccer_halloffamebit');
				$templater->register('region', $region);
				$templater->register('i', $i);
				$halloffame_bits  .= $templater->render();
			}
			$oldsaison = $values['sd_saison'];
		}
	}

	$headtitle = $vbphrase['soccer_nav_halloffame'];

	$templatename = 'vbsoccer_halloffame';

	vB_Template::preRegister($templatename, array(
		'halloffame_bits' => $halloffame_bits,
		'headtitle'       => $headtitle,
		));
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'ranking')
{
	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'm'          => TYPE_UINT,
		'pagenumber' => TYPE_UINT,
		));

	$perpage    = $vbulletin->GPC['perpage'];
	$pagenumber = $vbulletin->GPC['pagenumber'];

	if (empty($vbulletin->GPC['l']))
	{
		// aufruf aus main-menue ohne angabe einer liga
		if (!empty($vbulletin->vbsoccer_leaguecache['current']))
		{
			// die erste aktuelle saison auswaehlen
			reset($vbulletin->vbsoccer_leaguecache['current']);
			$vbulletin->GPC['l'] = key($vbulletin->vbsoccer_leaguecache['current']);
		}
		elseif (!empty($vbulletin->vbsoccer_leaguecache['archiv']))
		{
			reset($vbulletin->vbsoccer_leaguecache['archiv']);
			$vbulletin->GPC['l'] = key($vbulletin->vbsoccer_leaguecache['archiv']);
		}
		else
		{
			// eek... tippspiel scheint leer zu sein
			standard_error(fetch_error('invalidid', 'league', $vbulletin->options['contactuslink']));
		}
	}

	$leagueinfo = $vbulletin->vbsoccer_leaguecache[$vbulletin->GPC['l']];
	$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);

	$league_jump = construct_soccer_league_jump($vbulletin->GPC['l']);

	$show['notsubscribed'] = false;
	$show['latestranking'] = empty($vbulletin->GPC['m']);

	$matchday_jump = construct_soccer_matchdayjump($vbulletin->GPC['m']);
	$vbulletin->GPC['m'] = (int) $currentmatchday;
	$matchday = $vbulletin->GPC['m'];

	fetch_soccer_prevnext_matchday($vbulletin->GPC['m']);
	build_vbsoccer_lastupdate_info($leagueinfo);

	$leagueaction_jump = construct_leagueaction_tabs($_REQUEST['do'], $leagueinfo['id'], $currentmatchday);

	$groupby_sql = $where_sql = $select_sql = '';

	if (in_array(strtolower($leagueinfo['sd_shortname']), array('wm', 'em', 'chl', 'eul')))
	{
		// spieltagsauswahl ausblenden bei WM, EM und CHL
		// hier immer die komplette rangliste anzeigen
		$matchday_jump = "";
		$groupby_sql  .= " GROUP BY DATE_FORMAT(FROM_UNIXTIME(m.`dateline`), '%Y%m%d'), b.`userid`";
		$select_sql   .= ", DATE_FORMAT(FROM_UNIXTIME(m.`dateline`), '%Y%m%d') AS `mdate`";

		$lastmatch_date = $vbulletin->db->query_first("
			SELECT MAX(DATE_FORMAT(FROM_UNIXTIME(`dateline`), '%Y%m%d')) AS `mdate`
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE `league_id`=" . $leagueinfo['id'] . " AND `score_key`>0
			");
	}
	else
	{
		$groupby_sql .= " GROUP BY `match_day`, b.`userid`";

		if (!$show['latestranking'])
		{
			$where_sql .= " AND `match_day` <= " . $matchday . "";
		}
	}

	// es ist richtig, hier keine usernamen aus der usertabelle abzuholen!
	// siehe kommentar unter $rankingusers_result zur nutzung des query-caches
	// in verbindung mit der usertabelle!
	$rankingresults = $vbulletin->db->query_read_slave("
		SELECT
			b.`userid`" . $select_sql . ", `match_day`,
			COUNT(*) AS `bets`,
			SUM(`score_key`>0) AS 'evaluated',
			SUM(`score_key`>0 AND `score_key` != `bet_score_key`) AS 'wr',
			SUM(`score_key`>0 AND `bet_home`=`points_home` AND `bet_away`=`points_away`) AS 'rr',
			SUM(`score_key`>0 AND CAST(`bet_home`-`bet_away` AS SIGNED)=(`points_home`-`points_away`) AND NOT (`bet_home`=`points_home` AND `bet_away`=`points_away`)) AS 'rd'
		FROM `" . TABLE_PREFIX . "soccer_user_bet` b
		INNER JOIN `" . TABLE_PREFIX . "soccer_match` m ON (m.`id`=b.`match_id`)
		WHERE m.`league_id`=" . $leagueinfo['id'] . $where_sql . $groupby_sql . "
		");

	$rankingdata     = array();
	$prevrankingdata = array();
	$sortarray       = array();
	$rankingusers    = array();

	while (($rankingresult = $vbulletin->db->fetch_array($rankingresults)))
	{
		// anzahl der gewerteten tipps
		if (!isset($rankingdata[$rankingresult['userid']]['evaluated']))
		{
			$rankingdata[$rankingresult['userid']]['evaluated'] = 0;
		}
		$rankingdata[$rankingresult['userid']]['evaluated'] += $rankingresult['evaluated'];

		// anzahl abgegebene tipps
		if (!isset($rankingdata[$rankingresult['userid']]['bets']))
		{
			$rankingdata[$rankingresult['userid']]['bets'] = 0;
		}
		$rankingdata[$rankingresult['userid']]['bets'] += $rankingresult['bets'];

		$rankingresult['rw'] = $rankingresult['evaluated'] - $rankingresult['wr'] - $rankingresult['rr'] - $rankingresult['rd'];

		$rankingdata[$rankingresult['userid']]['wr'] += $rankingresult['wr'];
		$rankingdata[$rankingresult['userid']]['rr'] += $rankingresult['rr'];
		$rankingdata[$rankingresult['userid']]['rd'] += $rankingresult['rd'];
		$rankingdata[$rankingresult['userid']]['rw'] += $rankingresult['rw'];

		$points = ($rankingresult['wr'] * $vbulletin->options['vbsoccer_points']['wr'])
				+ ($rankingresult['rr'] * $vbulletin->options['vbsoccer_points']['rr'])
				+ ($rankingresult['rd'] * $vbulletin->options['vbsoccer_points']['rd'])
				+ ($rankingresult['rw'] * $vbulletin->options['vbsoccer_points']['rw']);
		$rankingdata[$rankingresult['userid']]['points'] += $points;

		if (!isset($rankingresult['mdate']))
		{
			if ($rankingresult['match_day'] < $matchday)
			{
				$rankingdata[$rankingresult['userid']]['prevpoints'] += $points;
				$prevrankingdata[$rankingresult['userid']] += $points;
			}
		}
		else
		{
			if ($rankingresult['mdate'] < $lastmatch_date['mdate'])
			{
				$rankingdata[$rankingresult['userid']]['prevpoints'] += $points;
				$prevrankingdata[$rankingresult['userid']] += $points;
			}
		}

		$rankingdata[$rankingresult['userid']]['userid'] = (int) $rankingresult['userid'];
		$sortarray[$rankingresult['userid']] = (int) $rankingdata[$rankingresult['userid']]['points'];

	}

	$vbulletin->db->free_result($rankingresults);

	if (!empty($rankingdata))
	{
		// hier die usernamen der tipper abholen. ein join der usertabelle beim
		// auslesen der tipps wuerde die nutzung des mysql-query-caches verhindern
		// weil die usertabelle mit jedem klick aktualisiert und damit der cache
		// erneuert wird.
		$rankingusers_result = $vbulletin->db->query_read("
			SELECT `userid`, `username`
			FROM `" . TABLE_PREFIX . "user`
			WHERE `userid` IN(" . implode(',', array_keys($rankingdata)) . ")
			");

		while (($rankinguser = $vbulletin->db->fetch_array($rankingusers_result)))
		{
			$rankingusers[$rankinguser['userid']] = $rankinguser['username'];
		}

		$vbulletin->db->free_result($rankingusers_result);
	}

	array_multisort($sortarray, SORT_NUMERIC, SORT_DESC, $rankingdata);
	unset($sortarray);
	arsort($prevrankingdata);

	$totalrankings = count($rankingdata);
	sanitize_pageresults($totalrankings, $pagenumber, $perpage, 100, $vbulletin->options['vbsoccer_rankingusersperpage']);

	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = ($pagenumber) * $perpage;
	$counter = 0;

	if ($limitupper > $totalrankings)
	{
		$limitupper = $totalrankings;
		if ($limitlower > $totalrankings)
		{
			$limitlower = $totalrankings - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $totalrankings, 'vbsoccer.php?' . $vbulletin->session->vars['sessionurl'], 'do=ranking'
		. ((!empty($matchday) AND $matchday_jump != '' AND !$show['latestranking']) ? "&amp;m=$matchday" : "")
		. (!empty($vbulletin->GPC['l']) ? "&amp;l=" . $vbulletin->GPC['l'] : "")
	);

	$prevrankings = array();

	$rank = $counter = 0;

	foreach ($prevrankingdata AS $userid => $points)
	{
		$counter++;
		if (!isset($oldpoints) OR $oldpoints != $points)
		{
			$rank = $counter;
		}

		$oldpoints = $points;
		$prevrankings[$userid] = $rank;
		$oldrank = $rank;
	}

	$colspan = 9;

	$templater = vB_Template::create('vbsoccer_leaguebit');
	$templater->register('leagueinfo', $leagueinfo);
	$templater->register('colspan', $colspan);
	$rankingbits = $templater->render();

	if (!empty($rankingdata))
	{
		// kopfzeile
		$vbphrase['rr_head'] = construct_phrase($vbphrase['soccer_x_points_abbr'], $vbulletin->options['vbsoccer_points']['rr']);
		$vbphrase['rd_head'] = construct_phrase($vbphrase['soccer_x_points_abbr'], $vbulletin->options['vbsoccer_points']['rd']);
		$vbphrase['rw_head'] = construct_phrase($vbphrase['soccer_x_points_abbr'], $vbulletin->options['vbsoccer_points']['rw']);
		$vbphrase['wr_head'] = construct_phrase($vbphrase['soccer_x_points_abbr'], $vbulletin->options['vbsoccer_points']['wr']);

		$templater = vB_Template::create('vbsoccer_rankinghead');
		$templater->register('sorturl', $sorturl);
		$templater->register('perpage', $perpage);
		$templater->register('sortarrow', $sortarrow);
		$rankingbits .= $templater->render();
	}

	$rank = $counter = 0;
	$userposition = array();

	foreach ($rankingdata AS $position => $betuser)
	{
		$counter++;
		if (!isset($oldpoints) OR $oldpoints != $betuser['points'])
		{
			$rank = $counter;
		}
		$oldpoints = $betuser['points'];

		if ($vbulletin->userinfo['userid'] == $betuser['userid'])
		{
			$userposition['rank']   = $rank;
			$userposition['page']   = ceil($counter / $perpage);
			$userposition['points'] = $betuser['points'];
		}

		if ($counter < $limitlower)
		{
			continue;
		}

		if ($counter > $limitupper)
		{
			if (!$vbulletin->userinfo['userid'] OR !empty($userposition))
			{
				break;
			}
			else
			{
				continue;
			}
		}

		$rankarrow = $rankdiff = '';

		if (isset($prevrankings[$betuser['userid']]))
		{
			$oldrank = $prevrankings[$betuser['userid']];
			if ($oldrank != $rank)
			{
				$rankdiff = abs($oldrank - $rank);
				$rankarrow = ($oldrank < $rank) ? ($rankdiff > 2 ? 'arrow_s.png' : 'arrow_se.png') : ($rankdiff > 2 ? 'arrow_n.png' : 'arrow_ne.png');
			}
			$daypoints = $betuser['points'] - $prevrankingdata[$betuser['userid']];
			$daypoints = ($daypoints == 0) ? '-' : sprintf('%+d', $daypoints);
		}
		else
		{
			$oldrank = 0;
			$daypoints = ($betuser['points'] == 0) ? '-' : sprintf('%+d', $betuser['points']);
		}

		if (isset($rankingusers[$betuser['userid']]))
		{
			$betuser['username'] = $rankingusers[$betuser['userid']];
			$betuser['realuserid'] = $betuser['userid'];
		}
		else
		{
			$betuser['username'] = htmlspecialchars_uni($vbphrase['soccer_deleted_user']);
			$betuser['realuserid'] = 0;
		}
		$nobetpointscount = 0;
		foreach (array('wr', 'rw', 'rd', 'rr') AS $x)
		{
			if (empty($betuser[$x]))
			{
				$betuser[$x] = '-';
				$nobetpointscount++;
			}
		}

		if ($nobetpointscount == 4)
		{
			$betuser['points'] = '-';
			$show['noranking'] = true;
		}
		else
		{
			$show['noranking'] = false;
		}

		$templater = vB_Template::create('vbsoccer_rankingbit');
		$templater->register('rank', $rank);
		$templater->register('rankarrow', $rankarrow);
		$templater->register('rankdiff', $rankdiff);
		$templater->register('betuser', $betuser);
		$templater->register('vbsoccerprefs', $vbulletin->userinfo['vbsoccerprefs']);
		$templater->register('daypoints', $daypoints);

		$rankingbits  .= $templater->render();
	}

	$templater = vB_Template::create('vbsoccer_leaguefooter');
	$show['result_column'] = false;
	$templater->register('colspan', $colspan);
	$urlparams = array('do' => 'sdupdate', 'l' => $leagueinfo['id'], 'redo' => 'ranking', 'm' => $matchday);
	$templater->register('urlparams', http_build_query($urlparams, '', '&amp;'));
	$rankingbits .= $templater->render();

	unset($rankingdata);
	$show['userranking'] = false;

	if (!empty($userposition))
	{
		if ($userposition['page'] != $pagenumber)
		{
			$show['userranking'] = true;
			$userposition['pagelink'] = 'vbsoccer.php?'
				. $vbulletin->session->vars['sessionurl']
				. 'do=ranking'
				. ((!empty($matchday) AND $matchday_jump != '' AND !$show['latestranking']) ? "&amp;m=$matchday" : "")
				. (!empty($vbulletin->GPC['l']) ? "&amp;l=" . $vbulletin->GPC['l'] : "")
				. (!empty($userposition['page']) ? "&amp;page=" . $userposition['page'] : "");
		}
	}

	$templatename = 'vbsoccer_ranking';
	vB_Template::preRegister($templatename, array(
		'league_jump'       => $league_jump,
		'matchday_jump'     => $matchday_jump,
		'leagueaction_jump' => $leagueaction_jump,
		'currentmatchday'   => $currentmatchday,
		'matchday'          => $matchday,
		'leagueinfo'        => $leagueinfo,
		'rankingbits'       => $rankingbits,
		'totalrankings'     => $totalrankings,
		'colspan'           => $colspan,
		'pagenav'           => $pagenav,
		'userposition'      => $userposition,
		'headtitle'         => construct_phrase($vbphrase['soccer_ranking_league_x'], $leagueinfo['league_name']),
		));
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'bet')
{
	$vbulletin->input->clean_gpc('r', 'm', TYPE_UINT);
	$leagueinfo = $vbulletin->vbsoccer_leaguecache[$vbulletin->GPC['l']];
	$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
	$show['reportlink']   = true;
	$show['matchinfolnk'] = true;
	$league_jump = construct_soccer_league_jump($vbulletin->GPC['l']);

	$matchday_jump = construct_soccer_matchdayjump($vbulletin->GPC['m']);
	$vbulletin->GPC['m'] = (int) $currentmatchday;
	$matchday = $vbulletin->GPC['m'];
	$leagueaction_jump = construct_leagueaction_tabs($_REQUEST['do'], $leagueinfo['id'], $currentmatchday);
	fetch_soccer_prevnext_matchday($vbulletin->GPC['m']);

	build_vbsoccer_lastupdate_info($leagueinfo);

	// gewaehlter spieltag + spiele aus vorhergehenden spieltagen ohne abschluss
	$condition = " AND m.`match_day`=" . $vbulletin->GPC['m'] . "";

	if ($leagueinfo['mdp'] != '')
	{
		// in gruppen und phrasen aufteilen 'gruppen;phrasen'
		$matchdaypagesplit = explode(';', $leagueinfo['mdp']);
		$daygroups         = explode(',', $matchdaypagesplit[0]);
		$dayphrases        = explode(',', $matchdaypagesplit[1]);

		foreach ($daygroups AS $group => $days)
		{
			$minmax = explode('-', $days);
			$minmaxrange = range($minmax[0], $minmax[1]);
			if (in_array($vbulletin->GPC['m'], $minmaxrange))
			{
				$show['matchdaygroups'] = true;
				$condition = " AND m.`match_day` IN(". implode(',', $minmaxrange) .")";
				break;
			}
		}
	}

	$colspan = 5;


	$headtitle = construct_phrase($vbphrase['soccer_league_x_matchday_y'],
								  $leagueinfo['league_name'],
								  (empty($show['matchdaygroups'])
								   ? htmlspecialchars_uni($matchdayinfos[$vbulletin->GPC['m']]['matchdayname'])
								   : htmlspecialchars_uni($matchdayinfos[$vbulletin->GPC['m']]['matchgroupname'])
								   )
								  );

	$show['match_result'] = true;

	$matches = $vbulletin->db->query_read("
		SELECT
			m.`dateline`, m.`league_id`, m.`match_day`, m.`id` AS `matchid`,
			m.`match_is_finished`,
			t1.`logo` AS `team_home_logo`,
			t2.`logo` AS `team_away_logo`,
			t1.`logo_size_html` AS `team_home_logo_size_html`,
			t2.`logo_size_html` AS `team_away_logo_size_html`,
			IF(t1.`custom_homepage`!='', t1.`custom_homepage`, t1.`sd_homepage`) AS `team_home_homepage`,
			IF(t2.`custom_homepage`!='', t2.`custom_homepage`, t2.`sd_homepage`) AS `team_away_homepage`,
			IF(t1.custom_shortname!='', t1.custom_shortname, t1.sd_shortname) AS team_home_shortname,
			IF(t2.custom_shortname!='', t2.custom_shortname, t2.sd_shortname) AS team_away_shortname,
			CONCAT('soccer_team_', t1.`sd_id`) AS `t1_phrase`,
			CONCAT('soccer_team_', t2.`sd_id`) AS `t2_phrase`,
			IF(m.`points_home`=-1, '-', m.`points_home`) AS `team_home_goals`,
			IF(m.`points_away`=-1, '-', m.`points_away`) AS `team_away_goals`,
			IFNULL(b.`bet_home`, '') AS `bet_home`,
			IFNULL(b.`bet_away`, '') AS `bet_away`,
			b.`bet_score_key`, m.`score_key`
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t1 ON (m.`team_home_id`=t1.`id`)
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t2 ON (m.`team_away_id`=t2.`id`)
		LEFT  JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.`id`=b.`match_id` AND b.`userid`=" . $vbulletin->userinfo['userid'] . ")
		WHERE m.`league_id`=" . $vbulletin->GPC['l'] . " " . $condition . "
		ORDER BY ". (!empty($show['matchdaygroups']) ? "m.`match_day`, " : "") . "m.`dateline`
		");

	$matchdata = $postp_matches = $match_ids = array();

	while (($match = $vbulletin->db->fetch_array($matches)))
	{
		$match['team_home_name'] = htmlspecialchars_uni($vbphrase[$match['t1_phrase']]);
		$match['team_away_name'] = htmlspecialchars_uni($vbphrase[$match['t2_phrase']]);

		$matchdata[$match['match_day']][] = $match;
		// matchids fuer ermittlung aller usertipps
		$match_ids[] = $match['matchid'];
	}

	$vbulletin->db->free_result($matches);
	unset($matches, $match);

	$templater = vB_Template::create('vbsoccer_leaguebit');
	$templater->register('leagueinfo', $leagueinfo);
	$templater->register('colspan', $colspan);
	$matchbits = $templater->render();

	$matchbetbit = '';
	$show['allowbet'] = $show['canbet'] = $show['showpoints'] = false;
	$matchday_points = 0;

	if ($vbulletin->userinfo['userid'] AND $GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canbet'])
	{
		$show['canbet'] = true;
		$show['showpoints'] = true;
	}

	if (!empty($show['matchdaygroups']))
	{
		if (!empty($_GET['m']))
		{
			$show['idhash'] = $matchday;
		}
	}

	foreach ($matchdata AS $md => $matchinfos)
	{
		if (!empty($show['matchdaygroups']))
		{
			$templater = vB_Template::create('vbsoccer_matchgroupbit');
			$templater->register('colspan', $colspan);
			$templater->register('md', $md);
			$templater->register('matchgrouptitle', $matchdayinfos[$md]['matchdayname']);
			$matchbits .= $templater->render();
		}

		if (empty($matcheshead))
		{
			$templater = vB_Template::create('vbsoccer_matches_head');
			$matchbits .= $templater->render();
			$matcheshead = true;
		}

		foreach ($matchinfos AS $matchinfo)
		{
			$matchbits .= construct_matchbit($leagueinfo, $matchinfo);
		}
	}

	$templater = vB_Template::create('vbsoccer_leaguefooter');
	$show['result_column'] = ($show['canbet'] AND $show['allowbet']) ? true : false;
	$templater->register('colspan', ($show['canbet'] AND $show['allowbet']) ? ($colspan -2) : $colspan);
	$urlparams = array('do' => 'sdupdate', 'l' => $leagueinfo['id'], 'redo' => 'bet', 'm' => $matchday);
	$templater->register('urlparams', http_build_query($urlparams, '', '&amp;'));
	$matchbits .= $templater->render();

	$templatename = 'vbsoccer_bet';
	vB_Template::preRegister($templatename, array(
		'colspan'           => ($show['canbet'] AND $show['allowbet']) ? ($colspan -2) : $colspan,
		'matchbits'         => $matchbits,
		'league_jump'       => $league_jump,
		'matchday_jump'     => $matchday_jump,
		'leagueaction_jump' => $leagueaction_jump,
		'currentmatchday'   => $currentmatchday,
		'matchday'          => $matchday,
		'leagueinfo'        => $leagueinfo,
		'headtitle'         => $headtitle,
		));

	unset($matchdata, $matchinfos, $matchinfo);
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'live')
{
	$hideleagues = fetch_invisible_leagues();

	$matches = $vbulletin->db->query_read_slave("
		SELECT
			m.*, m.`id` AS `matchid`,
			t1.`logo` AS `team_home_logo`,
			t2.`logo` AS `team_away_logo`,
			t1.`logo_size_html` AS `team_home_logo_size_html`,
			t2.`logo_size_html` AS `team_away_logo_size_html`,
			IF(t1.`custom_homepage`!='', t1.`custom_homepage`, t1.`sd_homepage`) AS `team_home_homepage`,
			IF(t2.`custom_homepage`!='', t2.`custom_homepage`, t2.`sd_homepage`) AS `team_away_homepage`,
			CONCAT('soccer_team_', t1.`sd_id`) AS `t1_phrase`,
			CONCAT('soccer_team_', t2.`sd_id`) AS `t2_phrase`,
			IF(m.`points_home`=-1, '-', m.`points_home`) AS `team_home_goals`,
			IF(m.`points_away`=-1, '-', m.`points_away`) AS `team_away_goals`,
			IFNULL(b.`bet_home`, '') AS `bet_home`,
			IFNULL(b.`bet_away`, '') AS `bet_away`,
			b.`bet_score_key`
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t1 ON (m.`team_home_id` = t1.`id`)
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t2 ON (m.`team_away_id` = t2.`id`)
		LEFT  JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.id = b.match_id AND b.userid=" . $vbulletin->userinfo['userid'] . ")
		WHERE m.`dateline` BETWEEN " . (TIMENOW - 14400) . " AND " . (TIMENOW + 28800) . "
		" . ((!empty($hideleagues) ? " AND m.`league_id` NOT IN(" . implode(',', $hideleagues) . ")" : "")) . "
		ORDER BY `dateline`
		");

	$colspan = 6;
	$matchbits = '';

	$show['refresh'] = true;
	$show['reportlink'] = true;
	$show['canpostresults'] = false;
	$show['showform'] = $show['canpostresults'];


	if ($vbulletin->userinfo['userid'] AND ($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canpostresults']))
	{
		$show['canpostresults'] = true;
	}

	$logmatches = array(); // hier informationen zu den spielen fuer logausgabe

	while (($matchinfo = $vbulletin->db->fetch_array($matches)))
	{
		if (!isset($vbulletin->vbsoccer_leaguecache[$matchinfo['league_id']]))
		{
			continue;
		}

		$leagueinfo = $vbulletin->vbsoccer_leaguecache[$matchinfo['league_id']];
		$leagueinfo['league_name']   = fetch_soccer_leaguename($leagueinfo);

		if ($vbulletin->userinfo['userid'] AND $GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canbet'])
		{
			$show['showpoints'] = true;
		}

		$matchinfo['kickoffdate']    = vbdate($vbulletin->options['dateformat'], $matchinfo['dateline'], true);
		$matchinfo['kickofftime']    = vbdate($vbulletin->options['timeformat'], $matchinfo['dateline']);
		$matchinfo['team_home_name'] = htmlspecialchars_uni($vbphrase[$matchinfo['t1_phrase']]);
		$matchinfo['team_away_name'] = htmlspecialchars_uni($vbphrase[$matchinfo['t2_phrase']]);


		// anzeige des abgegebenen tipps oder '-:-' wenn kein tipp abgegeben
		if ($matchinfo['bet_home'] == '' OR $matchinfo['bet_away'] == '')
		{
			$matchinfo['bet_home'] = $matchinfo['bet_away'] = '-';
		}

		// erreichte punkte anzeigen (nur auf tippseite)
		$pointkey = soccer_fetch_pointkey($matchinfo);
		$points = (isset($GLOBALS['vbulletin']->options['vbsoccer_points'][$pointkey])
				   ? (int) $GLOBALS['vbulletin']->options['vbsoccer_points'][$pointkey] : 0);
		$matchinfo['pointcolor'] = $GLOBALS['vbulletin']->userinfo['vbsoccerprefs']['color'][$pointkey];

		if (LANGUAGE_DIRECTION == 'rtl' AND $matchinfo['bet_away'] != '-')
		{
			// bloede idee, aber was solls
			$a = $matchinfo['bet_away'];
			$h = $matchinfo['bet_home'];
			$matchinfo['bet_home'] = $a;
			$matchinfo['bet_away'] = $h;
		}
		$show['showpoints'] = false;
		$show['betlink'] = true;

		if (TIMENOW > $matchinfo['dateline'])
		{
			$show['showpoints'] = true;
		}

		$templater = vB_Template::create('vbsoccer_betbit');
		$templater->register('leagueinfo', $leagueinfo);
		$templater->register('matchinfo', $matchinfo);
		$templater->register('points', $points);
		$matchbetbit = $templater->render();

		if ($show['canpostresults'] AND (TIMENOW > $matchinfo['dateline'])
			AND in_array($matchinfo['match_is_finished'], array(0, 2)))
		{
			$show['showform'] = true;

			$matchinfo['finchecked']  = ($matchinfo['match_is_finished'] == 2) ? ' checked="checked"' : '';
			$matchinfo['fin']         = !empty($matchinfo['finchecked']) ? 1 : 0;
			$matchinfo['findisabled'] = (TIMENOW > ($matchinfo['dateline'] + (105 * 60)) ? '' : ' disabled="disabled"');
			$matchinfo['result_home'] = ($matchinfo['team_home_goals'] == '-') ? '' : $matchinfo['team_home_goals'];
			$matchinfo['result_away'] = ($matchinfo['team_away_goals'] == '-') ? '' : $matchinfo['team_away_goals'];

			$templater = vB_Template::create('vbsoccer_resultinput');
			$templater->register('matchinfo', $matchinfo);
			$matchinfo['matchresult'] = $templater->render();
		}
		else
		{
			if (LANGUAGE_DIRECTION == 'rtl')
			{
				$matchinfo['matchresult'] = sprintf('%s:%s', $matchinfo['team_away_goals'], $matchinfo['team_home_goals']);
			}
			else
			{
				$matchinfo['matchresult'] = sprintf('%s:%s', $matchinfo['team_home_goals'], $matchinfo['team_away_goals']);
			}
		}

		$show['matchinfolnk'] = true;

		switch (true)
		{
			case ($matchinfo['dateline'] <= TIMENOW):
				if ($matchinfo['match_is_finished'] == 1)
				{
					$matchinfo['statusicon'] = 'done.png';
				}
				else
				{
					$matchinfo['statusicon'] = 'hourglass.png';
				}
				break;
			case ($matchinfo['dateline'] > TIMENOW):
				$matchinfo['statusicon'] = 'scheduled.png';
				break;
			default:
				$matchinfo['statusicon'] = 'scheduled.png';
				break;
		}

		$templater = vB_Template::create('vbsoccer_livebit');
		$templater->register('leagueinfo', $leagueinfo);
		$templater->register('matchinfo', $matchinfo);
		$templater->register('matchbetbit', $matchbetbit);

		$matchbits .= $templater->render();

		$logmatches[$matchinfo['matchid']]['t1'] = $matchinfo['team_home_name'];
		$logmatches[$matchinfo['matchid']]['t2'] = $matchinfo['team_away_name'];

	} // end while

	$vbulletin->db->free_result($matches);

	$show['matchbits'] = ($matchbits ? true : false);

	if (!empty($logmatches) AND $show['canpostresults'])
	{
		$resultlogbits      = '';
		$show['resultlogs'] = true;

		$resultlogs = $vbulletin->db->query_read("
			SELECT l.*, u.`username`
			FROM `" . TABLE_PREFIX . "soccer_postresult_log` AS l
			LEFT JOIN `" . TABLE_PREFIX . "user` AS u USING(`userid`)
			WHERE `match_id` IN(" . implode(',', array_keys($logmatches)) . ")
				AND `result` != '-1:-1'
			ORDER BY `dateline` DESC
			LIMIT 25
			");

		while (($logdata = $vbulletin->db->fetch_array($resultlogs)))
		{
			if ($logdata['userid'] == 0)
			{
				$logdata['musername'] = htmlspecialchars_uni($vbphrase['soccer_dataservice_nick']);
			}
			else
			{
				$logdata['musername'] = htmlspecialchars_uni($logdata['username']);
			}

			$logdata['team_home'] = $logmatches[$logdata['match_id']]['t1'];
			$logdata['team_away'] = $logmatches[$logdata['match_id']]['t2'];
			$logdata['result']    = htmlspecialchars_uni($logdata['result']);
			$logdata['logdate']   = vbdate($vbulletin->options['dateformat'], $logdata['dateline'], true);
			$logdata['logtime']   = vbdate($vbulletin->options['timeformat'], $logdata['dateline']);

			$templater = vB_Template::create('vbsoccer_resultlogbit');
			$templater->register('logdata', $logdata);

			$resultlogbits .= $templater->render();
		}

		$vbulletin->db->free_result($resultlogs);

		$show['logbits'] = ($resultlogbits != '' ? true : false);
	}

	if ($show['showform'])
	{
		include DIR . '/includes/functions_bigthree.php';

		$datecut  = TIMENOW - $vbulletin->options['cookietimeout'];
		$browsers = '';

		$show['activeusers'] = (!$show['search_engine'] ? true : false);

		$liveusers = $vbulletin->db->query_read_slave("
			SELECT user.username, user.usergroupid, user.membergroupids,
				session.userid, session.location, session.lastactivity, session.badlocation,
				IF(user.displaygroupid = 0, user.usergroupid, user.displaygroupid) AS displaygroupid, infractiongroupid,
				IF(user.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ", 1, 0) AS invisible
			FROM " . TABLE_PREFIX . "session AS session
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = session.userid)
			WHERE session.lastactivity > $datecut
			ORDER BY lastactivity DESC
			");

		$numberguest = 0;
		$numberregistered = 0;
		$doneuser = array();

		if ($vbulletin->userinfo['userid'])
		{
			$loggedin = array(
				'userid'        => $vbulletin->userinfo['userid'],
				'username'      => $vbulletin->userinfo['username'],
				'invisible'     => $vbulletin->userinfo['invisible'],
				'invisiblemark' => $vbulletin->userinfo['invisiblemark'],
				'location'      => '/vbsoccer.php?do=live',
				'lastactivity'  => TIMENOW,
				'musername'     => $vbulletin->userinfo['musername'],
			);

			$numberregistered = 1;
			$numbervisible = 1;
			fetch_online_status($loggedin);

			$show['comma_leader'] = false;

			$templater = vB_Template::create('forumdisplay_loggedinuser');
			$templater->register('loggedin', $loggedin);

			$activeusers .= $templater->render();
			$doneuser["{$vbulletin->userinfo['userid']}"] = 1;
		}

		while (($loggedin = $vbulletin->db->fetch_array($liveusers)))
		{
			if ($loggedin['badlocation'])
			{
				continue;
			}

			if (empty($doneuser["$loggedin[userid]"]))
			{
				if (strpos($loggedin['location'], 'vbsoccer.php?do=live') !== false)
				{
					if ($loggedin['userid'] == 0)
					{
						$numberguest++;
					}
					else
					{
						fetch_musername($loggedin);
						$numberregistered++;

						if (fetch_online_status($loggedin))
						{
							$show['comma_leader'] = ($activeusers != '');
							$templater = vB_Template::create('forumdisplay_loggedinuser');
							$templater->register('loggedin', $loggedin);
							$activeusers .= $templater->render();
						}
					}
				}

				if ($loggedin['userid'])
				{
					$doneuser["$loggedin[userid]"] = 1;
				}
			}
		}

		if (!$vbulletin->userinfo['userid'])
		{
			$numberguest = ($numberguest == 0) ? 1 : $numberguest;

			if ($numberregistered == 0)
			{
				$activeusers = '&nbsp;';
			}
		}

		$totalonline = $numberregistered + $numberguest;

		$vbulletin->db->free_result($liveusers);
		unset($userinfos, $userid, $userinfo, $loggedin, $datecut);
	}

	$templatename = 'vbsoccer_live';

	vB_Template::preRegister($templatename, array(
		'colspan'          => $colspan,
		'matchbits'        => $matchbits,
		'totalonline'      => $totalonline,
		'resultlogbits'    => $resultlogbits,
		'numberregistered' => $numberregistered,
		'numberguest'      => $numberguest,
		'activeusers'      => $activeusers,
		'headtitle'        => $vbphrase['soccer_live'],
		));
}

// #############################################################################
if (isset($_REQUEST['do']) AND ($_REQUEST['do'] == 'tab' OR $_REQUEST['do'] == 'crosstab'))
{
	$templatename = 'vbsoccer_tab';
	$tplObj = new stdClass;

	$vbulletin->input->clean_array_gpc('r', array(
		'm'    => TYPE_UINT,   // optional
		'type' => TYPE_NOHTML, // optional
		));

	if ($_REQUEST['do'] == 'crosstab')
	{
		$vbulletin->GPC['type'] = 'cross';
	}

	$leagueinfo = $vbulletin->vbsoccer_leaguecache[$vbulletin->GPC['l']];
	$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
	build_vbsoccer_lastupdate_info($leagueinfo);

	$league_jump  = construct_soccer_league_jump($vbulletin->GPC['l'], 'tab');

	$colspan         = 3;
	$matchday_jump   = '';
	$tabletype       = $vbulletin->GPC['type'];
	$currentmatchday = 0;

	if (empty($leagueinfo['showtable']))
	{
		standard_error(fetch_error('soccer_league_showtable_disabled'));
	}

	if (in_array($leagueinfo['sd_shortname'], array('WM', 'EM', 'CHL', 'EUL')))
	{
		$tabletype = strtolower($leagueinfo['sd_shortname']);
	}

	if (!in_array($tabletype, array('cross', 'wm', 'em', 'chl', 'eul')))
	{
		$matchday_jump = construct_soccer_matchdayjump($vbulletin->GPC['m']);
		$vbulletin->GPC['m'] = (int) $currentmatchday;
		fetch_soccer_prevnext_matchday($vbulletin->GPC['m']);
	}

	$matchday = $vbulletin->GPC['m'];
	$leagueaction_jump = construct_leagueaction_tabs($_REQUEST['do'], $leagueinfo['id'], (int) $matchday);

	switch ($tabletype)
	{
		case 'wm':
		case 'em':
		case 'chl':
		case 'eul':
			$colspan = 9;

			$templater = vB_Template::create('vbsoccer_leaguebit');
			$templater->register('leagueinfo', $leagueinfo);
			$templater->register('colspan', $colspan);
			$tabbits = $templater->render();

			$tabledata = fetch_leaguetable($vbulletin->GPC['l'], 0, $tabletype);
			$updownrel = fetch_soccertable_updownrel($leagueinfo, count($tabledata));
			$tablepos = 0;

			foreach ($tabledata AS $md => $teams)
			{
				if (empty($alpha))
				{
					$alpha = range('A', 'Z'); // A = 0! B = 1...
				}

				$matchgrouptitle = construct_phrase($vbphrase['soccer_group_alpha_x'], $alpha[($md - 1)]);

				$templater = vB_Template::create('vbsoccer_matchgroupbit');
				$templater->register('md', $md);
				$templater->register('colspan', $colspan);
				$templater->register('matchgrouptitle', $matchgrouptitle);
				$tabbits .= $templater->render();

				$templater = vB_Template::create('vbsoccer_tab_standard_head');
				$tabbits .= $templater->render();

				foreach ($teams AS $team)
				{
					$class = '';
					$tablepos = $team['pos'];
					$team['team_name'] = htmlspecialchars_uni($vbphrase['soccer_team_' . $team['did']]);

					if (!empty($vbulletin->options['vbsoccer_enableteamlinks']))
					{
						$team['team_name_url'] = sprintf('<a href="%s" target="_blank">%s</a>', $team['hp'], $team['team_name']);
					}
					else
					{
						$team['team_name_url'] = $team['team_name'];
					}

					if (isset($updownrel[$tablepos]))
					{
						$class = ' vbsoccer-' . $updownrel[$tablepos];
					}
					$team['pos_tendenz_image'] = 'empty';

					if (LANGUAGE_DIRECTION == 'rtl')
					{
						$g = $team['g'];
						$ga = $team['ga'];
						$team['g'] = $ga;
						$team['ga'] = $g;
					}

					$templater = vB_Template::create('vbsoccer_tab_standard_bit');
					$templater->register('leagueinfo', $leagueinfo);
					$templater->register('team', $team);
					$templater->register('cssclass', $class);
					$tabbits .= $templater->render();
				}
			}

			unset($team, $tabledata, $updownrel);
			$headtitle = construct_phrase($vbphrase['soccer_table_x'], $leagueinfo['league_name']);

			$tabletype = ''; // variable leeren wegen verlinkung in template!
			break;
		case 'cross': // kreuztabelle
			// aktuelle ligatabelle holen
			$tabledata = fetch_leaguetable($vbulletin->GPC['l'], 0, $tabletype);
			$tabledata = end($tabledata); // nur daten des letzten spieltages selektieren :)

			// alle spielergebnisse holen
			if (LANGUAGE_DIRECTION == 'rtl')
			{
				$points_home_column = 'points_away';
				$points_away_column = 'points_home';
			}
			else
			{
				$points_home_column = 'points_home';
				$points_away_column = 'points_away';
			}

			$matches = $vbulletin->db->query_read_slave("
				SELECT ma.*, IF(t.`custom_shortname` != '',
					t.`custom_shortname`, t.`sd_shortname`) AS `shortname`,
					t.sd_id AS sd_team_id
				FROM
					(SELECT lt.`team_id`,
						CAST(GROUP_CONCAT(m.`team_away_id`) AS CHAR) AS `team_away_list`,
						CAST(GROUP_CONCAT(CONCAT(IF(m.`" . $points_home_column . "` != -1, m.`" . $points_home_column . "`, '-')), ':',
							(IF(m.`" . $points_away_column . "` != -1, m.`" . $points_away_column . "`, '-'))) AS CHAR) AS `result_list`
					FROM `" . TABLE_PREFIX . "soccer_league_team` AS lt
					LEFT JOIN `" . TABLE_PREFIX . "soccer_match` m ON (lt.`team_id`=m.`team_home_id` AND m.`league_id`=" . $vbulletin->GPC['l'] . ")
					WHERE lt.`league_id`=" . $vbulletin->GPC['l'] . "
					GROUP BY lt.`team_id`
					) AS `ma`
				INNER JOIN `" . TABLE_PREFIX . "soccer_team` t ON (ma.`team_id`=t.`id`)
				");

			$leaguematchinfo = array();

			while (($matchinfo = $vbulletin->db->fetch_array($matches)))
			{
				// alle team_ids der gegnerischen mannschaften extrahieren
				$team_away_list = explode(',', $matchinfo['team_away_list']);

				// alle ergebnisse extrahieren
				$result_list = explode(',', $matchinfo['result_list']);

				foreach ($team_away_list as $key => $away_team_id)
				{
					$leaguematchinfo[$matchinfo['team_id']][$away_team_id][] = $result_list[$key];
				}

				$tabledata[$matchinfo['team_id']]['shortname'] = $matchinfo['shortname'];
			}

			$vbulletin->db->free_result($matches);
			unset($matchinfo);

			// kreuztabelle fuellen
			$tabcrossheadbits  = '';
			$tabbits_cache = '';
			$colspan = 4; //4 fixe spalten

			$tplObj->vbsoccer_tab_cross_head_bit    = vB_Template::create('vbsoccer_tab_cross_head_bit');
			$tplObj->vbsoccer_tab_cross_results_bit = vB_Template::create('vbsoccer_tab_cross_results_bit');
			$tplObj->vbsoccer_tab_cross_results     = vB_Template::create('vbsoccer_tab_cross_results');

			foreach($tabledata AS $team)
			{

				// spaltenueberschrift horizontal
				$colspan++; //pro team eine zusaetzliche spalte
				$team['team_name'] = htmlspecialchars_uni($vbphrase['soccer_team_' . $team['did']]);
				$team['shortname'] = htmlspecialchars_uni($team['shortname']);

				if (!empty($vbulletin->options['vbsoccer_enableteamlinks']))
				{
					$team['team_name_url'] = sprintf('<a href="%s" target="_blank">%s</a>', $team['hp'], $team['team_name']);
					$team['team_shortname_url'] = sprintf('<a href="%s" target="_blank">%s</a>', $team['hp'], $team['shortname']);
				}
				else
				{
					$team['team_name_url'] = $team['team_name'];
					$team['team_shortname_url'] = $team['shortname'];
				}

				$tplObj->vbsoccer_tab_cross_head_bit->register('team', $team);
				$tplObj->vbsoccer_tab_cross_head_bit->register('leagueinfo', $leagueinfo);
				$tabcrossheadbits .= $tplObj->vbsoccer_tab_cross_head_bit->render();

				// ergebnisse pro team vertikal
				$tabcrossresultsbits = '';

				foreach($tabledata AS $result)
				{
					$class = '';
					if (array_key_exists($result['id'], $leaguematchinfo[$team['id']]))
					{
						$sum = array();
						$mc = $np = 0;
						foreach ($leaguematchinfo[$team['id']][$result['id']] AS $res)
						{
							$mc++;
							if ($res == '-:-')
							{
								$np++;
								continue;
							}
							$r = explode(':', $res);
							$diff = intval($r[0])-intval($r[1]);
							//$sum[] = ($diff < 0 ? -1 : ($diff > 0 ? 1 : 0));
							$sum[] = intval($r[0])-intval($r[1]);
						}

						$sum = array_sum($sum);
						switch (true)
						{
							case ($np == $mc): $class = 'vbsoccer_crosstab_o'; break;
							case $sum == 0: $class = 'vbsoccer_crosstab_d'; break;
							case $sum > 0: $class = (LANGUAGE_DIRECTION == 'rtl') ? 'vbsoccer_crosstab_l' : 'vbsoccer_crosstab_w'; break;
							case $sum < 0: $class = (LANGUAGE_DIRECTION == 'rtl') ? 'vbsoccer_crosstab_w' : 'vbsoccer_crosstab_l'; break;
						}
						$tdcontent = implode('<br />', $leaguematchinfo[$team['id']][$result['id']]);

					}
					else
					{
						$class = 'vbsoccer_crosstab_empty';
						$tdcontent = '&nbsp;';
					}

					$tplObj->vbsoccer_tab_cross_results_bit->register('tdcontent', $tdcontent);
					$tplObj->vbsoccer_tab_cross_results_bit->register('tdclass', $class);
					$tabcrossresultsbits .= $tplObj->vbsoccer_tab_cross_results_bit->render();
				}

				$class = 'alt2';

				if (LANGUAGE_DIRECTION == 'rtl')
				{
					$g = $team['g'];
					$ga = $team['ga'];
					$team['g'] = $ga;
					$team['ga'] = $g;
				}

				$tplObj->vbsoccer_tab_cross_results->register('team', $team);
				$tplObj->vbsoccer_tab_cross_results->register('leagueinfo', $leagueinfo);
				$tplObj->vbsoccer_tab_cross_results->register('tabcrossresultsbits', $tabcrossresultsbits);
				$tabbits_cache .= $tplObj->vbsoccer_tab_cross_results->render();
			}

			unset($tplObj->vbsoccer_tab_cross_head_bit,
				  $tplObj->vbsoccer_tab_cross_results_bit,
				  $tplObj->vbsoccer_tab_cross_results);

			$templater = vB_Template::create('vbsoccer_leaguebit');
			$templater->register('leagueinfo', $leagueinfo);
			$templater->register('colspan', $colspan);
			$tabbits = $templater->render();

			$templater = vB_Template::create('vbsoccer_tab_cross_head');
			$templater->register('tabcrossheadbits', $tabcrossheadbits);
			$tabbits .= $templater->render();

			$tabbits .= $tabbits_cache;
			unset($tplObj, $tabcrossheadbits, $tabcrossresultsbits, $tabbits_cache);
			$headtitle = construct_phrase($vbphrase['soccer_cross_table_x'], $leagueinfo['league_name']);
			break;
		default: // standard-ligatabelle
			$tabledata = fetch_leaguetable($vbulletin->GPC['l'], $vbulletin->GPC['m'], $tabletype);
			$updownrel = fetch_soccertable_updownrel($leagueinfo, count($tabledata));
			$colspan = 9;

			$templater = vB_Template::create('vbsoccer_leaguebit');
			$templater->register('leagueinfo', $leagueinfo);
			$templater->register('colspan', $colspan);
			$tabbits = $templater->render();

			$templater = vB_Template::create('vbsoccer_tab_standard_head');
			$tabbits .= $templater->render();

			foreach ($tabledata AS $team)
			{
				$class = '';
				$tablepos = $team['pos'];
				$team['team_name'] = htmlspecialchars_uni($vbphrase['soccer_team_' . $team['did']]);

				if (!empty($vbulletin->options['vbsoccer_enableteamlinks']))
				{
					$team['team_name_url'] = sprintf('<a href="%s" target="_blank">%s</a>', $team['hp'], $team['team_name']);
				}
				else
				{
					$team['team_name_url'] = $team['team_name'];
				}

				if (isset($updownrel[$tablepos]))
				{
					$class = ' vbsoccer-' . $updownrel[$tablepos];
				}

				switch (true)
				{
					case $team['oldpos'] == '':
						$team['pos_tendenz_image'] = 'empty';
						break;
					case ($team['pos'] > $team['oldpos']):
						$team['pos_tendenz_image'] = ($team['pos'] - $team['oldpos']) > 2 ? 'arrow_s' : 'arrow_se';
						break;
					case ($team['pos'] < $team['oldpos']):
						$team['pos_tendenz_image'] = ($team['oldpos'] - $team['pos']) > 2 ? 'arrow_n' : 'arrow_ne';
						break;
					default:
						$team['pos_tendenz_image'] = 'empty';
						break;
				}

				if (LANGUAGE_DIRECTION == 'rtl')
				{
					$g = $team['g'];
					$ga = $team['ga'];
					$team['g'] = $ga;
					$team['ga'] = $g;
				}

				$templater = vB_Template::create('vbsoccer_tab_standard_bit');
				$templater->register('leagueinfo', $leagueinfo);
				$templater->register('team', $team);
				$templater->register('cssclass', $class);
				$tabbits .= $templater->render();
			}

			unset($team, $tabledata, $updownrel);
			$headtitle = construct_phrase($vbphrase['soccer_table_x'], $leagueinfo['league_name']);
			break;
	}

	$templater = vB_Template::create('vbsoccer_leaguefooter');
	$show['result_column'] = false;
	$templater->register('colspan', $colspan);
	$urlparams = array('do' => 'sdupdate', 'l' => $leagueinfo['id'], 'redo' => ($vbulletin->GPC['type'] == 'cross' ? 'crosstab' : 'tab'), 'm' => $matchday);
	$templater->register('urlparams', http_build_query($urlparams, '', '&amp;'));
	$tabbits .= $templater->render();


	vB_Template::preRegister($templatename, array(
		'colspan'           => $colspan,
		'league_jump'       => $league_jump,
		'matchday_jump'     => $matchday_jump,
		'leagueaction_jump' => $leagueaction_jump,
		'currentmatchday'   => $currentmatchday,
		'matchday'          => $matchday,
		'tabbits'           => $tabbits,
		'leagueinfo'        => $leagueinfo,
		'headtitle'         => $headtitle,
		));
}

// #############################################################################
// ranking der result-poster nur fuer benutzer sichtbar, die selbst die
// berechtigung zum einstellen von ergebnissen haben?
if ($vbulletin->userinfo['userid'] AND
	($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canpostresults']) AND
	isset($_REQUEST['do']) AND $_REQUEST['do'] == 'reportranking')
{
	// ranglisten
	$vbulletin->input->clean_array_gpc('r', array(
		'm'          => TYPE_UINT,
		'pagenumber' => TYPE_UINT,
		));

	$rankingbits = '';
	$perpage     = $vbulletin->GPC['perpage'];
	$pagenumber  = $vbulletin->GPC['pagenumber'];

	$posters = $vbulletin->db->query_first("
		SELECT COUNT(DISTINCT `userid`) `count`
		FROM `" . TABLE_PREFIX . "soccer_postresult_stats`
		WHERE `userid` != 0
		");

	$totalposters = $posters['count'];
	sanitize_pageresults($totalposters, $pagenumber, $perpage, 100, $vbulletin->options['vbsoccer_rankingusersperpage']);

	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = ($pagenumber) * $perpage;

	if ($limitupper > $totalposters)
	{
		$limitupper = $totalposters;

		if ($limitlower > $totalposters)
		{
			$limitlower = $totalposters - $perpage;
		}
	}

	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $totalposters, 'vbsoccer.php?' . $vbulletin->session->vars['sessionurl'], 'do=reportranking');

	$posters = $vbulletin->db->query_read("
		SELECT user.username, user.userid, SUM(count) AS `reports`,
			MAX(lastupdate) AS lastreport, COUNT(DISTINCT league_id) AS leagues
		FROM `" . TABLE_PREFIX . "soccer_postresult_stats` stats
		INNER JOIN `" . TABLE_PREFIX . "user` user USING(userid)
		GROUP BY stats.userid
		ORDER BY reports DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
		");

	while (($poster = $vbulletin->db->fetch_array($posters)))
	{
		if ($poster['lastreport'] > 0)
		{
			$poster['lastreport_date'] = vbdate($vbulletin->options['dateformat'], $poster['lastreport'], true);
			$poster['lastreport_time'] = vbdate($vbulletin->options['timeformat'], $poster['lastreport']);
		}
		else
		{
			$poster['lastreport_date'] = $poster['lastreport_time'] = 0;
		}

		$poster['reports'] = vb_number_format($poster['reports']);

		$templater = vB_Template::create('vbsoccer_reportrankingbit');
		$templater->register('poster', $poster);
		$rankingbits .= $templater->render();
	} // end while

	$vbulletin->db->free_result($posters);

	$templatename = 'vbsoccer_reportranking';

	vB_Template::preRegister($templatename, array(
		'headtitle'    => $vbphrase['soccer_reportranking'],
		'totalposters' => $totalposters,
		'pagenav'      => $pagenav,
		'rankingbits'  => $rankingbits,
		));
}


// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'overallranking')
{
	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'year'       => TYPE_UINT,
		'month'      => TYPE_UINT,
		'pagenumber' => TYPE_UINT,
		'sortfield'  => TYPE_STR,
		'sortorder'  => TYPE_STR,
		));

	$perpage    = $vbulletin->GPC['perpage'];
	$pagenumber = $vbulletin->GPC['pagenumber'];
	$sortfield  = $vbulletin->GPC['sortfield'];
	$sortorder  = $vbulletin->GPC['sortorder'];

	// per default nach punkten sortieren
	if ($sortfield == '')
	{
		$sortfield = 'pts';
	}

	if ($sortorder == '')
	{
		$sortorder = 'desc';
	}

	// aktuelles jahr ermitteln
	$dt = new DateTime('@' . TIMENOW, new DateTimeZone('UTC'));

	if (!empty($vbulletin->userinfo['timezoneoffset']))
	{
		$dt->modify('+' . $vbulletin->userinfo['timezoneoffset'] . ' HOURS');
	}

	$curyear  = $dt->format('Y');
	$ymlimit  = $dt->format('Y-m-t 23:59:59');

	if (empty($vbulletin->GPC['year']) AND empty($vbulletin->GPC['month']))
	{
		$vbulletin->GPC['month'] = $dt->format('n');
	}

	if (empty($vbulletin->GPC['year']))
	{
		$vbulletin->GPC['year'] = $curyear;
	}

	// timestamps
	$dt->setTime(0, 0);

	if (empty($vbulletin->GPC['month']))
	{
		// timestamps fuer das komplette jahr
		$dt->setDate($vbulletin->GPC['year'], 1, 1);
		$datetime_from = $dt->format('U');
		$dt->modify('+1 year');
		$datetime_to = $dt->format('U');
	}
	else
	{
		// timestamps fuer den kompletten monat
		$dt->setDate($vbulletin->GPC['year'], $vbulletin->GPC['month'], 1);
		$datetime_from = $dt->format('U');
		$dt->modify('+1 month');
		$datetime_to = $dt->format('U');
	}

	$months = array('january', 'february', 'march', 'april', 'may', 'june',
	                'july', 'august', 'september', 'october', 'november', 'december');

	$yearmonths = $vbulletin->db->query_read("
		SELECT YEAR(FROM_UNIXTIME(`dateline`)) AS `betyear`,
			CAST(GROUP_CONCAT(DISTINCT MONTH(FROM_UNIXTIME(`dateline`)) ORDER BY `dateline`) AS CHAR) AS `betmonths`
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		INNER JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.`id`=b.`match_id`)
		WHERE `dateline` < UNIX_TIMESTAMP('" . $ymlimit . "')
		GROUP BY YEAR(FROM_UNIXTIME(`dateline`))
		ORDER BY `betyear`
		");

	$yearoptions = '';
	$betmonths   = array();
	$found       = false;

	while (($yearmonth = $vbulletin->db->fetch_array($yearmonths)))
	{
		$templater = vB_Template::create('option');
		$templater->register('optiontitle', $yearmonth['betyear']);
		$templater->register('optionvalue', $yearmonth['betyear']);

		if ($yearmonth['betyear'] == $vbulletin->GPC['year'])
		{
			$optionselected = ' selected="selected"';
			$optionclass    = 'fjsel';
			$betmonths      = explode(',', $yearmonth['betmonths']);
			$betmonths      = array_flip($betmonths);
			$found = true;
		}
		else
		{
			$optionselected = '';
			$optionclass    = 'fjdpth0';
		}

		$templater->register('optionselected', $optionselected);
		$templater->register('optionclass', $optionclass);
		$yearoptions .= $templater->render();
	} // end while

	$vbulletin->db->free_result($yearmonths);
	unset($yearmonths, $yearmonth, $ymlimit, $dt);

	if (!$found)
	{
		// keine tipps gefunden, hier einfach das aktuelle jahr anzeigen
		$templater = vB_Template::create('option');
		$templater->register('optiontitle', $curyear);
		$templater->register('optionvalue', $curyear);
		$templater->register('optionselected', ' selected="selected"');
		$templater->register('optionclass', 'fjsel');
		$yearoptions = $templater->render();
	}

	$templater = vB_Template::create('option');
	$templater->register('optiontitle', $vbphrase['soccer_all_months']);
	$templater->register('optionvalue', 0);

	if ($vbulletin->GPC['month'])
	{
		$optionselected = '';
		$optionclass = 'fjdpth0';
	}
	else
	{
		$optionclass = 'fjsel';
		$optionselected = ' selected="selected"';
	}

	$templater->register('optionselected', $optionselected);
	$templater->register('optionclass', $optionclass);
	$monthnav = $templater->render();

	$templater = vB_Template::create('option');

	foreach ($months AS $monthnum => &$monthname)
	{
		$templater->register('optiontitle', $vbphrase[$monthname]);
		$templater->register('optionvalue', ($monthnum + 1));

		$optionclass = 'fjdpth0';

		if (isset($betmonths[($monthnum + 1)]))
		{
			// es existieren tipps fuer diesen monat
			if ($vbulletin->GPC['month'] == ($monthnum + 1))
			{
				$optionselected = ' selected="selected"';
				$optionclass = 'fjsel';
			}
			else
			{
				$optionselected = '';
			}
		}
		else
		{
			// keine tipps vorhanden
			$optionselected = ' disabled="disabled"';
		}

		$templater->register('optionselected', $optionselected);
		$templater->register('optionclass', $optionclass);
		$monthnav .= $templater->render();
	} // end foreach

	unset($templater, $months, $monthname, $optionselected, $optionclass, $optiontitle);

	$total = $vbulletin->db->query_first("
		SELECT COUNT(DISTINCT userid) AS `count`, COUNT(DISTINCT match_id) AS `bets`
		FROM `" . TABLE_PREFIX . "soccer_user_bet` b
		INNER JOIN `" . TABLE_PREFIX . "soccer_match` m ON (m.id=b.match_id)
		WHERE `dateline` BETWEEN " . (int) $datetime_from . " AND " . (int) $datetime_to . " AND `score_key`>0
		");

	vB_Template::preRegister('vbsoccer_overallrankingbit', array('total' => $total));
	$totalusers = $total['count'];

	sanitize_pageresults($totalusers, $pagenumber, $perpage, 100, $vbulletin->options['vbsoccer_rankingusersperpage']);

	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = ($pagenumber) * $perpage;

	if ($limitupper > $totalusers)
	{
		$limitupper = $totalusers;

		if ($limitlower > $totalusers)
		{
			$limitlower = $totalusers - $perpage;
		}
	}

	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}

	$sortorder = strtolower($sortorder);

	$secondarysortsql = '';

	switch ($sortfield)
	{
		case 'bets':
			$sqlsort = 'bets';
			$secondarysortsql = sprintf(', sum_pts %1$s, avg_pts %1$s', $sortorder);
			break;
		case 'pts':
		case 'sum_pts':
			$sqlsort = 'sum_pts';
			$secondarysortsql = sprintf(', avg_pts %s', $sortorder);
			break;
		case 'avg_pts':
		case 'avgpts':
			$sqlsort = 'avg_pts';
			$secondarysortsql = sprintf(', sum_pts %s', $sortorder);
			break;
		case 'wr':
		case 'rw':
		case 'rr':
		case 'rd':
			$sqlsort = $sortfield;
			if ($sortfield == 'wr')
			{
				$secondarysortsql = sprintf(', sum_pts %1$s, avg_pts %1$s', ($sortorder == 'desc' ? 'asc' : 'desc'));
			}
			else
			{
				$secondarysortsql = sprintf(', sum_pts %1$s, avg_pts %1$s', $sortorder);
			}
			break;
		default:
			$sqlsort = 'sum_pts';
			$secondarysortsql = sprintf(', avg_pts %s', $sortorder);
	}

	if ($sortorder != 'asc')
	{
		$sortorder    = 'desc';
		$oppositesort = 'asc';
	}
	else
	{
		$sortorder    = 'asc';
		$oppositesort = 'desc';
	}

	$action = 'do=overallranking&amp;year=' . $vbulletin->GPC['year'];

	$pagenav = construct_page_nav($pagenumber, $perpage, $totalusers, 'vbsoccer.php?' . $vbulletin->session->vars['sessionurl'], $action
	         . (!empty($vbulletin->GPC['month']) ? '&amp;month=' . $vbulletin->GPC['month'] : "")
	         . (!empty($vbulletin->GPC['perpage']) ? "&amp;pp=$perpage" : "")
	         . (!empty($sortorder) ? "&amp;order=$sortorder" : "")
	         . (!empty($sortfield) ? "&amp;sort=$sortfield" : ""));

	$sorturl = 'vbsoccer.php?' . $vbulletin->session->vars['sessionurl'] . $action
	         . (!empty($vbulletin->GPC['month']) ? '&amp;month=' . $vbulletin->GPC['month'] : "");

	$templater = vB_Template::create('forumdisplay_sortarrow');
	$templater->register('oppositesort', $oppositesort);
	$templater->register('sorturl', $sorturl);
	$templater->register('pagenumber', $pagenumber);
	$templater->register('perpage', $perpage);
	$templater->register('sortfield', $sortfield);
	$sortarrow[$sortfield] = $templater->render();

	$users = $vbulletin->db->query_read("
		SELECT `userid`, '' AS `username`, `bets`, `wr`, `rd`, (`bets`-`wr`-`rr`-`rd`) AS `rw`, `rr`,
			(`wr`*" . (int) $vbulletin->options['vbsoccer_points']['wr'] . ")+
			(`rr`*" . (int) $vbulletin->options['vbsoccer_points']['rr'] . ")+
			(`rd`*" . (int) $vbulletin->options['vbsoccer_points']['rd'] . ")+
			((`bets`-`wr`-`rr`-`rd`)*" . (int) $vbulletin->options['vbsoccer_points']['rw'] . ") AS `sum_pts`,
			((`wr`/`bets`)*" . (int) $vbulletin->options['vbsoccer_points']['wr'] . ")+
			((`rr`/`bets`)*" . (int) $vbulletin->options['vbsoccer_points']['rr'] . ")+
			((`rd`/`bets`)*" . (int) $vbulletin->options['vbsoccer_points']['rd'] . ")+
			(((`bets`-`wr`-`rr`-`rd`)/`bets`)*" . (int) $vbulletin->options['vbsoccer_points']['rw'] . ") AS `avg_pts`
		FROM
		(
			SELECT b.`userid`, COUNT(*) AS `bets`,
				SUM(`score_key`!=`bet_score_key`) AS `wr`,
				SUM(`bet_home`=`points_home` AND `bet_away`=`points_away`) AS `rr`,
				SUM(CAST(`bet_home`-`bet_away` AS SIGNED)=(`points_home`-`points_away`)
					AND NOT (`bet_home`=`points_home` AND `bet_away`=`points_away`)) AS `rd`
			FROM `" . TABLE_PREFIX . "soccer_user_bet` AS b
			INNER JOIN `" . TABLE_PREFIX . "soccer_match` AS m ON (m.`id`=b.`match_id`)
			WHERE `dateline` BETWEEN " . (int) $datetime_from . " AND " . (int) $datetime_to . " AND `score_key`>0
			GROUP BY b.`userid`
		) AS `foo`
		ORDER BY $sqlsort $sortorder $secondarysortsql
		LIMIT " . ($limitlower - 1) . ", $perpage
		");

	$rankingbits = '';

	if ($vbulletin->db->num_rows($users) > 0)
	{
		// kopfzeile
		$vbphrase['rr_head'] = construct_phrase($vbphrase['soccer_x_points_abbr'], $vbulletin->options['vbsoccer_points']['rr']);
		$vbphrase['rd_head'] = construct_phrase($vbphrase['soccer_x_points_abbr'], $vbulletin->options['vbsoccer_points']['rd']);
		$vbphrase['rw_head'] = construct_phrase($vbphrase['soccer_x_points_abbr'], $vbulletin->options['vbsoccer_points']['rw']);
		$vbphrase['wr_head'] = construct_phrase($vbphrase['soccer_x_points_abbr'], $vbulletin->options['vbsoccer_points']['wr']);

		$templater = vB_Template::create('vbsoccer_overallrankinghead');
		$templater->register('sorturl', $sorturl);
		$templater->register('perpage', $perpage);
		$templater->register('oppositesort', $oppositesort);
		$templater->register('sortarrow', $sortarrow);
		$rankingbits .= $templater->render();
	}

	$rankingresults = array();

	while (($user = $vbulletin->db->fetch_array($users)))
	{
		$rankingresults[$user['userid']] = $user;
	}

	$vbulletin->db->free_result($users);
	unset($users, $user);

	if (!empty($rankingresults))
	{
		$rankingusers = $vbulletin->db->query_read("
			SELECT userid, username
			FROM " . TABLE_PREFIX . "user
			WHERE userid IN(". implode(',', array_keys($rankingresults)) .")
			");

		while (($user = $vbulletin->db->fetch_array($rankingusers)))
		{
			$rankingresults[$user['userid']]['username'] = $user['username'];
		}

		$vbulletin->db->free_result($rankingusers);
		unset($rankingusers, $user);
	}

	$templater = vB_Template::create('vbsoccer_overallrankingbit');
	$templater->register('vbsoccerprefs', $vbulletin->userinfo['vbsoccerprefs']);

	foreach ($rankingresults AS &$user)
	{
		$templater->register('user', $user);
		$rankingbits .= $templater->render();
	}

	unset($templater, $rankingresults, $user);

	if ($vbulletin->GPC['month'])
	{
		$headtitle = construct_phrase($vbphrase['soccer_nav_overallranking_xy'], $vbulletin->GPC['year'], sprintf('%02d', $vbulletin->GPC['month']));
	}
	else
	{
		$headtitle = construct_phrase($vbphrase['soccer_nav_overallranking_x'], $vbulletin->GPC['year']);
	}

	$templatename = 'vbsoccer_overallranking';

	vB_Template::preRegister($templatename, array(
		'rankingbits' => $rankingbits,
		'totalusers'  => $totalusers,
		'pagenav'     => $pagenav,
		'monthnav'    => $monthnav,
		'yearoptions' => $yearoptions,
		'headtitle'   => $headtitle,
		));
}


// #############################################################################
if ($templatename != '')
{
	$templater = vB_Template::create($templatename);

	if (empty($headtitle))
	{
		$headtitle = $templater->registered('headtitle');
	}

	$HTML = $templater->render();

	if ((isset($vbulletin->vbsoccer_leaguecache['archiv'][$vbulletin->GPC['l']])
		OR isset($notsubscribed[$vbulletin->GPC['l']]))
		AND (!in_array($_REQUEST['do'], array('ranking', 'overallranking'))))
	{
		// befindet sich eine aufgerufene liga bei irgendeiner aktion im archiv
		// oder ist es ein
		// dann stets den main-menuepunkt 'archiv' aktivieren.
		// ausnahme: ranglisten - hier immer der menuepunkt ranglisten aktiv
		if (isset($notsubscribed[$vbulletin->GPC['l']]))
		{
			construct_soccer_nav('notsubscribed');
		}
		else
		{
			construct_soccer_nav('archive');
		}
	}
	else
	{
		// main-menuepunkt bei entsprechender aktion hervorheben. die eintraege
		// der aktuellen saisons werden hier nicht beruecksichtigt.
		construct_soccer_nav($_REQUEST['do']);
	}

	// build navbar
	$navbits_array = array();

	if (!empty($foruminfo['parentid']))
	{
		if (($parentforuminfo = fetch_foruminfo($foruminfo['parentid'])))
		{
			$navbits_array['forumdisplay.php?' . $vbulletin->session->vars['sessionurl'] . 'f=' . $parentforuminfo['forumid']] = $parentforuminfo['title'];
		}

		$navbits_array['forumdisplay.php?' . $vbulletin->session->vars['sessionurl'] . 'f=' . $foruminfo['forumid']] = $foruminfo['title'];
	}
	else
	{
		$navbits_array[$vbulletin->script . $vbulletin->session->vars['sessionurl_q']] = (!empty($vbphrase['soccer_forum_title']) ? $vbphrase['soccer_forum_title'] : $vbphrase['vbsoccer']);
	}

	$navbits_array[''] = $headtitle;

	$ad_location['ad_vbsoccer_first'] = vB_Template::create('ad_vbsoccer_first')->render();
	$ad_location['ad_vbsoccer_sidebar_start'] = vB_Template::create('ad_vbsoccer_sidebar_start')->render();
	$ad_location['ad_vbsoccer_sidebar_end'] = vB_Template::create('ad_vbsoccer_sidebar_end')->render();
	$ad_location['ad_vbsoccer_below_content'] = vB_Template::create('ad_vbsoccer_below_content')->render();

	$navbar = render_navbar_template(construct_navbits($navbits_array));

	$show['leaguearchive'] = !empty($vbulletin->vbsoccer_leaguecache['archiv']) ? true : false;
	$show['perms_canpostresults'] = ($permissions['vbsoccer_general_permissions'] & $vbsoccerperms['canpostresults']);

	// quicknav / forumjump
	$forumjump = '';
	$navpopup = array('id' => 'vbsoccer_navpopup');

	if (!empty($foruminfo))
	{
		$navpopup['title'] = $foruminfo['title_clean'];
		$navpopup['link']  = fetch_seo_url('forum', $foruminfo);
	}
	else
	{
		$navpopup['title'] = $vbphrase['vbsoccer'];
		$navpopup['link']  = 'vbsoccer.php';
	}

	construct_quick_nav($navpopup);

	$templater = vB_Template::create('vbsoccer_shell');
	$templater->register_page_templates();
	$templater->quickRegister(array(
		'template_hook' => $GLOBALS['template_hook'],
		'ad_location'   => $ad_location,
		'navbar'        => $navbar,
		'navclass'      => $GLOBALS['navclass'],
		'notsubscribed' => $notsubscribed,
		'cpnav'         => $cpnav,
		'HTML'          => $HTML,
		'forumjump'     => $forumjump,
		'headtitle'     => strip_tags($headtitle)
		));

	if (!empty($includecss))
	{
		$templater->register('includecss', $includecss);
	}

	print_output($templater->render());
}
