<?php
/* -*- mode: php; tab-width: 4; indent-tabs-mode: t; coding: utf-8 -*- */

/**
 * vbulletin add-on fussball-tippspiele
 *
 * vbulletin Version >= 4.0.2
 * php version 5
 *         _
 *  __   _| |__  ___  ___   ___ ___ ___ _ __
 *  \ \ / / '_ \/ __|/ _ \ / __/ __/ _ \ '__|
 *   \ V /| |_) \__ \ (_) | (_| (_|  __/ |
 *    \_/ |_.__/|___/\___/ \___\___\___|_|
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @author  xwing <xwing@geb-team.de>
 * @version SVN: $Id: functions_vbsoccer.php 1397 2010-05-14 12:32:27Z aa $
 */

if (!defined('VBSOCCER_DEFERRED'))
{
	/**
	 * unix-timestamp fuer 2037-12-31 00:00:00.
	 *
	 * dieser zeitstempel wird bei allen spielansetzungen hinterlegt, deren
	 * anstoss entweder nicht bekannt ist oder die auf unbestimmte zeit
	 * verlegt wurden. wird dieser zeitstempel beim anzeigen von ansetzungen
	 * entdeckt, wird kein datum/uhrzeit-string angezeigt sondern ein ueber-
	 * setzbarer string (phrase 'soccer_deferred').
	 */
	define('VBSOCCER_DEFERRED', 2145826800);
}

/**
 * liefert htmlcode fuer eine spielansetzung mit optionaler tipp-abgabe
 *
 * @param  array $leagueinfo ligainformationen
 * @param  array $matchinfo  spielinformationen
 *
 * @return string html-code fuer eine ansetzung
 */
function construct_matchbit($leagueinfo, $matchinfo)
{
	global $vbphrase, $show, $mainfontclass;
	static $tabindexcount;

	if (!isset($GLOBALS['matchday_points']))
	{
		$GLOBALS['matchday_points'] = 0;
	}

	// anstoss datum/zeit
	$show['kickoff_is_today'] = false;

	if ($matchinfo['dateline'] == VBSOCCER_DEFERRED)
	{
		if ($matchinfo['match_is_finished'] == 1)
		{
			// spiel ist verschoben *und* abgepfiffen: findet nicht mehr statt!
			// spiel einfach ausblenden
			return '';
		}
		$matchinfo['kickoffdate'] = $matchinfo['kickofftime'] = false;
	}
	else
	{
		$matchinfo['kickoffdate'] = vbdate($GLOBALS['vbulletin']->options['dateformat'], $matchinfo['dateline'], true);
		if (preg_match('/1$/', $matchinfo['dateline']))
		{
			$matchinfo['kickofftime'] = false;
		}
		else
		{
			$matchinfo['kickofftime'] = vbdate($GLOBALS['vbulletin']->options['timeformat'], $matchinfo['dateline']);
		}

		if (!defined('VBSOCCER_TODAYDATE'))
		{
			if (defined('TODAYDATE'))
			{
				define('VBSOCCER_TODAYDATE', TODAYDATE);
			}
			else
			{
				define ('VBSOCCER_TODAYDATE', vbdate('n-j-Y', TIMENOW, false, false));
			}
		}

		if (VBSOCCER_TODAYDATE == vbdate('n-j-Y', $matchinfo['dateline'], false, false))
		{
			$show['kickoff_is_today'] = true;
		}

	}

	if ($GLOBALS['vbulletin']->userinfo['userid'] AND $show['canbet'] AND TIMENOW < $matchinfo['dateline'] AND
		(isset($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'][$matchinfo['league_id']])
		 AND empty($leagueinfo['readonly'])) )
	{
		// eingabefelder fuer tippabgabe
		$show['allowbet'] = true;

		if (empty($tabindexcount))
		{
			$tabindexcount = 5000;
		}

		$matchinfo['tabindex_home'] = ++$tabindexcount;
		$matchinfo['tabindex_away'] = ++$tabindexcount;

		$betbitTemplate = 'vbsoccer_betinput';
	}
	else
	{
		// anzeige des abgegebenen tipps oder '-:-' wenn kein tipp abgegeben
		if ($matchinfo['bet_home'] == '' OR $matchinfo['bet_away'] == '')
		{
			$matchinfo['bet_home'] = $matchinfo['bet_away'] = '-';
		}

		if ($show['showpoints'])
		{
			// erreichte punkte anzeigen (nur auf tippseite)
			$pointkey = soccer_fetch_pointkey($matchinfo);
			$points = (isset($GLOBALS['vbulletin']->options['vbsoccer_points'][$pointkey])
					   ? (int) $GLOBALS['vbulletin']->options['vbsoccer_points'][$pointkey] : 0);
			$GLOBALS['matchday_points'] += $points;
			$matchinfo['pointcolor'] = $GLOBALS['vbulletin']->userinfo['vbsoccerprefs']['color'][$pointkey];
		}

		if (LANGUAGE_DIRECTION == 'rtl')
		{
			// bloede idee, aber was solls
			$a = $matchinfo['bet_away'];
			$h = $matchinfo['bet_home'];
			$matchinfo['bet_home'] = $a;
			$matchinfo['bet_away'] = $h;
		}

		$betbitTemplate = 'vbsoccer_betbit';
		vB_Template::preRegister($betbitTemplate, array('points' => $points));
	}

	if (!empty($show['match_result']) AND LANGUAGE_DIRECTION == 'rtl')
	{
		$h = $matchinfo['team_home_goals'];
		$a = $matchinfo['team_away_goals'];
		$matchinfo['team_home_goals'] = $a;
		$matchinfo['team_away_goals'] = $h;
	}

	$templater = vB_Template::create($betbitTemplate);
	$templater->register('matchinfo', $matchinfo);
	$matchbetbit = $templater->render();

	switch (true)
	{
		case ($matchinfo['dateline'] <= TIMENOW):
			$matchinfo['statusicon'] = $matchinfo['match_is_finished'] == 1 ? 'done.png' : 'hourglass.png';
			break;
		case ($matchinfo['dateline'] > TIMENOW):
			$matchinfo['statusicon'] = 'scheduled.png';
			break;
		default:
			$matchinfo['statusicon'] = 'scheduled.png';
			break;
	}

	$templater = vB_Template::create('vbsoccer_matchbit');
	$templater->register('matchinfo', $matchinfo);
	$templater->register('leagueinfo', $leagueinfo);
	$templater->register('matchbetbit', $matchbetbit);

	return $templater->render();
}

/**
 * erzeugen eines 'gewinnschluessel'-strings
 *
 * @param array $data spiel- und tippdaten eines spiels fuer einen user
 * @return string 'nb': nicht getippt oder spiel ist noch nicht angepfiffen
 *                'wr': falscher tipp
 *                'rw': auf richtigen gewinner getippt
 *                'rd': richtiger gewinner und richtiges torverhaeltnis
 *                'rr': korrekter tipp
 */
function soccer_fetch_pointkey($data=array())
{
	$key = 'wr';

	if ($data['team_home_goals'] == '-' OR $data['team_away_goals'] == '-')
	{
		// spiel hat kein ergebnis
		return 'nb';
	}

	if (($data['bet_home'] == '-' OR $data['bet_away'] == '-') OR
		($data['bet_home'] == '' OR $data['bet_away'] == ''))
	{
		// spiel wurde nicht getippt
		return 'nb';
	}

	if ((int) $data['score_key'] == (int) $data['bet_score_key'])
	{
		// spielausgang ist richtig (score_keys von spiel und tipp identisch)
		$key = 'rw';

		if (((int) $data['bet_home'] - (int) $data['bet_away'] == (int) $data['team_home_goals'] - (int) $data['team_away_goals']))
		{
			// tordifferenz ist richtig
			$key = 'rd';
		}

		if (((int) $data['bet_home'] == (int) $data['team_home_goals']) AND
			((int) $data['bet_away'] == (int) $data['team_away_goals']))
		{
			// ergebnis ist identisch mit tipp
			$key = 'rr';
		}
	}

	return $key;
}


/**
 * berechnung des score_keys (gewinnschluessel eines ergebnisses oder tipps)
 *
 * 0 = nicht getippt, nicht gespielt
 * 1 = team A gewinnt
 * 2 = unentschieden
 * 3 = team B gewinnt
 *
 * @param int tore team A
 * @param int tore team B
 * @return int score_key
 */
function fetch_soccer_score_key($home=-1, $away=-1)
{
	switch (true)
	{
		case ($home == -1 or $away == -1): return 0; break;
		case ($home == $away):             return 2; break;
		case ($home > $away):              return 1; break;
		case ($home < $away):              return 3; break;
	}
}


/**
 * liefert eine html-auswahlbox fuer alle ligen
 *
 * @param int aktuelle ligaid
 * @param string 'all' oder 'tab'. ist der parameter 'tab' engegeben, werden in
 *               in der auswahlbox die ligen deaktiviert, fuer die keine
 *               tabelle generiert werden soll.
 * @return string html-auswahlbox fuer ligen
 */
function construct_soccer_league_jump($curleagueid=0, $type='all')
{
	$optgroup_extra        = '';
	$archiv_options        = '';
	$notsubscribed_options = '';
	$current_options       = '';

	$GLOBALS['show']['notsubscribed'] = false;

	$tplObj = new stdClass;
	$tplObj->option   = vB_Template::create('option');
	$tplObj->optgroup = vB_Template::create('optgroup');

	$GLOBALS['notsubscribed'] = array();

	if (!empty($GLOBALS['vbulletin']->userinfo['vbsoccerprefs']['lhide']))
	{
		foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache AS $leagueid => $leagueinfo)
		{
			if (in_array(strtolower($leagueinfo['sd_shortname']), $GLOBALS['vbulletin']->userinfo['vbsoccerprefs']['lhide']))
			{
				// ausgeblendete ligen nicht im menue anzeigen
				$GLOBALS['notsubscribed'][$leagueinfo['id']] = $leagueinfo;
			}
		}

		if (isset($GLOBALS['notsubscribed'][$curleagueid]))
		{
			$GLOBALS['show']['notsubscribed'] = true;
		}
	}

	$leagueclassdepth = ((!empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv']) AND
						 !empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'])) ? 1 : 0);

	if (!empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['current']))
	{
		foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'] AS $optionvalue)
		{
			$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$optionvalue];

			if (isset($GLOBALS['notsubscribed'][$leagueinfo['id']]))
			{
				// ausgeblendeten wettbewerb nicht in auswahl anzeigen
				continue;
			}

			if ($type == 'tab' AND $leagueinfo['showtable'] == 0)
			{
				// wettbewerb ohne tabelle: deaktiviert anzeigen
				$optionselected = ' disabled="disabled"';
			}
			else
			{
				$optionselected = '';
			}

			if ($optionvalue == $curleagueid)
			{
				$optionselected .= ' selected="selected"';
			}

			$optionclass = ($optionvalue == $curleagueid ? 'fjsel' : 'fjdpth' . $leagueclassdepth);

			$tplObj->option->quickRegister(array(
				'optionclass' => $optionclass,
				'optionvalue' => $optionvalue,
				'optiontitle' => fetch_soccer_leaguename($leagueinfo),
				'optionselected' => $optionselected,
				));

			$current_options .= $tplObj->option->render();
		}
	}

	if (!empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv']))
	{
		if ($current_options != '')
		{
			$tplObj->optgroup->quickRegister(array(
				'optgroup_label'   => $GLOBALS['vbphrase']['soccer_current_saison'],
				'optgroup_options' => $current_options,
				'optgroup_extra'   => '',
				));

			$current_options = $tplObj->optgroup->render();
		}

		foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv'] AS $optionvalue)
		{
			$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$optionvalue];

			if (isset($GLOBALS['notsubscribed'][$leagueinfo['id']]))
			{
				// ausgeblendeten wettbewerb nicht in auswahl anzeigen
				continue;
			}

			if ($type == 'tab' AND $leagueinfo['showtable'] == 0)
			{
				// wettbewerb ohne tabelle: deaktiviert anzeigen
				$optionselected = ' disabled="disabled"';
			}
			else
			{
				$optionselected = '';
			}

			if ($optionvalue == $curleagueid)
			{
				$optionselected .= ' selected="selected"';
			}

			$optionclass = ($optionvalue == $curleagueid ? 'fjsel' : 'fjdpth' . $leagueclassdepth);

			$tplObj->option->quickRegister(array(
				'optionclass' => $optionclass,
				'optionvalue' => $optionvalue,
				'optiontitle' => fetch_soccer_leaguename($leagueinfo),
				'optionselected' => $optionselected,
				));

			$archiv_options .= $tplObj->option->render();
		}

		if ($current_options != '')
		{
			$tplObj->optgroup->quickRegister(array(
				'optgroup_label'   => $GLOBALS['vbphrase']['soccer_past_saisons'],
				'optgroup_options' => $archiv_options,
				'optgroup_extra'   => '',
				));

			$archiv_options = $tplObj->optgroup->render();
		}
	}

	// nicht abnonnierte ligen gruppiert am ende des selektors anzeigen
	if (!empty($GLOBALS['notsubscribed']))
	{
		foreach ($GLOBALS['notsubscribed'] AS $optionvalue => $leagueinfo)
		{
			if (($type == 'tab' AND $leagueinfo['showtable'] == 0))
			{
				continue;
			}

			$tplObj->option->quickRegister(array(
				'optionclass' => ($optionvalue == $curleagueid ? 'fjsel' : 'fjdpth1'),
				'optionvalue' => $optionvalue,
				'optiontitle' => fetch_soccer_leaguename($leagueinfo),
				'optionselected' =>  ($optionvalue == $curleagueid ? ' selected="selected"' : ''),
				));

			$notsubscribed_options .= $tplObj->option->render();
		}

		if ($notsubscribed_options != '')
		{
			$tplObj->optgroup->quickRegister(array(
				'optgroup_label'   => $GLOBALS['vbphrase']['soccer_not_subscribed'],
				'optgroup_options' => $notsubscribed_options,
				'optgroup_extra'   => '',
				));

			$notsubscribed_options = $tplObj->optgroup->render();
		}
	}

	$options = $current_options . $archiv_options . $notsubscribed_options;
	unset($tplObj, $current_options, $archiv_options, $notsubscribed_options);

	if ($options == '')
	{
		return $options;
	}

	return '<select name="l" id="l" onchange="soccer_leaguechange(this.form);">' . $options . '</select>';
}

/**
 * liganame aus phrase und saison zusammensetzen
 *
 * @param array $leagueinfo ligainformationen
 * @return string liganame
 */
function fetch_soccer_leaguename($leagueinfo)
{
	$leagueinfo['league_name'] = construct_phrase($GLOBALS['vbphrase']['soccer_league_x_saison_y'],
												  $GLOBALS['vbphrase'][$leagueinfo['phrase']],
												  fetch_soccer_leagueseason($leagueinfo['sd_shortname'], $leagueinfo['sd_saison'])
												  );

	return htmlspecialchars_uni($leagueinfo['league_name']);
}

function fetch_soccer_leagueseason($type, $saison)
{
	switch ($type)
	{
		case 'WM':
		case 'EM':
		case 'ASV':
		case 'BRA':
		case 'NOR':
			$saison = substr($saison, 0, 4);
			break;
	}

	return $saison;
}

/**
 * erstellt ein array mit css-klassen-namen fuer mainmenue
 *
 * @param string $selectedcell ausgewaehlter menueeintrag
 */
function construct_soccer_nav($selectedcell='')
{
	$cells = array('archive', 'pt', 'thread', 'schedule', 'settings',
				   'ranking', 'live', 'notsubscribed', 'reportranking',
				   'overallranking', 'hall_of_fame'
				   );

	/**
	 * array mit allen css-klassen je menueeintrag
	 *
	 * @global array $GLOBALS['navclass']
	 * @name $navclass
	 */
	$GLOBALS['navclass'] = array();

	foreach ($cells AS $cellname)
	{
		$GLOBALS['navclass']["$cellname"] = 'inactive';
	}

	if ($selectedcell != '')
	{
		$GLOBALS['navclass']["$selectedcell"] = 'active';
	}
}

/**
 * ermittelt alle verfuegbaren spieltage einer liga
 *
 * @param void
 * @return array spieltagsinformationen
 */
function fetch_soccer_matchdayinfo()
{
	$matchdays = $GLOBALS['db']->query_read("
		SELECT m.`match_day`, mt.`phrase_id`, SUM(score_key) AS `todaymatchday`,
			" . construct_soccer_sql_matchdaygroups() . " AS `matchday_group`,
			MIN(m.dateline) AS firstmatchdaymatch
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		LEFT JOIN `" . TABLE_PREFIX . "soccer_matchtype` AS mt USING(`matchtype_id`)
		WHERE m.`league_id`=" . (int) $GLOBALS['leagueinfo']['id'] . "
		GROUP BY m.`match_day`
		ORDER BY m.`match_day`
		");

	$matchdayinfo = array();

	while (($matchday = $GLOBALS['db']->fetch_array($matchdays)))
	{
		if (empty($GLOBALS['todaymatchday']) AND $matchday['todaymatchday'] == 0 AND ($matchday['match_day']-1 > 0))
		{
			if (172800 > ($matchday['firstmatchdaymatch'] - TIMENOW))
			{
				$GLOBALS['todaymatchday'] = $matchday['match_day'];
			}
			else
			{
				$GLOBALS['todaymatchday'] = $matchday['match_day']-1;
			}
		}

		if (empty($GLOBALS['firstmatchday']))
		{
			$GLOBALS['firstmatchday'] = $matchday['match_day'];
		}

		$matchdayinfo[$matchday['matchday_group']][$matchday['match_day']] = construct_soccer_matchday_phrase($matchday['match_day'], $matchday['phrase_id']);
		$GLOBALS['lastmatchday'] = $matchday['match_day'];
	}

	$GLOBALS['db']->free_result($matchdays);

	if (empty($GLOBALS['todaymatchday']))
	{
		// konnte kein spieltag als aktueller spieltag gefunden werden, dann den
		// letzten spieltag der liga als aktuellen spieltag setzen
		$GLOBALS['todaymatchday'] = $GLOBALS['lastmatchday'];
	}

	return $matchdayinfo;
}

function fetch_soccerblock_saison_rankings($league_info=array(), $blockentriestype=1)
{
	global $vbulletin;

	if (!isset($league_info['x_ranking']))
	{
		if (!($league_info = $vbulletin->db->query_first("
			SELECT id, x_ranking, visible, readonly
			FROM `" . TABLE_PREFIX . "soccer_league` WHERE id=". (int) $league_info['id'] ."
			")))
		{
			return '';
		}
	}

	if ($league_info['readonly'] == 1 OR $league_info['visible'] < 1)
	{
		return '';
	}

	if ($league_info['x_ranking'] == '')
	{
		$serialized_ranks = construct_saison_rankings($league_info['id'], 10);

		$vbulletin->db->query_write("
				UPDATE `" . TABLE_PREFIX . "soccer_league`
				SET `x_ranking`='" . $vbulletin->db->escape_string($serialized_ranks) . "'
				WHERE `id`=" . (int) $league_info['id'] . "
				");

		$league_info['x_ranking'] = $serialized_ranks;
	}

	$x_ranking = unserialize($league_info['x_ranking']);
	$rankingusers = array();

	foreach ($x_ranking AS $data)
	{
		foreach ($data AS $uids)
		{
			foreach ($uids AS $uid)
			{
				$rankingusers[$uid] = $uid;
			}
		}
	}


	if (!empty($rankingusers))
	{
		$result = $vbulletin->db->query_read("
			SELECT `userid`, `username`
			FROM `" . TABLE_PREFIX . "user`
			WHERE `userid` IN(" . implode(',', $rankingusers) . ")
			");

		while (($row = $vbulletin->db->fetch_array($result)))
		{
			$rankingusers[$row['userid']] = $row['username'];
		}

		$vbulletin->db->free_result($result);


		//$show['league_name'] = $vbphrase[$vbulletin->vbsoccer_leaguecache[$i]['phrase']];
		//$show['region'] = $vbulletin->vbsoccer_leaguecache[$i]['region'];
		//$region = strtolower($show['region']);
		$topusers = array();

		switch ($blockentriestype)
		{
			case 1:
			case 4:
				$limit = 3;
				break;
			case 2:
			case 5:
				$limit = 5;
				break;
			case 3:
			case 6:
				$limit = 10;
				break;
			default:
				$limit = 3; break;
		}

		foreach (range(1, $limit) AS $pos)
		{
			if (isset($x_ranking[$pos]))
			{
				$topusers[$pos]['users'] = array();

				foreach ($x_ranking[$pos] AS $_points => $_users)
				{
					if (empty($_points))
					{
						unset($topusers[$pos]);
						continue;
					}

					$topusers[$pos]['pts'] = $_points;

					foreach ($_users as $u)
					{
						if (isset($rankingusers[$u]))
						{
							$rankuser = $rankingusers[$u];
							$topusers[$pos]['users'][] = '<a href="member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $u . '">' . $rankuser . '</a>';
						}
						else
						{
							$topusers[$pos]['users'][] = htmlspecialchars_uni(fetch_phrase('soccer_deleted_user', 'vbsoccer'));
						}
					}
				} // end foreach

				if (isset($topusers[$pos]['users']))
				{
					$topusers[$pos]['users'] = implode('<br />', $topusers[$pos]['users']);
				}
			}
		} // end foreach
	}

	$templater = vB_Template::create('block_vbsoccer_rankings');
	$templater->register('leagueinfo', $league_info);
	$templater->register('rankingentries', $topusers);
	return $templater->render();
}

function fetch_soccerblock_saison_table($leagueid=0)
{
	global $vbulletin, $vbphrase, $saisonlastmatchday;

	$tabledata = array();

	if (($leagueinfo = $vbulletin->db->query_first("
			SELECT tabledata, sd_sent_back_down, sd_relegation, sd_called_up, lastmatchday, sd_shortname, showtable
			FROM `" . TABLE_PREFIX . "soccer_league`
			WHERE id=" . (int) $leagueid . " AND showtable=1
			")))
	{
		if (in_array(strtolower($leagueinfo['sd_shortname']), array('wm', 'em', 'chl', 'eul', 'dfb')))
		{
			return '';
		}

		if ($leagueinfo['tabledata'] != '')
		{
			$tabledata = unserialize($leagueinfo['tabledata']);
		}

		if (empty($tabledata))
		{
			$tabledata = build_leaguetable($leagueid);
			if (!empty($saisonlastmatchday))
			{
				$leagueinfo['lastmatchday'] = $saisonlastmatchday;
			}
		}

		if ($leagueinfo['lastmatchday'] != 0 AND isset($tabledata[$leagueinfo['lastmatchday']]))
		{
			$tabledata = $tabledata[$leagueinfo['lastmatchday']];
		}
		else
		{
			$tabledata = end($tabledata);
		}
	}

	if (!empty($tabledata) AND is_array($tabledata))
	{
		$updownrel = fetch_soccertable_updownrel($leagueinfo, count($tabledata));
		foreach ($tabledata AS &$team)
		{
			if (!empty($vbphrase['soccer_team_alias_' . $team['did']]))
			{
				$team['name'] = htmlspecialchars($vbphrase['soccer_team_alias_' . $team['did']]);
			}
			else
			{
				$team['name'] = htmlspecialchars($vbphrase['soccer_team_' . $team['did']]);
			}
			if (isset($updownrel[$team['pos']]))
			{
				$team['poscss'] = ' vbsoccer-' . $updownrel[$team['pos']];
			}
			switch (true)
			{
				case $team['oldpos'] == '':
					$team['pos_tendenz_image'] = 'empty';
					break;
				case ($team['pos'] > $team['oldpos']):
					$team['pos_tendenz_image'] = ($team['pos'] - $team['oldpos']) > 2 ? 'arrow_s' : 'arrow_se';
					break;
				case ($team['pos'] < $team['oldpos']):
					$team['pos_tendenz_image'] = ($team['oldpos'] - $team['pos']) > 2 ? 'arrow_n' : 'arrow_ne';
					break;
				default:
					$team['pos_tendenz_image'] = 'empty';
					break;
			}
		}
		$templater = vB_Template::create('block_vbsoccer_table');
		$templater->register('leagueid', $leagueid);
		$templater->register('tableentries', $tabledata);
		return $templater->render();
	}

	return '';
}

function construct_saison_rankings($league_id, $positions=10)
{
	global $vbulletin;

	if (!isset($vbulletin->options['vbsoccer_points']))
	{
		return array();
	}
	else
	{
		if (!is_array($vbulletin->options['vbsoccer_points']))
		{
			$vbulletin->options['vbsoccer_points'] = @unserialize($vbulletin->options['vbsoccer_points']);
		}
	}

	$result = $vbulletin->db->query_read("
		SELECT u.userid,
			(_wr * " . (int) $vbulletin->options['vbsoccer_points']['wr'] . ") +
			((_count - _wr - _rr - _rd) * " . (int) $vbulletin->options['vbsoccer_points']['rw'] . ") +
			(_rd * " . (int) $vbulletin->options['vbsoccer_points']['rd'] . ") +
			(_rr * " . (int) $vbulletin->options['vbsoccer_points']['rr'] . ") AS points
		FROM (
			SELECT userid, COUNT(*) AS _count,
				SUM(score_key != bet_score_key) AS _wr,
				SUM(bet_home=points_home AND bet_away=points_away) AS _rr,
				SUM(CAST(bet_home - bet_away AS SIGNED)=(points_home - points_away)
					AND NOT (bet_home = points_home AND bet_away = points_away)) AS _rd
			FROM " . TABLE_PREFIX . "soccer_user_bet AS b
			INNER JOIN " . TABLE_PREFIX . "soccer_match AS m ON(m.id=b.match_id)
			WHERE m.league_id=" . (int) $league_id . " AND score_key>0
			GROUP BY userid) AS userpoints
		INNER JOIN " . TABLE_PREFIX . "user AS u USING(userid)
		ORDER BY points DESC, username
		LIMIT 40
		");

	$count = 0;
	$pos = 0;
	$data = array();

	while (($row = $vbulletin->db->fetch_array($result)))
	{
		$count++;
		if (!isset($oldpoints) OR $oldpoints != $row['points'])
		{
			$rank = $count;
		}

		$oldpoints = $row['points'];


		if ($rank > $positions)
		{
			break;
		}

		$data[$rank][$row['points']][] = $row['userid'];
	}

	$vbulletin->db->free_result($result);

	return serialize($data);
}

/**
 *
 * @since 0.1.11
 */
function build_leagues_datastore()
{
	$GLOBALS['vbulletin']->db->hide_errors();

	$leagues_result = $GLOBALS['vbulletin']->db->query_read("
		SELECT league.*, CONCAT('soccer_leaguetype_', LOWER(league.`sd_shortname`)) AS `phrase`,
			masterphrase.`text` AS `league_name`, IFNULL(soccer_league_group.`displayorder`, 0) AS `grouporder`
		FROM (`" . TABLE_PREFIX . "soccer_league` AS `league`, `" . TABLE_PREFIX . "phrase` AS `masterphrase`)
		LEFT JOIN `" . TABLE_PREFIX . "soccer_league_group` AS `soccer_league_group` ON(soccer_league_group.`groupid`=league.`groupid`)
		WHERE league.`visible`!=0
			AND masterphrase.`languageid`=0
			AND masterphrase.`fieldname`='vbsoccernames'
			AND masterphrase.`varname`=CONCAT('soccer_leaguetype_', LOWER(league.`sd_shortname`))
		ORDER BY `grouporder`, league.`displayorder`, `league_name`, league.sd_saison
		");

	$GLOBALS['vbulletin']->db->show_errors();

	if ($GLOBALS['vbulletin']->db->errno)
	{
		return false;
	}

	$league_cache = array(
		'archiv'  => array(),
		'current' => array(),
		);

	while (($league = $GLOBALS['vbulletin']->db->fetch_array($leagues_result)))
	{
		if ($league['description'] != '')
		{
			$stripped = strip_tags($league['description']);

			if (strlen($stripped) != strlen($league['description']))
			{
				// htmlcode in beschreibung
				// @todo umwandeln von <br> nach \n noetig?
			}
		}

		$league['description'] = strtr($league['description'], array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />'));
		$league['id']                     = (int) $league['id'];
		$league['sd_id']                  = (int) $league['sd_id'];
		$league['last_cronjob_timestamp'] = (int) $league['last_cronjob_timestamp'];
		$league['sd_lastupdate']          = (int) $league['sd_lastupdate'];
		$league['sd_lastupdate_matches']  = (int) $league['sd_lastupdate_matches'];
		$league['sd_lastupdate_teams']    = (int) $league['sd_lastupdate_teams'];
		$league['groupid']                = (int) $league['groupid'];

		if ((int) $league['visible'] === -1)
		{
			$league_cache['archiv'][$league['id']] = $league['id'];
			$archivSaisons[$league['id']] = $league['sortsaison'];
		}
		else
		{
			$league_cache['current'][$league['id']] = $league['id'];
		}

		unset($league['league_name'], $league['visible'], $league['x_ranking'], $league['tabledata']);
		$league_cache[$league['id']] = $league;
	} // end while

	$GLOBALS['vbulletin']->db->free_result($leagues_result);

	build_datastore('vbsoccer_leaguecache', serialize($league_cache), 1);

	return true;
}

/**
 * ermittelt das datum der letzten datenaktualisierung
 *
 * von den 3 zeitstempeln fuer die letzte aktualisierung der liga-, team- oder
 * ansetzungsdaten wird der jeweils aktuellere (hoechste) wert benutzt und die
 * phrase 'soccer_last_update_on' erstellt.
 *
 * @param array $leagueinfo ligainformationen aus dem liga-cache
 * @return boolean
 */
function build_vbsoccer_lastupdate_info($leagueinfo)
{
	global $vbulletin, $show, $vbphrase;

	$show['sdupdate'] = ($vbulletin->userinfo['userid'] AND (TIMENOW - 120) < $leagueinfo['last_cronjob_timestamp'] ? false : true);

	$lastupdate = max(array(
		$leagueinfo['sd_lastupdate'],
		$leagueinfo['sd_lastupdate_matches'],
		$leagueinfo['sd_lastupdate_teams']
		));

	if ($lastupdate == 0)
	{
		$vbphrase['soccer_last_update_on'] = $vbphrase['soccer_last_update_never'];
		return false;
	}

	$vbphrase['soccer_last_update_on'] = construct_phrase(
		$vbphrase['soccer_last_update_on_x'],
		vbdate($vbulletin->options['dateformat'], $lastupdate, true),
		vbdate($vbulletin->options['timeformat'], $lastupdate)
		);

	return true;
}

function build_leaguetable($leagueid)
{
	global $vbulletin;

	$teamSummaryInitialValues = array(
		'm'    => 0, // anzahl spiele einer mannschaft
		'g'    => 0, // anzahl tore einer mannschaft
		'ga'   => 0, // anzahl gegentore einer mannschaft
		'diff' => 0, // tordifferenz
		'w'    => 0, // anzahl gewonnener spiele einer mannschaft
		'l'    => 0, // anzahl verlorener spiele einer mannschaft
		'd'    => 0, // anzahl unentschiedener spiele einer mannschaft
		'pts'  => 0, // anzahl punkte einer mannschaft
		'sp'   => 0, // strafpunkte fuer saison
		);

	$teams = $matchdaySummary = $teamSummary = $teamorder = $matchdayMatches = array();

	$result = $vbulletin->db->query_read("
		SELECT team.*,
			IF(team.`custom_shortname` != '', team.`custom_shortname`, team.`sd_shortname`) AS `shortname`,
			IF(team.`custom_homepage`!='', team.`custom_homepage`, team.`sd_homepage`) AS `homepage`,
			league_team.points AS start_points
		FROM `" . TABLE_PREFIX . "soccer_team` AS team
		INNER JOIN `" . TABLE_PREFIX . "soccer_league_team` AS league_team ON (league_team.team_id=team.id)
		WHERE league_team.league_id=" . (int) $leagueid . "
		");

	while (($row = $vbulletin->db->fetch_array($result)))
	{
		$teams[$row['id']] = $row;
	}

	$vbulletin->db->free_result($result);

	$result = $vbulletin->db->query_read("
		SELECT `match`.*
		FROM " . TABLE_PREFIX . "soccer_match AS `match`
		INNER JOIN " . TABLE_PREFIX . "soccer_matchtype AS `matchtype` USING(matchtype_id)
		WHERE league_id=" . (int) $leagueid . " AND `matchtype`.phrase_id IN('matchday_x','round_x','group_alpha_x')
		ORDER BY `match`.match_day
		");

	while (($row = $vbulletin->db->fetch_array($result)))
	{
		if (!isset($matchdaySummary[$row['match_day']][$row['team_home_id']]))
		{
			$matchdaySummary[$row['match_day']][$row['team_home_id']] = $teamSummaryInitialValues;
		}

		if (!isset($matchdaySummary[$row['match_day']][$row['team_away_id']]))
		{
			$matchdaySummary[$row['match_day']][$row['team_away_id']] = $teamSummaryInitialValues;
		}

		if (!isset($teamSummary[$row['team_home_id']]))
		{
			$teamSummary[$row['team_home_id']]        = $teamSummaryInitialValues;
			$teamSummary[$row['team_home_id']]['id']  = $row['team_home_id'];
			$teamSummary[$row['team_home_id']]['sp']  = $teams[$row['team_home_id']]['start_points'];
			$teamSummary[$row['team_home_id']]['hp']  = $teams[$row['team_home_id']]['homepage'];
			$teamSummary[$row['team_home_id']]['lgs'] = $teams[$row['team_home_id']]['logo_size_html'];
			$teamSummary[$row['team_home_id']]['lg']  = $teams[$row['team_home_id']]['logo'];
			$teamSummary[$row['team_home_id']]['did'] = $teams[$row['team_home_id']]['sd_id'];
			$teamSummary[$row['team_home_id']]['sn']  = $teams[$row['team_home_id']]['shortname'];
		}

		if (!isset($teamSummary[$row['team_away_id']]))
		{
			$teamSummary[$row['team_away_id']]        = $teamSummaryInitialValues;
			$teamSummary[$row['team_away_id']]['id']  = $row['team_away_id'];
			$teamSummary[$row['team_away_id']]['sp']  = $teams[$row['team_away_id']]['start_points'];
			$teamSummary[$row['team_away_id']]['hp']  = $teams[$row['team_away_id']]['homepage'];
			$teamSummary[$row['team_away_id']]['lgs'] = $teams[$row['team_away_id']]['logo_size_html'];
			$teamSummary[$row['team_away_id']]['lg']  = $teams[$row['team_away_id']]['logo'];
			$teamSummary[$row['team_away_id']]['did'] = $teams[$row['team_away_id']]['sd_id'];
			$teamSummary[$row['team_away_id']]['sn']  = $teams[$row['team_away_id']]['shortname'];
		}

		if ($row['match_is_finished'] == 1 AND $row['score_key'] != 0)
		{
			if (!isset($matchdayMatches[$row['match_day']]))
			{
				$matchdayMatches[$row['match_day']] = 1;
			}
			else
			{
				$matchdayMatches[$row['match_day']]++;
			}

			$teamSummary[$row['team_home_id']]['m']++;
			$teamSummary[$row['team_away_id']]['m']++;
			$teamSummary[$row['team_home_id']]['g']  += $row['points_home'];
			$teamSummary[$row['team_away_id']]['g']  += $row['points_away'];
			$teamSummary[$row['team_home_id']]['ga'] += $row['points_away'];
			$teamSummary[$row['team_away_id']]['ga'] += $row['points_home'];

			$diff = $teamSummary[$row['team_home_id']]['g'] - $teamSummary[$row['team_home_id']]['ga'];
			$teamSummary[$row['team_home_id']]['diff'] = ($diff != 0 ? sprintf('%+d', $diff) : 0);

			$diff = $teamSummary[$row['team_away_id']]['g'] - $teamSummary[$row['team_away_id']]['ga'];
			$teamSummary[$row['team_away_id']]['diff'] = ($diff != 0 ? sprintf('%+d', $diff) : 0);

			switch ($row['score_key'])
			{
				case '1': // "home" hat gewonnen
					$teamSummary[$row['team_home_id']]['w']++;
					$teamSummary[$row['team_away_id']]['l']++;
					break;
				case '2': // unentschieden
					$teamSummary[$row['team_home_id']]['d']++;
					$teamSummary[$row['team_away_id']]['d']++;
					break;
				case '3': // "home" hat verloren
					$teamSummary[$row['team_home_id']]['l']++;
					$teamSummary[$row['team_away_id']]['w']++;
					break;
			}
		}

		$teamSummary[$row['team_home_id']]['pts'] = ($teamSummary[$row['team_home_id']]['w'] * 3) + ($teamSummary[$row['team_home_id']]['d'] * 1) + $teamSummary[$row['team_home_id']]['sp'];
		$teamSummary[$row['team_away_id']]['pts'] = ($teamSummary[$row['team_away_id']]['w'] * 3) + ($teamSummary[$row['team_away_id']]['d'] * 1) + $teamSummary[$row['team_away_id']]['sp'];

		$teamorder[$row['match_day']][$row['team_home_id']] = sprintf('%04d-%04d-%04d', $teamSummary[$row['team_home_id']]['pts'], 1000+($teamSummary[$row['team_home_id']]['g'] - $teamSummary[$row['team_home_id']]['ga']), $teamSummary[$row['team_home_id']]['g']);
		$teamorder[$row['match_day']][$row['team_away_id']] = sprintf('%04d-%04d-%04d', $teamSummary[$row['team_away_id']]['pts'], 1000+($teamSummary[$row['team_away_id']]['g'] - $teamSummary[$row['team_away_id']]['ga']), $teamSummary[$row['team_away_id']]['g']);
		arsort($teamorder[$row['match_day']]);

		$matchdaySummary[$row['match_day']][$row['team_home_id']] = $teamSummary[$row['team_home_id']];
		$matchdaySummary[$row['match_day']][$row['team_away_id']] = $teamSummary[$row['team_away_id']];

	} // end while

	$vbulletin->db->free_result($result);
	$return = array();
	foreach ($teamorder AS $matchday => $values)
	{
		$counter = $rank = 0;
		$oldvalue = '';
		foreach ($values AS $k => $v)
		{
			$counter++;

			if ($oldvalue != $v)
			{
				$rank = $counter;
			}

			$matchdaySummary[$matchday][$k]['pos'] = $rank;

			if (isset($matchdaySummary[$matchday-1]))
			{
				$matchdaySummary[$matchday][$k]['oldpos'] =$matchdaySummary[$matchday-1][$k]['pos'];
			}

			if ($matchdaySummary[$matchday][$k]['w'] == 0 AND $matchdaySummary[$matchday][$k]['d'] == 0 AND $matchdaySummary[$matchday][$k]['l'] == 0)
			{
				$matchdaySummary[$matchday][$k]['m'] = $matchdaySummary[$matchday][$k]['g'] = $matchdaySummary[$matchday][$k]['ga'] = '-';
			}
			$return[$matchday][$k] = $matchdaySummary[$matchday][$k];
			$oldvalue = $v;
		}
	}

	unset($matchdaySummary, $teamorder);

	if (!empty($return))
	{
		global $saisonlastmatchday;
		$saisonlastmatchday = (!empty($matchdayMatches) ? max(array_keys($matchdayMatches)) : 0);
		$vbulletin->db->query_write("
			UPDATE `" . TABLE_PREFIX . "soccer_league`
			SET tabledata='" . $vbulletin->db->escape_string(serialize($return)) . "',
				lastmatchday=" . (int) $saisonlastmatchday . "
			WHERE id='" . (int) $leagueid . "'
			");
	}

	return $return;
}

/**
 * liefert eine ligatabelle, optional spieltags-genau
 *
 * @param int $leagueid liga-id
 * @param int $matchday optionale angabe des spieltages
 */
function fetch_leaguetable($leagueid=0, $matchday=0, $tabletype='')
{
	global $vbulletin;

	if (($result = $vbulletin->db->query_first("
		SELECT tabledata, showtable
		FROM `" . TABLE_PREFIX . "soccer_league`
		WHERE id=" . (int) $leagueid . "
		")))
	{
		if ($result['tabledata'] != '')
		{
			$tabledata = unserialize($result['tabledata']);
		}
	}

	if ($result['showtable'] == 0)
	{
		return array();
	}

	if (empty($tabledata))
	{
		$tabledata = build_leaguetable($leagueid);
	}

	if ($matchday)
	{
		return $tabledata[$matchday];
	}
	else
	{
		return $tabledata;
	}
}

/**
 * liefert parts der css-klasse fuer farbkennzeichnung in tabellen
 *
 * @param array $leagueinfo ligainformationen
 * @param int $tablecount anzahl mannschaften der liga
 * @return array array mit css-klassen und tabellenpositionen
 */
function fetch_soccertable_updownrel($leagueinfo=array(), $tablecount=0)
{
	$updownrel = array();

	if (empty($leagueinfo))
	{
		return $updownrel;
	}

	$teams_down_split = explode(',', $leagueinfo['sd_sent_back_down']);
	$teams_down_split = array_filter($teams_down_split);

	foreach ($teams_down_split AS $val)
	{
		$p = ((int) $val < 0) ? $tablecount + ((int) $val) +1 : (int) $val;
		$updownrel[$p] = 'down';
	}

	$teams_rel_split = explode(',', $leagueinfo['sd_relegation']);
	$teams_rel_split = array_filter($teams_rel_split);

	foreach ($teams_rel_split AS $val)
	{
		$p = ((int) $val < 0) ? $tablecount + ((int) $val) +1 : (int) $val;
		$updownrel[$p] = 'rel' . (((int) $val < 0) ? 'down' : 'up');
	}

	$teams_up_split = explode(',', $leagueinfo['sd_called_up']);
	$teams_up_split = array_filter($teams_up_split);

	foreach ($teams_up_split AS $val)
	{
		$p = ((int) $val < 0) ? $tablecount + ((int) $val) +1 : (int) $val;
		$updownrel[$p] = 'up';
	}

	unset($teams_down_split, $teams_rel_split, $teams_up_split);

	return $updownrel;
}

/**
 * erzeugt html-code fuer liga-icon, wenn vorhanden
 *
 * @param $leagueinfo ligainformationen
 * @return string leerer string oder htmlcode fuer icon
 */
function fetch_soccer_leagueicon($leagueinfo=array())
{
	if (!empty($leagueinfo['logo']))
	{
		$iconpath = $GLOBALS['vbulletin']->options['vbsoccer_imgdir'] .'/league/' . $leagueinfo['logo'];
		$icon = '<img src="' . $iconpath . '" ' . $leagueinfo['logo_size_html']
			  . ' alt="' . $leagueinfo['league_name'] . '" border="0" />';
	}
	else
	{
		$icon = '';
	}

	return $icon;
}

/**
 * bestimmung der spieltagsbezeichnung aus einer matchdaytype-id
 *
 * @staticvar array array a-z (fuer 'Gruppe A' etc)
 * @param int $matchday spieltag
 * @param string $phraseid phrase fuer spieltag
 * @return string bezeichnung des spieltags
 * @see fetch_soccer_matchdayinfo(), construct_soccer_matchdayjump()
 */
function construct_soccer_matchday_phrase($matchday=0, $phraseid='')
{
	static $alpha;

	if (isset($GLOBALS['vbphrase']['soccer_' . $phraseid]))
	{
		$matchdayphrase = $GLOBALS['vbphrase']['soccer_' . $phraseid];

		switch ($phraseid)
		{
			case 'matchday_x': // 1. Spieltag, 2. Spieltag, ...
			case 'round_x':    // Runde 1, Runde 2, ...
				return construct_phrase($matchdayphrase, $matchday);
				break;
			case 'group_alpha_x': // Gruppe A, Gruppe B, ...
				if (empty($alpha))
				{
					$alpha = range('A', 'Z'); // A = 0! B = 1...
				}
				return construct_phrase($matchdayphrase, $alpha[($matchday-1)]);
				break;
			default:
				return $matchdayphrase;
				break;
		}
	}
	else
	{
		return construct_phrase($vbphrase['soccer_round_x'], $matchday);
	}
}

/**
 * spieltags-auswahlbox (html)
 *
 * @param int $selected gewaehlter spieltag
 * @return string html-code fuer auswahlbox
 */
function construct_soccer_matchdayjump($selected=0)
{
	$matchdayinfo = fetch_soccer_matchdayinfo();

	if ($selected == 0)
	{
		// wenn GPC[m] nicht angegeben, dann aktuellen spieltag auswaehlen
		$selected = $GLOBALS['todaymatchday'];
	}

	if ($selected > $GLOBALS['lastmatchday'])
	{
		// wenn GPC[m] groesser als letzter spieltag, dann letzten spieltag
		// auswaehlen
		$selected = $GLOBALS['lastmatchday'];
	}

	if ($selected < $GLOBALS['firstmatchday'])
	{
		// wenn GPC[m] kleiner als erster spieltag, dann ersten spieltag
		// auswaehlen
		$selected = $GLOBALS['firstmatchday'];
	}

	$tplObj = new stdClass;
	$tplObj->option = vB_Template::create('option');

	$GLOBALS['currentmatchday'] = $selected;
	$matchday_options = '';

	if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'ranking')
	{
		$optionvalue = 0;
		$optiontitle = htmlspecialchars_uni($GLOBALS['vbphrase']['soccer_latestranking']);

		if (!empty($GLOBALS['show']['latestranking']))
		{
			$optionselected = ' selected="selected"';
			$optionclass = 'fjsel';
			$selected = 0;
		}
		else
		{
			$optionselected = '';
			$optionclass = 'fjdpth0';
		}

		$tplObj->option->quickRegister(array(
			'optionclass'    => $optionclass,
			'optionvalue'    => $optionvalue,
			'optiontitle'    => $optiontitle,
			'optionselected' => $optionselected,
			));

		$matchday_options .= $tplObj->option->render();
	}

	$groupnames = array();

	foreach ($matchdayinfo AS $group => $matchday)
	{
		$options = '';
		$matchdayclass = ($group == '' ? 'fjdpth0' : 'fjdpth1');

		if ($group != '')
		{
			$groupnames[$group] = construct_soccer_matchday_phrase(0, $group);
		}

		foreach ($matchday AS $optionvalue => $optiontitle)
		{
			$GLOBALS['matchdayinfos'][$optionvalue]['matchdayname'] = $optiontitle;
			$GLOBALS['matchdayinfos'][$optionvalue]['matchgroupname'] = $groupnames[$group];
			$optionclass = ($optionvalue == $selected ? 'fjsel' : $matchdayclass);
			$optionselected = ($optionvalue == $selected ? ' selected="selected"' : '');

			if ($GLOBALS['todaymatchday'] == $optionvalue)
			{
				// aktuellen spieltag hervorheben
				$optionclass .= '" style="font-weight: bold';
			}

			$tplObj->option->quickRegister(array(
				'optionclass'    => $optionclass,
				'optionvalue'    => $optionvalue,
				'optiontitle'    => $optiontitle,
				'optionselected' => $optionselected,
				));

			$options .= $tplObj->option->render();
		}


		// wenn $group ein leerer string ist, dann spieltag auf oberster ebene
		// als ungruppierte option abbilden
		if ($group == '')
		{
			$matchday_options .= $options;
		}
		else
		{
			// $group ist der phrasenkey fuer optiongroup-titel
			// spieltage gruppieren

			if (!isset($tplObj->optgroup))
			{
				$tplObj->optgroup = vB_Template::create('optgroup');
			}

			$tplObj->optgroup->quickRegister(array(
				'optgroup_label'   => $groupnames[$group],
				'optgroup_options' => $options,
				'optgroup_extra'   => '',
				));

			$matchday_options .= $tplObj->optgroup->render();
		}
	}

	unset($tplObj);
	return '<select name="m" id="m" onchange="this.form.submit();">' . $matchday_options . '</select>';
}

/**
 * status der buttons neben spieltags-auswahl (aktiviert, nicht aktiviert)
 *
 * @param int $matchday gewaehlter spieltag
 * @return bool
 */
function fetch_soccer_prevnext_matchday($matchday)
{
	// beide buttons inaktiv
	$GLOBALS['show']['mdprev'] = false;
	$GLOBALS['show']['mdnext'] = false;

	if (empty($GLOBALS['lastmatchday']))
	{
		return false;
	}

	// vor- und zurueck-buttons in spieltagauswahl
	if ($matchday > 1)
	{
		$GLOBALS['show']['mdprev'] = true;
	}

	if ($matchday < $GLOBALS['lastmatchday'])
	{
		$GLOBALS['show']['mdnext'] = true;
	}

	return true;
}

/**
 * erstellt einen teil einer sql-abfrage fuer spieltagsgruppierungen
 *
 * @param void
 * @return string sql-string
 * @see fetch_soccer_matchdayinfo()
 */
function construct_soccer_sql_matchdaygroups()
{
	// keine gruppierung vorgesehen
	if (!isset($GLOBALS['leagueinfo']['mdgrp']))
	{
		return "''";
	}

	// in gruppen und phrasen aufteilen 'gruppen;phrasen'
	$matchdaygroupsplit = explode(';', $GLOBALS['leagueinfo']['mdgrp']);

	// in spieltags-gruppen aufteilen (CASE-Expressions)
	$daygroups = explode(',', $matchdaygroupsplit[0]);

	if (empty($daygroups[0]))
	{
		// keine CASE-Expressions angegeben, keine spieltagsgruppierungen
		return "''";
	}

	if (isset($matchdaygroupsplit[1]))
	{
		// fuer die CASE-Expressions wurden phrasen-keys angegeben
		$phrasegroups = explode(',', $matchdaygroupsplit[1]);
	}

	$cases = array();

	foreach ($daygroups AS $group => $expression)
	{
		$groupname = isset($phrasegroups[$group]) ? $phrasegroups[$group] : '';

		$expression = str_replace(array('(lte)', '(gte)', '(lt)', '(gt)'),
								  array('<=', '>=', '<', '>'),
								  $expression);

		$cases[] = "WHEN `match_day` $expression THEN '$groupname'";
	}

	if (!empty($cases))
	{
		// case-when-expressions erstellen
		return "CASE " . implode("\n", $cases) . " ELSE '' END";
	}

	return "''";
}

function construct_leagueaction_tabs($selected='', $leagueid, $matchday=0)
{
	// standard-aktion 'Tipps und Spiele' immer vorhanden
	$actions = array('bet' => 'soccer_nav_bet');

	if ($GLOBALS['leagueinfo']['showtable'])
	{
		// aktion 'Tabelle'
		$actions['tab'] = 'soccer_nav_tab';

		if (!in_array(strtolower($GLOBALS['leagueinfo']['sd_shortname']), array('wm', 'em', 'chl', 'eul')))
		{
			// aktion 'kreuztabelle'
			$actions['crosstab'] = 'soccer_nav_crosstab';
		}

		if (isset($GLOBALS['vbulletin']->GPC['type']) AND $GLOBALS['vbulletin']->GPC['type'] == 'cross')
		{
			// kreuztabelle wurde angefordert ueber aktionsauswahl.
			if (!isset($actions['crosstab']))
			{
				// oh! die aktuell gewaehlte liga hat keine kreuztabellen!
				// hier wird die normale tabelle angezeigt. der aktionswaehler
				// muss hier ebenfalls auf 'Tabelle' geaendert werden:
				$selected = 'tab';
			}
			else
			{
				$selected = 'crosstab';
			}
		}
	}

	// aktion 'rangliste' nur fuer benutzer vorhanden
	if ($GLOBALS['vbulletin']->userinfo['userid'])
	{
		$actions['ranking'] = 'soccer_nav_ranking';
	}

	$tabs = '';

	// auswahlbox erstellen
	foreach ($actions AS $optionvalue => $optiontitle)
	{
		$tabselected = ($optionvalue == $selected ? ' class="selected"' : '');

		$templater = vB_Template::create('vbsoccer_navtab_bit');
		$templater->register('tabselected', $tabselected);
		$templater->register('tabtitle', $optiontitle);
		$templater->register('taburl', sprintf('vbsoccer.php?%sdo=%s&amp;l=%s%s', '', $optionvalue, $leagueid,($matchday ? '&amp;m='. $matchday : '')));
		$tabs .= $templater->render();
	}

	return $tabs;
}

/**
 * liefert alle nicht anzuzeigenden ligen basierend auf dem liga-typ
 *
 * @param void
 * @return array auszublendende ligen
 */
function fetch_invisible_leagues()
{
	$return = array();

	if (!empty($GLOBALS['vbulletin']->userinfo['vbsoccerprefs']['lhide']))
	{
		// auszublendende ligen ermitteln
		foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'] AS $leagueid)
		{
			if (in_array(strtolower($GLOBALS['vbulletin']->vbsoccer_leaguecache[$leagueid]['sd_shortname']), $GLOBALS['vbulletin']->userinfo['vbsoccerprefs']['lhide']))
			{
				$return[$leagueid] = $leagueid;
			}
		}
	}

	return $return;
}
