<?php
/**
 * vbulletin add-on fussball-tippspiele
 *
 * php version 5
 * vbulletin 3 und 4
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @version SVN: $Id: class_xmlrpc_vbsoccer.php 6577 2009-10-15 18:27:13Z aa $
 */

/** vBulletin XML objects */
require_once DIR . '/includes/class_xml.php';

/** vBulletin remote url */
require_once DIR . '/includes/class_vurl.php';


/**
* vbsoccer xml-rpc client
*
* @package vbsoccer
*/
class vBSoccer_XMLRPC_Client
{
	/**
	* Output type - response or call
	* @var string
	*/
	private $outputtype = null;

	/**
	* vBulletin Registry Object
	*
	* @var	Object
	*/
	private $registry = null;

	/**
	* vBulletin XML Object
	*
	* @var	Object
	*/
	private $xml_object = null;

	/**
	 * @var array
	 */
	private $options = null;

	/**
	* Constructor
	*
	* @param	object	vBulletin Registry Object
	*/
	function __construct(&$registry)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error(get_class($this) . '::Registry object is not an object', E_USER_ERROR);
		}

		$this->options = unserialize($this->registry->options['vbsoccer_sd']);
	}

	/**
	* Build XMPRPC Call Output
	*
	* The first parameter is the methodName
	* then (unlimited number of) following parameters are the params
	* Params can be sent as strings or arrays that define their type.
	*
	* @param	string	Text of the phrase
	* @param	mixed	First variable to be inserted
	* @param	mixed	Nth variable to be inserted
	*/
	private function _build_xml_call()
	{
		$args = func_get_args();
		$numargs = sizeof($args);

		if ($numargs < 1 OR !is_string($args[0]))
		{
			trigger_error('vBSoccer_XMLRPC_Client::_build_xml_call() Must specify a method (string)', E_USER_ERROR);
		}

		$this->_build_xml('methodCall', $args);
	}

	/**
	* Output the XML-RPC Call via HTTP POST
	*
	*/
	private function _send_xml_call($url)
	{
		if ($this->outputtype != 'call')
		{
			trigger_error('vBSoccer_XMLRPC_Client::_send_xml_call() Must call _build_xml_call() before _send_xml_call()', E_USER_ERROR);
		}

		$vurl = new vB_vURL($this->registry);
		$vurl->set_option(VURL_URL, $url);
		$vurl->set_option(VURL_POST, 1);
		$vurl->set_option(VURL_HEADER, 1);
		$vurl->set_option(VURL_ENCODING, 'gzip');
		$vurl->set_option(VURL_HTTPHEADER, array($this->xml_object->fetch_content_type_header(), sprintf('Authorization: Basic %s', $this->options['u'])));
		$vurl->set_option(VURL_USERAGENT, 'vBulletin/vBSoccer ' . $this->registry->options['bburl']);
		$vurl->set_option(VURL_MAXREDIRS, 1);
		$vurl->set_option(VURL_FOLLOWLOCATION, 1);
		$vurl->set_option(VURL_POSTFIELDS, $this->xml_object->fetch_xml_tag() . $this->xml_object->output());
		$vurl->set_option(VURL_RETURNTRANSFER, 1);
		$vurl->set_option(VURL_CLOSECONNECTION, 1);
		return $vurl->exec();
	}

	/**
	 *
	 */
	public function __call($method, $params=false)
	{
		if (!empty($params))
		{
			$this->_build_xml_call(sprintf('vbsoccer.%s', $method), $params);
		}
		else
		{
			$this->_build_xml_call(sprintf('vbsoccer.%s', $method));
		}

		$result = $this->_send_xml_call($this->options['s'] . 'rpc.php');

		$xml_object = new vB_XML_Parser($result['body']);

		// !<methodResponse>
		$xml_object->include_first_tag = false;

		$return = array();

		if ($xml_object->parse_xml())
		{
/*
			echo '<pre>';
			print_r($xml_object->parseddata);
			echo '</pre>';
*/

			// The body of the response is a single XML structure,
			// a <methodResponse>, which can contain a single <params> which
			// contains a single <param> which contains a single <value>.


			// The <methodResponse> could also contain a <fault> which contains
			// a <value> which is a <struct> containing two elements, one named
			// <faultCode>, an <int> and one named <faultString>, a <string>.

			if (isset($xml_object->parseddata['fault']))
			{
				$faultCode = 0;
				$faultString = 'Unknown Exception!';
				$exception = $xml_object->parseddata['fault']['value']['struct']['member'];
				foreach ($exception AS $key => &$value)
				{
					if ($value['name'] == 'faultCode')
					{
						$faultCode = $value['value']['int'];
						continue;
					}

					if ($value['name'] == 'faultString')
					{
						$faultString = $value['value']['string'];
						continue;
					}
				}
				throw new Exception($faultString, $faultCode);
			}

			if (isset($xml_object->parseddata['params']['param']['value']))
			{
				$response =& $xml_object->parseddata['params']['param']['value'];
			}

			if (isset($response['boolean']))
			{
				$return = (bool) $response['boolean'];
			}

			if (isset($response['string']))
			{
				$return = $response['string'];
			}

			if (isset($response['array']['data']['value']))
			{
				if (count($response['array']['data']['value']) == 1)
				{
					$obj = unserialize(base64_decode($response['array']['data']['value']['base64']));
					$return[] = (array) $obj;
				}
				else
				{
					foreach ($response['array']['data']['value'] AS &$val)
					{
						$obj = unserialize(base64_decode($val['base64']));
						$return[] = (array) $obj;
					}
				}
			}
		}

		$xml_object = null;
		return $return;
	}

	/**
	* Private
	* Build XMPRPC Output
	*
	* The first parameter is the type, methodCall, methodResponse, or Fault (methodResponse)
	* then (unlimited number of) following parameters are the params
	* Params can be sent as strings or arrays that define their type.
	*
	* Per spec, methodResponse should have a maximum of one param
	*
	* @param	string	Type
	* @param	mixed	First variable to be inserted
	* @param	mixed	Nth variable to be inserted
	*
	*/
	private function _build_xml($type = 'methodCall')
	{
		$tempargs = func_get_args();
		$args     = $tempargs[1];

		$this->xml_object = new vB_XML_Builder($this->registry, null, 'UTF-8');

		// Empty doc in case we call this method multiple times
		$this->xml_object->doc = '';

		if ($type == 'methodCall')
		{
			$this->outputtype = 'call';
			$this->xml_object->add_group('methodCall');
			$this->xml_object->add_tag('methodName', $args[0]);
			array_shift($args);
		}
		else if ($type == 'methodResponse' OR $type == 'fault')
		{
			$this->outputtype = 'response';
			$this->xml_object->add_group('methodResponse');

			if ($type == 'fault')
			{
				$this->xml_object->add_group('fault');
				$this->_add_value($args[0]);
				$this->xml_object->close_group('fault');
				$this->xml_object->close_group('methodResponse');
				return;
			}
		}

		$this->xml_object->add_group('params');

		foreach($args AS $key => $value)
		{
			$this->xml_object->add_group('param');
			$this->_add_value($value);
			$this->xml_object->close_group('param');
		}

		$this->xml_object->close_group('params');

		if ($type == 'methodCall')
		{
			$this->xml_object->close_group('methodCall');
		}
		else
		{
			$this->xml_object->close_group('methodResponse');
		}
	}

	/**
	* Add <value> object to Output
	*
	* @param	string
	*/
	private function _add_value($value)
	{
		if (!is_array($value))
		{
			// convert string into an array
			$value = array('string' => $value);
		}

		$key = array_pop(array_keys($value));
		$this->xml_object->add_group('value');
		switch(strtolower($key))
		{
			case 'i4':
			case 'int':
				// Integer
				$this->xml_object->add_tag('int', intval($value["$key"]));
				break;
			case 'boolean':
				// boolean
				$this->xml_object->add_tag('boolean', ($value["$key"] == 1 OR strtolower($value["$key"]) == 'true') ? 1 : 0);
				break;
			case 'double':
				// float
				$this->xml_object->add_tag('double', floatval($value["$key"]));
				break;
			case 'datetime.iso8601':
				// datetime
				$this->xml_object->add_tag('dateTime.iso8601', strval($value["$key"]));
				break;
			case 'base64':
				// base64 encoded field
				// must already be encoded
				$this->xml_object->add_tag('base64', strval($value["$key"]));
				break;
			case 'array':
				if (!is_array($value["$key"]) OR empty($value["$key"]))
				{	// treat this as a string?
					$this->xml_object->add_tag('string', strval($value["$key"]));
				}
				else
				{
					$this->xml_object->add_group('array');
					$this->xml_object->add_group('data');
					foreach($value["$key"] AS $subkey => $subvalue)
					{
						$this->_add_value($subvalue);
					}
					$this->xml_object->close_group('data');
					$this->xml_object->close_group('array');
				}
				// array'
				break;
			case 'struct':
				// struct
				if (!is_array($value["$key"]) OR empty($value["$key"]))
				{	// treat this as a string?
					$this->xml_object->add_tag('string', strval($value["$key"]));
				}
				else
				{
					$this->xml_object->add_group('struct');
					foreach($value["$key"] AS $subkey => $subvalue)
					{
						$this->xml_object->add_group('member');
						$this->xml_object->add_tag('name', $subvalue['name']);
						unset($subvalue['name']);
						$this->_add_value($subvalue);
						$this->xml_object->close_group('member');
					}
					$this->xml_object->close_group('struct');
				}
				break;
			case 'string':
			default:
				$this->xml_object->add_tag('string', strval($value["$key"]));
		}
		$this->xml_object->close_group('value');
	}
}
