<?php
/* -*- mode: php; tab-width: 4; indent-tabs-mode: t; coding: utf-8 -*- */

/**
 * vbulletin add-on fussball-tippspiele
 *
 * php version 5
 * vbulletin version >= 4.0.2
 *         _
 *  __   _| |__  ___  ___   ___ ___ ___ _ __
 *  \ \ / / '_ \/ __|/ _ \ / __/ __/ _ \ '__|
 *   \ V /| |_) \__ \ (_) | (_| (_|  __/ |
 *    \_/ |_.__/|___/\___/ \___\___\___|_|
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @version SVN: $Id: class_reportitem_vbsoccer.php 1319 2010-05-06 13:23:54Z aa $
 */

if (!isset($GLOBALS['vbulletin']->db))
{
	exit;
}

/** vbulletin report-klasse */
require_once DIR . '/includes/class_reportitem.php';

/**
 * report-klasse fuer tippspiel
 *
 * @package vbsoccer
 */
class vB_ReportItem_vbsoccer extends vB_ReportItem
{
	/**
	 * @var string	"Key" for the phrase(s) used when reporting this item
	 */
	var $phrasekey = '_vbsoccer_entry';

	/**
	 * Sets information to be used in the form for the report
	 *
	 * @param	array	Information to be used.
	 *
	 */
	function set_forminfo(&$iteminfo)
	{
		global $vbphrase;

		$this->forminfo = array(
			'file'         => 'vbsoccer',
			'action'       => 'submitreport',
			'itemname'     => $vbphrase['soccer_report_errors'],
			'description'  => $vbphrase['soccer_only_used_to_report'],
		);

		return $this->forminfo;
	}

	/**
	 * Sets information regarding the report
	 *
	 * @param	array	Information regarding the report
	 *
	 */
	function set_reportinfo(&$reportinfo)
	{
		return array();
	}

	/**
	 * Does the report
	 *
	 * @param	string	The Reason for the report
	 * @param	array	Information regarding the item being reported
	 *
	 */
	function do_report($reason, &$iteminfo)
	{
		$this->iteminfo =& $iteminfo;
		$reportinfo = array(
			'rusername' => unhtmlspecialchars($this->registry->userinfo['username']),
			'ruserid'   => $this->registry->userinfo['userid'],
			'remail'    => $this->registry->userinfo['email'],
		);

		if ($this->registry->options['postmaxchars'] > 0)
		{
			$reportinfo['reason'] = substr($reason, 0, $this->registry->options['postmaxchars']);
		}
		else
		{
			$reportinfo['reason'] = $reason;
		}

		require_once DIR . '/includes/functions_vbsoccer.php';

		@ignore_user_abort(true);

		try
		{
			if (strtoupper($this->registry->userinfo['lang_charset']) != 'UTF-8')
			{
				$reportinfo = array_map('utf8_encode', $reportinfo);
			}
			// werden diese zeichen nicht ersetzt, schlaegt unserialize fehl
			$reportinfo['reason'] = preg_replace("/(\r\n|\r|\n)/", "\n", $reportinfo['reason']);
			/** soccerclient functions */
			require_once DIR . '/includes/vbsoccer_services.php';
			$services = new vbsoccer_Services($this->registry);
			$services->report($reportinfo);
		}
		catch (Exception $e)
		{
			return false;
		}

		return true;
	}

	/**
	 * Updates the Item being reported with the item report info.
	 *
	 * @param	integer	ID of the item being reported
	 *
	 */
	function update_item_reportid($param)
	{
		return true;
	}

	/**
	 * Re-fetches information regarding the reported item from the database
	 *
	 */
	function refetch_iteminfo()
	{
	}
}
