<?php
/* -*- mode: php; tab-width: 4; indent-tabs-mode: t; coding: utf-8 -*- */

/**
 * vbulletin add-on fussball-tippspiele
 *
 * vbulletin Version >= 4.0.2
 * php version 5
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @version SVN: $Id: vbsoccerentries.php 1388 2010-05-13 21:14:44Z aa $
 */


/**
 * blocktyp 'vbsoccerentries'
 *
 * @package vbsoccer
 */
class vB_BlockType_Vbsoccerentries extends vB_BlockType
{
	/**
	 * The Productid that this block type belongs to
	 *
	 * @var string
	 */
	protected $productid = 'vbsoccer';

	/**
	 * The title of the block type
	 *
	 * @var string
	 */
	protected $title = '';

	/**
	 * The description of the block type
	 *
	 * @var string
	 */
	protected $description = '';

	/**
	 * The block settings
	 *
	 * @see print_setting_row()
	 * @var string
	 */
	protected $settings = array(
		'vbsoccerentries_type' => array(
			'defaultvalue' => 1,
			'optioncode'   => 'radio:piped
1|soccer_rankings_top3
2|soccer_rankings_top5
3|soccer_rankings_top10
4|soccer_rankings_top3_leaguetab
5|soccer_rankings_top5_leaguetab
6|soccer_rankings_top10_leaguetab
7|soccer_leaguetab',
			'displayorder' => 1,
			'datatype'     => 'integer',
		),
		'vbsoccerentries_defaultleague' => array(
			'defaultvalue' => '',
			'optioncode'   => 'select:eval
$options = vB_BlockType_Vbsoccerentries::construct_league_chooser_options();',
			'displayorder' => 2,
			'datatype'     => 'free',
		),
		'vbsoccerentries_league_selector' => array(
			'defaultvalue' => 1,
			'optioncode'   => 'yesno',
			'displayorder' => 3,
			'datatype'     => 'boolean',
		),
	);

	/**
	 * Fetches the standard page view for a block.
	 *
	 * @param void
	 * @return mixed string|false
	 */
	public function getHTML()
	{
		global $vbphrase;

		$current_league_info = array('sd_shortname' => $this->config['vbsoccerentries_defaultleague']);
		$league_options = '';

		if (empty($this->registry->vbsoccer_leaguecache))
		{

			if (!($leaguecache = $this->registry->db->query_first_slave("
				SELECT data FROM " . TABLE_PREFIX . "datastore WHERE title = 'vbsoccer_leaguecache'
				")))
			{
				// kein ligacache vorhanden; block nicht anzeigen
				return false;
			}

			$this->registry->vbsoccer_leaguecache = unserialize($leaguecache['data']);
			unset($leaguecache);
		}

		if (empty($this->registry->vbsoccer_leaguecache['current']))
		{
			// keine aktuellen ligen vorhanden; block nicht anzeigen
			return false;
		}

		if ($this->config['vbsoccerentries_league_selector'] OR $this->config['vbsoccerentries_type'] > 3)
		{
			$this->registry->db->hide_errors();

			$vbsoccernames = array();


			if (!isset($vbphrase['soccer_league_x_saison_y']))
			{
				if (!($phrasegroup = $this->registry->db->query_first_slave("
					SELECT phrasegroup_vbsoccernames AS vbsoccernames
					FROM " . TABLE_PREFIX . "language
					WHERE languageid = " . intval(iif($this->registry->userinfo['languageid'], $this->registry->userinfo['languageid'], $this->registry->options['languageid'])) . "
					")))
				{
					// keine ligaphrasen gefunden; block nicht anzeigen
					return false;
				}

				$vbsoccernames = unserialize($phrasegroup['vbsoccernames']);

				//if ($this->config['vbsoccerentries_type'] > 3)
				//{
					$vbphrase = array_merge($vbphrase, $vbsoccernames);
				//}
			}
		}

		if ($this->config['vbsoccerentries_league_selector'])
		{
			$templater = vB_Template::create('option');
		}

		$found = false;

		foreach ($this->registry->vbsoccer_leaguecache['current'] AS $leagueid)
		{
			$leagueinfo = $this->registry->vbsoccer_leaguecache[$leagueid];

			if ($this->config['vbsoccerentries_league_selector'])
			{
				if ($leagueinfo['readonly'] == 1)
				{
					continue;
				}

				switch ($leagueinfo['sd_shortname'])
				{
					case 'WM':
					case 'EM':
						$leagueinfo['sd_saison'] = substr($leagueinfo['sd_saison'], 0, 4);
					break;
				}
				$optionselected = '';

				if ($this->config['vbsoccerentries_type'] == 7)
				{
					if ($leagueinfo['showtable'] == 0 OR in_array(strtolower($leagueinfo['sd_shortname']), array('wm', 'em', 'chl', 'eul', 'dfb')))
					{
						$optionselected = ' disabled="disabled"';
					}
				}

				$templater->register('optionclass', '');
				$templater->register('optionvalue', $leagueinfo['id']);
				$templater->register('optiontitle', construct_phrase($vbphrase['soccer_league_x_saison_y'], !empty($vbphrase[$leagueinfo['phrase']]) ? $vbphrase[$leagueinfo['phrase']] : $leagueinfo['phrase'], $leagueinfo['sd_saison']));
				$templater->register('optionselected', $optionselected);
			}

			if ($this->config['vbsoccerentries_defaultleague'] == strtolower($leagueinfo['sd_shortname']))
			{
				if ($this->config['vbsoccerentries_league_selector'])
				{
					$templater->register('optionselected', ' selected="selected"');
				}

				$current_league_info = $leagueinfo;
				$found = true;
			}

			if ($this->config['vbsoccerentries_league_selector'])
			{
				$league_options .= $templater->render();
			}
		} // end foreach

		if ($found === false OR !isset($current_league_info['id']))
		{
			// keine aktuelle saison der voreingestellten liga gefunden
			return false;
		}

		unset($leagueinfo, $templater, $vbsoccernames);

		require_once DIR . '/includes/functions_vbsoccer.php';
		$output = '';
		switch ($this->config['vbsoccerentries_type'])
		{
			case 1:
			case 2:
			case 3:
				$output = fetch_soccerblock_saison_rankings($current_league_info, $this->config['vbsoccerentries_type']);
				break;
			case 4:
			case 5:
			case 6:
				$output  = fetch_soccerblock_saison_rankings($current_league_info, $this->config['vbsoccerentries_type']);
				$output .= fetch_soccerblock_saison_table($current_league_info['id']);
				break;
			case 7:
				$output = fetch_soccerblock_saison_table($current_league_info['id']);
		}

		if (empty($output))
		{
			// keine rankingdaten gefunden, weil liga readonly oder im archiv, oder geloescht
			return false;
		}

		$templater = vB_Template::create('block_vbsoccerentries');
		$templater->register('blockinfo', $this->blockinfo);
		$templater->register('leagueoptions', $league_options);
		$templater->register('blockconfig', $this->config);
		$templater->register('vbsoccerentries', $output);

		return $templater->render();
	}

	/**
	 * Returns the config view for the block.
	 *
	 * @param setting values
	 * @return boolean
	 */
	public function getConfigHTML($settingvalues = array())
	{
		$return = parent::getConfigHTML($settingvalues);

		if ($this->settings)
		{
			// cache voreinstellen und userinput ueberschreiben:)
			construct_hidden_code('cachettl', '144000');
		}

		return $return;
	}

	/**
	 * stellt fuer block manager die ligaauswahl zur verfuegung
	 *
	 * @param void
	 * @return array liga-optionen
	 */
	public function construct_league_chooser_options()
	{
		global $vbulletin;

		$vbsoccernames = array();

		if (!($phrasegroup = $vbulletin->db->query_first_slave("
			SELECT phrasegroup_vbsoccernames AS vbsoccernames
			FROM " . TABLE_PREFIX . "language
			WHERE languageid = " . intval(iif($vbulletin->userinfo['languageid'], $vbulletin->userinfo['languageid'], $vbulletin->options['languageid'])) . "
			")))
		{
			return $league_options;
		}

		$vbsoccernames = unserialize($phrasegroup['vbsoccernames']);

		$leagueTypes = $vbulletin->db->query_read("
			SELECT DISTINCT LOWER(`sd_shortname`) AS shortname
			FROM  `" . TABLE_PREFIX . "soccer_league` ORDER BY displayorder
			");

		$league_options = array('' => '---');
		while (($leagueTyp = $vbulletin->db->fetch_array($leagueTypes)))
		{
			$phrasevarname = 'soccer_leaguetype_' . $leagueTyp['shortname'];
			$league_options[$leagueTyp['shortname']] = (!empty($vbsoccernames[$phrasevarname]) ? $vbsoccernames[$phrasevarname] : $leagueTyp['shortname']);
		}

		$vbulletin->db->free_result($leagueTypes);
		unset($vbsoccernames, $leagueTyp, $leagueTypes, $phrasevarname);

		return $league_options;
	}

	/**
	 * Get hash for cache
	 *
	 * @param void
	 * @return string hash
	 */
	public function getHash()
	{
		$context = new vB_Context('forumblock.vbsoccer' , array('blockid' => $this->blockinfo['blockid'],
			'languageid' => LANGUAGEID,
			THIS_SCRIPT));
		return strval($context);
	}
}
