<?php
/**
 * vbulletin add-on fussball-tippspiele
 *
 * php version 5
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @version SVN: $Id: vbsoccer_digestdaily.php 6578 2009-10-15 18:53:14Z aa $
 */

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE & ~8192);

if (!is_object($vbulletin->db))
{
	exit;
}

$db =& $vbulletin->db;

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

/** @ignore */
require_once DIR . '/includes/functions_misc.php';

/** vbsoccer functions */
require_once DIR . '/includes/functions_vbsoccer.php';

$leagues_result = $db->query_read("
	SELECT league.*, CONCAT('soccer_leaguetype_', LOWER(league.`sd_shortname`)) AS `phrase`
	FROM `" . TABLE_PREFIX . "soccer_league` AS league
	WHERE `visible`=1 AND `readonly`=0
	");

$leaguesinfo = array();
$phrasearray = array();

while ($league = $db->fetch_array($leagues_result))
{
	$leaguesinfo['current'][$league['id']] = $league;
	$phrasearray[$league['phrase']] = $league['phrase'];
}

if (empty($leaguesinfo['current']))
{
	exit;
}

$matches = $db->query_read_slave("
	SELECT
		m.`dateline`, m.`league_id`, m.`match_day`, m.id AS matchid,
		CONCAT('soccer_team_', t1.`sd_id`) AS t1_phrase,
		CONCAT('soccer_team_', t2.`sd_id`) AS t2_phrase
	FROM `" . TABLE_PREFIX . "soccer_match` m
	INNER JOIN `" . TABLE_PREFIX . "soccer_team` t1 ON (m.`team_home_id` = t1.`id`)
	INNER JOIN `" . TABLE_PREFIX . "soccer_team` t2 ON (m.`team_away_id` = t2.`id`)
	INNER JOIN `" . TABLE_PREFIX . "soccer_league_team` lt1 ON (m.`team_home_id` = lt1.`team_id` AND m.`league_id` = lt1.`league_id`)
	INNER JOIN `" . TABLE_PREFIX . "soccer_league_team` lt2 ON (m.`team_away_id` = lt2.`team_id` AND m.`league_id` = lt2.`league_id`)
	WHERE m.league_id IN(" . implode(',', array_keys($leaguesinfo['current'])) . ")
		AND m.`dateline` > " . TIMENOW . "
		AND DATEDIFF(FROM_UNIXTIME(m.`dateline`), NOW()) = 0
	ORDER BY m.`dateline`;
	");

if (!$db->num_rows($matches))
{
	exit;
}

$curleaguesmatches = array();
$matchtemplate = array();

while ($match = $db->fetch_array($matches))
{
	$curleaguesmatches[vbstrtolower($leaguesinfo['current'][$match['league_id']]['sd_shortname'])][$match['matchid']] = $match['league_id'];
	$phrasearray[$match['t1_phrase']] = $match['t1_phrase'];
	$phrasearray[$match['t2_phrase']] = $match['t2_phrase'];
	$lmatches[$match['matchid']] = $match;
}

$db->free_result($matches);

$teamphrases = $db->query_read("
	SELECT languageid, varname, text
	FROM `" . TABLE_PREFIX . "phrase`
	WHERE fieldname='vbsoccernames'
		AND varname IN('" . implode('\',\'', array_keys($phrasearray)) . "')
	");

$teamnames = array();
while ($teamphrase = $db->fetch_array($teamphrases))
{
	$teamnames[$teamphrase['varname']][$teamphrase['languageid']] = $teamphrase['text'];
}

$db->free_result($teamphrases);

$recipients = $db->query_read_slave("
	SELECT user.userid, user.salt, user.username, user.email, user.languageid, user.usergroupid, user.membergroupids,
        user.timezoneoffset, IF(user.options & " . $vbulletin->bf_misc_useroptions['dstonoff'] . ", 1, 0) AS dstonoff,
        IF(user.options & " . $vbulletin->bf_misc_useroptions['hasaccessmask'] . ", 1, 0) AS hasaccessmask,
		usertextfield.vbsoccerprefs, soccer_league_subscribe.abo_type,
		language.dateoverride AS lang_dateoverride, language.timeoverride AS lang_timeoverride, language.locale AS lang_locale
    FROM `" . TABLE_PREFIX . "soccer_league_subscribe` AS soccer_league_subscribe
    INNER JOIN " . TABLE_PREFIX . "user AS user USING(userid)
	LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield USING(userid)
    LEFT JOIN " . TABLE_PREFIX . "usergroup AS usergroup ON (usergroup.usergroupid = user.usergroupid)
    LEFT JOIN " . TABLE_PREFIX . "language AS language ON (language.languageid = IF(user.languageid = 0, " . intval($vbulletin->options['languageid']) . ", user.languageid))
    WHERE user.usergroupid <> 3 AND (usergroup.genericoptions & " . $vbulletin->bf_ugp_genericoptions['isnotbannedgroup'] . ")
	");

$curleaguetypes = array_keys($curleaguesmatches);
vbmail_start();
$count = 0;

while ($recipient = $db->fetch_array($recipients))
{
	$vbsoccerprefs = array();

	if (!is_null($recipient['vbsoccerprefs']))
	{
		$vbsoccerprefs = @unserialize($recipient['vbsoccerprefs']);
		if (empty($vbsoccerprefs) or !is_array($vbsoccerprefs))
		{
			$vbsoccerprefs = array();
		}
	}

	if (!empty($vbsoccerprefs['lhide']))
	{
		$recipient['leagueabotypes'] = array_diff($curleaguetypes, $vbsoccerprefs['lhide']);
	}
	else
	{
		$recipient['leagueabotypes'] = $curleaguetypes;
	}

	if (empty($recipient['leagueabotypes']))
	{
		continue; // gaga! benutzer hat alle ligen ausgeblendet in einstellungen
	}

	$match_id_array = array();
	foreach ($recipient['leagueabotypes'] as $ltype)
	{
		$match_id_array = array_merge($match_id_array, array_keys($curleaguesmatches[$ltype]));
	}

	if (empty($match_id_array))
	{
		continue;
	}

	$tipp = array();
	foreach ($match_id_array as $matchid)
	{
		$tipp[$matchid] = '(-:-)';
	}

	// aua...
	// hier eventuell noch andere loesung finden
	$bets = $db->query_read_slave("
		SELECT match_id, bet_home, bet_away
		FROM `" . TABLE_PREFIX . "soccer_user_bet`
		WHERE `userid`=" . $recipient['userid'] . " AND match_id IN(" . implode(',', $match_id_array) . ")
		");

	while ($bet = $db->fetch_array($bets))
	{
		if ($recipient['abo_type'] == 2)
		{
			// spiel entfernen, welches der user bereits getippt hat
			if (($matchid_key = array_search($bet['match_id'], $match_id_array)) !== false)
			{
				unset($match_id_array[$matchid_key]);
				continue;
			}
		}

		$tipp[$bet['match_id']] = '(' . $bet['bet_home'] . ':' . $bet['bet_away'] . ')';
	}

	$userinfo = array(
		'lang_locale'    => $recipient['lang_locale'],
		'dstonoff'       => $recipient['dstonoff'],
		'timezoneoffset' => $recipient['timezoneoffset'],
	);

	$matchdata = array();

	foreach ($match_id_array as $matchid)
	{
		$leagueid = $lmatches[$matchid]['league_id'];

		$lmatches[$matchid]['team_home_name'] = $teamnames[$lmatches[$matchid]['t1_phrase']]['0'];
		$lmatches[$matchid]['team_away_name'] = $teamnames[$lmatches[$matchid]['t2_phrase']]['0'];
		$leaguesinfo['current'][$leagueid]['league_name'] = $teamnames[$leaguesinfo['current'][$leagueid]['phrase']]['0'];

		if (isset($teamnames[$leaguesinfo['current'][$leagueid]['phrase']][$recipient['languageid']]))
		{
			$leaguesinfo['current'][$leagueid]['league_name'] = $teamnames[$leaguesinfo['current'][$leagueid]['phrase']][$recipient['languageid']];
		}

		if (isset($teamnames[$lmatches[$matchid]['t1_phrase']][$recipient['languageid']]))
		{
			$lmatches[$matchid]['team_home_name'] = $teamnames[$lmatches[$matchid]['t1_phrase']][$recipient['languageid']];
		}

		if (isset($teamnames[$lmatches[$matchid]['t2_phrase']][$recipient['languageid']]))
		{
			$lmatches[$matchid]['team_away_name'] = $teamnames[$lmatches[$matchid]['t2_phrase']][$recipient['languageid']];
		}

		$lmatches[$matchid]['kickoff_date'] = vbdate($recipient['lang_dateoverride'] ? $recipient['lang_dateoverride'] : $vbulletin->options['default_dateformat'], $lmatches[$matchid]['dateline'], false, true, true, false, $userinfo);
		$lmatches[$matchid]['kickoff_time'] = vbdate($recipient['lang_timeoverride'] ? $recipient['lang_timeoverride'] : $vbulletin->options['default_timeformat'], $lmatches[$matchid]['dateline'], false, true, true, false, $userinfo);
		$matchdata[$leaguesinfo['current'][$leagueid]['league_name']][] =
			'  '
			. $lmatches[$matchid]['kickoff_date'] . ' ' . $lmatches[$matchid]['kickoff_time'] . ' '
			. $lmatches[$matchid]['team_home_name'] . ' - ' . $lmatches[$matchid]['team_away_name'] . ' '
			. $tipp[$matchid];
	}

	$emailmessage = "";
	foreach ($matchdata as $league => $matches)
	{
		$emailmessage .= " \n" . $league . "  \n" . implode("\n", $matches) . "\n";
	}

	if ($emailmessage != '')
	{
		$count++;
		$template = ($recipient['abo_type'] == 2 ? 'soccer_digest2' : 'soccer_digest');
		eval(fetch_email_phrases($template, $recipient['languageid']));
		vbmail($recipient['email'], $subject, $message);
	}
}

$db->free_result($recipients);

vbmail_end();

log_cron_action($count, $nextitem, 1);
