<?php
/**
 * vbulletin add-on fussball-tippspiele
 *
 * php version 5
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @author  xwing <xwing@geb-team.de>
 * @version SVN: $Id: vbsoccer.php 6750 2010-02-21 20:44:12Z aa $
 */

// ######################## SET PHP ENVIRONMENT ################################
error_reporting(E_ALL & ~E_NOTICE & ~8192);

// ####################### DEFINE IMPORTANT CONSTANTS ##########################
/**
 * @var string
 */
define('THIS_SCRIPT', 'vbsoccer');

/**
 * @var bool
 */
define('CSRF_PROTECTION', true);

// ###################### PRE-CACHE TEMPLATES AND DATA #########################
// get special phrase groups
$phrasegroups = array('vbsoccer', 'vbsoccernames');

// phrasen der einstellungen nur bei bedarf laden!
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'settings')
{
	$phrasegroups[] = 'vbsoccerup';
}

// get special data templates from the datastore
$specialtemplates = array('vbsoccer_leaguecache');

// pre-cache templates used by all actions
$globaltemplates = array(
	'vbsoccer_shell',
	'vbsoccer_league_menu_bit',
	'optgroup',
	'vbsoccer_leaguebit',
	'ad_vbsoccer_first',
	'ad_vbsoccer_sidebar_start',
	'ad_vbsoccer_sidebar_end',
	);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'schedule' => array(
		'vbsoccer_schedule',
		'vbsoccer_matchbit',
		'vbsoccer_betinput',
		'vbsoccer_matches_head',
		'vbsoccer_leaguefooter',
		'vbsoccer_betbit',
		),
	'bet' => array(
		'vbsoccer_bet',
		'vbsoccer_matchbit',
		'vbsoccer_matches_head',
		'vbsoccer_betinput',
		'vbsoccer_betbit',
		'vbsoccer_matchgroupbit',
		),
	'tab' => array(
		'vbsoccer_tab',
		'vbsoccer_tab_standard_bit',
		'vbsoccer_tab_standard_head',
		'vbsoccer_tab_cross_head',
		'vbsoccer_tab_cross_head_bit',
		'vbsoccer_tab_cross_results_bit',
		'vbsoccer_tab_cross_results',
		'vbsoccer_matchgroupbit',
		),
	'settings' => array(
		'vbsoccer_settings',
		'vbsoccer_league_abo_bit',
		'vbsoccer_prefs_headinclude',
		'vbsoccer_prefs_pointcolor_bit',
		),
	'ranking' => array(
		'vbsoccer_ranking',
		'vbsoccer_rankingbit',
		'vbsoccer_rankinghead',
		),
	'live' => array(
		'vbsoccer_live',
		'vbsoccer_livebit',
		'vbsoccer_resultinput',
		'vbsoccer_resultlogbit',
		'forumdisplay_loggedinuser',
		),
	'report' => array(
		'newpost_usernamecode',
		'vbsoccer_reportitem',
		),
	'matchinfo' => array(
		'vbsoccer_matchinfo',
		'vbsoccer_matches_head',
		'vbsoccer_matchbit',
		'vbsoccer_betbit',
		'vbsoccer_betinput',
		'vbsoccer_stats_nomatches',
		),
	'reportranking' => array(
		'vbsoccer_reportranking',
		'vbsoccer_reportrankingbit',
		),
	'overallranking' => array(
		'vbsoccer_overallranking',
		'vbsoccer_overallrankingbit',
		'vbsoccer_overallrankinghead',
		'forumdisplay_sortarrow',
		),
	'hall_of_fame' => array(
		'vbsoccer_halloffamesaisonbit',
		'vbsoccer_halloffamebit',
		'vbsoccer_halloffame',
		),
	);

$actiontemplates['crosstab'] =& $actiontemplates['tab'];

// standard aktion
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'schedule';
}
;
// ########################## REQUIRE BACK-END #################################
/** vbulletin back-end */
require './global.php';

if (empty($GLOBALS['vbulletin']->products['vbsoccer']))
{
	standard_error(fetch_error('product_not_installed_disabled'));
}

$vbsoccerperms =& $GLOBALS['vbulletin']->bf_ugp['vbsoccer_general_permissions'];

/** vbsoccer funktionen */
require DIR . '/includes/functions_vbsoccer.php';

// eingerichtetes vbsoccer-forum ermitteln und rechte dafuer pruefen
foreach ($GLOBALS['vbulletin']->forumcache AS &$forumvalue)
{
	if (empty($forumvalue['link']))
	{
		continue;
	}

	if (strpos($forumvalue['link'], 'vbsoccer.php') !== false)
	{
		$forumperms = fetch_permissions($forumvalue['forumid']);

		if (!($forumperms & $GLOBALS['vbulletin']->bf_ugp_forumpermissions['canview']))
		{
			print_no_permission();
		}

		// get forum info
		$forum = fetch_foruminfo($forumvalue['forumid']);
		$foruminfo =& $forum;

		// make the forum jump in order to fill the forum caches
		$curforumid = $foruminfo['forumid'];
		construct_forum_jump();
		break; // das erste gefundene als tippspiel verwendete forum wird benutzt!
	}
}

unset($forumvalue);



if (empty($foruminfo))
{
	// kein eingerichtetes forum gefunden
	standard_error(fetch_error('soccer_misconfiguration_forumlink'));
}

verify_forum_password($foruminfo['forumid'], $foruminfo['password']);

$GLOBALS['vbulletin']->options['vbsoccer_points'] = @unserialize($GLOBALS['vbulletin']->options['vbsoccer_points']);

if (!$GLOBALS['vbulletin']->options['vbsoccer_points'])
{
	// kein punktesystem gefunden
	standard_error(fetch_error('soccer_misconfiguration_pointsystem'));
}

// #############################################################################
$vbsoccerprefs = array();
$vbsoccerprefs['color']['nb'] = '#999999';
$vbsoccerprefs['color']['wr'] = '#CC3300';
$vbsoccerprefs['color']['rw'] = '#CC9900';
$vbsoccerprefs['color']['rd'] = '#99CC00';
$vbsoccerprefs['color']['rr'] = '#336600';
$vbsoccerprefs['smallfont']   = (bool) $GLOBALS['vbulletin']->options['vbsoccer_smallfont'];
$vbsoccerprefs['schedstyle']  = $GLOBALS['vbulletin']->options['vbsoccer_schedstyle'];

if ($GLOBALS['vbulletin']->userinfo['vbsoccerprefs'] != '')
{
	// usereinstellungen laden und defaults ueberschreiben
	$unserializedPrefs = unserialize($GLOBALS['vbulletin']->userinfo['vbsoccerprefs']);
	if (isset($unserializedPrefs['color']))
	{
		$unserializedPrefs['color'] = array_merge($vbsoccerprefs['color'], $unserializedPrefs['color']);
	}
	$vbsoccerprefs = array_merge($vbsoccerprefs, $unserializedPrefs);
}

$mainfontclass = !empty($vbsoccerprefs['smallfont']) ? ' smallfont' : '';
$notsubscribed = array();

// #############################################################################
if (isset($_POST['do']) AND $_POST['do'] == 'updateoptions')
{
	if (!$GLOBALS['vbulletin']->userinfo['userid'])
	{
		print_no_permission();
	}

	$GLOBALS['vbulletin']->input->clean_array_gpc('p', array(
		'pref'       => TYPE_ARRAY_ARRAY,
		'option'     => TYPE_ARRAY_ARRAY,
		'emailabo'   => TYPE_UINT,
		'notify'     => TYPE_BOOL,
		'smallfont'  => TYPE_BOOL,
		'schedstyle' => TYPE_BOOL,
		));

	$prefArray = array();

	if (isset($GLOBALS['vbulletin']->GPC['option']['l']) AND
		is_array($GLOBALS['vbulletin']->GPC['option']['l']))
	{
		foreach (array_keys($GLOBALS['vbulletin']->GPC['option']['l']) AS $l)
		{
			if (!isset($GLOBALS['vbulletin']->GPC['pref']['l'][$l]))
			{
				$prefArray['lhide'][] = $l;
			}
		}
	}

	if (isset($GLOBALS['vbulletin']->GPC['pref']['c']) AND
		is_array($GLOBALS['vbulletin']->GPC['pref']['c']))
	{
		foreach ($GLOBALS['vbulletin']->GPC['pref']['c'] AS $colorcode => $value)
		{
			if (!isset($vbsoccerprefs['color'][(string) $colorcode]))
			{
				// unbekannter farbschluessel!
				continue;
			}

			if (preg_match("/^(#[a-f0-9]{6}|#[a-f0-9]{3})$/i", trim($value), $match))
			{
				// farbcode fuer legende etc
				$prefArray['color'][$colorcode] = trim($match[1]);
			}
			else
			{
				require_once DIR . '/includes/html_color_names.php';
				$value = strtolower(trim($value));

				if (isset($html_color_names[$value]))
				{
					$prefArray['color'][$colorcode] = $value;
				}
			}
		}
	}

	$prefArray['smallfont']  = $GLOBALS['vbulletin']->GPC['smallfont'];
	$prefArray['schedstyle'] = $GLOBALS['vbulletin']->GPC['schedstyle'];

	// init user data manager
	$userdata =& datamanager_init('User', $GLOBALS['vbulletin'], ERRTYPE_STANDARD);
	$userdata->set_existing($GLOBALS['vbulletin']->userinfo);
	$userdata->set('vbsoccerprefs', serialize($prefArray));
	$userdata->set('vbsoccerunbet', '');
	$userdata->set('vbsoccernotify', (int) $vbulletin->GPC['notify']);
	$userdata->save();

	// email-abonnements
	if (($abonnements = $GLOBALS['vbulletin']->db->query_first("
		SELECT `userid`, `abo_type`
		FROM `" . TABLE_PREFIX . "soccer_league_subscribe`
		WHERE `userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . "
		")))
	{
		if ($GLOBALS['vbulletin']->GPC['emailabo'] == 0)
		{
			// abo loeschen
			$GLOBALS['vbulletin']->db->query_write("
				DELETE FROM `" . TABLE_PREFIX . "soccer_league_subscribe`
				WHERE `userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . "
				");
		}
		else
		{
			$GLOBALS['vbulletin']->db->query_write("
				UPDATE `" . TABLE_PREFIX . "soccer_league_subscribe`
				SET `abo_type`=" . (int) $GLOBALS['vbulletin']->GPC['emailabo'] . "
				WHERE `userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . "
				");
		}
	}
	else
	{
		if ($GLOBALS['vbulletin']->GPC['emailabo']!=0)
		{
			$GLOBALS['vbulletin']->db->query_write("
				INSERT INTO `" . TABLE_PREFIX . "soccer_league_subscribe`
				SET `userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . ",
					`abo_type`=" . (int) $GLOBALS['vbulletin']->GPC['emailabo'] . "
				ON DUPLICATE KEY UPDATE
					`abo_type`=" . (int) $GLOBALS['vbulletin']->GPC['emailabo'] . "
				");
		}
	}

	// weiterleitung zur einstellungsseite
	$GLOBALS['vbulletin']->options['useheaderredirect'] = false;
	$GLOBALS['vbulletin']->url = $GLOBALS['vbulletin']->script . '?' . $GLOBALS['vbulletin']->session->vars['sessionurl'] . 'do=settings';
	eval(print_standard_redirect("soccer_setprefs_successfully"));
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'sdupdate')
{
	if (!$GLOBALS['vbulletin']->userinfo['userid'])
	{
		print_no_permission();
	}

	$GLOBALS['vbulletin']->input->clean_array_gpc('r',
		array('l'    => TYPE_UINT,
			  'm'    => TYPE_UINT,
			  'redo' => TYPE_STR,
			  ));

	if (!isset($GLOBALS['vbulletin']->vbsoccer_leaguecache[$GLOBALS['vbulletin']->GPC['l']]))
	{
		print_no_permission();
	}

	$leagueinfo =& $GLOBALS['vbulletin']->vbsoccer_leaguecache[$GLOBALS['vbulletin']->GPC['l']];
	$result = soccer_update_fixtures(false, $leagueinfo);

	$urlparams = array();

	if ($GLOBALS['vbulletin']->GPC['redo'] != 'schedule')
	{
		$urlparams['do'] = $GLOBALS['vbulletin']->GPC['redo'];
	}

	if (!empty($GLOBALS['vbulletin']->session->vars['sessionurl']))
	{
		$urlparams['s'] = $GLOBALS['vbulletin']->session->vars['dbsessionhash'];
	}

	$urlparams['l'] = $GLOBALS['vbulletin']->GPC['l'];

	if ($GLOBALS['vbulletin']->GPC['m'] > 0)
	{
		$urlparams['m'] = $GLOBALS['vbulletin']->GPC['m'];
	}

	$GLOBALS['vbulletin']->url = 'vbsoccer.php?' . http_build_query($urlparams);
	$GLOBALS['vbulletin']->options['useheaderredirect'] = true;
	eval(print_standard_redirect('soccer_sdupdate_successfully'));
}

// #############################################################################
if (isset($_POST['do']) AND $_POST['do'] == 'liveupdate')
{
	if (!($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canpostresults']) OR
		!$GLOBALS['vbulletin']->userinfo['userid'])
	{
		print_no_permission();
	}

	$GLOBALS['vbulletin']->input->clean_array_gpc('p',
		array('r'    => TYPE_ARRAY_ARRAY,
			  'ctrl' => TYPE_ARRAY_ARRAY,
			  'fin'  => TYPE_ARRAY_BOOL,
			  ));

	if (empty($GLOBALS['vbulletin']->GPC['ctrl']['home']) OR
		empty($GLOBALS['vbulletin']->GPC['r']['home']) OR
		!is_array($GLOBALS['vbulletin']->GPC['ctrl']['home']) OR
		!is_array($GLOBALS['vbulletin']->GPC['r']['home']))
	{
		exit;
	}

	$matchids = array();

	foreach ($GLOBALS['vbulletin']->GPC['ctrl']['home'] AS $id => $val)
	{
		if (!isset($GLOBALS['vbulletin']->GPC['r']['home'][$id]) OR
			!isset($GLOBALS['vbulletin']->GPC['r']['away'][$id]) OR
			!isset($GLOBALS['vbulletin']->GPC['ctrl']['away']))
		{
			// baeh! kein regulaeres formular abgesendet. eintrag ignorieren
			continue;
		}

		if ($GLOBALS['vbulletin']->GPC['r']['home'][$id] == $val AND
			$GLOBALS['vbulletin']->GPC['r']['away'][$id] == $GLOBALS['vbulletin']->GPC['ctrl']['away'][$id])
		{
			if ((isset($GLOBALS['vbulletin']->GPC['fin'][$id]) AND $GLOBALS['vbulletin']->GPC['ctrl']['fin'][$id] == 1)
				OR (empty($GLOBALS['vbulletin']->GPC['fin'][$id]) AND $GLOBALS['vbulletin']->GPC['ctrl']['fin'][$id] == 0))
			{
				// keine aenderungen in den feldern (incl. abpfiff-status)
				continue;
			}
		}

		$matchids[] = (int) $id;
	}

	if (!empty($matchids))
	{
		$userlogs = $GLOBALS['vbulletin']->db->query_read_slave("
			SELECT `id`, `result`, `finished`, `match_id`
			FROM `" . TABLE_PREFIX . "soccer_postresult_log`
			WHERE `userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . "
				AND `match_id` IN(" . implode(',', $matchids) . ")
			");

		$postloghistory = array();

		while (($userlog = $GLOBALS['vbulletin']->db->fetch_array($userlogs)))
		{
			$postloghistory[$userlog['match_id']] = $userlog;
		}

		$GLOBALS['vbulletin']->db->free_result($userlogs);

		// alle zu aendernden spiele auslesen
		// ergebnis von spielen ohne ergebnis (-1) auf leeren string setzen
		$matches = $GLOBALS['vbulletin']->db->query_read_slave("
			SELECT *,
				IF(`points_home`=-1, '', `points_home`) AS `points_home`,
				IF(`points_away`=-1, '', `points_away`) AS `points_away`
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE `id` IN(" . implode(',', $matchids) . ")
			");

		unset($matchids);
		$changes = $changedleagues = array();

		// abbruch durch anwender ignorieren
		@ignore_user_abort(true);

		while (($match = $GLOBALS['vbulletin']->db->fetch_array($matches)))
		{
			if (TIMENOW < $match['dateline'])
			{
				// oeh?! spiel laeuft doch noch gar nicht?!
				continue;
			}

			if (!isset($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'][$match['league_id']]))
			{
				// spiel ist nicht in einer aktuellen saison (archiv?)
				continue;
			}

			if (!isset($GLOBALS['vbulletin']->GPC['r']['home'][$match['id']]) OR
				!isset($GLOBALS['vbulletin']->GPC['r']['away'][$match['id']]))
			{
				// formularfelder nicht vollstaendig
				continue;
			}

			if ($GLOBALS['vbulletin']->GPC['r']['home'][$match['id']] == $match['points_home'] AND
				$GLOBALS['vbulletin']->GPC['r']['away'][$match['id']] == $match['points_away'] AND
				(isset($GLOBALS['vbulletin']->GPC['fin'][$match['id']]) AND $match['match_is_finished'] == 2))
			{
				// ergebnis und spiel-ende unveraendert.
				continue;
			}

			if (trim($GLOBALS['vbulletin']->GPC['r']['home'][$match['id']]) == '' OR
				trim($GLOBALS['vbulletin']->GPC['r']['away'][$match['id']]) == '')
			{
				// ist nur eines von beiden feldern leer?
				if (trim($GLOBALS['vbulletin']->GPC['r']['home'][$match['id']]) != trim($GLOBALS['vbulletin']->GPC['r']['away'][$match['id']]))
				{
					// ergebnis-meldung unvollstaendig (beide felder muessen
					// ausgefuellt sein. ein feld ist jedoch leer). ignorieren.
					continue;
				}

				if ($match['points_home'] == '' AND $match['points_away'] == '')
				{
					// kein ergebnis vorhanden fuer das spiel. da der anwender
					// nichts eingegeben hat: ignorieren statt automatisch 0:0
					// immerhin besteht die moeglichkeit, dass das spiel ver-
					// schoben wurde, aber dies vom datendienst nocht nicht ge-
					// updatet wurde.
					continue;
				}

				if (trim($GLOBALS['vbulletin']->GPC['ctrl']['home'][$match['id']]) == '' OR
					trim($GLOBALS['vbulletin']->GPC['ctrl']['away'][$match['id']]) == '')
				{
					// keine aenderung zu den kontrollfeldern. eingabe ignorieren
					continue;
				}

				// hier aus dem leeren string ein -1 machen, sonst wird das ein 0:0
				$GLOBALS['vbulletin']->GPC['r']['home'][$match['id']] = -1;
				$GLOBALS['vbulletin']->GPC['r']['away'][$match['id']] = -1;
			}

			// werte zum versand an datendienst merken
			$changes['home'][(int) $match['sd_id']] = (int) $GLOBALS['vbulletin']->GPC['r']['home'][$match['id']];
			$changes['away'][(int) $match['sd_id']] = (int) $GLOBALS['vbulletin']->GPC['r']['away'][$match['id']];
			$changes['fin'][(int) $match['sd_id']]  = isset($GLOBALS['vbulletin']->GPC['fin'][$match['id']]) ? 1 : 0;

			$GLOBALS['vbulletin']->db->query_write("
				UPDATE `" . TABLE_PREFIX . "soccer_match`
				SET `points_home`=" . (int) $GLOBALS['vbulletin']->GPC['r']['home'][$match['id']] . ",
					`points_away`=" . (int) $GLOBALS['vbulletin']->GPC['r']['away'][$match['id']] . ",
					`last_update_timestamp`=" . TIMENOW . ",
					`score_key`=CASE
						WHEN `points_home`=-1 AND `points_away`=-1 THEN 0
						WHEN `points_home`=`points_away` THEN 2
						WHEN `points_home`>`points_away` THEN 1
						WHEN `points_home`<`points_away` THEN 3
					END, `match_is_finished`=" . (isset($GLOBALS['vbulletin']->GPC['fin'][$match['id']]) ? 2 : 0) . "
				WHERE `id`=" . $match['id'] . "
				");

			// postlog
			$postresult = $GLOBALS['vbulletin']->GPC['r']['home'][$match['id']] . ':' . $GLOBALS['vbulletin']->GPC['r']['away'][$match['id']];

			$changedleagues[$match['league_id']] = $match['league_id'];

			if ($GLOBALS['vbulletin']->GPC['r']['home'][$match['id']] == $match['points_home'] AND
				$GLOBALS['vbulletin']->GPC['r']['away'][$match['id']] == $match['points_away'])
			{
				continue;
			}

			$ipaddress = ($GLOBALS['vbulletin']->options['logip'] ? IPADDRESS : '');

			if (isset($postloghistory[$match['id']]))
			{
				// anwender hat bereits eine meldung zu diesem spiel gemacht
				if ($postloghistory[$match['id']]['result'] == $postresult AND
					$postloghistory[$match['id']]['finished'] == (int) $GLOBALS['vbulletin']->GPC['fin'][$match['id']])
				{

					// ergebnis und spiel-ende wurden bereits gemeldet.
					// hier nur den zeitstempel aktualisieren
					$postresultresult = $GLOBALS['vbulletin']->db->query_write("
						UPDATE `" . TABLE_PREFIX . "soccer_postresult_log`
						SET `dateline`=" . TIMENOW . ",
							`ipaddress`='" . $GLOBALS['vbulletin']->db->escape_string($ipaddress) . "'
						WHERE `id`=" . $postloghistory[$match['id']]['id'] . "
						");

					continue;
				}
			}

			$postresultresult = $GLOBALS['vbulletin']->db->query_write("
				INSERT INTO `" . TABLE_PREFIX . "soccer_postresult_log`
				SET `userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . ",
					`match_id`=" . $match['id'] . ",
					`dateline`=" . TIMENOW . ",
					`result`='" . $GLOBALS['vbulletin']->db->escape_string($postresult) . "',
					`finished`=" . (int) $GLOBALS['vbulletin']->GPC['fin'][$match['id']] . ",
					`ipaddress`='" . $GLOBALS['vbulletin']->db->escape_string($ipaddress) . "'
				");

			if ($GLOBALS['vbulletin']->db->affected_rows($postresultresult))
			{
				$GLOBALS['vbulletin']->db->query_write("
					INSERT INTO `" . TABLE_PREFIX . "soccer_postresult_stats`
					SET `userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . ",
						`league_id`=" . $match['league_id'] . ",
						`count`=1,
						`lastupdate`=" . TIMENOW . "
					ON DUPLICATE KEY UPDATE
						`userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . ",
						`league_id`=" . $match['league_id'] . ",
						`count`=`count`+1,
						`lastupdate`=" . TIMENOW . "
					");
			}

		} // end while

		$GLOBALS['vbulletin']->db->free_result($matches);

		try
		{
			$client = soccerDataClient();
			$client->updateMatches(serialize($changes));
		}
		catch (Exception $e)
		{
			// nothing
		}
	}

	if (!empty($changedleagues))
	{
		foreach ($changedleagues AS $id)
		{
			$leagueinfo  =& $GLOBALS['vbulletin']->vbsoccer_leaguecache[$id];
			$result = soccer_update_fixtures(true, $leagueinfo);
		}
	}

	$GLOBALS['vbulletin']->url = 'vbsoccer.php?'
					. $GLOBALS['vbulletin']->session->vars['sessionurl']
					. 'do=live';

	$GLOBALS['vbulletin']->options['useheaderredirect'] = true;
	eval(print_standard_redirect('redirect_soccer_sdupdate_successfully'));

}

// #############################################################################
if (isset($_POST['do']) AND $_POST['do'] == 'dobet')
{
	if (!($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canbet'])
		OR !$GLOBALS['vbulletin']->userinfo['userid'])
	{
		print_no_permission();
	}

	$GLOBALS['vbulletin']->input->clean_array_gpc('p', array(
		'b'       => TYPE_ARRAY_ARRAY,
		'l'       => TYPE_UINT,
		'm'       => TYPE_UINT,
		'redo'    => TYPE_STR,
		'list'    => TYPE_UINT,
		'matchid' => TYPE_UINT,
		));

	if (empty($GLOBALS['vbulletin']->GPC['b']['home']) OR empty($GLOBALS['vbulletin']->GPC['b']['away']))
	{
		// TODO fehlermeldung
		exit;
	}

	// anzeige von nachricht beim weiterleiten erzwingen
	$GLOBALS['vbulletin']->options['useheaderredirect'] = false;

	@ignore_user_abort(true);

	foreach ($GLOBALS['vbulletin']->GPC['b']['home'] AS $matchid => $value)
	{
		if (!isset($GLOBALS['vbulletin']->GPC['b']['away'][$matchid]))
		{
			// tipp unvollstaendig. es muessen beide felder ausgefuellt sein.
			// diesen eintrag ignorieren und ueberspringen
			continue;
		}

		$betHome = trim($value);
		$betAway = trim($GLOBALS['vbulletin']->GPC['b']['away'][$matchid]);

		// spielansetzung gueltig und tippen noch erlaubt?

		if (!($matchinfo = $GLOBALS['vbulletin']->db->query_first_slave("
			SELECT *
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE `id`=" . (int) $matchid . "
			")))
		{
			// spiel ist nicht vorhanden! ueberspringen
			continue;
		}

		if (!isset($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'][$matchinfo['league_id']]))
		{
			// spiel ist nicht in einer aktuellen saison (archiv?)
			continue;
		}

		if (!empty($GLOBALS['vbulletin']->vbsoccer_leaguecache[$matchinfo['league_id']]['readonly']))
		{
			// spiel darf nicht getippt werden (readonly)
			continue;
		}

		if (TIMENOW > $matchinfo['dateline'])
		{
			// aenderungen nicht mehr erlaubt nach spielbeginn
			continue;
		}

		if ((!preg_match('/^\d+$/', $betHome) OR $betHome == '') OR
			(!preg_match('/^\d+$/', $betAway) OR $betAway == ''))
		{
			// tipp war ungueltig oder wurde entfernt. eintrag loeschen.
			$GLOBALS['vbulletin']->db->query_write("
				DELETE FROM `" . TABLE_PREFIX . "soccer_user_bet`
				WHERE `userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . "
					AND `match_id`=" . (int) $matchid . "
				");

			continue;
		}

		// TODO ersetzen durch sql-case-statements
		$bet_score_key = fetch_soccer_score_key($betHome, $betAway);

		// tipp eintragen oder aktualisieren
		$GLOBALS['vbulletin']->db->query_write("
			INSERT INTO `" . TABLE_PREFIX . "soccer_user_bet`
			SET `userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . ",
				`match_id`=" . (int) $matchid . ",
				`bet_home`=" . (int) $betHome . ",
				`bet_away`=" . (int) $betAway . ",
				`bet_score_key`=" . (int) $bet_score_key . "
			ON DUPLICATE KEY UPDATE
				`bet_home`=" . (int) $betHome . ",
				`bet_away`=" . (int) $betAway . ",
				`bet_score_key`=" . (int) $bet_score_key . "
			");
	}

	if ($vbulletin->userinfo['vbsoccernotify'])
	{
		$vbulletin->db->shutdown_query("
			UPDATE `" . TABLE_PREFIX . "usertextfield`
			SET `vbsoccerunbet`=''
			WHERE userid=" . $vbulletin->userinfo['userid'] . "
			");
	}

	$params = array('do' => 'bet');

	if ($GLOBALS['vbulletin']->GPC['redo'] == 'schedule')
	{
		unset($params['do']);

		if ($GLOBALS['vbulletin']->GPC['list'] != $vbsoccerprefs['schedstyle'])
		{
			switch ($GLOBALS['vbulletin']->GPC['list'])
			{
				case 0: $params['list'] = 'kickoff'; break;
				case 1: $params['list'] = 'grouped'; break;
				default: break;
			}
		}
	}
	else if ($GLOBALS['vbulletin']->GPC['redo'] == 'matchinfo')
	{
		$params['do'] = 'matchinfo';
		$params['l'] = $matchinfo['league_id'];
		$params['matchid'] = $GLOBALS['vbulletin']->GPC['matchid'];
	}

	if ($GLOBALS['vbulletin']->GPC['l'] > 0)
	{
		$params['l'] = $GLOBALS['vbulletin']->GPC['l'];
	}
	if ($GLOBALS['vbulletin']->GPC['m'] > 0)
	{
		$params['m'] = $GLOBALS['vbulletin']->GPC['m'];
	}

	$uri = http_build_query($params);

	$GLOBALS['vbulletin']->url = 'vbsoccer.php'
					. ($uri != ''
					   ? '?' . $GLOBALS['vbulletin']->session->vars['sessionurl'] . $uri
					   : ((!empty($GLOBALS['vbulletin']->session->vars['sessionurl'])
						  ? '?' . $GLOBALS['vbulletin']->session->vars['sessionurl']
						  : '')));

	eval(print_standard_redirect('redirect_soccer_setresult_successfully'));
}

// #############################################################################
$GLOBALS['vbulletin']->input->clean_gpc('r', 'l', TYPE_UINT);

if (!empty($GLOBALS['vbulletin']->GPC['l']))
{
	if (!isset($GLOBALS['vbulletin']->vbsoccer_leaguecache[$GLOBALS['vbulletin']->GPC['l']]))
	{
		standard_error(fetch_error('invalidid', 'league', $GLOBALS['vbulletin']->options['contactuslink']));
	}
}

// liga-eintraege fuer main-menue
$league_menu_bits = $league_readonly_menu_bits = '';

if (empty($GLOBALS['vbulletin']->vbsoccer_leaguecache))
{
	$GLOBALS['vbulletin']->vbsoccer_leaguecache = array(
		'current' => array(),
		'archiv'  => array(),
		);
}

foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'] AS $leagueid)
{
	$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$leagueid];

	if (!empty($vbsoccerprefs['lhide']))
	{
		if (in_array(strtolower($leagueinfo['sd_shortname']), $vbsoccerprefs['lhide']))
		{
			// ausgeblendete ligen nicht im menue anzeigen
			continue;
		}
	}

	$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
	$region = strtolower($leagueinfo['region']);
	// css-klasse menue-eintrag (fuer ausgewaehlt oder nicht ausgewaehlt)
	$cssclass = (($GLOBALS['vbulletin']->GPC['l'] == $leagueid AND in_array($_REQUEST['do'], array('bet', 'tab', 'crosstab', 'matchinfo', 'report'))) ? 'alt1' : 'alt2');

	if (empty($leagueinfo['readonly']))
	{
		if ($leagueinfo['groupid'] == 0)
		{
			// mindestens ein wettbewerb ist keiner gruppe zugeordnet
			// 'Aktuelle Saison' als ueberschrift anzeigen
			$show['default_league_navgroup'] = true;
		}

		if (!isset($oldleaguenavgroup) OR $oldleaguenavgroup != $leagueinfo['groupid'])
		{
			if ($leagueinfo['groupid'] != 0)
			{
				$leagueinfo['navgroup'] = htmlspecialchars_uni($vbphrase['soccer_navgroup_' . $leagueinfo['groupid']]);
				eval('$league_menu_bits .= "' . fetch_template('vbsoccer_leaguegroup_menu_bit') . '";');
			}
		}

		$oldleaguenavgroup = $leagueinfo['groupid'];
		eval('$league_menu_bits .= "' . fetch_template('vbsoccer_league_menu_bit') . '";');
	}
	else
	{
		eval('$league_readonly_menu_bits .= "' . fetch_template('vbsoccer_league_menu_bit') . '";');
	}
}


if (isset($leagueinfo))
{
	unset($leagueinfo);
}

// #############################################################################
if ((isset($_REQUEST['do']) AND $_REQUEST['do'] == 'report') OR
	(isset($_POST['do']) AND $_POST['do'] == 'submitreport'))
{
	/** reportfunktionen */
	require DIR . '/includes/class_reportitem_vbsoccer.php';

	if (!$GLOBALS['vbulletin']->userinfo['userid'])
	{
		print_no_permission();
	}

	if ($GLOBALS['vbulletin']->GPC['l'])
	{
		if (!isset($GLOBALS['vbulletin']->vbsoccer_leaguecache[$GLOBALS['vbulletin']->GPC['l']]))
		{
			print_no_permission();
		}

		$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$GLOBALS['vbulletin']->GPC['l']];
	}
	else
	{
		$leagueinfo = array();
	}

	$reportobj = new vB_ReportItem_vbsoccer($GLOBALS['vbulletin']);
	$perform_floodcheck = $reportobj->need_floodcheck();
	$iteminfo = array('league' => $leagueinfo);
	$forminfo = $reportobj->set_forminfo($iteminfo);
	$headtitle = $forminfo['itemname'];

	if ($perform_floodcheck)
	{
		$reportobj->perform_floodcheck_precommit();
	}

	if ($_REQUEST['do'] == 'report')
	{
		/** editor funktionen */
		require DIR . '/includes/functions_editor.php';
		$textareacols = fetch_textarea_width();
		eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');
		$url = '';

		$templatename = 'vbsoccer_reportitem';
	}

	if ($_POST['do'] == 'submitreport')
	{

		$GLOBALS['vbulletin']->input->clean_array_gpc('p', array(
			'reason' => TYPE_STR,
		));

		if ($GLOBALS['vbulletin']->GPC['reason'] == '')
		{
			eval(standard_error(fetch_error('soccer_noreason')));
		}

		if ($perform_floodcheck)
		{
			$reportobj->perform_floodcheck_commit();
		}


		$reportobj->do_report($GLOBALS['vbulletin']->GPC['reason'], $iteminfo);

		$GLOBALS['vbulletin']->url = 'vbsoccer.php' . $GLOBALS['vbulletin']->session->vars['sessionurl_q'];
		eval(print_standard_redirect('redirect_reportthanks'));
	}
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'settings')
{
	if (!$GLOBALS['vbulletin']->userinfo['userid'])
	{
		print_no_permission();
	}

	$headtitle = $GLOBALS['vbphrase']['soccer_settings_and_options'];

	eval('$headinclude .= "' . fetch_template('vbsoccer_prefs_headinclude') . '";');

	$league_abo_bits = '';

	// email-abonnement
	if (($abonnements = $GLOBALS['vbulletin']->db->query_first("
		SELECT `userid`, `abo_type`
		FROM `" . TABLE_PREFIX . "soccer_league_subscribe`
		WHERE `userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . "
		")))
	{
		$emailabochecked0 = $emailabochecked1 = $emailabochecked2 = '';

		if ($abonnements['abo_type'] == 1)
		{
			$emailabochecked1 = ' checked="checked"';
		}
		else
		{
			$emailabochecked2 = ' checked="checked"';
		}
	}
	else
	{
		$emailabochecked0 = ' checked="checked"';
		$emailabochecked1 = $emailabochecked2 = '';
	}

	// liga-abonnement
	$leaguetypes = array();
	foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache AS $leagueid => $leagueinfo)
	{
		if (in_array($leagueid, array('current', 'archiv')))
		{
			continue;
		}

		if (isset($leaguetypes[$leagueinfo['phrase']]))
		{
			continue;
		}

		$leaguetypes[$leagueinfo['phrase']] = true;

		$leagueinfo['league_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$leagueinfo['phrase']]);
		$region = strtolower($leagueinfo['region']);
		$leaguetype = strtolower($leagueinfo['sd_shortname']);
		$checked = ' checked="checked"';

		if (isset($vbsoccerprefs['lhide']))
		{
			if (!empty($vbsoccerprefs['lhide']) AND in_array($leaguetype, $vbsoccerprefs['lhide']))
			{
				$checked = '';
			}
		}

		$show['archivedleaguetype'] = isset($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv'][$leagueid]) ? true : false;
		eval('$league_abo_bits .= "' . fetch_template('vbsoccer_league_abo_bit') . '";');
	}

	// farbeinstellungen
	$pointcolor_bits = '';
	$selectorinvalid = array();

	foreach (array_merge(array('nb' => 0), $GLOBALS['vbulletin']->options['vbsoccer_points']) AS $selectorname => $val)
	{
		$selectorinvalid['color'] = ''; //'usercsserror';
		$selectordesc = construct_phrase($GLOBALS['vbphrase']['soccer_pointcolor_'. $selectorname .'_x'], $val);
		if (isset($vbsoccerprefs['color'][$selectorname]))
		{
			$selectorvalue = $vbsoccerprefs['color'][$selectorname];
		}
		eval('$pointcolor_bits .= "' . fetch_template('vbsoccer_prefs_pointcolor_bit') . '";');
	}

	$templatename = 'vbsoccer_settings';
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'archive')
{
	if (!empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv']))
	{
		reset($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv']);
		$leagueid = key($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv']);
		$GLOBALS['vbulletin']->url = 'vbsoccer.php?' . $GLOBALS['vbulletin']->session->vars['sessionurl'] . 'do=bet&amp;l=' . $leagueid;
		exec_header_redirect($GLOBALS['vbulletin']->url);
	}

	// vbulletin-fehlermeldung (der link zum archiv existiert im menue nur
	// dann, wenn es archivierte eintraege gibt.)
	standard_error(fetch_error('soccer_no_archives'));
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'betinfo')
{
	if (!$GLOBALS['vbulletin']->userinfo['userid'] OR
		!$GLOBALS['vbulletin']->options['vbsoccer_betspymode'])
	{
		print_no_permission();
	}

	$GLOBALS['vbulletin']->input->clean_array_gpc('r', array(
		'matchid' => TYPE_UINT,
		));
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'matchinfo')
{
	$GLOBALS['vbulletin']->input->clean_gpc('r', 'matchid', TYPE_UINT);

	if (empty($GLOBALS['vbulletin']->GPC['matchid']))
	{
		standard_error(fetch_error('invalidid', 'matchid', $GLOBALS['vbulletin']->options['contactuslink']));
	}

	if (!($matchinfo = $GLOBALS['vbulletin']->db->query_first_slave("
		SELECT m.*, m.id AS matchid,
			CONCAT('soccer_team_', t1.`sd_id`) AS t1_phrase,
			CONCAT('soccer_team_', t2.`sd_id`) AS t2_phrase,
			t1.sd_homepage AS `team_home_homepage`, t2.sd_homepage AS `team_away_homepage`,
			t1.`logo` AS `team_home_logo`,
			t2.`logo` AS `team_away_logo`,
			t1.`logo_size_html` AS `team_home_logo_size_html`,
			t2.`logo_size_html` AS `team_away_logo_size_html`,
			t1.`sd_homepage` AS `team_home_homepage`,
			t2.`sd_homepage` AS `team_away_homepage`,
			IF(m.`points_home`=-1, '-', m.`points_home`) AS `team_home_goals`,
			IF(m.`points_away`=-1, '-', m.`points_away`) AS `team_away_goals`,
			IFNULL(b.`bet_home`, '') AS `bet_home`,
			IFNULL(b.`bet_away`, '') AS `bet_away`,
			b.bet_score_key, m.score_key
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t1 ON (m.`team_home_id`=t1.`id`)
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t2 ON (m.`team_away_id`=t2.`id`)
		LEFT  JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.id = b.match_id AND b.userid=" . $GLOBALS['vbulletin']->userinfo['userid'] . ")
		WHERE m.id=" . $GLOBALS['vbulletin']->GPC['matchid'] . "
		")))
	{
		standard_error(fetch_error('invalidid', 'matchid', $GLOBALS['vbulletin']->options['contactuslink']));
	}

	$lastmatcheslimit = 5;

	$matchstatistics = $GLOBALS['vbulletin']->db->query_read_slave("
		(
			SELECT id, '" . $matchinfo['team_home_id'] . "' AS `teammatches`
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE (`team_home_id`=" . $matchinfo['team_home_id'] . "
				OR `team_away_id`=" . $matchinfo['team_home_id'] . ")
				AND `match_is_finished`=1 AND id<>" . $matchinfo['matchid'] . "
			ORDER BY dateline DESC
			LIMIT " . $lastmatcheslimit . "
		)
		UNION ALL
		(
			SELECT id, '" . $matchinfo['team_away_id'] . "' AS `teammatches`
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE (`team_home_id`=" . $matchinfo['team_away_id'] . "
				OR `team_away_id`=" . $matchinfo['team_away_id'] . ")
				AND `match_is_finished`=1 AND id<>" . $matchinfo['matchid'] . "
			ORDER BY dateline DESC
			LIMIT " . $lastmatcheslimit . "
		)
		UNION ALL
		(
			SELECT id, 'both' AS `teammatches`
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE (`team_home_id` IN(" . $matchinfo['team_home_id'] . ", " . $matchinfo['team_away_id'] . ")
				AND `team_away_id` IN(" . $matchinfo['team_home_id'] . ", " . $matchinfo['team_away_id'] . "))
				AND match_is_finished=1 AND id<>" . $matchinfo['matchid'] . "
			ORDER BY dateline DESC
			LIMIT " . $lastmatcheslimit . "
		)");

	$matchids = $teamids = $matches = array();

	while (($matchstatistic = $GLOBALS['vbulletin']->db->fetch_array($matchstatistics)))
	{
		$matches[$matchstatistic['teammatches']][] = $matchstatistic;
		$matchids[$matchstatistic['id']] = $matchstatistic['id'];
		$teamids[$matchstatistic['team_home_id']] = $matchstatistic['team_home_id'];
		$teamids[$matchstatistic['team_away_id']] = $matchstatistic['team_away_id'];
	}

	$GLOBALS['vbulletin']->db->free_result($matchstatistics);

	// anzeige der angeklickten begegnung mit tippabgabemoeglichkeit
	$show['allowbet'] = $canbet = false;
	$show['match_result'] = true;
	$show['reportlink']   = true;
	$show['leaguehortname'] = true;

	$colspan = 6;

	if ($GLOBALS['vbulletin']->userinfo['userid'] AND ($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canbet']))
	{
		$canbet = true;
	}

	$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$matchinfo['league_id']];
	$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);

	$show['sdupdate'] = ($GLOBALS['vbulletin']->userinfo['userid'] AND (TIMENOW - 120) < $leagueinfo['last_cronjob_timestamp'] ? false : true);

	if ($leagueinfo['sd_lastupdate'] == 0)
	{
		$GLOBALS['vbphrase']['soccer_last_update_on'] = $GLOBALS['vbphrase']['soccer_last_update_never'];
	}
	else
	{
		$GLOBALS['vbphrase']['soccer_last_update_on'] = construct_phrase($GLOBALS['vbphrase']['soccer_last_update_on_x'],
															  vbdate($GLOBALS['vbulletin']->options['dateformat'], $leagueinfo['sd_lastupdate'], true),
															  vbdate($GLOBALS['vbulletin']->options['timeformat'], $leagueinfo['sd_lastupdate'])
															  );
	}

	// ligainformationen und spaltenueberschriften
	$leagueicon = fetch_soccer_leagueicon($leagueinfo);
	eval('$nextmatchbits  = "' . fetch_template('vbsoccer_leaguebit') . '";');
	eval('$nextmatchbits .= "' . fetch_template('vbsoccer_matches_head') . '";');
	$show['matchinfolnk'] = false;

	$matchinfo['team_home_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$matchinfo['t1_phrase']]);
	$matchinfo['team_away_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$matchinfo['t2_phrase']]);
	$nextmatchbits .= construct_matchbit($leagueinfo, $matchinfo, $canbet, true);

	// tipps anderer benutzer
	if ($GLOBALS['vbulletin']->userinfo['userid'] AND (
		(TIMENOW < $matchinfo['dateline'] AND $GLOBALS['vbulletin']->options['vbsoccer_betspymode'] == 1) OR
		(TIMENOW > $matchinfo['dateline'] AND $GLOBALS['vbulletin']->options['vbsoccer_betspymode'] == 2) OR
		$GLOBALS['vbulletin']->options['vbsoccer_betspymode'] == 3 OR
		$GLOBALS['vbulletin']->options['vbsoccer_betforecast'] == 1
		))
	{
		$userbetList = array();
		$selectSql = $joinSql = $whereSql = $orderSql = "";

		if ($GLOBALS['vbulletin']->options['vbsoccer_betspymode'] != 0)
		{
			$selectSql = "u.`userid`, u.`username`, b.`bet_home`, b.`bet_away`, CONCAT_WS(':', `bet_home`, `bet_away`) AS userbet, ";
			$joinSql = " INNER JOIN  `" . TABLE_PREFIX . "user` AS u USING(userid)";
			$orderSql = " ORDER BY u.`username`";
		}

		$userbets = $GLOBALS['vbulletin']->db->query_read("
			SELECT " . $selectSql . "b.`bet_score_key`
			FROM  `" . TABLE_PREFIX . "soccer_user_bet` AS b" . $joinSql . "
			WHERE b.`match_id`=" . $GLOBALS['vbulletin']->GPC['matchid'] .
				" AND b.`userid`!=" . $GLOBALS['vbulletin']->userinfo['userid']
			. $whereSql . $orderSql . "
			");

		$count = 0;
		$scoreKeyCounter = array(1 => 0, 2 => 0, 3 => 0);

		while (($userbet = $GLOBALS['vbulletin']->db->fetch_array($userbets)))
		{
			if ($GLOBALS['vbulletin']->options['vbsoccer_betforecast'])
			{
				$count++;
				$scoreKeyCounter[(int) $userbet['bet_score_key']]++;
			}

			if (TIMENOW > $matchinfo['dateline'])
			{
				// abgeschlossenes oder laufendes spiel mit anzeige eingefaerbter
				// tipps je nach erreichter punktezahl
				if ($GLOBALS['vbulletin']->options['vbsoccer_betspymode'] > 1)
				{
					$matchinfo['bet_score_key'] = $userbet['bet_score_key'];
					$matchinfo['bet_home']      = $userbet['bet_home'];
					$matchinfo['bet_away']      = $userbet['bet_away'];

					$pointkey   = soccer_fetch_pointkey($matchinfo);
					$pointcolor = $GLOBALS['vbsoccerprefs']['color'][$pointkey];

					$userbetList[] = '<a href="member.php?' . $GLOBALS['vbulletin']->session->vars['sessionurl'] . 'u=' . $userbet['userid'] . '">' . $userbet['username'] . '</a> <span style="color:' . $pointcolor . ';">' . $userbet['userbet'] . '</span>';
				}
			}
			else
			{
				// tipps des offenen spiels ohne einfaerbung der tipps
				if ($GLOBALS['vbulletin']->options['vbsoccer_betspymode'] == 1 OR
					$GLOBALS['vbulletin']->options['vbsoccer_betspymode'] == 3)
				{
					$userbetList[] = '<a href="member.php?' . $GLOBALS['vbulletin']->session->vars['sessionurl'] . 'u=' . $userbet['userid'] . '">' . $userbet['username'] . '</a> ' . $userbet['userbet'];
				}
			}
		}

		$GLOBALS['vbulletin']->db->free_result($userbets);

		if (!empty($userbetList))
		{
			$show['userbetlistcount'] = count($userbetList);
			$show['userbetlist']      = implode(', ', $userbetList);
			unset($userbetList);
		}

		if ($GLOBALS['vbulletin']->options['vbsoccer_betforecast'] AND (TIMENOW < $matchinfo['dateline']))
		{
			if (array_sum($scoreKeyCounter) > 0)
			{
				$maxCount = max($scoreKeyCounter);
				$bethints = construct_phrase($GLOBALS['vbphrase']['soccer_betforecast_summary'],
											 $matchinfo['team_home_name'],
											 ($scoreKeyCounter[1] > 0 ? ($scoreKeyCounter[1] == $maxCount ? '<b>'. $scoreKeyCounter[1] .'</b>' : $scoreKeyCounter[1]) : '-'),
											 ($scoreKeyCounter[2] > 0 ? ($scoreKeyCounter[2] == $maxCount ? '<b>'. $scoreKeyCounter[2] .'</b>' : $scoreKeyCounter[2]) : '-'),
											 $matchinfo['team_away_name'],
											 ($scoreKeyCounter[3] > 0 ? ($scoreKeyCounter[3] == $maxCount ? '<b>'. $scoreKeyCounter[3] .'</b>' : $scoreKeyCounter[3]) : '-'));
			}
		}
	}

	$matchinfos = array();

	if (!empty($matchids))
	{
		$matchinfodetails = $GLOBALS['vbulletin']->db->query_read_slave("
			SELECT m.*, m.id AS matchid,
				CONCAT('soccer_team_', t1.`sd_id`) AS t1_phrase,
				CONCAT('soccer_team_', t2.`sd_id`) AS t2_phrase,
				t1.sd_homepage AS `team_home_homepage`, t2.sd_homepage AS `team_away_homepage`,
				t1.`logo` AS `team_home_logo`,
				t2.`logo` AS `team_away_logo`,
				t1.`logo_size_html` AS `team_home_logo_size_html`,
				t2.`logo_size_html` AS `team_away_logo_size_html`,
				t1.`sd_homepage` AS `team_home_homepage`,
				t2.`sd_homepage` AS `team_away_homepage`,
				IF(m.`points_home`=-1, '-', m.`points_home`) AS `team_home_goals`,
				IF(m.`points_away`=-1, '-', m.`points_away`) AS `team_away_goals`,
				IFNULL(b.`bet_home`, '') AS `bet_home`,
				IFNULL(b.`bet_away`, '') AS `bet_away`,
				b.bet_score_key, m.score_key
			FROM `" . TABLE_PREFIX . "soccer_match` AS m
			INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t1 ON (m.`team_home_id`=t1.`id`)
			INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t2 ON (m.`team_away_id`=t2.`id`)
			LEFT  JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.id = b.match_id AND b.userid=" . $GLOBALS['vbulletin']->userinfo['userid'] . ")
			WHERE m.id IN(" . implode(',', $matchids) . ")
			");

		while (($matchinfodetail = $GLOBALS['vbulletin']->db->fetch_array($matchinfodetails)))
		{
			$matchinfodetail['team_home_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$matchinfodetail['t1_phrase']]);
			$matchinfodetail['team_away_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$matchinfodetail['t2_phrase']]);
			$matchinfos[$matchinfodetail['matchid']] = $matchinfodetail;
		}

		$GLOBALS['vbulletin']->db->free_result($matchinfodetails);
	}

	$show['leaguehortname'] = true;
	$show['matchinfolnk']   = true;

	$foundmatches = false;
	// $homestatsbits
	// die letzten x abgeschlossenen begegnungen von team 1
	// $matches[$matchinfo['team_home_id']]
	if (!empty($matches[$matchinfo['team_home_id']]))
	{
		$homestatstitle = construct_phrase($GLOBALS['vbphrase']['soccer_last_x_matches_from_y'], count($matches[$matchinfo['team_home_id']]), $matchinfo['team_home_name']);
		$homestatsbits = '';
		foreach ($matches[$matchinfo['team_home_id']] AS $match)
		{
			$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$matchinfos[$match['id']]['league_id']];
			$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
			$homestatsbits .= construct_matchbit($leagueinfo, $matchinfos[$match['id']], $canbet, true);
			$foundmatches = true;
		}
	}
	else
	{
		$homestatstitle = construct_phrase($GLOBALS['vbphrase']['soccer_last_matches_from_x'], $matchinfo['team_home_name']);
		eval('$homestatsbits = "' . fetch_template('vbsoccer_stats_nomatches') . '";');
	}

	// $awaystatsbits
	// die letzten x abgeschlossenen begegnungen von team 2
	// $matches[$matchinfo['team_away_id']]
	if (!empty($matches[$matchinfo['team_away_id']]))
	{
		$awaystatstitle = construct_phrase($GLOBALS['vbphrase']['soccer_last_x_matches_from_y'], count($matches[$matchinfo['team_away_id']]), $matchinfo['team_away_name']);
		$awaystatsbits = '';
		foreach ($matches[$matchinfo['team_away_id']] AS $match)
		{
			$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$matchinfos[$match['id']]['league_id']];
			$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
			$awaystatsbits .= construct_matchbit($leagueinfo, $matchinfos[$match['id']], $canbet, true);
			$foundmatches = true;
		}
	}
	else
	{
		$awaystatstitle = construct_phrase($GLOBALS['vbphrase']['soccer_last_matches_from_x'], $matchinfo['team_away_name']);
		eval('$awaystatsbits = "' . fetch_template('vbsoccer_stats_nomatches') . '";');
	}

	// $bothstatsbits
	// die letzten x abgeschlossenen begegnungen von team1 vs. team 2
	// $matches['both']
	if (!empty($matches['both']))
	{
		$bothstatstitle = construct_phrase($GLOBALS['vbphrase']['soccer_last_x_matches_from_y_and_z'], count($matches['both']), $matchinfo['team_home_name'], $matchinfo['team_away_name']);
		$bothstatsbits = '';
		foreach ($matches['both'] AS $match)
		{
			$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$matchinfos[$match['id']]['league_id']];
			$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
			$bothstatsbits .= construct_matchbit($leagueinfo, $matchinfos[$match['id']], $canbet, true);
			$foundmatches = true;
		}
	}
	else
	{
		$bothstatstitle = construct_phrase($GLOBALS['vbphrase']['soccer_last_matches_from_x_and_y'], $matchinfo['team_home_name'], $matchinfo['team_away_name']);
		eval('$bothstatsbits = "' . fetch_template('vbsoccer_stats_nomatches') . '";');
	}

	// spaltenueberschrift, wenn mindestens 1 ansetzung gefunden wurde
	$statsmatchheader = '';
	if ($foundmatches)
	{
		eval('$statsmatchheader = "' . fetch_template('vbsoccer_matches_head') . '";');
	}

	$headtitle = construct_phrase($GLOBALS['vbphrase']['soccer_matchinfo_x_vs_y_on_x'],
								  $matchinfo['team_home_name'],
								  $matchinfo['team_away_name'],
								  vbdate($GLOBALS['vbulletin']->options['dateformat'], $matchinfo['dateline'], true));

	$templatename = 'vbsoccer_matchinfo';
}

// #############################################################################
// anzeige der spiele-vorschau

if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'schedule')
{
	$GLOBALS['vbulletin']->input->clean_gpc('r', 'list', TYPE_STR);

	switch ($GLOBALS['vbulletin']->GPC['list'])
	{
		case 'grouped':
			$vbsoccerprefs['schedstyle'] = 1;
			break;
		case 'kickoff':
			$vbsoccerprefs['schedstyle'] = 0;
			break;
		default:
			unset($GLOBALS['vbulletin']->GPC['list']);
			break;
	}

	$show['sdupdate']     = false;
	$show['reportlink']   = true;
	$show['matchinfolnk'] = true;

	if (!empty($GLOBALS['vbulletin']->options['vbsoccer_previewdays'])
		AND !empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['current']))
	{
		$headtitle = construct_phrase($GLOBALS['vbphrase']['soccer_schedule_previewdays_x'],
									  $GLOBALS['vbulletin']->options['vbsoccer_previewdays']);

		$show['match_result'] = false;

		$hideleagues = fetch_invisible_leagues();

		$matches = $GLOBALS['vbulletin']->db->query_read_slave("
			SELECT
				m.`dateline`, m.`league_id`, m.`match_day`, m.id AS matchid,
				m.match_is_finished,
				t1.`logo` AS `team_home_logo`,
				t2.`logo` AS `team_away_logo`,
				t1.`logo_size_html` AS `team_home_logo_size_html`,
				t2.`logo_size_html` AS `team_away_logo_size_html`,
				t1.`sd_homepage` AS `team_home_homepage`,
				t2.`sd_homepage` AS `team_away_homepage`,
				CONCAT('soccer_team_', t1.`sd_id`) AS t1_phrase,
				CONCAT('soccer_team_', t2.`sd_id`) AS t2_phrase,
				IFNULL(b.bet_home, '') AS bet_home, IFNULL(b.bet_away, '') AS bet_away
			FROM `" . TABLE_PREFIX . "soccer_match` AS m
			INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t1 ON (m.`team_home_id`=t1.`id`)
			INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t2 ON (m.`team_away_id`=t2.`id`)
			INNER JOIN `" . TABLE_PREFIX . "soccer_league_team` AS lt1 ON (m.`team_home_id` = lt1.`team_id` AND m.`league_id` = lt1.`league_id`)
			INNER JOIN `" . TABLE_PREFIX . "soccer_league_team` AS lt2 ON (m.`team_away_id` = lt2.`team_id` AND m.`league_id` = lt2.`league_id`)
			LEFT  JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.id = b.match_id AND b.userid=" . $GLOBALS['vbulletin']->userinfo['userid'] . ")
			WHERE m.league_id IN(" . implode(',', $GLOBALS['vbulletin']->vbsoccer_leaguecache['current']) . ")
				" . ((!empty($hideleagues) ? "AND m.league_id NOT IN(" . implode(',', $hideleagues) . ")" : "")) . "
				AND m.`dateline` > " . TIMENOW . "
				AND DATEDIFF(FROM_UNIXTIME(m.`dateline`), NOW()) BETWEEN 0 AND " . $GLOBALS['vbulletin']->options['vbsoccer_previewdays'] . "
			ORDER BY m.`dateline`;
			");

		$colspan = 4;

		if (!$GLOBALS['vbulletin']->db->num_rows($matches))
		{
			// keine spiele in den kommenden xx tagen
			$show['nomatches'] = construct_phrase($GLOBALS['vbphrase']['soccer_schedule_nomatches_previewdays_x'], $GLOBALS['vbulletin']->options['vbsoccer_previewdays']);
		}
		else
		{
			$leaguematchinfo = $legacymatchinfo = array();

			while (($matchinfo = $GLOBALS['vbulletin']->db->fetch_array($matches)))
			{
				$matchinfo['team_home_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$matchinfo['t1_phrase']]);
				$matchinfo['team_away_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$matchinfo['t2_phrase']]);

				if ($vbsoccerprefs['schedstyle'] == 1)
				{
					$leaguematchinfo[$matchinfo['league_id']][] = $matchinfo;
				}
				else
				{
					$legacymatchinfo[] = $matchinfo;
				}
			}

			$GLOBALS['vbulletin']->db->free_result($matches);

			unset($matches, $matchinfo);

			$matchbits = '';
			$matchbetbit = '';
			$show['allowbet'] = $canbet = false;

			if ($GLOBALS['vbulletin']->userinfo['userid'] AND ($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canbet']))
			{
				$canbet = true;
			}

			if ($vbsoccerprefs['schedstyle'] == 1)
			{
				$show['leaguehortname'] = false;
				foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'] AS $leagueid)
				{
					if (isset($leaguematchinfo[$leagueid]))
					{
						$leagueinfo =& $GLOBALS['vbulletin']->vbsoccer_leaguecache[$leagueid];
						$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
						$leagueicon = fetch_soccer_leagueicon($leagueinfo);
						eval('$matchbits .= "' . fetch_template('vbsoccer_leaguebit') . '";');

						if (empty($matcheshead))
						{
							// spaltenueberschrift nur einmal unterhalb der ersten liga
							eval('$matchbits .= "' . fetch_template('vbsoccer_matches_head') . '";');
							$matcheshead = true;
						}

						foreach ($leaguematchinfo[$leagueid] AS $id => $matchinfo)
						{
							$matchbits .= construct_matchbit($leagueinfo, $matchinfo, $canbet);
						}

						unset($leaguematchinfo[$leagueid]);

						// link fuer datenaktualisierung anzeigen?
						$show['sdupdate'] = ($GLOBALS['vbulletin']->userinfo['userid'] AND (TIMENOW - 120) < $leagueinfo['last_cronjob_timestamp'] ? false : true);

						if ($leagueinfo['sd_lastupdate'] == 0)
						{
							$GLOBALS['vbphrase']['soccer_last_update_on'] = $GLOBALS['vbphrase']['soccer_last_update_never'];
						}
						else
						{
							$GLOBALS['vbphrase']['soccer_last_update_on'] = construct_phrase($GLOBALS['vbphrase']['soccer_last_update_on_x'],
																				  vbdate($GLOBALS['vbulletin']->options['dateformat'], $leagueinfo['sd_lastupdate'], true),
																				  vbdate($GLOBALS['vbulletin']->options['timeformat'], $leagueinfo['sd_lastupdate'])
																				  );
						}

						$lfootcolspan = ($canbet AND $show['allowbet']) ? $colspan - 1 : $colspan;
						eval('$matchbits .= "' . fetch_template('vbsoccer_leaguefooter') . '";');
					}
				} // end foreach
			}
			else
			{
				$colspan = 5;
				$show['leaguehortname'] = true;
				eval('$matchbits .= "' . fetch_template('vbsoccer_matches_head') . '";');
				foreach ($legacymatchinfo AS $matchinfo)
				{
					$leagueinfo =& $GLOBALS['vbulletin']->vbsoccer_leaguecache[$matchinfo['league_id']];
					$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
					$matchbits .= construct_matchbit($leagueinfo, $matchinfo, $canbet);
				}
				unset($legacymatchinfo);
				$lfootcolspan = ($GLOBALS['vbulletin']->userinfo['userid'] AND $canbet AND $show['allowbet']) ? $colspan - 1 : $colspan;
				eval('$matchbits .= "' . fetch_template('vbsoccer_leaguefooter') . '";');
			}
		}
	}
	else
	{
		$headtitle = $GLOBALS['vbphrase']['soccer_note'];

		if (empty($GLOBALS['vbulletin']->options['vbsoccer_previewdays']))
		{
			$show['nomatches'] = $GLOBALS['vbphrase']['soccer_schedule_preview_disabled'];
		}
		else
		{
			$show['nomatches'] = $GLOBALS['vbphrase']['soccer_no_leagues_enabled'];
		}
	}

	$templatename = 'vbsoccer_schedule';
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'hall_of_fame')
{
	// permissions check
	if (!$GLOBALS['vbulletin']->userinfo['userid'])
	{
		print_no_permission();
	}

	$result = $GLOBALS['vbulletin']->db->query_read("
		SELECT `id`, `x_ranking`, `sd_saison`
		FROM `" . TABLE_PREFIX . "soccer_league`
		WHERE `visible`!=0
		ORDER BY `sd_saison` DESC, `displayorder`
		");

	$rankingusers = array();
	$ltype = array();
	$lcache = array();

	while (($row = $GLOBALS['vbulletin']->db->fetch_array($result)))
	{
		if ($row['x_ranking'] == '')
		{
			$serialized_ranks = construct_saison_rankings($row['id']);

			$GLOBALS['vbulletin']->db->query_write("
				UPDATE `" . TABLE_PREFIX . "soccer_league`
				SET `x_ranking`='" . $GLOBALS['db']->escape_string($serialized_ranks) . "'
				WHERE `id`=" . $row['id'] . "
				");

			$row['x_ranking'] = $serialized_ranks;
		}

		$x_ranking = unserialize($row['x_ranking']);

		if (empty($x_ranking))
		{
			continue;
		}

		$ltype[$row['sd_saison']][$row['id']] = $row['id'];

		foreach ($x_ranking AS $data)
		{
			foreach ($data AS $uids)
			{
				foreach ($uids AS $uid)
				{
					$rankingusers[$uid] = $uid;
				}
			}
		}

		$lcache[$row['id']]['x_ranking'] = $x_ranking;
	}

	$GLOBALS['db']->free_result($result);

	if (!empty($rankingusers))
	{
		$result = $GLOBALS['vbulletin']->db->query_read("
			SELECT `userid`, `username`
			FROM `" . TABLE_PREFIX . "user`
			WHERE `userid` IN(" . implode(',', $rankingusers) . ")
			");

		while (($row = $GLOBALS['vbulletin']->db->fetch_array($result)))
		{
			$rankingusers[$row['userid']] = $row['username'];
		}

		$GLOBALS['db']->free_result($result);

		$oldsaison = '';
		$halloffame_bits = '';

		foreach ($lcache AS $id => &$values)
		{
			$values['sd_saison'] = $vbulletin->vbsoccer_leaguecache[$id]['sd_saison'];

			if (!isset($ltype[$values['sd_saison']]))
			{
				continue;
			}

			if ($oldsaison == $values['sd_saison'])
			{
				continue;
			}

			eval('$halloffame_bits .= "' . fetch_template('vbsoccer_halloffamesaisonbit') . '";');

			foreach ($ltype[$values['sd_saison']] as $i)
			{
				unset($ltype[$values['sd_saison']][$i]);

				$show['league_name'] = $vbphrase[$vbulletin->vbsoccer_leaguecache[$i]['phrase']];
				$show['region'] = $vbulletin->vbsoccer_leaguecache[$i]['region'];
				$region = strtolower($show['region']);

				foreach (range(1, 3) AS $pos)
				{
					$show['pos' . $pos . 'users'] = array();
					$show['pos' . $pos . 'pts']   = '';

					if (isset($lcache[$i]['x_ranking'][$pos]))
					{
						foreach ($lcache[$i]['x_ranking'][$pos] AS $_points => $_users)
						{
							$show['pos' . $pos . 'pts'] = $_points;
							foreach ($_users as $u)
							{
								if (isset($rankingusers[$u]))
								{
									$rankuser = $rankingusers[$u];

									if ($GLOBALS['vbulletin']->userinfo['userid'] == $u)
									{
										$rankuser = '<span class="highlight">' . $rankingusers[$u] . '</span>';
									}

									$show['pos' . $pos . 'users'][] = '<a href="member.php?' . $GLOBALS['vbulletin']->session->vars['sessionurl'] . 'u=' . $u . '">' . $rankuser . '</a>';
								}
								else
								{
									$show['pos' . $pos . 'users'][] = htmlspecialchars_uni($GLOBALS['vbphrase']['soccer_deleted_user']);
								}
							}
						}

						$show['pos' . $pos . 'users'] = implode(', ', $show['pos' . $pos . 'users']);
					}
					else
					{
						$show['pos' . $pos . 'users'] = '-';
					}
				}
				eval('$halloffame_bits  .= "' . fetch_template('vbsoccer_halloffamebit') . '";');
			}
			$oldsaison = $values['sd_saison'];
		}
	}

	$headtitle = $GLOBALS['vbphrase']['soccer_nav_halloffame'];
	$templatename = 'vbsoccer_halloffame';
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'ranking')
{
	if (!$GLOBALS['vbulletin']->userinfo['userid'])
	{
		print_no_permission();
	}

	// ranglisten
	$GLOBALS['vbulletin']->input->clean_array_gpc('r', array(
		'm'          => TYPE_UINT,
		'pagenumber' => TYPE_UINT,
		));

	$perpage = $GLOBALS['vbulletin']->GPC['perpage'];
	$pagenumber = $GLOBALS['vbulletin']->GPC['pagenumber'];

	if (empty($GLOBALS['vbulletin']->GPC['l']))
	{
		// aufruf aus main-menue ohne angabe einer liga
		if (!empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['current']))
		{
			// die erste aktuelle saison auswaehlen
			reset($GLOBALS['vbulletin']->vbsoccer_leaguecache['current']);
			$GLOBALS['vbulletin']->GPC['l'] = key($GLOBALS['vbulletin']->vbsoccer_leaguecache['current']);
		}
		elseif (!empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv']))
		{
			reset($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv']);
			$GLOBALS['vbulletin']->GPC['l'] = key($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv']);
		}
		else
		{
			// eek... tippspiel scheint leer zu sein
			standard_error(fetch_error('invalidid', 'league', $GLOBALS['vbulletin']->options['contactuslink']));
		}
	}

	$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$GLOBALS['vbulletin']->GPC['l']];
	$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);

	$league_jump = construct_soccer_league_jump($GLOBALS['vbulletin']->GPC['l']);
	$leagueaction_jump = construct_leagueaction_jump($_REQUEST['do']);
	$show['notsubscribed'] = false;
	$show['latestranking'] = empty($GLOBALS['vbulletin']->GPC['m']);

	$matchday_jump = construct_soccer_matchdayjump($GLOBALS['vbulletin']->GPC['m']);
	$GLOBALS['vbulletin']->GPC['m'] = (int) $currentmatchday;
	$matchday = $GLOBALS['vbulletin']->GPC['m'];

	fetch_soccer_prevnext_matchday($GLOBALS['vbulletin']->GPC['m']);

	// link fuer datenaktualisierung anzeigen?
	$show['sdupdate'] = ($GLOBALS['vbulletin']->userinfo['userid'] AND (TIMENOW - 120) < $leagueinfo['last_cronjob_timestamp'] ? false : true);

	if ($leagueinfo['sd_lastupdate'] == 0)
	{
		$GLOBALS['vbphrase']['soccer_last_update_on'] = $GLOBALS['vbphrase']['soccer_last_update_never'];
	}
	else
	{
		$GLOBALS['vbphrase']['soccer_last_update_on'] = construct_phrase($GLOBALS['vbphrase']['soccer_last_update_on_x'],
															  vbdate($GLOBALS['vbulletin']->options['dateformat'], $leagueinfo['sd_lastupdate'], true),
															  vbdate($GLOBALS['vbulletin']->options['timeformat'], $leagueinfo['sd_lastupdate'])
															  );
	}

	$groupby_sql = $where_sql = $select_sql = '';

	if (in_array(strtolower($leagueinfo['sd_shortname']), array('wm', 'em', 'chl', 'eul')))
	{
		// spieltagsauswahl ausblenden bei WM, EM und CHL
		// hier immer die komplette rangliste anzeigen
		$matchday_jump = "";
		$groupby_sql .= " GROUP BY DATE_FORMAT(FROM_UNIXTIME(m.`dateline`), '%Y%m%d'), b.`userid`";
		$select_sql  .= ", DATE_FORMAT(FROM_UNIXTIME(m.`dateline`), '%Y%m%d') AS `mdate`";

		$lastmatch_date = $GLOBALS['vbulletin']->db->query_first("
			SELECT MAX(DATE_FORMAT(FROM_UNIXTIME(`dateline`), '%Y%m%d')) AS `mdate`
			FROM `" . TABLE_PREFIX . "soccer_match`
			WHERE `league_id`=" . $leagueinfo['id'] . " AND `score_key`>0
			");
	}
	else
	{
		$groupby_sql .= " GROUP BY `match_day`, b.`userid`";
		if (!$show['latestranking'])
		{
			$where_sql .= " AND `match_day` <= " . $matchday . "";
		}
	}

	// es ist richtig, hier keine usernamen aus der usertabelle abzuholen!
	// siehe kommentar unter $rankingusers_result zur nutzung des query-caches
	// in verbindung mit der usertabelle!
	$rankingresults = $GLOBALS['vbulletin']->db->query_read_slave("
		SELECT
			b.`userid`" . $select_sql . ", `match_day`,
			COUNT(*) AS `bets`,
			SUM(`score_key`>0) AS 'evaluated',
			SUM(`score_key`>0 AND `score_key` != `bet_score_key`) AS 'wr',
			SUM(`score_key`>0 AND `bet_home`=`points_home` AND `bet_away`=`points_away`) AS 'rr',
			SUM(`score_key`>0 AND CAST(`bet_home`-`bet_away` AS SIGNED)=(`points_home`-`points_away`) AND NOT (`bet_home`=`points_home` AND `bet_away`=`points_away`)) AS 'rd'
		FROM `" . TABLE_PREFIX . "soccer_user_bet` b
		INNER JOIN `" . TABLE_PREFIX . "soccer_match` m ON (m.`id`=b.`match_id`)
		WHERE m.`league_id`=" . $leagueinfo['id'] . $where_sql . $groupby_sql . "
		");

	$rankingdata     = array();
	$prevrankingdata = array();
	$sortarray       = array();

	while (($rankingresult = $GLOBALS['vbulletin']->db->fetch_array($rankingresults)))
	{
		// anzahl der gewerteten tipps
		if (!isset($rankingdata[$rankingresult['userid']]['evaluated']))
		{
			$rankingdata[$rankingresult['userid']]['evaluated'] = 0;
		}
		$rankingdata[$rankingresult['userid']]['evaluated'] += $rankingresult['evaluated'];

		// anzahl abgegebene tipps
		if (!isset($rankingdata[$rankingresult['userid']]['bets']))
		{
			$rankingdata[$rankingresult['userid']]['bets'] = 0;
		}
		$rankingdata[$rankingresult['userid']]['bets'] += $rankingresult['bets'];

		$rankingresult['rw'] = $rankingresult['evaluated'] - $rankingresult['wr'] - $rankingresult['rr'] - $rankingresult['rd'];

		$rankingdata[$rankingresult['userid']]['wr'] += $rankingresult['wr'];
		$rankingdata[$rankingresult['userid']]['rr'] += $rankingresult['rr'];
		$rankingdata[$rankingresult['userid']]['rd'] += $rankingresult['rd'];
		$rankingdata[$rankingresult['userid']]['rw'] += $rankingresult['rw'];

		$points = ($rankingresult['wr'] * $GLOBALS['vbulletin']->options['vbsoccer_points']['wr'])
				+ ($rankingresult['rr'] * $GLOBALS['vbulletin']->options['vbsoccer_points']['rr'])
				+ ($rankingresult['rd'] * $GLOBALS['vbulletin']->options['vbsoccer_points']['rd'])
				+ ($rankingresult['rw'] * $GLOBALS['vbulletin']->options['vbsoccer_points']['rw']);
		$rankingdata[$rankingresult['userid']]['points'] += $points;

		if (!isset($rankingresult['mdate']))
		{
			if ($rankingresult['match_day'] < $matchday)
			{
				$rankingdata[$rankingresult['userid']]['prevpoints'] += $points;
				$prevrankingdata[$rankingresult['userid']] += $points;
			}
		}
		else
		{
			if ($rankingresult['mdate'] < $lastmatch_date['mdate'])
			{
				$rankingdata[$rankingresult['userid']]['prevpoints'] += $points;
				$prevrankingdata[$rankingresult['userid']] += $points;
			}
		}

		$rankingdata[$rankingresult['userid']]['userid'] = (int) $rankingresult['userid'];
		$sortarray[$rankingresult['userid']] = (int) $rankingdata[$rankingresult['userid']]['points'];

	}

	$GLOBALS['vbulletin']->db->free_result($rankingresults);

	$rankingusers = array();
	if (!empty($rankingdata))
	{
		// hier die usernamen der tipper abholen. ein join der usertabelle beim
		// auslesen der tipps wuerde die nutzung des mysql-query-caches verhindern
		// weil die usertabelle mit jedem klick aktualisiert und damit der cache
		// erneuert wird.
		$rankingusers_result = $GLOBALS['vbulletin']->db->query_read("
			SELECT `userid`, `username`
			FROM `" . TABLE_PREFIX . "user`
			WHERE `userid` IN(" . implode(',', array_keys($rankingdata)) . ")
			");

		while (($rankinguser = $GLOBALS['vbulletin']->db->fetch_array($rankingusers_result)))
		{
			$rankingusers[$rankinguser['userid']] = $rankinguser['username'];
		}

		$GLOBALS['vbulletin']->db->free_result($rankingusers_result);
	}

	array_multisort($sortarray, SORT_NUMERIC, SORT_DESC, $rankingdata);
	unset($sortarray);
	arsort($prevrankingdata);

	$totalrankings = count($rankingdata);
	sanitize_pageresults($totalrankings, $pagenumber, $perpage, 100, $GLOBALS['vbulletin']->options['vbsoccer_rankingusersperpage']);

	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = ($pagenumber) * $perpage;
	$counter = 0;

	if ($limitupper > $totalrankings)
	{
		$limitupper = $totalrankings;
		if ($limitlower > $totalrankings)
		{
			$limitlower = $totalrankings - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $totalrankings, 'vbsoccer.php?' . $GLOBALS['vbulletin']->session->vars['sessionurl'], 'do=ranking'
		. ((!empty($matchday) AND $matchday_jump != '' AND !$show['latestranking']) ? "&amp;m=$matchday" : "")
		. (!empty($GLOBALS['vbulletin']->GPC['l']) ? "&amp;l=" . $GLOBALS['vbulletin']->GPC['l'] : "")
	);


	$prevrankings = array();

	$rank = $counter = 0;

	foreach ($prevrankingdata AS $userid => $points)
	{
		$counter++;
		if (!isset($oldpoints) OR $oldpoints != $points)
		{
			$rank = $counter;
		}

		$oldpoints = $points;
		$prevrankings[$userid] = $rank;
		$oldrank = $rank;
	}

	$colspan = 10;
	$leagueicon = fetch_soccer_leagueicon($leagueinfo);
	eval('$rankingbits  = "' . fetch_template('vbsoccer_leaguebit') . '";');

	if (!empty($rankingdata))
	{
		// kopfzeile
		$GLOBALS['vbphrase']['rr_head'] = construct_phrase($GLOBALS['vbphrase']['soccer_x_points_abbr'], $GLOBALS['vbulletin']->options['vbsoccer_points']['rr']);
		$GLOBALS['vbphrase']['rd_head'] = construct_phrase($GLOBALS['vbphrase']['soccer_x_points_abbr'], $GLOBALS['vbulletin']->options['vbsoccer_points']['rd']);
		$GLOBALS['vbphrase']['rw_head'] = construct_phrase($GLOBALS['vbphrase']['soccer_x_points_abbr'], $GLOBALS['vbulletin']->options['vbsoccer_points']['rw']);
		$GLOBALS['vbphrase']['wr_head'] = construct_phrase($GLOBALS['vbphrase']['soccer_x_points_abbr'], $GLOBALS['vbulletin']->options['vbsoccer_points']['wr']);
		eval('$rankingbits  .= "' . fetch_template('vbsoccer_rankinghead') . '";');
	}
	$rank = $counter = 0;
	$userposition = array();

	foreach ($rankingdata AS $position => $betuser)
	{
		$counter++;
		if (!isset($oldpoints) OR $oldpoints != $betuser['points'])
		{
			$rank = $counter;
		}
		$oldpoints = $betuser['points'];

		if ($GLOBALS['vbulletin']->userinfo['userid'] == $betuser['userid'])
		{
			$userposition['rank']   = $rank;
			$userposition['page']   = ceil($counter / $perpage);
			$userposition['points'] = $betuser['points'];
		}

		if ($counter < $limitlower)
		{
			continue;
		}

		if ($counter > $limitupper)
		{
			if (!$GLOBALS['vbulletin']->userinfo['userid']
				OR !empty($userposition))
			{
				break;
			}
			else
			{
				continue;
			}
		}

		$rankarrow = $rankdiff = '';

		if (isset($prevrankings[$betuser['userid']]))
		{
			$oldrank = $prevrankings[$betuser['userid']];
			if ($oldrank != $rank)
			{
				$rankdiff = abs($oldrank - $rank);
				$rankarrow = ($oldrank < $rank) ? 'darr.png' : 'uarr.png';
			}
			$daypoints = $betuser['points'] - $prevrankingdata[$betuser['userid']];
			$daypoints = ($daypoints == 0) ? '-' : sprintf('%+d', $daypoints);
		}
		else
		{
			$oldrank = 0;
			$daypoints = ($betuser['points'] == 0) ? '-' : sprintf('%+d', $betuser['points']);
		}

		if (isset($rankingusers[$betuser['userid']]))
		{
			$betuser['username'] = $rankingusers[$betuser['userid']];
			$betuser['realuserid'] = $betuser['userid'];
		}
		else
		{
			$betuser['username'] = htmlspecialchars_uni($GLOBALS['vbphrase']['soccer_deleted_user']);
			$betuser['realuserid'] = 0;
		}
		$nobetpointscount = 0;
		foreach (array('wr', 'rw', 'rd', 'rr') AS $x)
		{
			if (empty($betuser[$x]))
			{
				$betuser[$x] = '-';
				$nobetpointscount++;
			}
		}

		if ($nobetpointscount == 4)
		{
			$betuser['points'] = '-';
			$show['noranking'] = true;
		}
		else
		{
			$show['noranking'] = false;
		}
		eval('$rankingbits  .= "' . fetch_template('vbsoccer_rankingbit') . '";');
	}

	unset($rankingdata);
	$show['userranking'] = false;

	if (!empty($userposition))
	{
		if ($userposition['page'] != $pagenumber)
		{
			$show['userranking'] = true;
			$userposition['pagelink'] = 'vbsoccer.php?'
				. $GLOBALS['vbulletin']->session->vars['sessionurl']
				. 'do=ranking'
				. ((!empty($matchday) AND $matchday_jump != '' AND !$show['latestranking']) ? "&amp;m=$matchday" : "")
				. (!empty($GLOBALS['vbulletin']->GPC['l']) ? "&amp;l=" . $GLOBALS['vbulletin']->GPC['l'] : "")
				. (!empty($userposition['page']) ? "&amp;page=" . $userposition['page'] : "");
		}
	}

	$headtitle = construct_phrase($GLOBALS['vbphrase']['soccer_ranking_league_x'], $leagueinfo['league_name']);
	$templatename = 'vbsoccer_ranking';
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'bet')
{
	$GLOBALS['vbulletin']->input->clean_gpc('r', 'm', TYPE_UINT);
	$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$GLOBALS['vbulletin']->GPC['l']];
	$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
	$show['reportlink']   = true;
	$show['matchinfolnk'] = true;
	$league_jump = construct_soccer_league_jump($GLOBALS['vbulletin']->GPC['l']);
	$leagueaction_jump = construct_leagueaction_jump($_REQUEST['do']);

	$matchday_jump = construct_soccer_matchdayjump($GLOBALS['vbulletin']->GPC['m']);
	$GLOBALS['vbulletin']->GPC['m'] = (int) $currentmatchday;
	$matchday = $GLOBALS['vbulletin']->GPC['m'];

	fetch_soccer_prevnext_matchday($GLOBALS['vbulletin']->GPC['m']);

	$show['sdupdate'] = ($GLOBALS['vbulletin']->userinfo['userid'] AND (TIMENOW - 120) < $leagueinfo['last_cronjob_timestamp'] ? false : true);

	if ($leagueinfo['sd_lastupdate'] == 0)
	{
		$GLOBALS['vbphrase']['soccer_last_update_on'] = $GLOBALS['vbphrase']['soccer_last_update_never'];
	}
	else
	{
		$GLOBALS['vbphrase']['soccer_last_update_on'] = construct_phrase($GLOBALS['vbphrase']['soccer_last_update_on_x'],
															  vbdate($GLOBALS['vbulletin']->options['dateformat'], $leagueinfo['sd_lastupdate'], true),
															  vbdate($GLOBALS['vbulletin']->options['timeformat'], $leagueinfo['sd_lastupdate'])
															  );
	}

	// gewaehlter spieltag + spiele aus vorhergehenden spieltagen ohne abschluss
	$condition = " AND m.`match_day`=" . $GLOBALS['vbulletin']->GPC['m'] . "";

	if ($leagueinfo['mdp'] != '')
	{
		// in gruppen und phrasen aufteilen 'gruppen;phrasen'
		$matchdaypagesplit = explode(';', $leagueinfo['mdp']);
		$daygroups         = explode(',', $matchdaypagesplit[0]);
		$dayphrases        = explode(',', $matchdaypagesplit[1]);

		foreach ($daygroups AS $group => $days)
		{
			$minmax = explode('-', $days);
			$minmaxrange = range($minmax[0], $minmax[1]);
			if (in_array($GLOBALS['vbulletin']->GPC['m'], $minmaxrange))
			{
				$show['matchdaygroups'] = true;
				$condition = " AND m.`match_day` IN(". implode(',', $minmaxrange) .")";
				break;
			}
		}
	}

	$colspan = 5;
	$templatename = 'vbsoccer_bet';

	$headtitle = construct_phrase($GLOBALS['vbphrase']['soccer_league_x_matchday_y'],
								  $leagueinfo['league_name'],
								  (empty($show['matchdaygroups'])
								   ? htmlspecialchars_uni($matchdayinfos[$GLOBALS['vbulletin']->GPC['m']]['matchdayname'])
								   : htmlspecialchars_uni($matchdayinfos[$GLOBALS['vbulletin']->GPC['m']]['matchgroupname'])
								   )
								  );

	$show['match_result'] = true;

	$matches = $GLOBALS['vbulletin']->db->query_read("
		SELECT
			m.`dateline`, m.`league_id`, m.`match_day`, m.`id` AS `matchid`,
			m.`match_is_finished`,
			t1.`logo` AS `team_home_logo`,
			t2.`logo` AS `team_away_logo`,
			t1.`logo_size_html` AS `team_home_logo_size_html`,
			t2.`logo_size_html` AS `team_away_logo_size_html`,
			t1.`sd_homepage` AS `team_home_homepage`,
			t2.`sd_homepage` AS `team_away_homepage`,
			IF(t1.custom_shortname!='', t1.custom_shortname, t1.sd_shortname) AS team_home_shortname,
			IF(t2.custom_shortname!='', t2.custom_shortname, t2.sd_shortname) AS team_away_shortname,
			CONCAT('soccer_team_', t1.`sd_id`) AS `t1_phrase`,
			CONCAT('soccer_team_', t2.`sd_id`) AS `t2_phrase`,
			IF(m.`points_home`=-1, '-', m.`points_home`) AS `team_home_goals`,
			IF(m.`points_away`=-1, '-', m.`points_away`) AS `team_away_goals`,
			IFNULL(b.`bet_home`, '') AS `bet_home`,
			IFNULL(b.`bet_away`, '') AS `bet_away`,
			b.`bet_score_key`, m.`score_key`
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t1 ON (m.`team_home_id`=t1.`id`)
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t2 ON (m.`team_away_id`=t2.`id`)
		INNER JOIN `" . TABLE_PREFIX . "soccer_league_team` AS lt1 ON (m.`team_home_id`=lt1.`team_id` AND m.`league_id`=lt1.`league_id`)
		INNER JOIN `" . TABLE_PREFIX . "soccer_league_team` AS lt2 ON (m.`team_away_id`=lt2.`team_id` AND m.`league_id`=lt2.`league_id`)
		LEFT  JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.`id`=b.`match_id` AND b.`userid`=" . $GLOBALS['vbulletin']->userinfo['userid'] . ")
		WHERE m.`league_id`=" . $GLOBALS['vbulletin']->GPC['l'] . " " . $condition . "
		ORDER BY ". (!empty($show['matchdaygroups']) ? "m.`match_day`, " : "") . "m.`dateline`
		");

	$matchdata = $postp_matches = $match_ids = array();

	while (($match = $GLOBALS['vbulletin']->db->fetch_array($matches)))
	{
		$match['team_home_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$match['t1_phrase']]);
		$match['team_away_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$match['t2_phrase']]);

		$matchdata[$match['match_day']][] = $match;
		// matchids fuer ermittlung aller usertipps
		$match_ids[] = $match['matchid'];
	}

	$GLOBALS['vbulletin']->db->free_result($matches);
	unset($matches, $match);

	$leagueicon = fetch_soccer_leagueicon($leagueinfo);
	eval('$matchbits = "' . fetch_template('vbsoccer_leaguebit') . '";');

	$matchbetbit = '';
	$show['allowbet'] = $canbet = false;
	$matchday_points = 0;

	if ($GLOBALS['vbulletin']->userinfo['userid'] AND $GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canbet'])
	{
		$canbet = true;
	}

	if (!empty($show['matchdaygroups']))
	{
		if (!empty($_GET['m']))
		{
			$show['idhash'] = $matchday;
		}
	}

	foreach ($matchdata AS $md => $matchinfos)
	{
		if (!empty($show['matchdaygroups']))
		{
			$matchgrouptitle = $matchdayinfos[$md]['matchdayname'];
			eval('$matchbits .= "' . fetch_template('vbsoccer_matchgroupbit') . '";');
		}

		// spaltenueberschrift nur einmal unterhalb der ersten liga
		if (empty($matcheshead))
		{
			eval('$matchbits .= "' . fetch_template('vbsoccer_matches_head') . '";');
			$matcheshead = true;
		}

		foreach ($matchinfos AS $matchinfo)
		{
			$matchbits .= construct_matchbit($leagueinfo, $matchinfo, $canbet, true);
		}
	}

	unset($matchdata, $matchinfos, $matchinfo);
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'live')
{
	$hideleagues = fetch_invisible_leagues();

	$matches = $vbulletin->db->query_read_slave("
		SELECT
			m.*, m.`id` AS `matchid`,
			t1.`logo` AS `team_home_logo`,
			t2.`logo` AS `team_away_logo`,
			t1.`logo_size_html` AS `team_home_logo_size_html`,
			t2.`logo_size_html` AS `team_away_logo_size_html`,
			t1.`sd_homepage` AS `team_home_homepage`,
			t2.`sd_homepage` AS `team_away_homepage`,
			CONCAT('soccer_team_', t1.`sd_id`) AS `t1_phrase`,
			CONCAT('soccer_team_', t2.`sd_id`) AS `t2_phrase`,
			IF(m.`points_home`=-1, '-', m.`points_home`) AS `team_home_goals`,
			IF(m.`points_away`=-1, '-', m.`points_away`) AS `team_away_goals`
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t1 ON (m.`team_home_id` = t1.`id`)
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS t2 ON (m.`team_away_id` = t2.`id`)
		WHERE m.`dateline` BETWEEN " . (TIMENOW - 14400) . " AND " . (TIMENOW + 28800) . "
		" . ((!empty($hideleagues) ? " AND m.`league_id` NOT IN(" . implode(',', $hideleagues) . ")" : "")) . "
		ORDER BY `dateline`
		");

	$colspan = 5;
	$matchbits = '';
	$showform = $canpostresults = false;
	$show['refresh'] = true;
	$show['reportlink'] = true;

	if ($GLOBALS['vbulletin']->userinfo['userid'] AND ($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canpostresults']))
	{
		$canpostresults = true;
	}

	$logmatches = array(); // hier informationen zu den spielen fuer logausgabe

	while (($matchinfo = $GLOBALS['vbulletin']->db->fetch_array($matches)))
	{
		if (!isset($GLOBALS['vbulletin']->vbsoccer_leaguecache[$matchinfo['league_id']]))
		{
			continue;
		}

		$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$matchinfo['league_id']];
		$leagueinfo['league_name']   = fetch_soccer_leaguename($leagueinfo);

		$matchinfo['kickoffdate']    = vbdate($GLOBALS['vbulletin']->options['dateformat'], $matchinfo['dateline'], true);
		$matchinfo['kickofftime']    = vbdate($GLOBALS['vbulletin']->options['timeformat'], $matchinfo['dateline']);
		$matchinfo['team_home_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$matchinfo['t1_phrase']]);
		$matchinfo['team_away_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$matchinfo['t2_phrase']]);

		if ($canpostresults AND (TIMENOW > $matchinfo['dateline'])
			AND in_array($matchinfo['match_is_finished'], array(0, 2)))
		{
			$showform = true;
			$finchecked = ($matchinfo['match_is_finished'] == 2) ? ' checked="checked"' : '';
			$matchinfo['fin'] = !empty($finchecked) ? 1 : 0;
			$findisabled = (TIMENOW > ($matchinfo['dateline'] + (105 * 60)) ? '' : ' disabled="disabled"');

			// ergebnis bei spielen ohne ergebnis ('-') auf leeren string setzen
			// fuer die eingabe- und kontrollfelder
			$matchinfo['result_home'] = ($matchinfo['team_home_goals'] == '-') ? '' : $matchinfo['team_home_goals'];
			$matchinfo['result_away'] = ($matchinfo['team_away_goals'] == '-') ? '' : $matchinfo['team_away_goals'];

			eval('$matchresult = "' . fetch_template('vbsoccer_resultinput') . '";');
		}
		else
		{
			$matchresult = $matchinfo['team_home_goals'] . ':' . $matchinfo['team_away_goals'];
		}
		$show['matchinfolnk'] = true;
		switch (true)
		{
			case ($matchinfo['dateline'] <= TIMENOW):
				if ($matchinfo['match_is_finished'] == 1)
				{
					$matchstatusicon = 'done.png';
				}
				else
				{
					$matchstatusicon = 'hourglass.png';
				}
				break;
			case ($matchinfo['dateline'] > TIMENOW):
				// spiel hat noch nicht begonnen
				$matchstatusicon = 'scheduled.png';
				break;
			default:
				$matchstatusicon = 'scheduled.png';
				break;
		}

		// teamnamen fuer logausgabe zwischenspeichern
		$logmatches[$matchinfo['matchid']]['t1'] = $matchinfo['team_home_name'];
		$logmatches[$matchinfo['matchid']]['t2'] = $matchinfo['team_away_name'];

		eval('$matchbits .= "' . fetch_template('vbsoccer_livebit') . '";');
	} // end while

	$GLOBALS['vbulletin']->db->free_result($matches);

	if (!empty($logmatches) AND $canpostresults)
	{
		$resultlogbits = '';
		$show['resultlogs'] = true;

		// log anzeigen (sichtbar nur fuer user mit berechtigung zum eintragen!)
		$resultlogs = $GLOBALS['vbulletin']->db->query_read("
			SELECT l.*, u.`username`
			FROM `" . TABLE_PREFIX . "soccer_postresult_log` AS l
			LEFT JOIN `" . TABLE_PREFIX . "user` AS u USING(`userid`)
			WHERE `match_id` IN(" . implode(',', array_keys($logmatches)) . ")
				AND `result` != '-1:-1'
			ORDER BY `dateline` DESC
			LIMIT 25
			");

		while (($logdata = $GLOBALS['vbulletin']->db->fetch_array($resultlogs)))
		{
			if ($logdata['userid'] == 0)
			{
				$logdata['musername'] = htmlspecialchars_uni($GLOBALS['vbphrase']['soccer_dataservice_nick']);
			}
			else
			{
				$logdata['musername'] = htmlspecialchars_uni($logdata['username']);
			}
			$logdata['team_home'] = $logmatches[$logdata['match_id']]['t1'];
			$logdata['team_away'] = $logmatches[$logdata['match_id']]['t2'];
			$logdata['result']    = htmlspecialchars_uni($logdata['result']);
			$logdata['logdate']   = vbdate($GLOBALS['vbulletin']->options['dateformat'], $logdata['dateline'], true);
			$logdata['logtime']   = vbdate($GLOBALS['vbulletin']->options['timeformat'], $logdata['dateline']);

			eval('$resultlogbits .= "' . fetch_template('vbsoccer_resultlogbit') . '";');
		}

		$GLOBALS['vbulletin']->db->free_result($resultlogs);
	}

	if ($showform)
	{
		include DIR . '/includes/functions_bigthree.php';

		$datecut = TIMENOW - $GLOBALS['vbulletin']->options['cookietimeout'];
		$browsers = '';

		$show['activeusers'] = iif(!$show['search_engine'], true, false);

		// Don't put the inthread value in the WHERE clause as it might not be the newest location!
		$liveusers = $GLOBALS['vbulletin']->db->query_read_slave("
			SELECT user.username, user.usergroupid, user.membergroupids,
				session.userid, session.location, session.lastactivity, session.badlocation,
				IF(user.displaygroupid = 0, user.usergroupid, user.displaygroupid) AS displaygroupid, infractiongroupid,
				IF(user.options & " . $GLOBALS['vbulletin']->bf_misc_useroptions['invisible'] . ", 1, 0) AS invisible
			FROM " . TABLE_PREFIX . "session AS session
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = session.userid)
			WHERE session.lastactivity > $datecut
			ORDER BY lastactivity DESC
		");

		$numberguest = 0;
		$numberregistered = 0;
		$doneuser = array();

		if ($GLOBALS['vbulletin']->userinfo['userid']) // fakes the user being in this thread
		{
			$loggedin = array(
				'userid'        => $GLOBALS['vbulletin']->userinfo['userid'],
				'username'      => $GLOBALS['vbulletin']->userinfo['username'],
				'invisible'     => $GLOBALS['vbulletin']->userinfo['invisible'],
				'invisiblemark' => $GLOBALS['vbulletin']->userinfo['invisiblemark'],
				'location'      => '/vbsoccer.php?do=live',
				'lastactivity'  => TIMENOW,
				'musername'     => $GLOBALS['vbulletin']->userinfo['musername'],
			);
			$numberregistered = 1;
			$numbervisible = 1;
			fetch_online_status($loggedin);

			$show['comma_leader'] = false;
			eval('$activeusers = "' . fetch_template('forumdisplay_loggedinuser') . '";');
			$doneuser["{$GLOBALS['vbulletin']->userinfo['userid']}"] = 1;
		}

		// this requires the query to have lastactivity ordered by DESC so that the latest location will be the first encountered.
		while (($loggedin = $GLOBALS['vbulletin']->db->fetch_array($liveusers)))
		{
			if ($loggedin['badlocation'])
			{
				continue;
			}

			if (empty($doneuser["$loggedin[userid]"]))
			{
				if (strpos($loggedin['location'], 'vbsoccer.php?do=live') !== false)
				{
					if ($loggedin['userid'] == 0) // Guest
					{
						$numberguest++;
					}
					else
					{
						fetch_musername($loggedin);
						$numberregistered++;

						if (fetch_online_status($loggedin))
						{
							$show['comma_leader'] = ($activeusers != '');
							eval('$activeusers .= "' . fetch_template('forumdisplay_loggedinuser') . '";');
						}
					}
				}
				if ($loggedin['userid'])
				{
					$doneuser["$loggedin[userid]"] = 1;
				}
			}
		}

		if (!$GLOBALS['vbulletin']->userinfo['userid'])
		{
			$numberguest = ($numberguest == 0) ? 1 : $numberguest;
			if ($numberregistered == 0)
			{
				$activeusers = '&nbsp;';
			}
		}
		$totalonline = $numberregistered + $numberguest;

		$GLOBALS['vbulletin']->db->free_result($liveusers);
		unset($userinfos, $userid, $userinfo, $loggedin, $threadusers, $datecut);
	}

	$headtitle = $GLOBALS['vbphrase']['soccer_live'];
	$templatename = 'vbsoccer_live';
}

// #############################################################################
if (isset($_REQUEST['do']) AND ($_REQUEST['do'] == 'tab' OR $_REQUEST['do'] == 'crosstab'))
{
	$GLOBALS['vbulletin']->input->clean_array_gpc('r',
		array('m'    => TYPE_UINT,   // optional
			  'type' => TYPE_NOHTML, // optional
			  ));

	if ($_REQUEST['do'] == 'crosstab')
	{
		$GLOBALS['vbulletin']->GPC['type'] = 'cross';
	}

	$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$GLOBALS['vbulletin']->GPC['l']];
	$leagueinfo['league_name'] = fetch_soccer_leaguename($leagueinfo);
	$show['sdupdate'] = ($GLOBALS['vbulletin']->userinfo['userid'] AND (TIMENOW - 120) < $leagueinfo['last_cronjob_timestamp'] ? false : true);

	if ($leagueinfo['sd_lastupdate'] == 0)
	{
		$GLOBALS['vbphrase']['soccer_last_update_on'] = $GLOBALS['vbphrase']['soccer_last_update_never'];
	}
	else
	{
		$GLOBALS['vbphrase']['soccer_last_update_on'] = construct_phrase($GLOBALS['vbphrase']['soccer_last_update_on_x'],
															  vbdate($GLOBALS['vbulletin']->options['dateformat'], $leagueinfo['sd_lastupdate'], true),
															  vbdate($GLOBALS['vbulletin']->options['timeformat'], $leagueinfo['sd_lastupdate'])
															  );
	}

	$league_jump  = construct_soccer_league_jump($GLOBALS['vbulletin']->GPC['l'], 'tab');
	$leagueaction_jump = construct_leagueaction_jump($_REQUEST['do']);

	$leagueicon   = fetch_soccer_leagueicon($leagueinfo);
	$colspan      = 3;

	$tabletype    = $GLOBALS['vbulletin']->GPC['type'];

	if (empty($leagueinfo['showtable']))
	{
		standard_error(fetch_error('soccer_league_showtable_disabled'));
	}

	if (in_array($leagueinfo['sd_shortname'], array('WM', 'EM', 'CHL', 'EUL')))
	{
		$tabletype = strtolower($leagueinfo['sd_shortname']);
	}

	if (!in_array($tabletype, array('cross', 'wm', 'em', 'chl', 'eul')))
	{
		$matchday_jump = construct_soccer_matchdayjump($GLOBALS['vbulletin']->GPC['m']);
		$GLOBALS['vbulletin']->GPC['m'] = (int) $currentmatchday;
		fetch_soccer_prevnext_matchday($GLOBALS['vbulletin']->GPC['m']);
	}

	$matchday = $GLOBALS['vbulletin']->GPC['m'];

	switch ($tabletype)
	{
		case 'wm':
		case 'em':
		case 'chl':
		case 'eul':
			$tabledata = fetch_leaguetable($GLOBALS['vbulletin']->GPC['l'], 0, $tabletype);
			$updownrel = fetch_soccertable_updownrel($leagueinfo, count($tabledata));
			$tablepos = 0;
			$colspan = 8;
			eval('$tabbits  = "' . fetch_template('vbsoccer_leaguebit') . '";');

			foreach ($tabledata AS $team)
			{
				if (empty($currentmatchday) OR $currentmatchday != $team['match_day'])
				{
					$tablepos = 0;

					if (empty($alpha))
					{
						$alpha = range('A', 'Z'); // A = 0! B = 1...
					}

					$matchgrouptitle = construct_phrase($GLOBALS['vbphrase']['soccer_group_alpha_x'], $alpha[($team['match_day']-1)]);
					$md = $team['match_day'];
					eval('$tabbits .= "' . fetch_template('vbsoccer_matchgroupbit') . '";');
					eval('$tabbits .= "' . fetch_template('vbsoccer_tab_standard_head') . '";');
				}

				$class = 'alt1';
				$tablepos++;

				$team['team_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$team['team_phrase']]);

				if (!empty($GLOBALS['vbulletin']->options['vbsoccer_enableteamlinks']))
				{
					$team['team_name_url'] = sprintf('<a href="%s" target="_blank">%s</a>', $team['sd_homepage'], $team['team_name']);
				}
				else
				{
					$team['team_name_url'] = $team['team_name'];
				}

				$team['goal_difference'] = ($team['goal_difference'] != 0 ? sprintf('%+d', $team['goal_difference']) : 0);

				if (isset($updownrel[$tablepos]))
				{
					$class .= ' vbsoccer-' . $updownrel[$tablepos];
				}

				eval('$tabbits .= "' . fetch_template('vbsoccer_tab_standard_bit') . '";');
				$currentmatchday = $team['match_day'];
			}

			unset($team, $tabledata, $updownrel);
			$headtitle = construct_phrase($GLOBALS['vbphrase']['soccer_table_x'], $leagueinfo['league_name']);

			$tabletype = ''; // variable leeren wegen verlinkung in template!
			break;
		case 'cross': // kreuztabelle
			// aktuelle ligatabelle holen
			$tabledata = fetch_leaguetable($GLOBALS['vbulletin']->GPC['l'], 0, $tabletype);

			// alle spielergebnisse holen
			$matches = $GLOBALS['vbulletin']->db->query_read_slave("
				SELECT ma.*, t.logo, t.`logo_size_html`, IF(t.`custom_shortname` != '',
					t.`custom_shortname`, t.`sd_shortname`) AS `shortname`,
					t.`sd_homepage`,
					t.sd_id AS sd_team_id
				FROM
					(SELECT lt.`team_id`,
						CAST(GROUP_CONCAT(m.`team_away_id`) AS CHAR) AS `team_away_list`,
						CAST(GROUP_CONCAT(CONCAT(IF(m.`points_home` != -1, m.`points_home`, '-')), ':',
							(IF(m.`points_away` != -1, m.`points_away`, '-'))) AS CHAR) AS `result_list`
					FROM `" . TABLE_PREFIX . "soccer_league_team` AS lt
					LEFT JOIN `" . TABLE_PREFIX . "soccer_match` m ON (lt.`team_id`=m.`team_home_id` AND m.`league_id`=" . $GLOBALS['vbulletin']->GPC['l'] . ")
					WHERE lt.`league_id`=" . $GLOBALS['vbulletin']->GPC['l'] . "
					GROUP BY lt.`team_id`
					) AS `ma`
				INNER JOIN `" . TABLE_PREFIX . "soccer_team` t ON (ma.`team_id`=t.`id`)
				");

			$leaguematchinfo = array();

			while (($matchinfo = $GLOBALS['vbulletin']->db->fetch_array($matches)))
			{
				// alle team_ids der gegnerischen mannschaften extrahieren
				$team_away_list = explode(',', $matchinfo['team_away_list']);

				// alle ergebnisse extrahieren
				$result_list = explode(',', $matchinfo['result_list']);

				foreach ($team_away_list as $key => $away_team_id)
				{
					$leaguematchinfo[$matchinfo['team_id']][$away_team_id][] = $result_list[$key];
				}

				$tabledata[$matchinfo['team_id']]['shortname'] = $matchinfo['shortname'];
			}

			$GLOBALS['vbulletin']->db->free_result($matches);
			unset($matchinfo);

			$tabbits = '';

			// kreuztabelle fuellen
			$tabcrossheadbits  = '';
			$tabbits_cache = '';
			$colspan = 4; //4 fixe spalten
			foreach($tabledata AS $team)
			{
				// spaltenueberschrift horizontal
				$colspan++; //pro team eine zusaetzliche spalte
				$team['team_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$team['team_phrase']]);
				$team['shortname'] = htmlspecialchars_uni($team['shortname']);

				if (!empty($GLOBALS['vbulletin']->options['vbsoccer_enableteamlinks']))
				{
					$team['team_name_url'] = sprintf('<a href="%s" target="_blank">%s</a>', $team['sd_homepage'], $team['team_name']);
					$team['team_shortname_url'] = sprintf('<a href="%s" target="_blank">%s</a>', $team['sd_homepage'], $team['shortname']);
				}
				else
				{
					$team['team_name_url'] = $team['team_name'];
					$team['team_shortname_url'] = $team['shortname'];
				}

				eval('$tabcrossheadbits  .= "' . fetch_template('vbsoccer_tab_cross_head_bit') . '";');
				$team['goal_difference'] = ($team['goal_difference'] != 0 ? sprintf('%+d', $team['goal_difference']) : 0);

				// ergebnisse pro team vertikal
				$tabcrossresultsbits = '';
				foreach($tabledata AS $result)
				{
					if (array_key_exists($result['team_id'], $leaguematchinfo[$team['team_id']]))
					{
						$tdcontent = implode('<br />', $leaguematchinfo[$team['team_id']][$result['team_id']]);
						$class = 'alt1';
					}
					else
					{
						$class = 'alt2';
						// ein team kann nicht gegen sich selbst spielen
						$tdcontent = '&nbsp;';
					}
					eval('$tabcrossresultsbits  .= "' . fetch_template('vbsoccer_tab_cross_results_bit') . '";');
				}
				$class = 'alt2';
				eval('$tabbits_cache  .= "' . fetch_template('vbsoccer_tab_cross_results') . '";');
			}
			eval('$tabbits  .= "' . fetch_template('vbsoccer_leaguebit') . '";');
			eval('$tabbits  .= "' . fetch_template('vbsoccer_tab_cross_head') . '";');
			$tabbits .= $tabbits_cache;
			unset($tabcrossheadbits, $tabcrossresultsbits, $tabbits_cache);
			$headtitle = construct_phrase($GLOBALS['vbphrase']['soccer_cross_table_x'], $leagueinfo['league_name']);
			break;
		default: // standard-ligatabelle
			$tabledata = fetch_leaguetable($GLOBALS['vbulletin']->GPC['l'], $GLOBALS['vbulletin']->GPC['m'], $tabletype);
			$updownrel = fetch_soccertable_updownrel($leagueinfo, count($tabledata));
			$tablepos = 0;
			$colspan = 8;
			eval('$tabbits  = "' . fetch_template('vbsoccer_leaguebit') . '";');
			eval('$tabbits .= "' . fetch_template('vbsoccer_tab_standard_head') . '";');

			foreach ($tabledata AS $team)
			{
				$class = 'alt1';
				$tablepos++;
				$team['team_name'] = htmlspecialchars_uni($GLOBALS['vbphrase'][$team['team_phrase']]);

				if (!empty($GLOBALS['vbulletin']->options['vbsoccer_enableteamlinks']))
				{
					$team['team_name_url'] = sprintf('<a href="%s" target="_blank">%s</a>', $team['sd_homepage'], $team['team_name']);
				}
				else
				{
					$team['team_name_url'] = $team['team_name'];
				}

				$team['goal_difference'] = ($team['goal_difference'] != 0 ? sprintf('%+d', $team['goal_difference']) : 0);
				if (isset($updownrel[$tablepos]))
				{
					$class .= ' vbsoccer-' . $updownrel[$tablepos];
				}
				eval('$tabbits .= "' . fetch_template('vbsoccer_tab_standard_bit') . '";');
			}

			unset($team, $tabledata, $updownrel);
			$headtitle = construct_phrase($GLOBALS['vbphrase']['soccer_table_x'], $leagueinfo['league_name']);
			break;
	}

	$templatename = 'vbsoccer_tab';
}

// #############################################################################
// ranking der result-poster nur fuer benutzer sichtbar, die selbst die
// berechtigung zum einstellen von ergebnissen haben?
if ($GLOBALS['vbulletin']->userinfo['userid'] AND
	($GLOBALS['permissions']['vbsoccer_general_permissions'] & $vbsoccerperms['canpostresults']) AND
	isset($_REQUEST['do']) AND $_REQUEST['do'] == 'reportranking')
{
	// ranglisten
	$GLOBALS['vbulletin']->input->clean_array_gpc('r',
		array('m'          => TYPE_UINT,
			  'pagenumber' => TYPE_UINT,
			  ));

	$rankingbits = '';
	$perpage     = $GLOBALS['vbulletin']->GPC['perpage'];
	$pagenumber  = $GLOBALS['vbulletin']->GPC['pagenumber'];

	$posters = $GLOBALS['vbulletin']->db->query_first("
		SELECT COUNT(DISTINCT `userid`) `count`
		FROM `" . TABLE_PREFIX . "soccer_postresult_stats`
		WHERE `userid` != 0
		");

	$totalposters = $posters['count'];
	sanitize_pageresults($totalposters, $pagenumber, $perpage, 100, $GLOBALS['vbulletin']->options['vbsoccer_rankingusersperpage']);

	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = ($pagenumber) * $perpage;

	if ($limitupper > $totalposters)
	{
		$limitupper = $totalposters;
		if ($limitlower > $totalposters)
		{
			$limitlower = $totalposters - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $totalposters, 'vbsoccer.php?' . $GLOBALS['vbulletin']->session->vars['sessionurl'], 'do=reportranking');

	$posters = $GLOBALS['vbulletin']->db->query_read("
		SELECT user.username, user.userid, SUM(count) AS `reports`,
			MAX(lastupdate) AS lastreport, COUNT(DISTINCT league_id) AS leagues
		FROM `" . TABLE_PREFIX . "soccer_postresult_stats` stats
		INNER JOIN `" . TABLE_PREFIX . "user` user USING(userid)
		GROUP BY stats.userid
		ORDER BY reports DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
		");

	while (($poster = $GLOBALS['vbulletin']->db->fetch_array($posters)))
	{
		if ($poster['lastreport'] > 0)
		{
			$poster['lastreport_date']      = vbdate($GLOBALS['vbulletin']->options['dateformat'], $poster['lastreport'], true);
			$poster['lastreport_time']      = vbdate($GLOBALS['vbulletin']->options['timeformat'], $poster['lastreport']);
		}
		else
		{
			$poster['lastreport_date'] = $poster['lastreport_time'] = 0;
		}
		$poster['reports'] = vb_number_format($poster['reports']);
		eval('$rankingbits .= "' . fetch_template('vbsoccer_reportrankingbit') . '";');
	} // end while

	$GLOBALS['vbulletin']->db->free_result($posters);
	$headtitle = $GLOBALS['vbphrase']['soccer_reportranking'];
	$templatename = 'vbsoccer_reportranking';
}

// #############################################################################
if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'overallranking')
{
	if (!$GLOBALS['vbulletin']->userinfo['userid'])
	{
		print_no_permission();
	}

	$GLOBALS['vbulletin']->input->clean_array_gpc('r',
		array('year'       => TYPE_UINT,
			  'month'      => TYPE_UINT,
			  'pagenumber' => TYPE_UINT,
			  'sortfield'  => TYPE_STR,
			  'sortorder'  => TYPE_STR,
			  ));

	$perpage    = $GLOBALS['vbulletin']->GPC['perpage'];
	$pagenumber = $GLOBALS['vbulletin']->GPC['pagenumber'];
	$sortfield  = $GLOBALS['vbulletin']->GPC['sortfield'];
	$sortorder  = $GLOBALS['vbulletin']->GPC['sortorder'];

	// per default nach punkten sortieren
	if ($sortfield == '')
	{
		$sortfield = 'pts';
	}

	if ($sortorder == '')
	{
		$sortorder = 'desc';
	}

	// aktuelles jahr ermitteln
	$dt = new DateTime('@' . TIMENOW, new DateTimeZone('UTC'));
	$dt->modify('+' . $GLOBALS['vbulletin']->userinfo['timezoneoffset'] . ' HOURS');

	$curyear  = $dt->format('Y');
	$ymlimit  = $dt->format('Y-m-t 23:59:59');

	if (empty($GLOBALS['vbulletin']->GPC['year']))
	{
		$GLOBALS['vbulletin']->GPC['year'] = $curyear;
	}

	// timestamps
	$dt->setTime(0, 0);

	if (empty($GLOBALS['vbulletin']->GPC['month']))
	{
		// timestamps fuer das komplette jahr
		$dt->setDate($GLOBALS['vbulletin']->GPC['year'], 1, 1);
		$datetime_from = $dt->format('U');
		$dt->modify('+1 year');
		$datetime_to = $dt->format('U');
	}
	else
	{
		// timestamps fuer den kompletten monat
		$dt->setDate($GLOBALS['vbulletin']->GPC['year'], $GLOBALS['vbulletin']->GPC['month'], 1);
		$datetime_from = $dt->format('U');
		$dt->modify('+1 month');
		$datetime_to = $dt->format('U');
	}

	$months = array('january', 'february', 'march', 'april', 'may', 'june',
					'july', 'august', 'september', 'october', 'november', 'december');

	$yearmonths = $GLOBALS['vbulletin']->db->query_read("
		SELECT YEAR(FROM_UNIXTIME(`dateline`)) AS `betyear`,
			CAST(GROUP_CONCAT(DISTINCT MONTH(FROM_UNIXTIME(`dateline`)) ORDER BY `dateline`) AS CHAR) AS `betmonths`
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		INNER JOIN `" . TABLE_PREFIX . "soccer_user_bet` AS b ON (m.`id`=b.`match_id`)
		WHERE `dateline` < UNIX_TIMESTAMP('" . $ymlimit . "')
		GROUP BY YEAR(FROM_UNIXTIME(`dateline`))
		ORDER BY `betyear`
		");

	$yearoptions = '';
	$betmonths   = array();
	$found       = false;

	while (($yearmonth = $GLOBALS['vbulletin']->db->fetch_array($yearmonths)))
	{
		$optiontitle = $yearmonth['betyear'];
		$optionvalue = $yearmonth['betyear'];

		if ($yearmonth['betyear'] == $GLOBALS['vbulletin']->GPC['year'])
		{
			$optionselected = ' selected="selected"';
			$optionclass    = 'fjsel';
			$betmonths      = explode(',', $yearmonth['betmonths']);
			$betmonths      = array_flip($betmonths);
			$found = true;
		}
		else
		{
			$optionselected = '';
			$optionclass    = 'fjdpth0';
		}
		eval('$yearoptions .= "' . fetch_template('option') . '";');
	} // end while

	$GLOBALS['vbulletin']->db->free_result($yearmonths);
	unset($yearmonths, $yearmonth, $ymlimit, $dt);

	if (!$found)
	{
		// keine tipps gefunden, hier einfach das aktuelle jahr anzeigen
		$optiontitle    = $curyear;
		$optionvalue    = $curyear;
		$optionselected = ' selected="selected"';
		$optionclass    = 'fjsel';
		eval('$yearoptions = "' . fetch_template('option') . '";');
	}

	$optiontitle = $GLOBALS['vbphrase']['soccer_all_months'];
	$optionvalue = 0;

	if ($GLOBALS['vbulletin']->GPC['month'])
	{
		$optionselected = '';
		$optionclass = 'fjdpth0';
	}
	else
	{
		$optionclass = 'fjsel';
		$optionselected = ' selected="selected"';
	}
	eval('$monthnav = "' . fetch_template('option') . '";');

	foreach ($months AS $monthnum => &$monthname)
	{
		$optiontitle = $GLOBALS['vbphrase'][$monthname];
		$optionvalue = ($monthnum + 1);
		$optionclass = 'fjdpth0';

		if (isset($betmonths[($monthnum + 1)]))
		{
			// es existieren tipps fuer diesen monat
			if ($GLOBALS['vbulletin']->GPC['month'] == ($monthnum + 1))
			{
				$optionselected = ' selected="selected"';
				$optionclass = 'fjsel';
			}
			else
			{
				$optionselected = '';
			}
		}
		else
		{
			// keine tipps vorhanden
			$optionselected = ' disabled="disabled"';
		}
		eval('$monthnav .= "' . fetch_template('option') . '";');
	} // end foreach

	unset($months, $monthname, $optionselected, $optionclass, $optiontitle);

	$total = $GLOBALS['vbulletin']->db->query_first("
		SELECT COUNT(DISTINCT userid) AS `count`, COUNT(DISTINCT match_id) AS `bets`
		FROM `" . TABLE_PREFIX . "soccer_user_bet` b
		INNER JOIN `" . TABLE_PREFIX . "soccer_match` m ON (m.id=b.match_id)
		WHERE `dateline` BETWEEN " . (int) $datetime_from . " AND " . (int) $datetime_to . " AND `score_key`>0
		");

	$totalusers = $total['count'];
	$betcount['bets'] = $total['bets'];
	sanitize_pageresults($totalusers, $pagenumber, $perpage, 100, $GLOBALS['vbulletin']->options['vbsoccer_rankingusersperpage']);

	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = ($pagenumber) * $perpage;

	if ($limitupper > $totalusers)
	{
		$limitupper = $totalusers;
		if ($limitlower > $totalusers)
		{
			$limitlower = $totalusers - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}

	$sortorder = strtolower($sortorder);

	$secondarysortsql = '';

	switch ($sortfield)
	{
		case 'bets':
			$sqlsort = 'bets';
			$secondarysortsql = ', sum_pts ' . $sortorder . ', avg_pts ' . $sortorder;
			break;
		case 'pts':
		case 'sum_pts':
			$sqlsort = 'sum_pts';
			$secondarysortsql = ', avg_pts ' . $sortorder;
			break;
		case 'avg_pts':
		case 'avgpts':
			$sqlsort = 'avg_pts';
			$secondarysortsql = ', sum_pts ' . $sortorder;
			break;
		case 'wr':
		case 'rw':
		case 'rr':
		case 'rd':
			$sqlsort = $sortfield;
			if ($sortfield == 'wr')
			{
				$secondarysortsql = ', sum_pts ' . ($sortorder == 'desc' ? 'asc' : 'desc') . ', avg_pts ' . ($sortorder == 'desc' ? 'asc' : 'desc');
			}
			else
			{
				$secondarysortsql = ', sum_pts ' . $sortorder . ', avg_pts ' . $sortorder;
			}
			break;
		default:
			$sqlsort = 'sum_pts';
			$secondarysortsql = ', avg_pts ' . $sortorder;
	}

	if ($sortorder != 'asc')
	{
		$sortorder    = 'desc';
		$oppositesort = 'asc';
	}
	else
	{
		$oppositesort = 'desc';
	}

	$action = 'do=overallranking&amp;year=' . $GLOBALS['vbulletin']->GPC['year'];

	$pagenav = construct_page_nav($pagenumber, $perpage, $totalusers, 'vbsoccer.php?' . $GLOBALS['vbulletin']->session->vars['sessionurl'], $action
		. (!empty($GLOBALS['vbulletin']->GPC['month']) ? '&amp;month=' . $GLOBALS['vbulletin']->GPC['month'] : "")
		. (!empty($vbulletin->GPC['perpage']) ? "&amp;pp=$perpage" : "")
		. (!empty($sortorder) ? "&amp;order=$sortorder" : "")
		. (!empty($sortfield) ? "&amp;sort=$sortfield" : "")
		);

	$sorturl = 'vbsoccer.php?' . $vbulletin->session->vars['sessionurl'] . $action
		. (!empty($GLOBALS['vbulletin']->GPC['month']) ? '&amp;month=' . $GLOBALS['vbulletin']->GPC['month'] : "");

	eval('$sortarrow[' . $sortfield . '] = "' . fetch_template('forumdisplay_sortarrow') . '";');

	$users = $GLOBALS['vbulletin']->db->query_read("
		SELECT `userid`, '' AS `username`, `bets`, `wr`, `rd`, (`bets`-`wr`-`rr`-`rd`) AS `rw`, `rr`,
			(`wr`*" . (int) $GLOBALS['vbulletin']->options['vbsoccer_points']['wr'] . ")+
			(`rr`*" . (int) $GLOBALS['vbulletin']->options['vbsoccer_points']['rr'] . ")+
			(`rd`*" . (int) $GLOBALS['vbulletin']->options['vbsoccer_points']['rd'] . ")+
			((`bets`-`wr`-`rr`-`rd`)*" . (int) $GLOBALS['vbulletin']->options['vbsoccer_points']['rw'] . ") AS `sum_pts`,
			((`wr`/`bets`)*" . (int) $GLOBALS['vbulletin']->options['vbsoccer_points']['wr'] . ")+
			((`rr`/`bets`)*" . (int) $GLOBALS['vbulletin']->options['vbsoccer_points']['rr'] . ")+
			((`rd`/`bets`)*" . (int) $GLOBALS['vbulletin']->options['vbsoccer_points']['rd'] . ")+
			(((`bets`-`wr`-`rr`-`rd`)/`bets`)*" . (int) $GLOBALS['vbulletin']->options['vbsoccer_points']['rw'] . ") AS `avg_pts`
		FROM
		(
			SELECT b.`userid`, COUNT(*) AS `bets`,
				SUM(`score_key`!=`bet_score_key`) AS `wr`,
				SUM(`bet_home`=`points_home` AND `bet_away`=`points_away`) AS `rr`,
				SUM(CAST(`bet_home`-`bet_away` AS SIGNED)=(`points_home`-`points_away`)
					AND NOT (`bet_home`=`points_home` AND `bet_away`=`points_away`)) AS `rd`
			FROM `" . TABLE_PREFIX . "soccer_user_bet` AS b
			INNER JOIN `" . TABLE_PREFIX . "soccer_match` AS m ON (m.`id`=b.`match_id`)
			WHERE `dateline` BETWEEN " . (int) $datetime_from . " AND " . (int) $datetime_to . " AND `score_key`>0
			GROUP BY b.`userid`
		) AS `foo`
		ORDER BY $sqlsort $sortorder $secondarysortsql
		LIMIT " . ($limitlower - 1) . ", $perpage
		");

	$rankingbits = '';
	$maxpoints = (int) $GLOBALS['vbulletin']->options['vbsoccer_points']['rr'];
	$betcount['bets'] = vb_number_format($betcount['bets']);

	if ($GLOBALS['vbulletin']->db->num_rows($users) > 0)
	{
		// kopfzeile
		$GLOBALS['vbphrase']['rr_head'] = construct_phrase($GLOBALS['vbphrase']['soccer_x_points_abbr'], $GLOBALS['vbulletin']->options['vbsoccer_points']['rr']);
		$GLOBALS['vbphrase']['rd_head'] = construct_phrase($GLOBALS['vbphrase']['soccer_x_points_abbr'], $GLOBALS['vbulletin']->options['vbsoccer_points']['rd']);
		$GLOBALS['vbphrase']['rw_head'] = construct_phrase($GLOBALS['vbphrase']['soccer_x_points_abbr'], $GLOBALS['vbulletin']->options['vbsoccer_points']['rw']);
		$GLOBALS['vbphrase']['wr_head'] = construct_phrase($GLOBALS['vbphrase']['soccer_x_points_abbr'], $GLOBALS['vbulletin']->options['vbsoccer_points']['wr']);
		eval('$rankingbits  .= "' . fetch_template('vbsoccer_overallrankinghead') . '";');
	}

	$rankingresults = array();

	while (($user = $GLOBALS['vbulletin']->db->fetch_array($users)))
	{
		$rankingresults[$user['userid']] = $user;
	}

	$GLOBALS['vbulletin']->db->free_result($users);
	unset($users, $user);

	if (!empty($rankingresults))
	{
		$rankingusers = $GLOBALS['vbulletin']->db->query_read("
			SELECT userid, username
			FROM " . TABLE_PREFIX . "user
			WHERE userid IN(". implode(',', array_keys($rankingresults)) .")
			");

		while (($user = $GLOBALS['vbulletin']->db->fetch_array($rankingusers)))
		{
			$rankingresults[$user['userid']]['username'] = $user['username'];
		}

		$GLOBALS['vbulletin']->db->free_result($rankingusers);
		unset($rankingusers, $user);
	}

	foreach ($rankingresults AS &$user)
	{
		$user['bets'] = vb_number_format($user['bets']);
		$user['avg_pts_f'] = vb_number_format($user['avg_pts'], 3);
		$user['sum_pts'] = vb_number_format($user['sum_pts']);
		eval('$rankingbits .= "' . fetch_template('vbsoccer_overallrankingbit') . '";');
	}

	unset($rankingresults, $user);

	if ($GLOBALS['vbulletin']->GPC['month'])
	{
		$headtitle = construct_phrase($GLOBALS['vbphrase']['soccer_nav_overallranking_xy'], $GLOBALS['vbulletin']->GPC['year'], sprintf('%02d', $GLOBALS['vbulletin']->GPC['month']));
	}
	else
	{
		$headtitle = construct_phrase($GLOBALS['vbphrase']['soccer_nav_overallranking_x'], $GLOBALS['vbulletin']->GPC['year']);
	}
	$templatename = 'vbsoccer_overallranking';
}

// #############################################################################
if ($templatename != '')
{
	if ((isset($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv'][$GLOBALS['vbulletin']->GPC['l']])
		 OR isset($notsubscribed[$GLOBALS['vbulletin']->GPC['l']]))
		AND (!in_array($_REQUEST['do'], array('ranking', 'overallranking'))))
	{
		// befindet sich eine aufgerufene liga bei irgendeiner aktion im archiv
		// oder ist es ein
		// dann stets den main-menuepunkt 'archiv' aktivieren.
		// ausnahme: ranglisten - hier immer der menuepunkt ranglisten aktiv
		if (isset($notsubscribed[$GLOBALS['vbulletin']->GPC['l']]))
		{
			construct_soccer_nav('notsubscribed');
		}
		else
		{
			construct_soccer_nav('archive');
		}
	}
	else
	{
		// main-menuepunkt bei entsprechender aktion hervorheben. die eintraege
		// der aktuellen saisons werden hier nicht beruecksichtigt.
		construct_soccer_nav($_REQUEST['do']);
	}

	// build navbar
	$navbits_array = array();

	if (!empty($foruminfo['parentid']))
	{
		if (($parentforuminfo = fetch_foruminfo($foruminfo['parentid'])))
		{
			$navbits_array['forumdisplay.php?' . $GLOBALS['vbulletin']->session->vars['sessionurl'] . 'f=' . $parentforuminfo['forumid']] = $parentforuminfo['title'];
		}
		$navbits_array['forumdisplay.php?' . $GLOBALS['vbulletin']->session->vars['sessionurl'] . 'f=' . $foruminfo['forumid']] = $foruminfo['title'];
	}
	else
	{
		$navbits_array[$GLOBALS['vbulletin']->script . $GLOBALS['vbulletin']->session->vars['sessionurl_q']] = $foruminfo['title'];
	}

	$navbits_array[''] = $headtitle;
	$navbits = construct_navbits($navbits_array);

	eval('$ad_location[\'ad_vbsoccer_first\'] = "' . fetch_template('ad_vbsoccer_first') . '";');
	eval('$ad_location[\'ad_vbsoccer_sidebar_start\'] = "' . fetch_template('ad_vbsoccer_sidebar_start') . '";');
	eval('$ad_location[\'ad_vbsoccer_sidebar_end\'] = "' . fetch_template('ad_vbsoccer_sidebar_end') . '";');

	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('$HTML = "' . fetch_template($templatename) . '";');
	eval('print_output("' . fetch_template('vbsoccer_shell') . '");');
}
