<?php
/**
 * vbulletin add-on fussball-tippspiele
 *
 * vbulletin Version 3.7.x, 3.8.x
 * php version 5
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @author  xwing <xwing@geb-team.de>
 * @version SVN: $Id: functions_vbsoccer.php 6809 2010-03-24 21:32:29Z aa $
 */

// fuer den fall, dass keine default-zeitzone in der php.ini angegeben ist:
// achtung, wirft ohne '@' ne reihe meldungen aus, wenn eintrag leer oder nicht
// vorhanden.
if (!($tz = @ini_get('date.timezone')))
{
	if (function_exists('date_default_timezone_set'))
	{
		// default zeitzone des servers ermitteln und setzen
		// achtung, wirft ohne '@' ne reihe meldungen aus.
		$tz = @date_default_timezone_get();
		// zeitzone fuer diese "session" setzen
		@date_default_timezone_set($tz);
	}
}

if (!defined('VBSOCCER_DEFERRED'))
{
	/**
	 * unix-timestamp fuer 2037-12-31 00:00:00.
	 *
	 * dieser zeitstempel wird bei allen spielansetzungen hinterlegt, deren
	 * anstoss entweder nicht bekannt ist oder die auf unbestimmte zeit
	 * verlegt wurden. wird dieser zeitstempel beim anzeigen von ansetzungen
	 * entdeckt, wird kein datum/uhrzeit-string angezeigt sondern ein ueber-
	 * setzbarer string (phrase 'soccer_deferred').
	 */
	define('VBSOCCER_DEFERRED', 2145826800);
}

// "ersatz" fuer ungepatchte php5-versionen < 5.2
if (!class_exists('DateTime'))
{
	/**
	 * bildet benoetigte funktionen der php-internen DateTime-klasse ab
	 *
	 * @package vbsoccer
	 */
	class DateTime
	{
		public $date;
		private $_defaultTimeZone;
		private $_currentTimeZone;

		/**
		 * constructor
		 */
		public function __construct($date='now', $timezone=null)
		{
			$this->_defaultTimeZone = @date_default_timezone_get();
			$this->_currentTimeZone = (!is_null($timezone) ? $timezone->getName() : $this->_defaultTimeZone);

			if (strpos($date, '@') === 0)
			{
				$this->date = substr($date, 1);
			}
			else
			{
				$this->_setTimezone();
				$this->date = strtotime($date);
				$this->_resetTimezone();
			}
		}

		/**
		 * setzt die zeitzone fuer dieses datumsobjekt
		 *
		 * @param string zeitzone
		 * @return true
		 */
		public function setTimeZone($timezone)
		{
			$this->_currentTimeZone = (!is_null($timezone) ? $timezone->getName() : $this->_defaultTimeZone);
			return true;
		}

		/**
		 * liefert aktuellen datetime-string
		 *
		 * @return string datetime
		 */
		private function __getDate()
		{
			return date(DATE_ATOM, $this->date);
		}

		/**
		 * strtotime-funktionen
		 *
		 * @param string $multiplier
		 */
		public function modify($multiplier)
		{
			$this->_setTimezone();
			$this->date = strtotime($this->__getDate() . ' ' . $multiplier);
			$this->_resetTimezone();
		}

		/**
		 *
		 */
		public function format($format)
		{
			$this->_setTimezone();
			$return = date($format, $this->date);
			$this->_resetTimezone();
			return $return;
		}

		/**
		 *
		 */
		public function setTime($hour=0, $minute=0, $second=0)
		{
			$this->_setTimezone();
			$month = date('n', $this->date);
			$day   = date('j', $this->date);
			$year  = date('Y', $this->date);
			$this->date = mktime($hour, $minute, $second, $month, $day, $year);
			$this->_resetTimezone();
		}

		/**
		 *
		 */
		public function setDate($year=0, $month=0, $day=0)
		{
			$this->_setTimezone();
			$hour   = date('H', $this->date);
			$minute = date('i', $this->date);
			$second = date('s', $this->date);
			$this->date = mktime($hour, $minute, $second, $month, $day, $year);
			$this->_resetTimezone();
		}

		/**
		 *
		 */
		private function _setTimezone()
		{
			if ($this->_defaultTimeZone != $this->_currentTimeZone)
			{
				date_default_timezone_set($this->_currentTimeZone);
			}
		}

		/**
		 *
		 */
		private function _resetTimezone()
		{
			if ($this->_defaultTimeZone != $this->_currentTimeZone)
			{
				date_default_timezone_set($this->_defaultTimeZone);
			}
		}
	}

	/**
	 * bildet benoetigte funktionen der php-internen DateTimeZone-klasse ab
	 *
	 * @package vbsoccer
	 */
	class DateTimeZone
	{
		/**
		 *
		 */
		private $_timeZoneName;

		/**
		 *
		 */
		public function __construct($timezone='')
		{
			if (empty($timezone))
			{
				$timezone = @date_default_timezone_get();
			}

			$this->_timeZoneName = $timezone;
		}

		/**
		 *
		 */
		public function getName()
		{
			return $this->_timeZoneName;
		}
	}
}

/**
 * erstellt aus den verfuegbaren ligen eine auswahl-box fuer import (ACP)
 *
 * @author aa <aa@geb-team.de>
 * @param  void
 * @throws Exception 'soccer_service_unavailable' dienst antwortete nicht
 * @throws Exception 'soccer_service_no_data' keine importierbare ligen vorhanden
 * @return string auswahlbox oder hinweistext, wenn keine angebote verfuegbar
 */
function construct_sd_league_chooser()
{
	$code = $leagueoptions = array();
	$leagues = fetch_sd_leagues();

	if (empty($leagues))
	{
		throw new Exception('soccer_service_unavailable', 1);
	}

	$code[] = '<select name="sd_id">';
	$code[] = construct_select_options(array(
		'no_value' => $GLOBALS['vbphrase']['soccer_choose_league']
		), 'no_value', true);

	foreach ($leagues as $league)
	{
		if (isset($GLOBALS['leagueinfo'][$league['id']]))
		{
			continue;
		}

		$leagueoptions[$league['s']][$league['id']] = $league['name'];
	}

	krsort($leagueoptions);

	$code[] = construct_select_options($leagueoptions, '', true);
	$code[] = '</select>';

	if (empty($leagueoptions))
	{
		throw new Exception('soccer_service_no_data', 1);
	}

	return implode("\n", $code);
}

function decode_response_data(&$value, $key, $target_encoding)
{
	static $iconv;
	static $mb_convert_encoding;
	static $keysToConvert;

	if (!$keysToConvert)
	{
		$keysToConvert = array('name', 'sn', 'ln');
	}

	if (in_array($key, $keysToConvert) AND $value != '')
	{
		$iconv_passed = $mb_passed = false;

		if (!$iconv)
		{
			$iconv = function_exists('iconv') ? 1 : -1;
		}

		if ($iconv === 1 AND $encoded_data = iconv('UTF-8', $target_encoding . '//TRANSLIT', $value))
		{
			$iconv_passed = true;
			$value = $encoded_data;
		}

		if (!$mb_convert_encoding)
		{
			$mb_convert_encoding = function_exists('mb_convert_encoding') ? 1 : -1;
		}

		if (!$iconv_passed AND $mb_convert_encoding === 1 AND $encoded_data = @mb_convert_encoding($value, $target_encoding, 'UTF-8'))
		{
			$mb_passed = true;
			$value = $encoded_data;
		}

		if (!$iconv_passed AND !$mb_passed)
		{
			$value = utf8_decode($value);
		}
	}
}

/**
 * wandelt soap-responses in array um
 *
 * der soap-server liefert liga-, spiel- oder teamdaten stets als ein array von
 * objekten oder arrays
 *
 * in jedem fall aber werden alle objekte in arrays umgewandelt und je nach
 * client und verwendetem zeichensatz eine charset-konvertierung vorgenommen.
 *
 * @param mixed $response   rueckgabedaten des soap-servers
 *
 * @param int $requested    id eines bestimmten datensatzes (liga, team, spiel).
 *                          wird ein wert ungleich 0 uebergeben, wird nur der
 *                          datensatz mit dieser id zurueckgegeben und der rest
 *                          verworfen (zb. anfordern der infos fuer eine liga).
 *
 * @return array            angeforderte liga-, spiel- oder teamdaten.
 */
function fetch_response_data($response = array(), $requested = 0)
{
	static $target_encoding;
	static $decode;

	if (!$target_encoding)
	{
		$target_encoding = (strtolower($GLOBALS['stylevar']['charset']) == 'iso-8859-1' ? 'WINDOWS-1252' : $GLOBALS['stylevar']['charset']);

		if ('UTF-8' !== strtoupper($target_encoding))
		{
			$decode = true;
		}
	}

	$return = array();

	if (empty($response) OR !is_array($response))
	{
		return $return;
	}

	$isArrayOfObjects = $isArrayOfArrays = false;

	if (is_object($response[0]))
	{
		$isArrayOfObjects = true;
	}
	else if (is_array($response[0]))
	{
		$isArrayOfArrays = true;
	}

	foreach ($response AS &$data)
	{
		// array mit objekten (native soap-extension)?
		if ($isArrayOfObjects)
		{
			if (empty($data->id))
			{
				// jedes objekt hat eine eigenschaft 'id'. hier ist was sauer!
				continue;
			}

			if ($requested != 0 AND (int) $data->id != (int) $requested)
			{
				// nicht angeforderten datensatz ignorieren!
				continue;
			}

			// typecasting object -> array
			$return[$data->id] = (array) $data;

			if ($decode)
			{
				// alle werte im array dekodieren
				array_walk($return[$data->id], 'decode_response_data', $target_encoding);
				$return[$data->id] = $return[$data->id];
			}
		}
		// mehrdimensionales array (pear-soap)?
		elseif ($isArrayOfArrays)
		{
			if (empty($data['id']))
			{
				// jedes array hat einen schluessel 'id'. hier ist was sauer!
				continue;
			}

			if ($requested != 0 and (int) $data['id'] != (int) $requested)
			{
				// nicht angeforderten datensatz ignorieren!
				continue;
			}

			if ($decode)
			{
				// array-werte dekodieren
				array_walk($data, 'decode_response_data', $target_encoding);
			}

			$return[$data['id']] = $data;
		}
	}

	if ($requested != 0 and isset($return[$requested]))
	{
		// nur den angeforderten datensatz zurueckgeben!
		return $return[$requested];
	}

	return $return;
}

/**
 * information zu verfuegbaren ligen abholen
 *
 * @param int $leagueid (optional) id der liga im datendienst
 * @return array ligainformation
 */
function fetch_sd_leagues($leagueid=0)
{
	try
	{
		$client = soccerDataClient();
		return fetch_response_data($client->getLeagues($leagueid), $leagueid);
	}
	catch (Exception $e)
	{
		if ((defined('VB_AREA') AND VB_AREA == 'AdminCP') OR
			(defined('IN_CONTROL_PANEL') AND IN_CONTROL_PANEL === true))
		{
			printf('EXCEPTION: %s', $e->getMessage());
			exit;
		}

		return array();
	}
}

/**
 * letzte aenderung an ligen im datendienst ermitteln
 *
 * funktion liefert ein array mit id und zeitstempel der letzten datenaenderung.
 *
 * @param array $leagues (optional) ids der liga im datendienst
 * @return array ligainformation
 */
function fetch_sd_changed_leagues($leagues=array())
{
	if (!empty($leagues) AND is_array($leagues))
	{
		$sleagues = serialize($leagues);
	}
	else
	{
		$sleagues = 0;
	}

	try
	{
		$client = soccerDataClient();
		return fetch_response_data($client->getChangedLeagues($sleagues));
	}
	catch (Exception $e)
	{
		return array();
	}
}

/**
 * holt alle teamdaten einer angegebenen liga ab
 *
 * @param int $leagueid id der liga im datendienst
 * @return array teamdaten
 */
function fetch_sd_teamdata($leagueid=0)
{
	try
	{
		$client = soccerDataClient();
		return fetch_response_data($client->getTeams($leagueid));
	}
	catch (Exception $e)
	{
		return array();
	}
}

/**
 * holt alle spieldaten einer angegebenen liga vom datendienst ab
 *
 * @param int $leagueid id der liga im datendienst
 * @return array spielansetzungen der liga
 */
function fetch_sd_matchdata($leagueid=0)
{
	try
	{
		$client = soccerDataClient();
		return fetch_response_data($client->getLeagueMatches($leagueid));
	}
	catch (Exception $e)
	{
		return array();
	}
}

function fetch_sd_TeamIcon($id=0)
{
	try
	{
		$client = soccerDataClient();
		return fetch_response_data($client->getTeamIcon($id));
	}
	catch (Exception $e)
	{
		return '';
	}
}

function fetch_sd_LeagueIcon($id=0)
{
	try
	{
		$client = soccerDataClient();
		return fetch_response_data($client->getLeagueIcon($id));
	}
	catch (Exception $e)
	{
		return '';
	}
}

/**
 * Erstellt ein XML-RPC-Client-Objekt
 *
 * @param     void
 * @return    object vBSoccer_XMLRPC_Client
 */
function soccerDataClient()
{
	static $called;

	if (isset($GLOBALS['vbSoccerClient']) AND is_object($GLOBALS['vbSoccerClient']))
	{
		return $GLOBALS['vbSoccerClient'];
	}

	if (!$called)
	{
		require_once DIR . '/includes/class_xmlrpc_vbsoccer.php';
		$called = true;
	}

	$GLOBALS['vbSoccerClient'] = new vBSoccer_XMLRPC_Client($GLOBALS['vbulletin']);
	return $GLOBALS['vbSoccerClient'];
}

/**
 * liefert htmlcode fuer eine spielansetzung mit optionaler tipp-abgabe
 *
 * @global array phrasen
 * @global array diverse variablen fuer darstellung in templates
 * @global string name der css-klasse fuer darstellung
 * @param  array $leagueinfo ligainformationen
 * @param  array $matchinfo  spielinformationen
 * @param  bool  $canbet     berechtigung zum abgeben von tipps durch benutzer
 * @param  bool  $showpoints anzeige von erzielten punkten
 * @return string html-code fuer eine ansetzung
 * @since 0.1.0 alpha 9
 */
function construct_matchbit($leagueinfo, $matchinfo, $canbet=false, $showpoints=false)
{
	global $vbphrase, $show, $mainfontclass;
	static $tabindexcount;
	/**
	 * summe aller erreichten punkte fuer einen spieltag
	 *
	 * @global int $GLOBALS['matchday_points']
	 * @name $matchday_points
	 */
	if (!isset($GLOBALS['matchday_points']))
	{
		$GLOBALS['matchday_points'] = 0;
	}

	// anstoss datum/zeit
	if ($matchinfo['dateline'] == VBSOCCER_DEFERRED)
	{
		if ($matchinfo['match_is_finished'] == 1)
		{
			// spiel ist verschoben *und* abgepfiffen: findet nicht mehr statt!
			// spiel einfach ausblenden
			return '';
		}
		$matchinfo['kickoffdate'] = $matchinfo['kickofftime'] = false;
	}
	else
	{
		$matchinfo['kickoffdate'] = vbdate($GLOBALS['vbulletin']->options['dateformat'], $matchinfo['dateline'], true);

		if (preg_match('/1$/', $matchinfo['dateline']))
		{
			$matchinfo['kickofftime'] = false;
		}
		else
		{
			$matchinfo['kickofftime'] = vbdate($GLOBALS['vbulletin']->options['timeformat'], $matchinfo['dateline']);
		}
	}

	if ($GLOBALS['vbulletin']->userinfo['userid'] AND $canbet AND TIMENOW < $matchinfo['dateline'] AND
		(isset($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'][$matchinfo['league_id']])
		 AND empty($leagueinfo['readonly'])) )
	{
		// eingabefelder fuer tippabgabe
		$show['allowbet'] = true;

		if (empty($tabindexcount))
		{
			$tabindexcount = 5000;
		}

		$matchinfo['tabindex_home'] = ++$tabindexcount;
		$matchinfo['tabindex_away'] = ++$tabindexcount;

		eval('$matchbetbit = "' . fetch_template('vbsoccer_betinput') . '";');
	}
	else
	{
		// anzeige des abgegebenen tipps oder '-:-' wenn kein tipp abgegeben
		if ($matchinfo['bet_home'] == '' OR $matchinfo['bet_away'] == '')
		{
			$matchinfo['bet_home'] = $matchinfo['bet_away'] = '-';
		}

		if ($showpoints)
		{
			// erreichte punkte anzeigen (nur auf tippseite)
			$pointkey = soccer_fetch_pointkey($matchinfo);
			$points = (isset($GLOBALS['vbulletin']->options['vbsoccer_points'][$pointkey])
					   ? (int) $GLOBALS['vbulletin']->options['vbsoccer_points'][$pointkey] : 0);
			$GLOBALS['matchday_points'] += $points;
			$pointcolor = $GLOBALS['vbsoccerprefs']['color'][$pointkey];
		}

		eval('$matchbetbit = "' . fetch_template('vbsoccer_betbit') . '";');
	}

	switch (true)
	{
		case ($matchinfo['dateline'] <= TIMENOW):
			if ($matchinfo['match_is_finished'] == 1)
			{
				$matchstatusicon = 'done.png';
			}
			else
			{
				$matchstatusicon = 'hourglass.png';
			}
			break;
		case ($matchinfo['dateline'] > TIMENOW):
			$matchstatusicon = 'scheduled.png';
			break;
		default:
			$matchstatusicon = 'scheduled.png';
			break;
	}

	eval('$matchbit = "' . fetch_template('vbsoccer_matchbit') . '";');
	return $matchbit;
}

/**
 * erzeugen eines 'gewinnschluessel'-strings
 *
 * @param array $data spiel- und tippdaten eines spiels fuer einen user
 * @return string 'nb': nicht getippt oder spiel ist noch nicht angepfiffen
 *                'wr': falscher tipp
 *                'rw': auf richtigen gewinner getippt
 *                'rd': richtiger gewinner und richtiges torverhaeltnis
 *                'rr': korrekter tipp
 */
function soccer_fetch_pointkey($data=array())
{
	$key = 'wr';

	if ($data['team_home_goals'] == '-' OR $data['team_away_goals'] == '-')
	{
		// spiel hat kein ergebnis
		return 'nb';
	}

	if (($data['bet_home'] == '-' OR $data['bet_away'] == '-') OR
		($data['bet_home'] == '' OR $data['bet_away'] == ''))
	{
		// spiel wurde nicht getippt
		return 'nb';
	}

	if ((int) $data['score_key'] == (int) $data['bet_score_key'])
	{
		// spielausgang ist richtig (score_keys von spiel und tipp identisch)
		$key = 'rw';

		if (((int) $data['bet_home'] - (int) $data['bet_away'] == (int) $data['team_home_goals'] - (int) $data['team_away_goals']))
		{
			// tordifferenz ist richtig
			$key = 'rd';
		}

		if (((int) $data['bet_home'] == (int) $data['team_home_goals']) AND
			((int) $data['bet_away'] == (int) $data['team_away_goals']))
		{
			// ergebnis ist identisch mit tipp
			$key = 'rr';
		}
	}

	return $key;
}

/**
 * ermitteln aller geaenderten wettbewerbe
 *
 * @param array sd_ids von ausgesuchten ligen/wettbewerben
 * @return array zeitstempel der angeforderten ligen/wettbewerbe
 *               (sd_id => timestamp)
 */
function soccer_fetch_changed_leagues($leagues=array())
{
	// aktionen ausfuehren, auch wenn benutzer den vorgang abbricht oder die
	// seite schliesst etc...
	@ignore_user_abort(true);

	// abfrage des datendienstes
	$leaguedata = fetch_sd_changed_leagues($leagues);
	$retval = array();

	foreach ($leaguedata AS $id => $obj)
	{
		$retval[$obj['id']] = $obj['lu'];
	}

	return $retval;
}

/**
 * holt aktuelle spieldaten vom datendienst ab
 *
 * @param bool $ignoretimestamp aufruf nicht nur alle 2 minuten erlauben
 * @param array $leagueinfo liga-daten
 * @return bool wenn aktion erfolgreich true, sonst false
 */
function soccer_update_fixtures($ignoretimestamp=false, $leagueinfo=array())
{
	static $sd2vbsoccer_map;
	static $sdLeagueMap;

	$retval = false;

	if (empty($leagueinfo) OR !is_array($leagueinfo))
	{
		return $retval;
	}

	// per default nur alle 2 minuten aktualisierung zulassen, damit nicht
	// irgendein irrer staendig auf den datendienst einpruegelt.
	if ($ignoretimestamp === false)
	{
		if ((TIMENOW - 120) < $leagueinfo['last_cronjob_timestamp'])
		{
			return $retval;
		}
	}

	// aktionen ausfuehren, auch wenn benutzer den vorgang abbricht oder die
	// seite schliesst etc...
	@ignore_user_abort(true);

	if (!($leaguedata = fetch_sd_leagues($leagueinfo['sd_id'])))
	{
		return false;
	}

	$leagueupdatesql = "";
	$leagueChanges = array();

	if ($leaguedata['lu'] == $leagueinfo['sd_lastupdate'])
	{
		// timestamp fuer letzte aktualisierung setzen
		$GLOBALS['db']->query_write("
			UPDATE `" . TABLE_PREFIX . "soccer_league`
			SET `last_cronjob_timestamp`=" . TIMENOW . "
			WHERE `id`=" . $leagueinfo['id'] . "
			");

		// datastore fuer ligainformationen neu erstellen
		build_leagues_datastore();

		// keine aenderungen im datendienst!
		return false;
	}

	// liganamen koennen das format "^name saison$" oder "name" haben.
	// basisname extrahieren (saisonangaben entfernen)
	$leaguetypename = preg_replace(array('/\/\d{4}/', '/\d{4}/'), array('', ''), $leaguedata['name']);
	$leaguetype = strtolower($leagueinfo['sd_shortname']);
	$leaguedata['tab'] = (int) $leaguedata['tab'];


	if (($phraseinfo = $GLOBALS['db']->query_first("
		SELECT *
		FROM `" . TABLE_PREFIX . "phrase`
		WHERE `languageid`=0 AND `fieldname`='vbsoccernames' AND
			`varname`='" . $GLOBALS['db']->escape_string('soccer_leaguetype_' . $leaguetype) . "'
		")))
	{
		// hat sich die bezeichnung der liga geaendert?
		if (trim($phraseinfo['text']) != trim($leaguetypename))
		{
			$GLOBALS['db']->query_write("
				UPDATE `" . TABLE_PREFIX . "phrase`
				SET `text`='" . $GLOBALS['db']->escape_string(trim($leaguetypename)) . "'
				WHERE `languageid`=0 AND `fieldname`='vbsoccernames' AND
					`varname`='" . $GLOBALS['db']->escape_string('soccer_leaguetype_' . $leaguetype) . "'
				");
		}

		unset($phraseinfo);
	}

	// ueberschreiben aller geaenderten sd_daten
	if (!$sdLeagueMap)
	{
		$sdLeagueMap = array(
			'sd_homepage'       => 'hp',
			'sd_relegation'     => 'rel',
			'sd_sent_back_down' => 'down',
			'sd_called_up'      => 'up',
			'sd_lastupdate'     => 'lu',
			'mdgrp'             => 'mdgrp',
			'mdp'               => 'mdp',
			'showtable'         => 'tab',
			'region'            => 'reg',
			);
	}

	foreach ($sdLeagueMap AS $key => $sdkey)
	{
		if ($leaguedata[$sdkey] != $leagueinfo[$key])
		{
			$leagueChanges[] = sprintf("`%s`='%s'", $key, $GLOBALS['db']->escape_string($leaguedata[$sdkey]));
		}
	}

	if (!empty($leagueChanges))
	{
		$leagueupdatesql = sprintf(', %s', implode(',', $leagueChanges));
	}

	// alle ansetzungen fuer liga holen
	if (!($fixtures = fetch_sd_matchdata((int) $leagueinfo['sd_id'])))
	{
		// keine ansetzungen gefunden.
		return false;
	}

	// teaminfos der liga-teams holen (namensaenderungen, etc.)
	$teams = fetch_sd_teamdata((int) $leagueinfo['sd_id']);

	// initialisierungen
	$sdteams = $availfixtures = $lt = array();

	foreach ($fixtures AS $id => $obj)
	{
		// boolsche angaben fuer spielende in INT 0 oder 1 konvertieren
		$obj['fi'] = (int) $obj['fi'];

		// initialisierung fuer team-daten (team a und team b)
		$sdteams[$obj['t1']] = $sdteams[$obj['t2']] = array();

		// stdClass-objekt der spieldaten in array konvertieren
		$availfixtures[$obj['id']] = $obj;
	}

	unset($fixtures);

	$notAssignedTeams = $sdLeagueTeams = array();

	// teamdaten in array speichern
	foreach ($teams AS $id => $obj)
	{
		if (isset($sdteams[$obj['id']]))
		{
			$sdteams[$obj['id']] = $obj;
		}
		else
		{
			// uebermittelte mannschaften der liga, die keiner ansetzung
			// zugeordnet sind in array speichern
			$notAssignedTeams[$obj['id']] = $obj;
		}

		$sdLeagueTeams[$obj['id']] = $obj;
	}

	unset($teams);

	if (!empty($sdLeagueTeams))
	{
		// alle teams ermitteln, die bereits in einer anderen liga vorhanden sind
		$teamresult = $GLOBALS['db']->query_read("
			SELECT `id`, `sd_id`
			FROM `" . TABLE_PREFIX . "soccer_team`
			WHERE `sd_id` IN(" . implode(',', array_keys($sdLeagueTeams)) . ")
		");

		$teampool = array();

		while (($row = $GLOBALS['db']->fetch_array($teamresult)))
		{
			$teampool[$row['sd_id']] = $row['id'];
		}

		$GLOBALS['db']->free_result($teamresult);

		$league_teams = array();

		foreach ($sdLeagueTeams as $teamid => $teamvalue)
		{
			if (!isset($teampool[$teamid]))
			{
				// team existiert noch nicht
				$GLOBALS['db']->query_write("
					INSERT INTO `" . TABLE_PREFIX . "soccer_team`
					SET `sd_id`       = " . (int) $teamid . ",
						`sd_shortname`='" . $GLOBALS['db']->escape_string($teamvalue['sn']) . "',
						`sd_homepage` ='" . $GLOBALS['db']->escape_string($teamvalue['hp']) . "'
					");

				$teampool[$teamid] = $GLOBALS['db']->insert_id();

				// teamname als customphrase speichern (soccer_team_$id)
				$GLOBALS['db']->query_write("
					REPLACE INTO `" . TABLE_PREFIX . "phrase`
						(`languageid`, `fieldname`, `varname`, `text`, `product`, `username`, `dateline`, `version`)
					VALUES (
						0,
						'vbsoccernames',
						'" . $GLOBALS['db']->escape_string('soccer_team_' . (int) $teamid) . "',
						'" . $GLOBALS['db']->escape_string($teamvalue['name']) . "',
						'vbsoccer',
						'" . $GLOBALS['db']->escape_string($vbulletin->userinfo['username']) . "',
						" . TIMENOW . ",
						'" . $GLOBALS['db']->escape_string($vbulletin->options['templateversion']) . "')
					");
			}

			// sql-insert-strings fuer team/liga-verknuepfung
			$league_teams[] = sprintf("(%d, %d, %d)", $leagueinfo['id'], $teampool[$teamid], $teamvalue['p']);
		}

		if (!empty($league_teams))
		{
			// teams der neuen liga zuordnen
			$GLOBALS['db']->query_write("
				INSERT IGNORE INTO `" . TABLE_PREFIX . "soccer_league_team`
				(`league_id`, `team_id`, `points`)
				VALUES " . implode(',', $league_teams) . "
				");
		}
	}

	unset($notAssignedTeams);

	// mapping fuer datenschluessel erstellen
	//
	// die daten von datendienst werden mit stark abgekuerzten keys gesendet, um
	// die datenmenge so gering wie nur irgend moeglich zu halten. diese
	// kuerzel werden hier auf die tatsaechlichen spalten-namen gemapped
	if (!$sd2vbsoccer_map)
	{
		$sd2vbsoccer_map = array(
			'id'     => 'sd_id',
			'dt'     => 'dateline',
			'lu'     => 'sd_lastupdate',
			't1'     => 'team_home_id',
			't2'     => 'team_away_id',
			'mdphid' => 'matchtype_id',
			'mdph'   => 'phrase_id',
			'md'     => 'match_day',
			's1'     => 'points_home',
			's2'     => 'points_away',
			'fi'     => 'match_is_finished',
			);
	}

	// schluessel und werte des mappings verdrehen, damit sowohl mit dem
	// kuerzel als auch mit dem tatsaechlichen spalten-namen auf das mapping
	// zugegriffen werden kann.
	$vbsoccer2sd_map = array_flip($sd2vbsoccer_map);

	// bereits vorhandene teams der liga auslesen
	$leagueteams = $GLOBALS['db']->query_read("
		SELECT t.`sd_id`, t.`id`, t.`sd_homepage`, t.`sd_shortname`, lt.`points`
		FROM `" . TABLE_PREFIX . "soccer_team` AS t
		INNER JOIN `" . TABLE_PREFIX . "soccer_league_team` AS lt ON (lt.`team_id`=t.`id`)
		WHERE lt.`league_id`=" . $leagueinfo['id'] . "
		");

	while (($leagueteam = $GLOBALS['db']->fetch_array($leagueteams)))
	{
		// mapping fuer lokale ligaid und der ligaid des datendienstes
		// id -> sd_id
		$lt[$leagueteam['id']] = $leagueteam['sd_id'];

		// initialisierungen fuer sql-statements-array
		$teamupdatesql = $lteamupdatesql = array();

		if (isset($sdteams[$leagueteam['sd_id']]))
		{
			// team existiert und ist der liga zugeordnet
			//
			if ($sdteams[$leagueteam['sd_id']]['sn'] != $leagueteam['sd_shortname'])
			{
				// der kurzname des teams hat sich geaendert
				$teamupdatesql[] = "`sd_shortname`='" . $GLOBALS['db']->escape_string($sdteams[$leagueteam['sd_id']]['sn']) . "'";
			}

			if ($sdteams[$leagueteam['sd_id']]['hp'] != $leagueteam['sd_homepage'])
			{
				// die homepage des teams hat sich geaendert
				$teamupdatesql[] = "`sd_homepage`='" . $GLOBALS['db']->escape_string($sdteams[$leagueteam['sd_id']]['hp']) . "'";
			}

			if ($sdteams[$leagueteam['sd_id']]['p'] != $leagueteam['points'])
			{
				// strafpunkte des teams in dieser liga haben sich geaendert
				$lteamupdatesql[] = "`points`='" . $GLOBALS['db']->escape_string($sdteams[$leagueteam['sd_id']]['p']) . "'";
			}
		}

		if (!empty($teamupdatesql))
		{
			// team aktualisieren, wenn aenderungen erkannt wurden
			$GLOBALS['db']->query_write("
				UPDATE `" . TABLE_PREFIX . "soccer_team`
				SET " . implode(',', $teamupdatesql) . "
				WHERE `id`=" . $leagueteam['id'] . "
				");
		}

		if (!empty($lteamupdatesql))
		{
			// ligainformationen dieses teams aktualisieren wenn notwendig
			$GLOBALS['db']->query_write("
				UPDATE `" . TABLE_PREFIX . "soccer_league_team`
				SET " . implode(',', $lteamupdatesql) . "
				WHERE `league_id`=" . $leagueinfo['id'] . " AND `team_id`=" . $leagueteam['id'] . "
				");
		}
	}

	$GLOBALS['db']->free_result($leagueteams);
	unset($leagueteam);

	// reverse-mapping fuer lokale ligaid und der ligaid des datendienstes
	// sd_id -> id
	$lt_reverse = array_flip($lt);

	// vorhandene ansetzungen der liga auslesen und mithilfe der mappings fuer
	// nachfolgende vergleichsoperationen auf die entsprechenden aliase setzen
	// ok, scheisse zu lesen, spart aber unendlich viele if/else-abfragen beim
	// vergleichen.
	$leaguematches = $GLOBALS['db']->query_read("
		SELECT
			m.`" . $sd2vbsoccer_map[$vbsoccer2sd_map['sd_id']] . "`             AS `" . $vbsoccer2sd_map['sd_id'] . "`,
			m.`" . $sd2vbsoccer_map[$vbsoccer2sd_map['dateline']] . "`          AS `" . $vbsoccer2sd_map['dateline'] . "`,
			m.`" . $sd2vbsoccer_map[$vbsoccer2sd_map['sd_lastupdate']] . "`     AS `" . $vbsoccer2sd_map['sd_lastupdate'] . "`,
			m.`" . $sd2vbsoccer_map[$vbsoccer2sd_map['match_day']] . "`         AS `" . $vbsoccer2sd_map['match_day'] . "`,
			m.`" . $sd2vbsoccer_map[$vbsoccer2sd_map['matchtype_id']] . "`      AS `" . $vbsoccer2sd_map['matchtype_id'] . "`,
			m.`" . $sd2vbsoccer_map[$vbsoccer2sd_map['points_home']] . "`       AS `" . $vbsoccer2sd_map['points_home'] . "`,
			m.`" . $sd2vbsoccer_map[$vbsoccer2sd_map['points_away']] . "`       AS `" . $vbsoccer2sd_map['points_away'] . "`,
			m.`" . $sd2vbsoccer_map[$vbsoccer2sd_map['match_is_finished']] . "` AS `" . $vbsoccer2sd_map['match_is_finished'] . "`,
			mt.`" . $sd2vbsoccer_map[$vbsoccer2sd_map['phrase_id']] . "`        AS `" . $vbsoccer2sd_map['phrase_id'] . "`,
			m.`team_home_id` AS t1, m.`team_away_id` AS t2
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		LEFT JOIN `" . TABLE_PREFIX . "soccer_matchtype` AS mt USING(`matchtype_id`)
		WHERE `league_id`=" . $leagueinfo['id'] . "
		");

	while (($leaguematch = $GLOBALS['db']->fetch_array($leaguematches)))
	{
		// vergleichsarrays erstellen, die mit dem aufbau der daten vom daten-
		// dienst identisch sind
		$leaguematch[$vbsoccer2sd_map['team_home_id']] = $lt[$leaguematch[$vbsoccer2sd_map['team_home_id']]];
		$leaguematch[$vbsoccer2sd_map['team_away_id']] = $lt[$leaguematch[$vbsoccer2sd_map['team_away_id']]];

		if ($leaguematch[$vbsoccer2sd_map['match_is_finished']] == 2)
		{
			// wurde lokal ein spiel abgepfiffen, ist der status '2'. der daten-
			// dienst kennt nur 1 und 0. um hier zu pruefen, ob das spiel tat-
			// saechlich beendet ist muss die 2 in 0 geaendert werden.
			$leaguematch[$vbsoccer2sd_map['match_is_finished']] = 0;
		}

		$lmatches[$leaguematch[$vbsoccer2sd_map['sd_id']]] = $leaguematch;
	}

	$GLOBALS['db']->free_result($leaguematches);

	// pruefen, ob ein neues spiel in der liga vorhanden ist. dies ist bei
	// einigen events der fall, wo durch auslosungen oder durch die natur des
	// jeweiligen ligasystems etc. im nachhinein neue spiele hinzukommen.
	if (($diff = array_diff_assoc($availfixtures, $lmatches)))
	{
		foreach ($diff AS $data)
		{
			// spiel einfuegen (nur die ids!)
			$GLOBALS['db']->query_write("
				INSERT INTO `" . TABLE_PREFIX . "soccer_match`
				SET `sd_id`=" . (int) $data['id'] . ",
					`league_id`=" . $leagueinfo['id'] . "
				");

			// spiel ohne details ins vergleichsarray aufnehmen.
			// details des spieles werden dann nachfolgend aktualisiert.
			$lmatches[$data['id']] = array();
		}
	}

	// vorhandene spiele mit den spieldaten des datendienstes direkt vergleichen
	foreach ($availfixtures AS $sddata)
	{
		if (($diff = array_diff_assoc($sddata, $lmatches[$sddata['id']])))
		{
			// initialisierung fuer moegliche sql-statements
			$matchsql = array();

			if (isset($diff['mdph']) AND isset($diff['mdphid']))
			{
				// eines aenderung des spieltagtypes wurde erkannt. dieser
				// spieltag-type ist kein unmittelbarer bestandteil der spiel-
				// daten
				$GLOBALS['db']->query_write("
					INSERT IGNORE INTO `" . TABLE_PREFIX . "soccer_matchtype`
					SET `phrase_id`='" . $GLOBALS['db']->escape_string($diff['mdph']) . "',
						`matchtype_id`='" . (int) $diff['mdphid'] . "'
					");

				// entfernen aus vergleichsarray, weil dies kein bestandteil
				// der spieltabelle ist!
				unset($diff['mdph']);
			}

			// indikator, ob es veraenderung gibt, die ein update erfordern
			$chgsummary = array();

			foreach ($diff AS $key => $value)
			{
				if ($key == 'mdph')
				{
					continue;
				}

				if ($key == 't1' OR $key == 't2')
				{
					// hoppla, hier wurden teams einer ansetzung geaendert!
					$value = $lt_reverse[$value];
				}

				$matchsql[$key] = sprintf('`%s`=%d', $sd2vbsoccer_map[$key], $value);
				$chgsummary[$key] = (int) $value;
			}

			unset($diff);

			// aenderungen pruefen
			if (!empty($chgsummary))
			{
				$unsets = false;

				// wurde das spiel nicht abgepfiffen durch den datendienst?
				if (empty($chgsummary['fin']))
				{
					// soll das ergebnis geaendert werden?
					//
					// lokale ergebnisse werden nur dann waehrend der spielzeit
					// ueberschrieben, wenn die torzahl im datendienst groesser
					// ist.
					//
					// tore team A
					if (isset($chgsummary['s1']))
					{
						if ($chgsummary['s1'] < $lmatches[$sddata['id']]['s1'])
						{
							$unsets = true;
						}
					}

					// tore team B
					if (isset($chgsummary['s2']))
					{
						if ($chgsummary['s2'] < $lmatches[$sddata['id']]['s2'])
						{
							$unsets = true;
						}
					}

					if ($unsets AND ($sddata['fi'] == 0 AND $sddata['dt'] < TIMENOW))
					{
						// spiel ist im datendienst noch nicht abgepfiffen, aber
						// es sollen die ergebnisse lokal nicht ueberschrieben
						// werden (lokal sind hoehere torzahlen vorhanden, was
						// entweder darauf schliessen laesst, dass die daten
						// aktueller sind, oder ein scherzbold am werke war)
						//
						// keine tore aktualisieren!
						if (isset($matchsql['s1']))
						{
							unset($matchsql['s1']);
						}
						if (isset($matchsql['s2']))
						{
							unset($matchsql['s2']);
						}
					}
				}

				if (($sddata['s1'] != -1 AND $sddata['s1'] > $lmatches[$sddata['id']]['s1']) OR
					($sddata['s2'] != -1 AND $sddata['s2'] > $lmatches[$sddata['id']]['s2']))
				{
					// ergebnis-string des neuen ergebnisses fuer aenderungslog
					$postresult = $sddata['s1'] . ':' . $sddata['s2'];

					// lokale spiel-id ermitteln...
					if (($rmatchdata = $GLOBALS['db']->query_first("
						SELECT `id`
						FROM `" . TABLE_PREFIX . "soccer_match`
						WHERE sd_id=" . $sddata['id'] . "
						")))
					{
						// ... und aktion ins log schreiben (datendienst)
						$GLOBALS['db']->query_write("
							INSERT INTO `" . TABLE_PREFIX . "soccer_postresult_log`
								SET `userid`=0,
								`match_id`=" . $rmatchdata['id'] . ",
								`dateline`=" . TIMENOW . ",
								`result`='" . $GLOBALS['db']->escape_string($postresult) . "',
								`finished`=" . (int) $sddata['fi'] . ",
								`ipaddress`=''
							");
					}
				}
			}

			if ($sddata['dt'] == VBSOCCER_DEFERRED)
			{
				// zeitstempel des spiels ist identisch mit dem alias fuer
				// unbekannte anstosszeit (spiel abgesagt, etc.)
				//
				// bereits eingetragene ergebnisse zuruecksetzen auf -1
				$matchsql['s1'] = sprintf('`%s`=-1', $sd2vbsoccer_map['s1']);
				$matchsql['s2'] = sprintf('`%s`=-1', $sd2vbsoccer_map['s2']);

				// und spiel auf 'nicht angepfiffen' setzen, es sei denn, es ist
				// im datendienst explizit so gesetzt (spiel findet nicht mehr
				// statt)
				$matchsql['fi'] = sprintf('`%s`=%d', $sd2vbsoccer_map['fi'], ($sddata['fi'] == 1 ? 1 : 0));
			}

			if (!empty($matchsql))
			{
				// zeitstempel der aktualisierung setzen
				$matchsql[] = "`last_update_timestamp`=" . TIMENOW . "";

				$GLOBALS['db']->query_write("
					UPDATE `" . TABLE_PREFIX . "soccer_match`
					SET " . implode(',', $matchsql) . ",
						`score_key`=CASE
							WHEN `points_home`=-1 AND `points_away`=-1 THEN 0
							WHEN `points_home`=`points_away` THEN 2
							WHEN `points_home`>`points_away` THEN 1
							WHEN `points_home`<`points_away` THEN 3
						END
					WHERE `sd_id`=" . (int) $sddata['id'] . "
					");

				$retval = true;
			}
		}
	} // end foreach

	unset($availfixtures);

	// true = mindestens 1 spiel wurde aktualisiert
	// false = kein spiel wurde aktualisiert

	if ($retval === true)
	{
		$saison_rankings = construct_saison_rankings($leagueinfo['id']);

		$GLOBALS['db']->query_write("
			UPDATE `" . TABLE_PREFIX . "soccer_league`
			SET `x_ranking`='" . $GLOBALS['db']->escape_string($saison_rankings) . "'
			WHERE `id`=" . $leagueinfo['id'] . "
			");

		unset($saison_rankings);
	}

	// timestamp fuer letzte aktualisierung setzen
	$GLOBALS['db']->query_write("
		UPDATE `" . TABLE_PREFIX . "soccer_league`
		SET `last_cronjob_timestamp`=" . TIMENOW . $leagueupdatesql . "
		WHERE `id`=" . $leagueinfo['id'] . "
		");

	unset($leagueupdatesql);

	// datastore fuer ligainformationen neu erstellen
	build_leagues_datastore();

	return $retval;
}

/**
 * berechnung des score_keys (gewinnschluessel eines ergebnisses oder tipps)
 *
 * 0 = nicht getippt, nicht gespielt
 * 1 = team A gewinnt
 * 2 = unentschieden
 * 3 = team B gewinnt
 *
 * @param int tore team A
 * @param int tore team B
 * @return int score_key
 */
function fetch_soccer_score_key($home=-1, $away=-1)
{
	switch (true)
	{
		case ($home == -1 or $away == -1): return 0; break;
		case ($home == $away):             return 2; break;
		case ($home > $away):              return 1; break;
		case ($home < $away):              return 3; break;
	}
}

/**
 * liefert eine html-auswahlbox fuer alle ligen
 *
 * @param int aktuelle ligaid
 * @param string 'all' oder 'tab'. ist der parameter 'tab' engegeben, werden in
 *               in der auswahlbox die ligen deaktiviert, fuer die keine
 *               tabelle generiert werden soll.
 * @return string html-auswahlbox fuer ligen
 */
function construct_soccer_league_jump($curleagueid=0, $type='all')
{
	$optgroup_extra        = '';
	$archiv_options        = '';
	$notsubscribed_options = '';
	$current_options       = '';

	$GLOBALS['show']['notsubscribed'] = false;

	/**
	 * array mit allen ligen, die nicht abonniert wurden
	 *
	 * @global array $GLOBALS['notsubscribed']
	 * @name $notsubscribed
	 */
	$GLOBALS['notsubscribed'] = array();

	if (!empty($GLOBALS['vbsoccerprefs']['lhide']))
	{
		foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache AS $leagueid => $leagueinfo)
		{
			if (in_array(strtolower($leagueinfo['sd_shortname']), $GLOBALS['vbsoccerprefs']['lhide']))
			{
				// ausgeblendete ligen nicht im menue anzeigen
				$GLOBALS['notsubscribed'][$leagueinfo['id']] = $leagueinfo;
			}
		}

		if (isset($GLOBALS['notsubscribed'][$curleagueid]))
		{
			$GLOBALS['show']['notsubscribed'] = true;
		}
	}

	$leagueclassdepth = ((!empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv']) AND
						 !empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'])) ? 1 : 0);

	if (!empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['current']))
	{
		foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'] AS $optionvalue)
		{
			$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$optionvalue];

			if (isset($GLOBALS['notsubscribed'][$leagueinfo['id']]))
			{
				// ausgeblendeten wettbewerb nicht in auswahl anzeigen
				continue;
			}

			if ($type == 'tab' AND $leagueinfo['showtable'] == 0)
			{
				// wettbewerb ohne tabelle: deaktiviert anzeigen
				$optionselected = ' disabled="disabled"';
			}
			else
			{
				$optionselected = '';
			}

			$optiontitle = fetch_soccer_leaguename($leagueinfo);

			if ($optionvalue == $curleagueid)
			{
				$optionselected .= ' selected="selected"';
			}

			$optionclass = ($optionvalue == $curleagueid ? 'fjsel' : 'fjdpth' . $leagueclassdepth);
			eval('$current_options .= "' . fetch_template('option') . '";');
		}
	}

	if (!empty($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv']))
	{
		if ($current_options != '')
		{
			// aktuelle saisons gruppieren
			$optgroup_options = $current_options;
			$optgroup_label   = $GLOBALS['vbphrase']['soccer_current_saison'];
			eval('$current_options = "' . fetch_template('optgroup') . '";');
		}

		foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache['archiv'] AS $optionvalue)
		{
			$leagueinfo = $GLOBALS['vbulletin']->vbsoccer_leaguecache[$optionvalue];

			if (isset($GLOBALS['notsubscribed'][$leagueinfo['id']]))
			{
				// ausgeblendeten wettbewerb nicht in auswahl anzeigen
				continue;
			}

			if ($type == 'tab' AND $leagueinfo['showtable'] == 0)
			{
				// wettbewerb ohne tabelle: deaktiviert anzeigen
				$optionselected = ' disabled="disabled"';
			}
			else
			{
				$optionselected = '';
			}

			$optiontitle = fetch_soccer_leaguename($leagueinfo);

			if ($optionvalue == $curleagueid)
			{
				$optionselected .= ' selected="selected"';
			}

			$optionclass = ($optionvalue == $curleagueid ? 'fjsel' : 'fjdpth' . $leagueclassdepth);
			eval('$archiv_options .= "' . fetch_template('option') . '";');
		}

		if ($current_options != '')
		{
			// archiv-saisons gruppieren
			$optgroup_options = $archiv_options;
			$optgroup_label   = $GLOBALS['vbphrase']['soccer_past_saisons'];
			eval('$archiv_options = "' . fetch_template('optgroup') . '";');
		}
	}

	// nicht abnonnierte ligen gruppiert am ende des selektors anzeigen
	if (!empty($GLOBALS['notsubscribed']))
	{
		foreach ($GLOBALS['notsubscribed'] AS $optionvalue => $leagueinfo)
		{
			if (($type == 'tab' AND $leagueinfo['showtable'] == 0))
			{
				continue;
			}

			$optiontitle = fetch_soccer_leaguename($leagueinfo);
			$optionselected = ($optionvalue == $curleagueid ? ' selected="selected"' : '');
			$optionclass = ($optionvalue == $curleagueid ? 'fjsel' : 'fjdpth1');
			eval('$notsubscribed_options .= "' . fetch_template('option') . '";');
		}

		if ($notsubscribed_options != '')
		{
			// nicht abonnierte ligen gruppieren
			$optgroup_options = $notsubscribed_options;
			$optgroup_label   = $GLOBALS['vbphrase']['soccer_not_subscribed'];
			eval('$notsubscribed_options = "' . fetch_template('optgroup') . '";');
		}
	}


	$options = $current_options . $archiv_options . $notsubscribed_options;

	if ($options == '')
	{
		return $options;
	}
	else
	{
		return '<select name="l" id="l" onchange="soccer_leaguechange(this.form);">' . $options . '</select>';
	}
}

/**
 * liganame aus phrase und saison zusammensetzen
 *
 * @param array $leagueinfo ligainformationen
 * @return string liganame
 */
function fetch_soccer_leaguename($leagueinfo)
{
	switch ($leagueinfo['sd_shortname'])
	{
		case 'WM':
		case 'EM':
		case 'ASV':
		case 'BRA':
			$leagueinfo['sd_saison'] = substr($leagueinfo['sd_saison'], 0, 4);
			break;
	}

	$leagueinfo['league_name'] = construct_phrase($GLOBALS['vbphrase']['soccer_league_x_saison_y'],
												  $GLOBALS['vbphrase'][$leagueinfo['phrase']],
												  $leagueinfo['sd_saison']
												  );

	return htmlspecialchars_uni($leagueinfo['league_name']);
}

/**
 * erstellt ein array mit css-klassen-namen fuer mainmenue
 *
 * @param string $selectedcell ausgewaehlter menueeintrag
 */
function construct_soccer_nav($selectedcell='')
{
	$cells = array('archive', 'pt', 'thread', 'schedule', 'settings',
				   'ranking', 'live', 'notsubscribed', 'reportranking',
				   'overallranking', 'hall_of_fame'
				   );

	/**
	 * array mit allen css-klassen je menueeintrag
	 *
	 * @global array $GLOBALS['navclass']
	 * @name $navclass
	 */
	$GLOBALS['navclass'] = array();

	foreach ($cells AS $cellname)
	{
		$GLOBALS['navclass']["$cellname"] = 'alt2';
	}

	if ($selectedcell != '')
	{
		$GLOBALS['navclass']["$selectedcell"] = 'alt1';
	}
}

/**
 * ermittelt alle verfuegbaren spieltage einer liga
 *
 * @param void
 * @return array spieltagsinformationen
 */
function fetch_soccer_matchdayinfo()
{
	$matchdays = $GLOBALS['db']->query_read("
		SELECT m.`match_day`, mt.`phrase_id`, SUM(score_key) AS `todaymatchday`,
			" . construct_soccer_sql_matchdaygroups() . " AS `matchday_group`,
			MIN(m.dateline) AS firstmatchdaymatch
		FROM `" . TABLE_PREFIX . "soccer_match` AS m
		LEFT JOIN `" . TABLE_PREFIX . "soccer_matchtype` AS mt USING(`matchtype_id`)
		WHERE m.`league_id`=" . (int) $GLOBALS['leagueinfo']['id'] . "
		GROUP BY m.`match_day`
		ORDER BY m.`match_day`
		");

	$matchdayinfo = array();

	while (($matchday = $GLOBALS['db']->fetch_array($matchdays)))
	{
		if (empty($GLOBALS['todaymatchday']) AND $matchday['todaymatchday'] == 0 AND ($matchday['match_day']-1 > 0))
		{
			if (172800 > ($matchday['firstmatchdaymatch'] - TIMENOW))
			{
				$GLOBALS['todaymatchday'] = $matchday['match_day'];
			}
			else
			{
				$GLOBALS['todaymatchday'] = $matchday['match_day']-1;
			}
		}

		if (empty($GLOBALS['firstmatchday']))
		{
			$GLOBALS['firstmatchday'] = $matchday['match_day'];
		}

		$matchdayinfo[$matchday['matchday_group']][$matchday['match_day']] = construct_soccer_matchday_phrase($matchday['match_day'], $matchday['phrase_id']);
		$GLOBALS['lastmatchday'] = $matchday['match_day'];
	}

	$GLOBALS['db']->free_result($matchdays);

	if (empty($GLOBALS['todaymatchday']))
	{
		// konnte kein spieltag als aktueller spieltag gefunden werden, dann den
		// letzten spieltag der liga als aktuellen spieltag setzen
		$GLOBALS['todaymatchday'] = $GLOBALS['lastmatchday'];
	}

	return $matchdayinfo;
}

function construct_saison_rankings($league_id, $positions=3)
{
	global $vbulletin;

	if (!isset($vbulletin->options['vbsoccer_points']))
	{
		return array();
	}
	else
	{
		if (!is_array($vbulletin->options['vbsoccer_points']))
		{
			$vbulletin->options['vbsoccer_points'] = @unserialize($vbulletin->options['vbsoccer_points']);
		}
	}

	$result = $GLOBALS['db']->query_read("
		SELECT u.userid,
			(_wr * " . (int) $vbulletin->options['vbsoccer_points']['wr'] . ") +
			((_count - _wr - _rr - _rd) * " . (int) $vbulletin->options['vbsoccer_points']['rw'] . ") +
			(_rd * " . (int) $vbulletin->options['vbsoccer_points']['rd'] . ") +
			(_rr * " . (int) $vbulletin->options['vbsoccer_points']['rr'] . ") AS points
		FROM (
			SELECT userid, COUNT(*) AS _count,
				SUM(score_key != bet_score_key) AS _wr,
				SUM(bet_home=points_home AND bet_away=points_away) AS _rr,
				SUM(CAST(bet_home - bet_away AS SIGNED)=(points_home - points_away)
					AND NOT (bet_home = points_home AND bet_away = points_away)) AS _rd
			FROM " . TABLE_PREFIX . "soccer_user_bet AS b
			INNER JOIN " . TABLE_PREFIX . "soccer_match AS m ON(m.id=b.match_id)
			WHERE m.league_id=" . (int) $league_id . " AND score_key>0
			GROUP BY userid) AS userpoints
		INNER JOIN " . TABLE_PREFIX . "user AS u USING(userid)
		ORDER BY points DESC, username
		LIMIT 20
		");

	$count = 0;
	$pos = 0;
	$data = array();

	while (($row = $GLOBALS['db']->fetch_array($result)))
	{
		$count++;
		if (!isset($oldpoints) OR $oldpoints != $row['points'])
		{
			$rank = $count;
		}

		$oldpoints = $row['points'];


		if ($rank > $positions)
		{
			break;
		}

		$data[$rank][$row['points']][] = $row['userid'];
	}

	$GLOBALS['db']->free_result($result);

	return serialize($data);
}

/**
 *
 * @since 0.1.11
 */
function build_leagues_datastore()
{
	$GLOBALS['vbulletin']->db->hide_errors();

	$leagues_result = $GLOBALS['vbulletin']->db->query_read("
		SELECT league.*, CONCAT('soccer_leaguetype_', LOWER(league.`sd_shortname`)) AS `phrase`,
			masterphrase.`text` AS `league_name`, IFNULL(soccer_league_group.`displayorder`, 0) AS `grouporder`
		FROM (`" . TABLE_PREFIX . "soccer_league` AS `league`, `" . TABLE_PREFIX . "phrase` AS `masterphrase`)
		LEFT JOIN `" . TABLE_PREFIX . "soccer_league_group` AS `soccer_league_group` ON(soccer_league_group.`groupid`=league.`groupid`)
		WHERE league.`visible`!=0
			AND masterphrase.`languageid`=0
			AND masterphrase.`fieldname`='vbsoccernames'
			AND masterphrase.`varname`=CONCAT('soccer_leaguetype_', LOWER(league.`sd_shortname`))
		ORDER BY `grouporder`, league.`displayorder`, `league_name`, league.sd_saison
		");

	$GLOBALS['vbulletin']->db->show_errors();

	if ($GLOBALS['vbulletin']->db->errno)
	{
		return false;
	}

	$league_cache = array(
		'archiv'  => array(),
		'current' => array()
		);

	while (($league = $GLOBALS['vbulletin']->db->fetch_array($leagues_result)))
	{
		if ($league['description'] != '')
		{
			$stripped = strip_tags($league['description']);

			if (strlen($stripped) != strlen($league['description']))
			{
				$league['description'] = nl2br($league['description']);
			}
		}

		$league['id']                     = (int) $league['id'];
		$league['sd_id']                  = (int) $league['sd_id'];
		$league['last_cronjob_timestamp'] = (int) $league['last_cronjob_timestamp'];
		$league['sd_lastupdate']          = (int) $league['sd_lastupdate'];
		$league['groupid']                = (int) $league['groupid'];

		if ((int) $league['visible'] === -1)
		{
			$league_cache['archiv'][$league['id']] = $league['id'];
		}
		else
		{
			$league_cache['current'][$league['id']] = $league['id'];
		}

		unset($league['league_name'], $league['visible'], $league['x_ranking']);
		$league_cache[$league['id']] = $league;
	} // end while

	$GLOBALS['vbulletin']->db->free_result($leagues_result);

	build_datastore('vbsoccer_leaguecache', serialize($league_cache), 1);

	return true;
}

/**
 * liefert eine ligatabelle, optional spieltags-genau
 *
 * @param int $leagueid liga-id
 * @param int $matchday optionale angabe des spieltages
 */
function fetch_leaguetable($leagueid=0, $matchday=0, $tabletype='')
{
	$leagueTeams = array();
/*
-- alle mannschaften der liga ermitteln
SELECT team.*, CONCAT('soccer_team_', team.`sd_id`) AS team_phrase,
	league_team.points AS start_points
FROM `v3_soccer_team` AS team
INNER JOIN `v3_soccer_league_team` AS league_team ON (league_team.team_id=team.id)
WHERE league_team.league_id=36

-- alle tabellen-relevanten spiele einer liga ermitteln
SELECT `match`.*
FROM v3_soccer_match AS `match`
INNER JOIN v3_soccer_matchtype AS `matchtype` USING(matchtype_id)
WHERE league_id=36 AND `matchtype`.phrase_id IN('matchday_x','round_x','group_alpha_x')
ORDER BY `match`.match_day


*/
/*
echo '<pre>';

	$result = $GLOBALS['vbulletin']->db->query_read("
		SELECT team.*, CONCAT('soccer_team_', team.`sd_id`) AS team_phrase,
			league_team.points AS start_points
		FROM `" . TABLE_PREFIX . "soccer_team` AS team
		INNER JOIN `" . TABLE_PREFIX . "soccer_league_team` AS league_team ON (league_team.team_id=team.id)
		WHERE league_team.league_id=36
		");

	$teams = array();

	while (($row = $GLOBALS['vbulletin']->db->fetch_array($result)))
	{
		$teams[$row['id']] = $row;
	}

	$result = $GLOBALS['vbulletin']->db->query_read("
		SELECT `match`.*
		FROM " . TABLE_PREFIX . "soccer_match AS `match`
		INNER JOIN " . TABLE_PREFIX . "soccer_matchtype AS `matchtype` USING(matchtype_id)
		WHERE league_id=" . $leagueid . " AND `matchtype`.phrase_id IN('matchday_x','round_x','group_alpha_x')
		ORDER BY `match`.match_day
		");

$teamsummary = array();
$sides = array('home', 'away');
	while (($row = $GLOBALS['vbulletin']->db->fetch_array($result)))
	{
		#print_r($row);
		foreach ($sides AS $key => &$side)
		{
			$teamid = $row['team_' . $side . '_id'];
			if (!isset($teamsummary[$row['team_' . $side . '_id']]))
			{
				$teamsummary[$teamid]['goals'] = 0;
				$teamsummary[$teamid]['goals_against'] = 0;
				$teamsummary[$teamid]['played'] = 0;
				$teamsummary[$teamid]['goals_diff'] = 0;
				$teamsummary[$teamid]['wins'] = 0;
				$teamsummary[$teamid]['draws'] = 0;
				$teamsummary[$teamid]['losses'] = 0;
				$teamsummary[$teamid]['sum_points'] = 0;
			}

			if ($row['match_is_finished'] == 1)
			{
				$teamsummary[$teamid]['goals'] += $row['points_' . $side];
				$teamsummary[$teamid]['goals_against'] += $row['points_' . $sides[!$key]];
				$teamsummary[$teamid]['played']++;
				$teamsummary[$teamid]['goals_diff'] = $teamsummary[$teamid]['goals'] - $teamsummary[$teamid]['goals_against'];
				if ($row['score_key'] == 2)
				{
					$teamsummary[$teamid]['draws']++;
				}
				$teamsummary[$teamid]['matchday'] = $row['match_day'];
			}

		}

		if ($row['match_is_finished'] == 1)
		{
			if ($row['score_key'] == 1)
			{
				$teamsummary[$row['team_home_id']]['wins']++;
				$teamsummary[$row['team_away_id']]['losses']++;
			}

			if ($row['score_key'] == 3)
			{
				$teamsummary[$row['team_home_id']]['losses']++;
				$teamsummary[$row['team_away_id']]['wins']++;
			}

			$teamsummary[$row['team_home_id']]['sum_points'] = ($teamsummary[$row['team_home_id']]['wins'] * 3) + $teamsummary[$row['team_home_id']]['draws'] + $teams[$row['team_home_id']]['start_points'];
			$teamsummary[$row['team_away_id']]['sum_points'] = ($teamsummary[$row['team_away_id']]['wins'] * 3) + $teamsummary[$row['team_away_id']]['draws'] + $teams[$row['team_away_id']]['start_points'];
		}

	}

print_r($teamsummary);

exit;
 */
	switch ($tabletype)
	{
		case 'wm':
		case 'em':
		case 'chl':
		case 'eul':
			$sql_select       = "`match_day`,";
			$match_select1    = "`match_day`,";
			$match_select2    = "`match_day`,";
			$match_join1      = " INNER JOIN " . TABLE_PREFIX . "soccer_matchtype mt1 USING(matchtype_id)";
			$match_join2      = " INNER JOIN " . TABLE_PREFIX . "soccer_matchtype mt2 USING(matchtype_id)";
			$match_condition1 = " AND mt1.phrase_id='group_alpha_x' AND `score_key` > 0";
			$match_condition2 = " AND mt2.phrase_id='group_alpha_x' AND `score_key` > 0";
			$order_sql        = "`match_day`, `sum_points` DESC, `goal_difference` DESC, `sum_goals` DESC";

			$result = $GLOBALS['vbulletin']->db->query_read("
				SELECT
					DISTINCT match_day, CONCAT('soccer_team_', t.`sd_id`) AS team_phrase,
					t.id AS team_id, '-' AS `sum_goals`, '-' AS `sum_goalsagainst`,
					0 AS `goal_difference`, 0 AS `sum_wins`, 0 AS `sum_draws`,
					0 AS `sum_losses`, '-' AS `sum_matches`, lt.`points` AS `sum_points`,
					lt.`points` AS `start_points`, t.`sd_homepage`,
					t.`logo`, t.`logo_size_html`
				FROM `" . TABLE_PREFIX . "soccer_team` AS t
				INNER JOIN " . TABLE_PREFIX . "soccer_league_team AS lt ON(lt.`team_id`=t.`id`)
				INNER JOIN " . TABLE_PREFIX . "soccer_match AS m ON(m.team_home_id=t.id OR m.team_away_id=t.id)
				INNER JOIN " . TABLE_PREFIX . "soccer_matchtype mt USING(matchtype_id)
				WHERE lt.league_id=" . $leagueid . " AND m.league_id=" . $leagueid . " AND mt.phrase_id='group_alpha_x'
				ORDER BY `match_day`
				");

			while (($row = $GLOBALS['vbulletin']->db->fetch_array($result)))
			{
				$leagueTeams[(int) $row['team_id']] = $row;
			}

			$GLOBALS['vbulletin']->db->free_result($result);

			break;
		default:
			$match_join1 = $match_join2 = $sql_select = $match_select1 = $match_select2 = "";

			$match_condition1 = " AND `dateline` < " . TIMENOW . ""
			                  . ($matchday != 0 ? " AND `match_day`<=" . $matchday . "" : '') . "";

			// $match_condition1 = ($matchday != 0 ? " AND `match_day`<=" . $matchday . "" : '');
			$match_condition2 = $match_condition1;
			$order_sql = "`sum_points` DESC, `goal_difference` DESC, `sum_goals` DESC";

			$result = $GLOBALS['vbulletin']->db->query_read("
				SELECT
					CONCAT('soccer_team_', t.`sd_id`) AS team_phrase,
					t.id AS team_id, '-' AS `sum_goals`, '-' AS `sum_goalsagainst`,
					0 AS `goal_difference`, 0 AS `sum_wins`, 0 AS `sum_draws`,
					0 AS `sum_losses`, '-' AS `sum_matches`, lt.`points` AS `sum_points`,
					lt.`points` AS `start_points`, t.`sd_homepage`,
					t.`logo`, t.`logo_size_html`
				FROM `" . TABLE_PREFIX . "soccer_team` AS t
				INNER JOIN " . TABLE_PREFIX . "soccer_league_team AS lt ON(lt.`team_id`=t.`id`)
				WHERE league_id=" . $leagueid . "
				ORDER BY `sum_points` DESC
				");

			while (($row = $GLOBALS['vbulletin']->db->fetch_array($result)))
			{
				$leagueTeams[(int) $row['team_id']] = $row;
			}

			$GLOBALS['vbulletin']->db->free_result($result);
			break;
	}

	$result = $GLOBALS['vbulletin']->db->query_read_slave("
		SELECT " . $sql_select . "
			CONCAT('soccer_team_', t.`sd_id`) AS team_phrase,
			`md`.`team_id`,
			SUM(`sum_points_home`) AS `sum_goals`,
			SUM(`sum_points_away`) AS `sum_goalsagainst`,
			SUM(`sum_points_home`) - SUM(`sum_points_away`) AS `goal_difference`,
			SUM(`sum_wins`) AS `sum_wins`,
			SUM(`sum_draws`) AS `sum_draws`,
			SUM(`sum_losses`) AS `sum_losses`,
			SUM(`count_matches`) AS `sum_matches`,
			(SUM(`sum_wins`)*3) + SUM(`sum_draws`) + lt.`points` AS `sum_points`,
			lt.`points` AS `start_points`,
			t.`sd_homepage`,
			t.`logo`, t.`logo_size_html`
		FROM ((
			SELECT " . $match_select1 . "
				`team_home_id` AS `team_id`,
				SUM(`points_home`) AS `sum_points_home`,
				SUM(`points_away`) AS `sum_points_away`,
				SUM(`score_key`=1) `sum_wins`,
				SUM(`score_key`=2) `sum_draws`,
				SUM(`score_key`=3) `sum_losses`,
				COUNT(*) AS `count_matches`
			FROM " . TABLE_PREFIX . "soccer_match AS `m1`" . $match_join1 . "
			WHERE `league_id`=" . $leagueid . " " . $match_condition1 . "
			GROUP BY `team_home_id`
			) UNION ALL (
			SELECT " . $match_select2 . "
				`team_away_id` AS `team_id`,
				SUM(`points_away`) AS `sum_points_home`,
				SUM(`points_home`) AS `sum_points_away`,
				SUM(`score_key`=3) `sum_wins`,
				SUM(`score_key`=2) `sum_draws`,
				SUM(`score_key`=1) `sum_losses`,
				COUNT(*) AS `count_matches`
			FROM " . TABLE_PREFIX . "soccer_match AS `m2`" . $match_join2 . "
			WHERE `league_id`=" . $leagueid . " " . $match_condition2 . "
			GROUP BY `team_away_id`
		)) AS `md`
		INNER JOIN " . TABLE_PREFIX . "soccer_team t ON (`md`.`team_id`=`t`.`id`)
		INNER JOIN " . TABLE_PREFIX . "soccer_league_team `lt` ON(`lt`.`team_id`=`t`.`id`
			AND `lt`.`league_id`=" . $leagueid . ")
		GROUP BY `md`.`team_id`
		ORDER BY " . $order_sql . "
		");

	$resultarray = array();

	while (($row = $GLOBALS['vbulletin']->db->fetch_array($result)))
	{
		if ($row['sum_wins'] == 0 AND $row['sum_draws'] == 0 AND $row['sum_losses'] == 0)
		{
			$row['sum_matches'] = $row['sum_goals'] = $row['sum_goalsagainst'] = '-';
		}
		$resultarray[$row['team_id']] = $row;
	}

	$GLOBALS['vbulletin']->db->free_result($result);

	// mannschaften vervollstaendigen, damit bei unvollstaendigem 1. spieltag
	// oder noch nicht begonnenem wettbewerb die tabellen dennoch angezeigt
	// werden koennen.
	if (count($resultarray) != count($leagueTeams))
	{
		foreach ($leagueTeams AS $key => &$values)
		{
			if (!isset($resultarray[$key]))
			{
				$resultarray[$key] = $values;
			}
		}
	}

	unset($leagueTeams);

	return $resultarray;
}

/**
 * liefert parts der css-klasse fuer farbkennzeichnung in tabellen
 *
 * @param array $leagueinfo ligainformationen
 * @param int $tablecount anzahl mannschaften der liga
 * @return array array mit css-klassen und tabellenpositionen
 */
function fetch_soccertable_updownrel($leagueinfo=array(), $tablecount=0)
{
	$updownrel = array();

	if (empty($leagueinfo))
	{
		return $updownrel;
	}

	$teams_down_split = explode(',', $leagueinfo['sd_sent_back_down']);
	$teams_down_split = array_filter($teams_down_split);

	foreach ($teams_down_split AS $val)
	{
		$p = ((int) $val < 0) ? $tablecount + ((int) $val) +1 : (int) $val;
		$updownrel[$p] = 'down';
	}

	$teams_rel_split = explode(',', $leagueinfo['sd_relegation']);
	$teams_rel_split = array_filter($teams_rel_split);

	foreach ($teams_rel_split AS $val)
	{
		$p = ((int) $val < 0) ? $tablecount + ((int) $val) +1 : (int) $val;
		$updownrel[$p] = 'rel' . (((int) $val < 0) ? 'down' : 'up');
	}

	$teams_up_split = explode(',', $leagueinfo['sd_called_up']);
	$teams_up_split = array_filter($teams_up_split);

	foreach ($teams_up_split AS $val)
	{
		$p = ((int) $val < 0) ? $tablecount + ((int) $val) +1 : (int) $val;
		$updownrel[$p] = 'up';
	}

	unset($teams_down_split, $teams_rel_split, $teams_up_split);

	return $updownrel;
}

/**
 * erzeugt html-code fuer liga-icon, wenn vorhanden
 *
 * @param $leagueinfo ligainformationen
 * @return string leerer string oder htmlcode fuer icon
 */
function fetch_soccer_leagueicon($leagueinfo=array())
{
	if (!empty($leagueinfo['logo']))
	{
		$iconpath = $GLOBALS['vbulletin']->options['vbsoccer_imgdir'] .'/league/' . $leagueinfo['logo'];
		$icon = '<img src="' . $iconpath . '" ' . $leagueinfo['logo_size_html']
			  . ' alt="' . $leagueinfo['league_name'] . '" border="0" />';
	}
	else
	{
		$icon = '';
	}

	return $icon;
}

/**
 * bestimmung der spieltagsbezeichnung aus einer matchdaytype-id
 *
 * @staticvar array array a-z (fuer 'Gruppe A' etc)
 * @param int $matchday spieltag
 * @param string $phraseid phrase fuer spieltag
 * @return string bezeichnung des spieltags
 * @see fetch_soccer_matchdayinfo(), construct_soccer_matchdayjump()
 */
function construct_soccer_matchday_phrase($matchday=0, $phraseid='')
{
	static $alpha;

	if (isset($GLOBALS['vbphrase']['soccer_' . $phraseid]))
	{
		$matchdayphrase = $GLOBALS['vbphrase']['soccer_' . $phraseid];

		switch ($phraseid)
		{
			case 'matchday_x': // 1. Spieltag, 2. Spieltag, ...
			case 'round_x':    // Runde 1, Runde 2, ...
				return construct_phrase($matchdayphrase, $matchday);
				break;
			case 'group_alpha_x': // Gruppe A, Gruppe B, ...
				if (empty($alpha))
				{
					$alpha = range('A', 'Z'); // A = 0! B = 1...
				}
				return construct_phrase($matchdayphrase, $alpha[($matchday-1)]);
				break;
			default:
				return $matchdayphrase;
				break;
		}
	}
	else
	{
		return construct_phrase($vbphrase['soccer_round_x'], $matchday);
	}
}

/**
 * spieltags-auswahlbox (html)
 *
 * @param int $selected gewaehlter spieltag
 * @return string html-code fuer auswahlbox
 */
function construct_soccer_matchdayjump($selected=0)
{
	$matchdayinfo = fetch_soccer_matchdayinfo();

	if ($selected == 0)
	{
		// wenn GPC[m] nicht angegeben, dann aktuellen spieltag auswaehlen
		$selected = $GLOBALS['todaymatchday'];
	}

	if ($selected > $GLOBALS['lastmatchday'])
	{
		// wenn GPC[m] groesser als letzter spieltag, dann letzten spieltag
		// auswaehlen
		$selected = $GLOBALS['lastmatchday'];
	}

	if ($selected < $GLOBALS['firstmatchday'])
	{
		// wenn GPC[m] kleiner als erster spieltag, dann ersten spieltag
		// auswaehlen
		$selected = $GLOBALS['firstmatchday'];
	}

	$GLOBALS['currentmatchday'] = $selected;
	$matchday_options = '';

	if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'ranking')
	{
		$optionvalue = 0;
		$optiontitle = htmlspecialchars_uni($GLOBALS['vbphrase']['soccer_latestranking']);

		if (!empty($GLOBALS['show']['latestranking']))
		{
			$optionselected = ' selected="selected"';
			$optionclass = 'fjsel';
			$selected = 0;
		}
		else
		{
			$optionselected = '';
			$optionclass = 'fjdpth0';
		}
		eval('$matchday_options .= "' . fetch_template('option') . '";');
	}

	$groupnames = array();

	foreach ($matchdayinfo AS $group => $matchday)
	{
		$options = '';
		$matchdayclass = ($group == '' ? 'fjdpth0' : 'fjdpth1');

		if ($group != '')
		{
			$groupnames[$group] = construct_soccer_matchday_phrase(0, $group);
		}

		foreach ($matchday AS $optionvalue => $optiontitle)
		{
			$GLOBALS['matchdayinfos'][$optionvalue]['matchdayname'] = $optiontitle;
			$GLOBALS['matchdayinfos'][$optionvalue]['matchgroupname'] = $groupnames[$group];
			$optionclass = ($optionvalue == $selected ? 'fjsel' : $matchdayclass);
			$optionselected = ($optionvalue == $selected ? ' selected="selected"' : '');

			if ($GLOBALS['todaymatchday'] == $optionvalue)
			{
				// aktuellen spieltag hervorheben
				$optionclass .= '" style="font-weight: bold';
			}
			eval('$options .= "' . fetch_template('option') . '";');
		}


		// wenn $group ein leerer string ist, dann spieltag auf oberster ebene
		// als ungruppierte option abbilden
		if ($group == '')
		{
			$matchday_options .= $options;
		}
		else
		{
			// $group ist der phrasenkey fuer optiongroup-titel
			// spieltage gruppieren
			$optgroup_options = $options;
			$optgroup_label   = $groupnames[$group];
			eval('$matchday_options .= "' . fetch_template('optgroup') . '";');
		}
	}

	return '<select name="m" id="m" onchange="this.form.submit();">' . $matchday_options . '</select>';
}

/**
 * status der buttons neben spieltags-auswahl (aktiviert, nicht aktiviert)
 *
 * @param int $matchday gewaehlter spieltag
 * @return bool
 */
function fetch_soccer_prevnext_matchday($matchday)
{
	// beide buttons inaktiv
	$GLOBALS['show']['mdprev'] = false;
	$GLOBALS['show']['mdnext'] = false;

	if (empty($GLOBALS['lastmatchday']))
	{
		return false;
	}

	// vor- und zurueck-buttons in spieltagauswahl
	if ($matchday > 1)
	{
		$GLOBALS['show']['mdprev'] = true;
	}

	if ($matchday < $GLOBALS['lastmatchday'])
	{
		$GLOBALS['show']['mdnext'] = true;
	}

	return true;
}

/**
 * erstellt einen teil einer sql-abfrage fuer spieltagsgruppierungen
 *
 * @param void
 * @return string sql-string
 * @see fetch_soccer_matchdayinfo()
 */
function construct_soccer_sql_matchdaygroups()
{
	// keine gruppierung vorgesehen
	if (!isset($GLOBALS['leagueinfo']['mdgrp']))
	{
		return "''";
	}

	// in gruppen und phrasen aufteilen 'gruppen;phrasen'
	$matchdaygroupsplit = explode(';', $GLOBALS['leagueinfo']['mdgrp']);

	// in spieltags-gruppen aufteilen (CASE-Expressions)
	$daygroups = explode(',', $matchdaygroupsplit[0]);

	if (empty($daygroups[0]))
	{
		// keine CASE-Expressions angegeben, keine spieltagsgruppierungen
		return "''";
	}

	if (isset($matchdaygroupsplit[1]))
	{
		// fuer die CASE-Expressions wurden phrasen-keys angegeben
		$phrasegroups = explode(',', $matchdaygroupsplit[1]);
	}

	$cases = array();

	foreach ($daygroups AS $group => $expression)
	{
		$groupname = isset($phrasegroups[$group]) ? $phrasegroups[$group] : '';

		$expression = str_replace(array('(lte)', '(gte)', '(lt)', '(gt)'),
								  array('<=', '>=', '<', '>'),
								  $expression);

		$cases[] = "WHEN `match_day` $expression THEN '$groupname'";
	}

	if (!empty($cases))
	{
		// case-when-expressions erstellen
		return "CASE " . implode("\n", $cases) . " ELSE '' END";
	}

	return "''";
}

/**
 * html-auswahlbox fuer aktionen
 *
 * @param string gewaehlte aktion
 * @return string html-code fuer aktionsmenue
 */
function construct_leagueaction_jump($selected='')
{
	// standard-aktion 'Tipps und Spiele' immer vorhanden
	$actions = array('bet' => $GLOBALS['vbphrase']['soccer_nav_bet']);

	if ($GLOBALS['leagueinfo']['showtable'])
	{
		// aktion 'Tabelle'
		$actions['tab'] = $GLOBALS['vbphrase']['soccer_nav_tab'];

		if (!in_array(strtolower($GLOBALS['leagueinfo']['sd_shortname']), array('wm', 'em', 'chl', 'eul')))
		{
			// aktion 'kreuztabelle'
			$actions['crosstab'] = $GLOBALS['vbphrase']['soccer_nav_crosstab'];
		}

		if (isset($GLOBALS['vbulletin']->GPC['type']) AND $GLOBALS['vbulletin']->GPC['type'] == 'cross')
		{
			// kreuztabelle wurde angefordert ueber aktionsauswahl.
			if (!isset($actions['crosstab']))
			{
				// oh! die aktuell gewaehlte liga hat keine kreuztabellen!
				// hier wird die normale tabelle angezeigt. der aktionswaehler
				// muss hier ebenfalls auf 'Tabelle' geaendert werden:
				$selected = 'tab';
			}
			else
			{
				$selected = 'crosstab';
			}
		}
	}

	// aktion 'rangliste' immer vorhanden
	$actions['ranking'] = $GLOBALS['vbphrase']['soccer_nav_ranking'];

	$options = '';

	// auswahlbox erstellen
	foreach ($actions AS $optionvalue => $optiontitle)
	{
		$optionselected = ($optionvalue == $selected ? ' selected="selected"' : '');
		$optionclass = ($optionselected != '' ? 'fjsel' : 'fjdpth0');
		eval('$options .= "' . fetch_template('option') . '";');
	}

	return '<select name="do" onchange="this.form.submit();">' . $options . '</select>';
}

/**
 * liefert alle nicht anzuzeigenden ligen basierend auf dem liga-typ
 *
 * @return array auszublendende ligen
 */
function fetch_invisible_leagues()
{
	$return = array();

	if (!empty($GLOBALS['vbsoccerprefs']['lhide']))
	{
		// auszublendende ligen ermitteln
		foreach ($GLOBALS['vbulletin']->vbsoccer_leaguecache['current'] AS $leagueid)
		{
			if (in_array(strtolower($GLOBALS['vbulletin']->vbsoccer_leaguecache[$leagueid]['sd_shortname']), $GLOBALS['vbsoccerprefs']['lhide']))
			{
				$return[$leagueid] = $leagueid;
			}
		}
	}

	return $return;
}
