<?php
/**
 * vbulletin add-on fussball-tippspiele
 *
 * php version 5
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @author  xwing <xwing@geb-team.de>
 * @version SVN: $Id: vbsoccer_livedata.php 6608 2009-10-27 20:03:14Z aa $
 */

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE & ~8192);

if (!is_object($vbulletin->db))
{
	exit;
}

$db =& $vbulletin->db;

/** vbsoccer functions */
require_once DIR . '/includes/functions_vbsoccer.php';

@ignore_user_abort(true);

if (!defined('TIMENOW'))
{
	/** @ignore */
	define('TIMENOW', time());
}

$dt = new DateTime();

// ermitteln der wettbewerbe mit aktuellem jahr im saison-string
$leagues = $db->query_read_slave("
	SELECT id, sd_id, sd_lastupdate
	FROM `" . TABLE_PREFIX . "soccer_league`
	WHERE `visible`=1 AND `sd_saison` LIKE '%" . $dt->format('Y') . "%'
	");

$leagueinfos = array();

while (($league = $db->fetch_array($leagues)))
{
	$leagueinfos[$league['sd_id']] = $league;
}

$db->free_result($leagues);

if (empty($leagueinfos))
{
	$sd_data = array();

	// keine aktuellen spiele gefunden. cronjob wieder deaktivieren!
	if ((defined('VB_AREA') AND VB_AREA == 'AdminCP') OR
		(defined('IN_CONTROL_PANEL') AND IN_CONTROL_PANEL === true))
	{
		// achtung, nicht wenn der job manuell aus dem acp gestartet wurde!
	}
	else
	{
		$db->query_write("
			UPDATE `" . TABLE_PREFIX . "cron`
			SET `minute`='0', `hour`=0, `nextrun`=0, `active`=0
			WHERE `varname`='vbsoccer_livedata'
			");

		$jobdisabled = true;
	}
}
else
{
	// vom datendienst die zeitstempel der letzten aenderungen an den wettbewerben
	// abholen (id => lastupdate)
	$sd_data = soccer_fetch_changed_leagues(array_keys($leagueinfos));
}

$changedLeagues = array();

foreach ($sd_data as $sd_id => $lastupdate)
{
	if (isset($leagueinfos[$sd_id]))
	{
		if ($leagueinfos[$sd_id]['sd_lastupdate'] == $lastupdate)
		{
			// keine aenderung am wettbewerb (ansetzung oder ergebnisse) seit
			// letzter anfrage.
			unset($leagueinfos[$sd_id]);
		}
		else
		{
			$changedLeagues[$sd_id] = $leagueinfos[$sd_id]['id'];
		}
	}
}


if (!empty($changedLeagues))
{
	$matches = $db->query_read_slave("
		SELECT `id` AS matchid, `sd_id` AS id, `sd_lastupdate` AS lu, `dateline` AS dt,
			`points_home` AS s1, `points_away` AS s2, `match_is_finished` AS fi,
			`league_id`
		FROM `" . TABLE_PREFIX . "soccer_match`
		WHERE `dateline` BETWEEN (" . TIMENOW . "-28800) AND (" . TIMENOW . "+28800)
			AND `league_id` IN(" . implode(',', $changedLeagues) . ")
		");

	$matchinfos = array();
	$matchlogdata = array();
	$matchLeagues = array();

	while (($match = $db->fetch_array($matches)))
	{
		$matchlogdata[$match['id']] = $match['matchid'];
		$matchLeagues[$match['id']] = $match['league_id'];

		unset($match['matchid'], $match['league_id']);

		$match = array_map('intval', $match);
		$matchinfos[$match['id']] = $match;
	}

	$db->free_result($matches);
}

$availfixtures = array();
$matchleagues = array();
$outdatedLeagues = array();

if (!empty($matchinfos))
{
	try
	{
		$client = soccerDataClient();
		$params = new stdClass;
		$params->matches = array_keys($matchinfos);
		$params = serialize($params);

		$fixtures = $client->latestResults($params);

		foreach ($fixtures as $id => $obj)
		{
			if ($obj->lu == $matchinfos[$obj['id']]['lu'])
			{
				// keine aenderungen vorhanden!
				continue;
			}

			$obj['fi'] = (int) $obj['fi'];
			$matchleagues[$obj['id']] = $obj['l'];
			unset($obj['t1'], $obj['t2'], $obj['md'], $obj['mdph'], $obj['mdphid'], $obj['l']);
			$availfixtures[$obj['id']] = (array) $obj;
			unset($luObj, $dtObj);
		}

		unset($fixtures);
	}
	catch (Exception $e)
	{
		$availfixtures = array();

		if ((defined('VB_AREA') AND VB_AREA == 'AdminCP') OR
			(defined('IN_CONTROL_PANEL') AND IN_CONTROL_PANEL === true))
		{
			printf('<pre>EXCEPTION: %s</pre>', $e->getMessage());
		}
	}
}

foreach ($availfixtures as $id => $val)
{
	$diff = array_diff_assoc($val, $matchinfos[$id]);

	if (!empty($diff))
	{

		$sql = array();
		if (isset($diff['dt']))
		{
			$sql[] = "`dateline`=". (int) $val['dt'] ."";
		}
		if (isset($diff['lu']))
		{
			$sql['sdlu'] = "`sd_lastupdate`=". (int) $val['lu'] ."";
			$sql['lut'] = "`last_update_timestamp`=`sd_lastupdate`";
		}

		if (isset($diff['s1']) or isset($diff['s2']))
		{
			// ergebnisabweichung!
			//
			// wenn auf datendienst mindestens ein home- oder away-tor groesser
			// ist, oder auf dem datendienst das spiel als beendet markiert ist,
			// dann das ergebnis von datendienst uebernehmen
			if (($val['fi'] == 1 AND ($matchinfos[$id]['dt'] + (105*60)) < TIMENOW) OR
				($val['s1'] > $matchinfos[$id]['s1']) OR
				($val['s2'] > $matchinfos[$id]['s2']))
			{
				$sql['s1'] = "`points_home`=" . (int) $val['s1'] . "";
				$sql['s2'] = "`points_away`=" . (int) $val['s2'] . "";
			}

			if (($val['s1'] != -1 AND $val['s1'] > $matchinfos[$id]['s1']) OR
				($val['s2'] != -1 AND $val['s2'] > $matchinfos[$id]['s2']))
			{
				// aenderung durch datendienst ins log schreiben!
				// dies wird angezeigt in der live-ansicht

				$postresult = $val['s1'] . ':' . $val['s2'];

				$postresultresult = $db->query_write("
					INSERT DELAYED INTO `" . TABLE_PREFIX . "soccer_postresult_log`
					SET `userid`=0,
						`match_id`=" . $matchlogdata[$val['id']] . ",
						`dateline`=" . TIMENOW . ",
						`result`='" . $db->escape_string($postresult) . "',
						`finished`=" . (int) $val['fi'] . ",
						`ipaddress`=''
				");
			}
		}

		if (isset($diff['fi']))
		{
			// spiel-abpfiff ist abweichend!
			//
			// wenn local der wert 2 eingetragen wurde, gilt das spiel lokal als
			// abgepfiffen. wenn der datendienst den wert 1 sendet, ist das spiel
			// in jedem fall beendet, wenn 120 minuten nach anpfiff vergangen sind
			if ($val['fi'] == 1 AND ($matchinfos[$id]['dt'] + (105*60)) < TIMENOW)
			{
				$sql['sdlu'] = "`sd_lastupdate`=". (int) $val['lu'] ."";
				$sql['lut']  = "`last_update_timestamp`=`sd_lastupdate`";
				$sql['fin']  = "`match_is_finished`=1";
			}
		}

		if ((int) $val['dt'] == VBSOCCER_DEFERRED)
		{
			// spiel wurde abgesagt / verschoben / abgebrochen
			// alle bisherigen eintragungen ueberschreiben
			$sql['fin'] = "`match_is_finished`=0";
			$sql['s1']  = "`points_home`=-1";
			$sql['s2']  = "`points_away`=-1";
		}

		if (!empty($sql))
		{
			// "gewinnschluessel" am ende des queries setzen
			$sql[] = "`score_key`=CASE"
				   . " WHEN `points_home`=-1 AND `points_away`=-1 THEN 0"
				   . " WHEN `points_home`=`points_away` THEN 2"
				   . " WHEN `points_home`>`points_away` THEN 1"
				   . " WHEN `points_home`<`points_away` THEN 3"
				   . " END";

			// aenderungen am spiel speichern
			$db->query_write("
				UPDATE `" . TABLE_PREFIX . "soccer_match`
				SET " . implode(',', $sql) . "
				WHERE `sd_id`=" . $val['id'] . "
				");

			$outdatedLeagues[] = $matchleagues[$val['id']];
		}
	}
}

if (!empty($outdatedLeagues))
{
	$outdatedLeagues = array_unique($outdatedLeagues);

	foreach ($outdatedLeagues AS $sd_id)
	{
		$saison_rankings = construct_saison_rankings($changedLeagues[$sd_id]);

		$db->query_write("
		UPDATE `" . TABLE_PREFIX . "soccer_league`
		SET `x_ranking`='" . $db->escape_string($saison_rankings) . "',
			`sd_lastupdate`=UNIX_TIMESTAMP()
		WHERE `id`=" . $changedLeagues[$sd_id] . "
		");
	}
}


// naechste ausfuehrung des cronjobs fuer ansetzungen ermitteln
if (empty($jobdisabled))
{
	$result = $db->query_first("
		SELECT `nextrun`
		FROM `" . TABLE_PREFIX . "cron`
		WHERE `varname`='vbsoccer_fixtures'
		");

	if ($result['nextrun'] == 0)
	{
		$result['nextrun'] = TIMENOW;
	}

	// pruefen, ob es nicht beendete spiele vor dem naechsten job gibt
	if (!$db->query_first("
		SELECT *
		FROM `" . TABLE_PREFIX . "soccer_match`
		WHERE `match_is_finished` IN(0,2) AND `dateline`<" . $result['nextrun'] . "
		"))
	{
		// livejob kann gestoppt werden. er wird beim naechsten lauf des fixtures-
		// jobs bei bedarf wieder aktiviert
		$db->query_write("
			UPDATE `" . TABLE_PREFIX . "cron`
			SET `minute`='0', `hour`=0, `nextrun`=0, `active`=0
			WHERE `varname`='vbsoccer_livedata'
			");
	}
}

if (!empty($outdatedLeagues))
{
	build_leagues_datastore();
}
