<?php
/**
 * vbulletin add-on fussball-tippspiele
 *
 * php version 5
 *
 * @package vbsoccer
 * @author  aa    <aa@geb-team.de>
 * @author  xwing <xwing@geb-team.de>
 * @version SVN: $Id: vbsoccer_admin.php 6828 2010-03-26 13:11:45Z aa $
 */

error_reporting(E_ALL & ~E_NOTICE & ~8192);
@set_time_limit(0);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
/** version */
define('CVS_REVISION', '$Id: vbsoccer_admin.php 6828 2010-03-26 13:11:45Z aa $');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('vbsoccer', 'cpsoccer', 'vbsoccernames');

if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'diag')
{
	$phrasegroups[] = 'diagnostic';
}

$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
/** vbulletin back end */
require './global.php';

/** addon functions */
require DIR . '/includes/functions_vbsoccer.php';

// #############################################################################
// ############################ START MAIN SCRIPT ##############################
// #############################################################################

// #############################################################################
if (isset($_POST['do']) and $_POST['do'] == 'killgroup')
{
	$vbulletin->input->clean_gpc('p', 'groupid', TYPE_UINT);

	if (empty($vbulletin->GPC['groupid']))
	{
		print_stop_message('nothing_to_do');
	}

	$db->query_write("
		DELETE FROM `" . TABLE_PREFIX . "soccer_league_group`
		WHERE groupid=" . $vbulletin->GPC['groupid'] . "
		");

	$db->query_write("
		UPDATE `" . TABLE_PREFIX . "soccer_league`
		SET groupid=0
		WHERE groupid=" . $vbulletin->GPC['groupid'] . "
		");

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "phrase
		WHERE product='vbsoccer' AND `varname`='soccer_navgroup_" . $vbulletin->GPC['groupid'] . "'
		");

	require DIR . '/includes/adminfunctions_language.php';
	build_language();

	build_leagues_datastore();

	/** @ignore */
	define('CP_REDIRECT', 'vbsoccer_admin.php?do=groups');
	print_stop_message('deleted_group_successfully');
}

// #############################################################################
if (isset($_POST['do']) and $_POST['do'] == 'killleague')
{
	$vbulletin->input->clean_gpc('p', 'leagueid', TYPE_UINT);

	if (empty($vbulletin->GPC['leagueid']))
	{
		print_stop_message('nothing_to_do');
	}

	$leagueinfo = $db->query_first_slave("
		SELECT *
		FROM `" . TABLE_PREFIX . "soccer_league`
		WHERE `id`=" . $vbulletin->GPC['leagueid'] . "
		");

	if (!empty($leagueinfo['logo']))
	{
		@unlink(DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/league/' . $leagueinfo['logo']);
	}

	$db->query_write("
		DELETE FROM `" . TABLE_PREFIX . "soccer_league`
		WHERE `id`=" . $vbulletin->GPC['leagueid'] . "
		");

	$db->query_write("
		DELETE FROM `" . TABLE_PREFIX . "soccer_match`
		WHERE `league_id`=" . $vbulletin->GPC['leagueid'] . "
		");

	$db->query_write("
		DELETE FROM `" . TABLE_PREFIX . "soccer_league_team`
		WHERE `league_id`=" . $vbulletin->GPC['leagueid'] . "
		");

	$rebuildphrases = false;

	// alle team-logos von teams loeschen, die keiner liga zugeordnet sind
	$teams = $db->query_read("
		SELECT `logo`, CONCAT('soccer_team_', `sd_id`) `varname`
		FROM `" . TABLE_PREFIX . "soccer_team`
		WHERE `id` NOT IN (SELECT `team_id` FROM `" . TABLE_PREFIX . "soccer_league_team`)
		");

	while ($teaminfo = $db->fetch_array($teams))
	{
		if ($teaminfo['logo'] != '')
		{
			@unlink(DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/team/' . $teaminfo['logo']);
		}
		// teamphrasen von teams loeschen, die keiner liga mehr zugeordnet sind
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "phrase
			WHERE product='vbsoccer' AND `varname`='" . $db->escape_string($teaminfo['varname']) . "'
			");
		$rebuildphrases = true;
	}



	// ligatyp-phrasen loeschen, wenn ligatyp nicht mehr vorhanden ist
	$leaguetype = vbstrtolower($leagueinfo['sd_shortname']);

	if (!($leaguetypes = $db->query_first("
		SELECT *
		FROM `" . TABLE_PREFIX . "soccer_league`
		WHERE `sd_shortname` LIKE '" . $db->escape_string($leaguetype) . "'
		")))
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "phrase
			WHERE product = 'vbsoccer' AND `varname`='soccer_leaguetype_" . $db->escape_string($leaguetype) . "'
			");
		$rebuildphrases = true;
	}

	// teams loeschen, die keiner liga mehr zugeordnet sind
	$db->query_write("
		DELETE FROM `" . TABLE_PREFIX . "soccer_team`
		WHERE `id` NOT IN (SELECT `team_id` FROM `" . TABLE_PREFIX . "soccer_league_team`)
		");

	// spieltagtypen loeschen, die keinem spiel zugeordnet sind
	$db->query_write("
		DELETE FROM `" . TABLE_PREFIX . "soccer_matchtype`
		WHERE `matchtype_id` NOT IN (SELECT `matchtype_id` FROM `" . TABLE_PREFIX . "soccer_match`)
		");

	// tips loeschen, die keinem spiel zugeordnet sind
	$db->query_write("
		DELETE FROM `" . TABLE_PREFIX . "soccer_user_bet`
		WHERE `match_id` NOT IN (SELECT `id` FROM `" . TABLE_PREFIX . "soccer_match`)
		");

	if ($rebuildphrases)
	{
		require DIR . '/includes/adminfunctions_language.php';
		build_language();
	}

	build_leagues_datastore();

	/** @ignore */
	define('CP_REDIRECT', 'vbsoccer_admin.php?do=leagues');
	print_stop_message('deleted_league_successfully');
}

// #############################################################################
if (isset($_POST['do']) and $_POST['do'] == 'importleague')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'sd_id'      => TYPE_UINT,
		'activate'   => TYPE_BOOL,
		'nextimport' => TYPE_BOOL,
	));

	if (empty($vbulletin->GPC['sd_id']))
	{
		print_stop_message('nothing_to_do');
	}

	if ($db->query_first("
		SELECT *
		FROM `" . TABLE_PREFIX . "soccer_league`
		WHERE `sd_id`=" . $vbulletin->GPC['sd_id'] . "
		"))
	{
		print_stop_message('soccer_league_exists');
	}

	// aktionen ausfuehren, auch wenn benutzer den vorgang abbricht oder die
	// seite schliesst etc...
	@ignore_user_abort(true);

	// ligainformationen abholen
	$leagueinfo = fetch_sd_leagues($vbulletin->GPC['sd_id']);

	if (empty($leagueinfo))
	{
		/**
		 * redirect
		 * @ignore
		 */
		define('CP_REDIRECT', 'vbsoccer_admin.php?do=leagues');
		print_stop_message('invalid_action_specified');
	}

	// spielansetzungen der liga abholen
	$matchinfo = fetch_sd_matchdata($vbulletin->GPC['sd_id']);

	if (empty($matchinfo))
	{
		print_stop_message('soccer_no_matches_found');
	}

	// initialisierungen
	$matchdays = $matchdata = array();

	foreach ($matchinfo as $val)
	{
		$matchdays[$val['md']] = $val['md'];
		$matchdata[$val['id']] = $val;
	}

	// teamdaten abholen
	$teamdata = fetch_sd_teamdata($vbulletin->GPC['sd_id']);

	if (empty($teamdata))
	{
		print_stop_message('soccer_no_teams_found');
	}

	// liga speichern
	if (is_string($leagueinfo['lu']))
	{
		$lastupdate       = new DateTime($leagueinfo['lu']);
		$leagueinfo['lu'] = $lastupdate->format('U');
		unset($lastupdate);
	}

	$db->query_write("
		INSERT INTO `" . TABLE_PREFIX . "soccer_league`
		SET `sd_id`            = " . (int) $leagueinfo['id'] . ",
			`sd_shortname`     ='" . $db->escape_string($leagueinfo['sn']) . "',
			`sd_homepage`      ='" . $db->escape_string($leagueinfo['hp']) . "',
			`showtable`        ='" . $db->escape_string($leagueinfo['tab']) . "',
			`sd_saison`        ='" . $db->escape_string($leagueinfo['s']) . "',
			`sd_relegation`    ='" . $db->escape_string($leagueinfo['rel']) . "',
			`sd_sent_back_down`='" . $db->escape_string($leagueinfo['down']) . "',
			`sd_called_up`     ='" . $db->escape_string($leagueinfo['up']) . "',
			`sd_lastupdate`    ='" . $db->escape_string($leagueinfo['lu']) . "',
			`mdgrp`            ='" . $db->escape_string($leagueinfo['mdgrp']) . "',
			`mdp`              ='" . $db->escape_string($leagueinfo['mdp']) . "',
			`region`           ='" . $db->escape_string($leagueinfo['reg']) . "'
		");

	// id der neuen liga
	$league_id = $db->insert_id();

	// alte saisons dieser liga archivieren
	if (!empty($vbulletin->GPC['activate']))
	{
		$oldleagues = $db->query_read("
			SELECT `id`, `visible`
			FROM `" . TABLE_PREFIX . "soccer_league`
			WHERE `sd_shortname` LIKE '" . $db->escape_string($leagueinfo['sn']) . "'
				AND `sd_saison`<'" . $db->escape_string($leagueinfo['s']) . "'
			");

		while ($oldleague = $db->fetch_array($oldleagues))
		{
			if ($oldleague['visible'] == 1)
			{
				// alte saison ins archiv, wenn diese im mainmenue angezeigt wird
				$db->query_write("
					UPDATE `" . TABLE_PREFIX . "soccer_league`
					SET visible=-1
					WHERE id=" . $oldleague['id'] . "
					");
			}
		}

		$db->free_result($oldleagues);

		if (!($newerleagues = $db->query_first("
			SELECT `id`, `visible`
			FROM `" . TABLE_PREFIX . "soccer_league`
			WHERE `sd_shortname` LIKE '" . $db->escape_string($leagueinfo['sn']) . "'
				AND `sd_saison`>'" . $db->escape_string($leagueinfo['s']) . "'
			")))
		{
			$db->query_write("
				UPDATE `" . TABLE_PREFIX . "soccer_league`
				SET visible=1
				WHERE id=" . $league_id . "
				");
		}
	}

	// liganamen haben immer das format "^name saison$".
	// basisname extrahieren und als custom phrase speichern
	$leaguetypename = preg_replace(array('/\/\d{4}/', '/\d{4}/'), array('', ''), $leagueinfo['name']);

	// kurzname der liga fuer phrasen_key aufbereiten
	$leaguetype = strtolower($leagueinfo['sn']);

	// name der liga als custom-phrase speichern
	$db->query_write("
		REPLACE INTO `" . TABLE_PREFIX . "phrase`
			(`languageid`, `fieldname`, `varname`, `text`, `product`, `username`, `dateline`, `version`)
		VALUES (
			0,
			'vbsoccernames',
			'" . $db->escape_string('soccer_leaguetype_' . $leaguetype) . "',
			'" . $db->escape_string(trim($leaguetypename)) . "',
			'vbsoccer',
			'" . $db->escape_string($vbulletin->userinfo['username']) . "',
			" . TIMENOW . ",
			'" . $db->escape_string($vbulletin->options['templateversion']) . "')
		");

	// navigationsgruppe automatisch setzen, wenn eine liga gleichen types
	// bereits vorhanden und einer gruppe zugeordnet ist
	if (($navgroup = $db->query_first("
		SELECT `groupid`, `displayorder`
		FROM `" . TABLE_PREFIX . "soccer_league`
		WHERE `sd_shortname` LIKE '" . $db->escape_string($leagueinfo['sn']) . "'
			AND `sd_id`!= " . (int) $leagueinfo['id'] . "
		")))
	{
		$db->query_write("
			UPDATE `" . TABLE_PREFIX . "soccer_league`
			SET `groupid`=" . $navgroup['groupid'] . ",
				`displayorder`=" . $navgroup['displayorder'] . "
			WHERE `sd_id`=" . (int) $leagueinfo['id'] . "
			");
	}
	else
	{
		$result = $db->query_first("
			SELECT MAX(`displayorder`) AS `lastorderpos`
			FROM `" . TABLE_PREFIX . "soccer_league`
			WHERE `sd_id`!= " . (int) $leagueinfo['id'] . "
			");

		$db->query_write("
			UPDATE `" . TABLE_PREFIX . "soccer_league`
			SET `displayorder`=" . ((int) $result['lastorderpos'] + 10) . "
			WHERE `sd_id`=" . (int) $leagueinfo['id'] . "
			");
	}

	// alle teams ermitteln, die bereits in einer anderen liga vorhanden sind
	$teamresult = $db->query_read("
		SELECT `id`, `sd_id`
		FROM `" . TABLE_PREFIX . "soccer_team`
		WHERE `sd_id` IN(" . implode(',', array_keys($teamdata)) . ")
		");

	$teampool = array();

	while (($row = $db->fetch_array($teamresult)))
	{
		$teampool[$row['sd_id']] = $row['id'];
	}

	$db->free_result($teamresult);

	$league_teams = array();

	foreach ($teamdata as $teamid => $teamvalue)
	{
		if (!isset($teampool[$teamid]))
		{
			// team existiert noch nicht
			$db->query_write("
				INSERT INTO `" . TABLE_PREFIX . "soccer_team`
				SET `sd_id`       = " . (int) $teamid . ",
					`sd_shortname`='" . $db->escape_string($teamvalue['sn']) . "',
					`sd_homepage` ='" . $db->escape_string($teamvalue['hp']) . "'
				");

			$teampool[$teamid] = $db->insert_id();

			// teamname als customphrase speichern (soccer_team_$id)
			$db->query_write("
				REPLACE INTO `" . TABLE_PREFIX . "phrase`
					(`languageid`, `fieldname`, `varname`, `text`, `product`, `username`, `dateline`, `version`)
				VALUES (
					0,
					'vbsoccernames',
					'" . $db->escape_string('soccer_team_' . (int) $teamid) . "',
					'" . $db->escape_string($teamvalue['name']) . "',
					'vbsoccer',
					'" . $db->escape_string($vbulletin->userinfo['username']) . "',
					" . TIMENOW . ",
					'" . $db->escape_string($vbulletin->options['templateversion']) . "')
				");
		}

		// sql-insert-strings fuer team/liga-verknuepfung
		$league_teams[] = "(" . $league_id . ", " . $teampool[$teamid] . ", " . $teamvalue['p'] . ")";
	}

	if (!empty($league_teams))
	{
		// teams der neuen liga zuordnen
		$db->query_write("
			REPLACE INTO `" . TABLE_PREFIX . "soccer_league_team`
			(`league_id`, `team_id`, `points`)
			VALUES " . implode(',', $league_teams) . "
			");
	}

	$sqldata = $matchtypes = array();

	foreach ($matchdata as $matchid => $data)
	{
		$matchtypes[$data['mdphid']] = "(" . (int) $data['mdphid'] . ",'" . $db->escape_string($data['mdph']) . "')";
		$values = array('sd_id' => $data['id']);

		if (is_string($data['lu']))
		{
			$lastupdate              = new DateTime($data['lu']);
			$values['sd_lastupdate'] = $lastupdate->format('U');
		}
		else
		{
			$values['sd_lastupdate'] = $data['lu'];
		}

		if (is_string($data['dt']))
		{
			$dateline           = new DateTime($data['dt']);
			$values['dateline'] = $dateline->format('U');
		}
		else
		{
			$values['dateline'] = $data['dt'];
		}

		$values['match_day']         = $data['md'];
		$values['matchtype_id']      = $data['mdphid'];
		$values['match_is_finished'] = (int) $data['fi'];
		$values['points_home']       = (int) $data['s1'];
		$values['points_away']       = (int) $data['s2'];

		$values['league_id']         = $league_id;
		$values['team_home_id']      = $teampool[$data['t1']];
		$values['team_away_id']      = $teampool[$data['t2']];
		$values['score_key']         = fetch_soccer_score_key((int) $data['s1'], (int) $data['s2']);

		$sqldata[] = implode(', ', $values);
	}

	if (!empty($sqldata) and !empty($values))
	{
		$fields = '`' . implode('`,`', array_keys($values)) . '`';

		$db->query_write("
			INSERT INTO `" . TABLE_PREFIX . "soccer_match`
			(" . $fields . ")
			VALUES (" . implode('), (', $sqldata) . ")
			");
	}

	if (!empty($matchtypes))
	{
		$db->query_write("
			INSERT IGNORE INTO `" . TABLE_PREFIX . "soccer_matchtype`
			(`matchtype_id`, `phrase_id`)
			VALUES " . implode(',', $matchtypes) . "
			");
	}

	// datastore fuer ligen neu erzeugen
	build_leagues_datastore();

	/** language tools */
	require DIR . '/includes/adminfunctions_language.php';

	// datastore fuer phrasen neu erstellen
	build_language();

	/**
	 * redirect
	 * @ignore
	 */
	define('CP_REDIRECT', 'vbsoccer_admin.php?do=leagues');
	print_stop_message('soccer_league_import_successfully', htmlspecialchars_uni($leagueinfo['name']));
}

// #############################################################################
if (isset($_POST['do']) and $_POST['do'] == 'leaguedisplayorder')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'league_order' => TYPE_ARRAY_STR,
	));

	foreach ($vbulletin->GPC['league_order'] AS $type => $displayorder)
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "soccer_league SET
				displayorder =  " . intval($displayorder) . "
			WHERE sd_shortname LIKE '" . $db->escape_string($type) . "'
		");
	}

	build_leagues_datastore();

	/**
	 * redirect
	 * @ignore
	 */
	define('CP_REDIRECT', 'vbsoccer_admin.php?do=leagues');
	print_stop_message('saved_display_order_successfully');
}

// #############################################################################
if (isset($_POST['do']) and $_POST['do'] == 'groupdisplayorder')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'group_order' => TYPE_ARRAY_STR,
	));

	foreach ($vbulletin->GPC['group_order'] AS $id => $displayorder)
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "soccer_league_group
			SET displayorder =  " . intval($displayorder) . "
			WHERE groupid = " . intval($id) . "
		");
	}

	build_leagues_datastore();

	/**
	 * redirect
	 * @ignore
	 */
	define('CP_REDIRECT', 'vbsoccer_admin.php?do=groups');
	print_stop_message('saved_display_order_successfully');
}

// #############################################################################
if (isset($_POST['do']) and $_POST['do'] == 'addgroup')
{
	$vbulletin->input->clean_gpc('p', 'name', TYPE_STR);
	define('CP_REDIRECT', 'vbsoccer_admin.php?do=groups');

	if (trim($vbulletin->GPC['name']) == '')
	{
		print_stop_message('invalid_action_specified');
	}

	$result = $db->query_first("
		SELECT MAX(displayorder) AS lastorder
		FROM `" . TABLE_PREFIX . "soccer_league_group`
		");

	$order = (int) $result['lastorder'] + 10;

	$db->query_write("
		INSERT INTO `" . TABLE_PREFIX . "soccer_league_group`
		SET displayorder=" . $order . "
		");

	$groupid = $db->insert_id();

	// gruppe als customphrase speichern (soccer_navgroup_$id)
	$db->query_write("
		REPLACE INTO `" . TABLE_PREFIX . "phrase`
			(`languageid`, `fieldname`, `varname`, `text`, `product`, `username`, `dateline`, `version`)
		VALUES (
			0,
			'vbsoccernames',
			'" . $db->escape_string('soccer_navgroup_' . (int) $groupid) . "',
			'" . $db->escape_string(trim($vbulletin->GPC['name'])) . "',
			'vbsoccer',
			'" . $db->escape_string($vbulletin->userinfo['username']) . "',
			" . TIMENOW . ",
			'" . $db->escape_string($vbulletin->options['templateversion']) . "')
		");

	/** language tools */
	require DIR . '/includes/adminfunctions_language.php';

	// datastore fuer phrasen neu erstellen
	build_language();

	print_stop_message('soccergroup_added_successfully');
}

// #############################################################################
if ($_REQUEST['do'] == 'groups')
{
	// count teams
	$countteams = $db->query_first("
		SELECT COUNT(*) AS `total`
		FROM `" . TABLE_PREFIX . "soccer_team`"
	);

	if ((int) $countteams['total'] == 0)
	{
		print_cp_redirect('vbsoccer_admin.php?do=leagues');
	}

	print_cp_header($vbphrase['soccer_navgroups']);

	$navgroups = $db->query_read("
		SELECT navgroup.*, masterphrase.text AS navgroup_name
		FROM `" . TABLE_PREFIX . "soccer_league_group` AS navgroup,
			 `" . TABLE_PREFIX . "phrase` AS masterphrase
		WHERE masterphrase.languageid=0 AND masterphrase.fieldname='vbsoccernames' AND masterphrase.varname=CONCAT('soccer_navgroup_', navgroup.groupid)
		ORDER BY `displayorder`, `navgroup_name`
		");

	if ($db->num_rows($navgroups))
	{
		print_form_header('vbsoccer_admin', 'groupdisplayorder', false, true, 'cpform1');
		print_table_header($vbphrase['soccer_navgroups'], 3);
		print_description_row($vbphrase['if_you_change_display_order'], 0, 3);
		print_cells_row(array($vbphrase['soccer_navgroup'], $vbphrase['display_order'], $vbphrase['options']), true);

		$trans_link = "phrase.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&fieldname=vbsoccernames&t=1&varname=";

		while (($navgroup = $db->fetch_array($navgroups)))
		{
			$options = array(
				construct_link_code($vbphrase['translations'], $trans_link . 'soccer_navgroup_' . $navgroup['groupid'], 1),
				construct_link_code($vbphrase['delete'], 'vbsoccer_admin.php?do=deletegroup&amp;groupid=' . $navgroup['groupid']),
				);

			print_cells_row(array(
				htmlspecialchars_uni($vbphrase['soccer_navgroup_' . $navgroup['groupid']]),
				'<input type="text" size="3" class="bginput" name="group_order[' . $navgroup['groupid'] . ']" value="' . $navgroup['displayorder'] . '" />',
				'<div style="white-space:nowrap;">' . implode(' | ', $options) . '</div>',
				));
		}
		print_submit_row($vbphrase['save_display_order'], '_default_', 3);
	}

	print_form_header('vbsoccer_admin', 'addgroup', false, true, 'cpform2');
	print_table_header($vbphrase['soccer_addnavgroup']);
	print_description_row($vbphrase['soccer_navgroup_description']);
	print_input_row($vbphrase['title'], 'name');
	print_submit_row($vbphrase['save']);
	//print_table_footer();

	print_cp_footer();
}

// #############################################################################
if ($_REQUEST['do'] == 'deletegroup')
{
	$vbulletin->input->clean_gpc('r', 'groupid', TYPE_UINT);

	print_cp_header($vbphrase['soccer_navgroups']);
	echo "<p>&nbsp;</p><p>&nbsp;</p>";
	print_form_header('vbsoccer_admin', 'killgroup', 0, 1, 'deleteform', '75%');
	construct_hidden_code('groupid', $vbulletin->GPC['groupid']);
	print_table_header(construct_phrase($vbphrase['confirm_deletion_x'], $vbphrase['soccer_navgroup_' . $vbulletin->GPC['groupid']]));
	print_description_row("
		<blockquote><br />
		" . construct_phrase($vbphrase["are_you_sure_want_to_delete_group_x_y"], $vbphrase['soccer_navgroup_' . $vbulletin->GPC['groupid']], $vbulletin->GPC['groupid']) . "
		<br /></blockquote>\n\t");
	print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
	print_cp_footer();
}

// #############################################################################
if ($_REQUEST['do'] == 'leagues')
{
	print_cp_header($vbphrase['soccer_leagues_manager']);

	$leaguedisplay = array(0 => $vbphrase['no'],
						   1 => $vbphrase['yes'],
						  -1 => $vbphrase['archiv'],
						  -2 => $vbphrase['yes'],
						  );

	$status_icons  = array(0 => 'inactive.png',
						   1 => 'active.png',
						  -1 => 'archive.png',
						  -2 => 'readonly.png',
						  );

	// bereits importierte ligen auflisten
	$leagues = $db->query_read_slave("
		SELECT soccer_league.*, CONCAT('soccer_leaguetype_', LOWER(`sd_shortname`)) AS league_phrase,
			masterphrase.text AS league_name, IFNULL(navgroup.displayorder, 0) AS grouporder
		FROM (`" . TABLE_PREFIX . "soccer_league` AS soccer_league, `" . TABLE_PREFIX . "phrase` AS masterphrase)
		LEFT JOIN `" . TABLE_PREFIX . "soccer_league_group` AS navgroup ON(navgroup.groupid=soccer_league.groupid)
		WHERE masterphrase.languageid=0 AND masterphrase.fieldname='vbsoccernames' AND masterphrase.varname=CONCAT('soccer_leaguetype_', LOWER(`sd_shortname`))
		ORDER BY `sd_saison` DESC, `grouporder`, soccer_league.`displayorder`, `league_name`
		");

	if (($totalleagues = $db->num_rows($leagues)))
	{
		$colspan = 3;
		print_form_header('vbsoccer_admin', 'leaguedisplayorder');
		print_table_header($vbphrase['soccer_leagues_manager'], $colspan);
		print_description_row($vbphrase['if_you_change_display_order'], 0, $colspan);
		if (empty($optionheader))
		{
			print_cells_row(array(
				$vbphrase['soccer_league_displayname'],
				$vbphrase['display_order'] . ' / ' . $vbphrase['soccer_league_display'],
				$vbphrase['options']), true);

			$optionheader = 1;
		}
		$sortorderarray = array();
		while (($leagueinfo = $db->fetch_array($leagues)))
		{
			if (empty($oldsaison) or $oldsaison != $leagueinfo['sd_saison'])
			{
				print_table_header($leagueinfo['sd_saison'], $colspan);

			}

			$options = array(construct_link_code($vbphrase['edit'], 'vbsoccer_admin.php?do=editleague&amp;leagueid=' . $leagueinfo['id']),
							 construct_link_code($vbphrase['delete'], 'vbsoccer_admin.php?do=deleteleague&amp;leagueid=' . $leagueinfo['id']),
							 );

			if ($leagueinfo['logo'] != '')
			{
				if (preg_match('#width="(\d+)" height="(\d+)"#', $leagueinfo['logo_size_html'], $sizes))
				{
					unset($sizes[0]);
					$x = max($sizes) / 16;
					$leagueinfo['logo_size_html'] = ' width="' . ceil($sizes[1] / $x) . '" height="' . ceil($sizes[2] / $x) . '"';
				}
			}

			// saison
			$oldsaison = $leagueinfo['sd_saison'];

			$sortorderdisabled = (!empty($sortorderarray[$leagueinfo['sd_shortname']]) ? ' disabled="disabled"' : '');

			if ($leagueinfo['visible'] == 1 AND $leagueinfo['readonly'] == 1)
			{
				$leagueinfo['visible'] = -2;
			}

			print_cells_row(array(
				(isset($vbphrase[$leagueinfo['league_phrase']]) ? htmlspecialchars_uni($vbphrase[$leagueinfo['league_phrase']]) : htmlspecialchars_uni($leagueinfo['league_name']))
				. ($leagueinfo['groupid'] ? '<br /><i><small>' . htmlspecialchars_uni($vbphrase['soccer_navgroup_' . $leagueinfo['groupid']]) . '</small></i>' : ''),
				'<div style="white-space:nowrap;">' .
				'<input' . $sortorderdisabled . ' type="text" size="3" class="bginput" name="league_order[' . $leagueinfo['sd_shortname'] . ']" value="' . $leagueinfo['displayorder'] . '" />&nbsp;&nbsp;&nbsp;' .
				($leagueinfo['logo'] != '' ? '<img src="../'. $vbulletin->options['vbsoccer_imgdir'] .'/league/' . $leagueinfo['logo'] . '?' . TIMENOW . '"' . $leagueinfo['logo_size_html'] . ' alt=""/>' : '<img src="../'. $vbulletin->options['vbsoccer_imgdir'] . '/empty.png" alt=""/>') .
				' <img src="../'. $vbulletin->options['vbsoccer_imgdir'] .'/' . $status_icons[$leagueinfo['visible']] . '" alt="' . htmlspecialchars_uni($leaguedisplay[$leagueinfo['visible']]) . '"/>' .
				($leagueinfo['showteamicons'] == 1 ? ' <img src="../'. $vbulletin->options['vbsoccer_imgdir'] . '/images.png" alt=""/>' : ' <img src="../'. $vbulletin->options['vbsoccer_imgdir'] . '/empty.png" alt=""/>') .
				'</div>',
				'<div style="white-space:nowrap;">' . implode(' | ', $options) . '</div>',
				), false);

			$sortorderarray[$leagueinfo['sd_shortname']] = true;
		}
		$db->free_result($leagues);

		echo '<tr valign="top" align="center">
				<td class="tfoot" align="left">
					<input type="image" style="width: 1px; height: 1px;" src="' . $vbulletin->options['cleargifurl'] . '" />
					<input type="button" class="button" value="'. htmlspecialchars_uni($vbphrase['soccer_league_new']) .'"
					title="" tabindex="1" onclick="window.location=\'vbsoccer_admin.php?do=addleague\';"/>
				</td>
				<td class="tfoot" align="left" colspan="2"><input class="button" type="submit" value="' . htmlspecialchars_uni($vbphrase['save_display_order']) . '" /></td>
			</tr>';

		print_table_footer();
	}
	else
	{
		// keine liga im system vorhanden
		print_table_start(true);
		$colspan = 1;
		print_table_header($vbphrase['notices'], $colspan);
		print_cells_row(array($vbphrase['soccer_no_leagues']), false);
		print_table_footer($colspan,
		construct_button_code($vbphrase['soccer_league_new'], "vbsoccer_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=addleague"), '', false);
	}


	print_cp_footer();
}

// #############################################################################
if ($_REQUEST['do'] == 'addleague')
{
	$leagueinfo = array();

	$leagues = $db->query_read("
		SELECT `sd_id` AS `id`
		FROM `" . TABLE_PREFIX . "soccer_league`
		");

	while (($league = $db->fetch_array($leagues)))
	{
		$leagueinfo[$league['id']] = true;
	}

	$db->free_result($leagues);

	try
	{
		$availleagues = construct_sd_league_chooser();
	}
	catch (Exception $e)
	{
		print_stop_message($e->getMessage());
	}

	print_cp_header($vbphrase['soccer_leagues_manager']);
	print_form_header('vbsoccer_admin', 'importleague');
	print_table_header($vbphrase['soccer_import_league'], 1);
	print_cells_row(array($availleagues), 0);
	print_cells_row(array(
		'<label for="activate"><input type="checkbox" id="activate" name="activate" value="1" checked="checked"/> ' . $GLOBALS['vbphrase']['soccer_activate_after_import'] . '</label>'
		), 0);
	print_submit_row($vbphrase['soccer_import'], 0, 1, $vbphrase['go_back']);
	print_cp_footer();
}

// #############################################################################
if ($_REQUEST['do'] == 'deleteleague')
{
	$vbulletin->input->clean_gpc('r', 'leagueid', TYPE_UINT);

	$leagueinfo = $db->query_first_slave("
		SELECT *, CONCAT('soccer_leaguetype_', LOWER(league.`sd_shortname`)) AS league_phrase,
			masterphrase.text AS league_name
		FROM " . TABLE_PREFIX . "soccer_league AS league, `" . TABLE_PREFIX . "phrase` AS masterphrase
		WHERE `id`=" . $vbulletin->GPC['leagueid'] . "
			AND masterphrase.languageid=0 AND masterphrase.fieldname='vbsoccernames'
			AND masterphrase.varname=CONCAT('soccer_leaguetype_', LOWER(league.`sd_shortname`))
		");

	if (in_array($leagueinfo['sd_shortname'], array('WM', 'EM', 'ASV', 'BRA')))
	{
		// bei WM und EM nur die erste jahresangabe anzeigen
		$leagueinfo['sd_saison'] = substr($leagueinfo['sd_saison'], 0, 4);
	}

	$leagueinfo['name'] = construct_phrase($vbphrase['soccer_league_x_saison_y'],
										   $leagueinfo['league_name'],
										   $leagueinfo['sd_saison']);

	print_cp_header($vbphrase['soccer_leagues_manager']);
	echo "<p>&nbsp;</p><p>&nbsp;</p>";
	print_form_header('vbsoccer_admin', 'killleague', 0, 1, 'deleteform', '75%');
	construct_hidden_code('leagueid', $vbulletin->GPC['leagueid']);
	print_table_header(construct_phrase($vbphrase['confirm_deletion_x'], $leagueinfo['name']));
	print_description_row("
		<blockquote><br />
		" . construct_phrase($vbphrase["are_you_sure_want_to_delete_league_x_y"], $leagueinfo['name'], $vbulletin->GPC['leagueid']) . "
		<br /></blockquote>\n\t");
	print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
	print_cp_footer();
}

// #############################################################################
if ($_POST['do'] == 'updateleague')
{
	$vbulletin->input->clean_array_gpc('f', array(
		'logo'  => TYPE_FILE,
	));

	$vbulletin->input->clean_array_gpc('p', array(
		'leagueid'       => TYPE_UINT,
		'teamid'         => TYPE_UINT,
		'groupid'        => TYPE_UINT,
		'visible'        => TYPE_INT,
		'description'    => TYPE_STR,
		'showteamicons'  => TYPE_BOOL,
		'readonly'       => TYPE_BOOL,
		'delete_logo'    => TYPE_BOOL,
		'newicon'        => TYPE_STR,
	));

	if (!($leagueinfo = $db->query_first_slave("
		SELECT *
		FROM " . TABLE_PREFIX . "soccer_league
		WHERE `id`=" . $vbulletin->GPC['leagueid'] . "
		")))
	{
		print_stop_message('invalid_action_specified');
	}

	if ($vbulletin->GPC['delete_logo'])
	{
		@unlink(DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/league/' . $leagueinfo['logo']);
		$unset_logo_sql = ", `logo`='', `logo_size_html`=''";
	}
	else
	{
		$unset_logo_sql = '';
	}

	$db->query_write("
		UPDATE `" . TABLE_PREFIX . "soccer_league`
		SET `visible`=" . $vbulletin->GPC['visible'] . ",
			`description`='" . $db->escape_string(trim($vbulletin->GPC['description'])) . "',
			`showteamicons`=" . $vbulletin->GPC['showteamicons'] . $unset_logo_sql . ",
			`readonly`=" . $vbulletin->GPC['readonly'] . "
		WHERE `id`=" . $vbulletin->GPC['leagueid'] . "
		");

	// navigationsgruppe aller wettbewerbe gleichen types updaten
	$db->query_write("
		UPDATE `" . TABLE_PREFIX . "soccer_league`
		SET `groupid`=" . $vbulletin->GPC['groupid'] . "
		WHERE `sd_shortname`='" . $db->escape_string($leagueinfo['sd_shortname']) . "'
		");

	if ($vbulletin->GPC['logo']['tmp_name'] != '')
	{
		include_once DIR . '/includes/class_upload.php';
		include_once DIR . '/includes/class_image.php';

		$upload = new vB_Upload_Image($vbulletin);
		$upload->image =& vB_Image::fetch_library($vbulletin);
		$upload->path = DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] .'/league';

		if (!file_exists($upload->path))
		{
			/**
			 * @todo schreibrechte pruefen und fehlermeldung anzeigen
			 */
			if (!(@mkdir($upload->path, 0777)))
			{
				die('Verzeichnis ' . $upload->path . ' existiert nicht oder ist schreibgeschuetzt!');
			}
		}

		if (!($imagepath = $upload->process_upload($vbulletin->GPC['logo'])))
		{
			print_stop_message('there_were_errors_encountered_with_your_upload_x', $upload->fetch_error());
		}

		$imagename = $vbulletin->GPC['leagueid'] . '.' . $upload->upload['extension'];
		$imagesize = 'width="' . $upload->image->imageinfo[0] .'" height="' . $upload->image->imageinfo[1] . '"';
		if (file_exists(DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/league/' . $imagename))
		{
			@unlink(DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/league/' . $imagename);
		}
		rename($imagepath, DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/league/' . $imagename);

		$db->query_write("
			UPDATE `" . TABLE_PREFIX . "soccer_league`
			SET `logo`='" . $db->escape_string($imagename) . "',
				`logo_size_html`='" . $db->escape_string($imagesize) . "'
			WHERE `id`=" . $vbulletin->GPC['leagueid'] . "
			");

		/** @ignore */
		define('IMAGE_UPLOADED', true);
	}

	if ($vbulletin->GPC['newicon'] != '')
	{
		$uploadpath = DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] .'/league';

		if (!file_exists($uploadpath))
		{
			/**
			 * @todo schreibrechte pruefen und fehlermeldung anzeigen
			 */
			if (!(@mkdir($uploadpath, 0777)))
			{
				die('Verzeichnis ' . $uploadpath . ' existiert nicht oder ist schreibgeschuetzt!');
			}
		}

		$imagename = $vbulletin->GPC['leagueid'] . '.png';
		$imagesize = 'width="32" height="32"';
		file_put_contents($uploadpath . '/' . $imagename, base64_decode($vbulletin->GPC['newicon']));

		$db->query_write("
			UPDATE `" . TABLE_PREFIX . "soccer_league`
			SET `logo`='" . $db->escape_string($imagename) . "',
				`logo_size_html`='" . $db->escape_string($imagesize) . "'
			WHERE `id`=" . $vbulletin->GPC['leagueid'] . "
			");
	}

	include_once DIR . '/includes/functions_vbsoccer.php';
	build_leagues_datastore();

	if (!empty($vbulletin->GPC['teamid']))
	{
		/** @ignore */
		define('CP_REDIRECT', 'vbsoccer_admin.php?do=editteam&amp;teamid='. $vbulletin->GPC['teamid']);
	}
	else
	{
		/** @ignore */
		define('CP_REDIRECT', 'vbsoccer_admin.php?do=leagues');
	}
	print_stop_message('soccer_league_update_successfully');
}


// #############################################################################
if ($_REQUEST['do'] == 'editleague')
{
	print_cp_header($vbphrase['soccer_leagues_manager']);

	$vbulletin->input->clean_array_gpc('r', array(
		'teamid'    => TYPE_UINT,
		'leagueid'  => TYPE_UINT,
	));

	$leagueinfo = $db->query_first("
		SELECT *, CONCAT('soccer_leaguetype_', LOWER(`sd_shortname`)) AS league_phrase
		FROM `" . TABLE_PREFIX . "soccer_league`
		WHERE `id`=" . $vbulletin->GPC['leagueid'] . "
		");

	if (in_array($leagueinfo['sd_shortname'], array('WM', 'EM', 'ASV', 'BRA')))
	{
		// bei WM und EM nur die erste jahresangabe anzeigen
		$leagueinfo['sd_saison'] = substr($leagueinfo['sd_saison'], 0, 4);
	}

	$leagueinfo['league_name'] = $vbphrase[$leagueinfo['league_phrase']];
	$trans_link = "phrase.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&fieldname=vbsoccernames&t=1&varname=";

	print_form_header('vbsoccer_admin', 'updateleague', true);
	construct_hidden_code('leagueid', $vbulletin->GPC['leagueid']);
	construct_hidden_code('teamid', $vbulletin->GPC['teamid']);
	print_table_header(construct_phrase($vbphrase['soccer_league_x_saison_y'],
										$leagueinfo['league_name'],
										$leagueinfo['sd_saison']));
	print_label_row($vbphrase['soccer_league_name'],
					htmlspecialchars_uni($leagueinfo['league_name']) . '<dfn>' . construct_link_code($vbphrase['translations'], $trans_link . $leagueinfo['league_phrase'], 1) . '</dfn>');
	print_label_row($vbphrase['soccer_league_saison'], $leagueinfo['sd_saison']);
	print_label_row($vbphrase['soccer_homepage'], ($leagueinfo['sd_homepage'] != '') ? '<a href="' . $leagueinfo['sd_homepage'] . '" target="_blank">' . htmlspecialchars_uni($leagueinfo['sd_homepage']) . '</a>' : 'N/A');
	print_textarea_row($vbphrase['soccer_league_description'], 'description', $leagueinfo['description']);

	if (is_writable('./' . $vbulletin->options['vbsoccer_imgdir']))
	{
		$icondata = fetch_sd_LeagueIcon($leagueinfo['sd_id']);

		if (!empty($icondata[$leagueinfo['sd_id']]['imagedata']))
		{
			// Checks for HTML tags that can be exploited via IE

			$segment_length = 256;
			$fp = fopen('php://memory', 'r+');
			fputs($fp, base64_decode($icondata[$leagueinfo['sd_id']]['imagedata']));
			$total_length = ftell($fp);
			$icondata_chunk = fread ($fp, $segment_length);
			fclose($fp);

			if (!preg_match('#<html|<head|<body|<script|<pre|<plaintext|<table|<a href|<img|<title#si', $icondata_chunk))
			{
				unset($icondata_chunk);
				if ($leagueinfo['logo'] != '')
				{
					if (!($local_icondata = @file_get_contents(DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/league/' . $leagueinfo['logo'])))
					{
						$local_icondata = 'wtf?'; // dummy-string ;-)
					}

					$local_icondata_hash = md5(base64_encode($local_icondata));
					$icondata_hash = md5($icondata[$leagueinfo['sd_id']]['imagedata']);

					if ($local_icondata_hash != $icondata_hash)
					{
						$showIconSrc = true;
					}
				}
				else
				{
					$showIconSrc = true;
				}
			}
		}
		print_upload_row($vbphrase['soccer_league_logo'], 'logo');
	}
	else
	{
		print_label_row($vbphrase['soccer_league_logo'], construct_phrase($vbphrase['soccer_uploaddir_not_writable'], realpath('./' . $vbulletin->options['vbsoccer_imgdir'])));
	}

	if ($leagueinfo['logo'] != '')
	{
		// eine zeilenfarbe ueberspringen, damit uploadfeld und iconvorschau die
		// gleiche zeilenfarbe haben
		fetch_row_bgclass();

		print_label_row('&nbsp;',
						'<img src="../' . $vbulletin->options['vbsoccer_imgdir'] . '/league/' . $leagueinfo['logo'] .'" alt="" />' .
						' <input id="dellogo" type="checkbox" name="delete_logo" value="1" /> <label for="dellogo">' . $vbphrase['delete'] . '</label>');

		if ($showIconSrc)
		{
			fetch_row_bgclass();
			print_label_row('&nbsp;', '<dfn>' . $vbphrase['soccer_icon_update_found'] . '</dfn><br /><img border="0" width="32" height="32" alt="icon" src="data:image/png;base64,' . $icondata[$leagueinfo['sd_id']]['imagedata'] . '" /> <input type="checkbox" id="newicon" name="newicon" value="' . $icondata[$leagueinfo['sd_id']]['imagedata'] .'" /> <label for="newicon">' . $vbphrase['soccer_upload_this_icon'] . '</label>');
		}
	}
	else
	{
		if ($showIconSrc)
		{
			fetch_row_bgclass();
			print_label_row('&nbsp;', '<dfn>' . $vbphrase['soccer_icon_found'] . '</dfn><br /><img border="0" width="32" height="32" alt="icon" src="data:image/png;base64,' . $icondata[$leagueinfo['sd_id']]['imagedata'] . '" /> <input type="checkbox" id="newicon" name="newicon" value="' . $icondata[$leagueinfo['sd_id']]['imagedata'] .'" /> <label for="newicon">' . $vbphrase['soccer_upload_this_icon'] . '</label>');
		}
	}
	print_label_row('<div style="width: 200px; text-align: right;"><img src="../' . $vbulletin->options['vbsoccer_imgdir'] . '/stop.png" border="0" width="48" height="48" alt="STOP!" /></div>', $vbphrase['soccer_league_icon_warning']);

	print_yes_no_other_row($vbphrase['soccer_league_display'], 'visible', $vbphrase['archiv'], $leagueinfo['visible']);
	print_yes_no_row($vbphrase['soccer_league_readonly'], 'readonly', $leagueinfo['readonly']);
	print_yes_no_row($vbphrase['soccer_league_showteamicons'], 'showteamicons', $leagueinfo['showteamicons']);


	$navgroups = $db->query_read("
		SELECT navgroup.*, masterphrase.text AS navgroup_name
		FROM `" . TABLE_PREFIX . "soccer_league_group` AS navgroup,
			 `" . TABLE_PREFIX . "phrase` AS masterphrase
		WHERE masterphrase.languageid=0 AND masterphrase.fieldname='vbsoccernames' AND masterphrase.varname=CONCAT('soccer_navgroup_', navgroup.groupid)
		ORDER BY `displayorder`, `navgroup_name`
		");

	if (($totalnavgroups = $db->num_rows($navgroups)))
	{
		$data = array(0 => '--');

		while (($navgroup = $db->fetch_array($navgroups)))
		{
			$data[$navgroup['groupid']] = $vbphrase['soccer_navgroup_' . $navgroup['groupid']];
		}

		print_select_row($vbphrase['soccer_navgroup'], 'groupid', $data, $leagueinfo['groupid']);
	}

	print_submit_row($vbphrase['save'], '_default_', 2, $vbphrase['go_back']);

	$teamTableCols = 4;
	print_table_start();
	print_table_header(construct_phrase($vbphrase['soccer_teams_league_x'], htmlspecialchars_uni($leagueinfo['league_name'] .' '. $leagueinfo['sd_saison'])), $teamTableCols);


	$teams = $db->query_read("
		SELECT soccer_team.*, IF(soccer_team.`custom_shortname`!='', soccer_team.`custom_shortname`, soccer_team.`sd_shortname`) AS `team_shortname`
		FROM `" . TABLE_PREFIX . "soccer_league_team` AS soccer_league_team
		INNER JOIN `" . TABLE_PREFIX . "soccer_team` AS soccer_team ON(soccer_league_team.team_id=soccer_team.id)
		WHERE soccer_league_team.league_id=" . $vbulletin->GPC['leagueid'] . "
		");

	$teamsort_array = array();
	$team_data = array();

	while (($team = $db->fetch_array($teams)))
	{
		$teamsort_array[$team['sd_id']] = $vbphrase['soccer_team_' . $team['sd_id']];
		$team_data[$team['sd_id']] = $team;
	}

	$db->free_result($teams);

	asort($teamsort_array);

	foreach ($teamsort_array AS $id => $data)
	{
		$team = $team_data[$id];
		if (empty($optionheader))
		{
			print_cells_row(array(
				htmlspecialchars_uni($vbphrase['soccer_teamname']),
				$vbphrase['soccer_shortname'],
				$vbphrase['soccer_team_logo'],
				$vbphrase['options'],
				), true);

			$optionheader = 1;
		}

		print_cells_row(array(
			htmlspecialchars_uni($vbphrase['soccer_team_' . $team['sd_id']]),
			htmlspecialchars_uni($team['team_shortname']),
			(($team['logo'] != '') ? '<img src="../' . $vbulletin->options['vbsoccer_imgdir'] . '/team/' . $team['logo'] . '?' . TIMENOW . '" width="16" height="16" alt="" />' : '<img src="../' . $vbulletin->options['vbsoccer_imgdir'] . '/empty.png" alt="" />'),
			construct_link_code($vbphrase['edit'], 'vbsoccer_admin.php?do=editteam&amp;teamid=' . $team['id'] . '&amp;leagueid=' . $leagueinfo['id']),
			), false);
	}

	print_table_footer($teamTableCols, '', '', false);

	print_cp_footer();
}

// #############################################################################
if ($_REQUEST['do'] == 'teams')
{
	print_cp_header($vbphrase['soccer_team_manager']);
	$vbulletin->input->clean_array_gpc('r', array(
		'perpage'    => TYPE_INT,
		'pagenumber' => TYPE_INT,
	));

	// check display values are valid
	if ($vbulletin->GPC['perpage'] < 1)
	{
		$vbulletin->GPC['perpage'] = 15;
	}
	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}

	// count teams
	$countteams = $db->query_first("
		SELECT COUNT(*) AS `total`
		FROM `" . TABLE_PREFIX . "soccer_team`"
	);

	if ((int) $countteams['total'] == 0)
	{
		print_cp_redirect('vbsoccer_admin.php?do=leagues');
	}

	$numteams =& $countteams['total'];
	$numpages = ceil($numteams / $vbulletin->GPC['perpage']);

	if ($numpages < 1)
	{
		$numpages = 1;
	}
	if ($vbulletin->GPC['pagenumber'] > $numpages)
	{
		$vbulletin->GPC['pagenumber'] = $numpages;
	}

	$showprev = false;
	$shownext = false;

	if ($vbulletin->GPC['pagenumber'] > 1)
	{
		$showprev = true;
	}
	if ($vbulletin->GPC['pagenumber'] < $numpages)
	{
		$shownext = true;
	}

	$pageoptions = array();

	for ($i = 1; $i <= $numpages; $i++)
	{
		$pageoptions["$i"] = "$vbphrase[page] $i / $numpages";
	}

	print_form_header('vbsoccer_admin', 'teams', false, true, 'navform', '90%', '', true, 'get');

	echo '<colgroup span="5">
		<col style="white-space:nowrap"/>
		<col width="100%"/>
		<col style="white-space:nowrap"/>
		<col/>
		<col/>
	</colgroup>
	<tr>
		<td class="thead" nowrap="nowrap">' .
			'<input type="button"' . iif(!$showprev, ' disabled="disabled"') . ' class="button" value="&laquo; ' . $vbphrase['prev'] . '" tabindex="1" onclick="this.form.page.selectedIndex -= 1; this.form.submit()" />' .
			'<select name="page" tabindex="1" onchange="this.form.submit()" class="bginput">' . construct_select_options($pageoptions, $vbulletin->GPC['pagenumber']) . '</select>' .
			'<input type="button"' . iif(!$shownext, ' disabled="disabled"') . ' class="button" value="' . $vbphrase['next'] . ' &raquo;" tabindex="1" onclick="this.form.page.selectedIndex += 1; this.form.submit()" />
		</td>
		<td class="thead"></td>
		<td class="thead" nowrap="nowrap">' . $vbphrase['teams_to_show_per_page'] . ':</td>
		<td class="thead"><input type="text" class="bginput" name="perpage" value="' . $vbulletin->GPC['perpage'] . '" tabindex="1" size="5" /></td>
		<td class="thead"><input type="submit" class="button" value=" ' . $vbphrase['go'] . ' " tabindex="1" accesskey="s" /></td>
	</tr>';

	print_table_footer();

	$teams = $db->query_read("
		SELECT *, CONCAT('soccer_team_', `sd_id`) AS `team_phrase`,
		masterphrase.text AS `team_name`,
			IF(`custom_shortname`!='', `custom_shortname`, `sd_shortname`) AS `team_shortname`
		FROM `" . TABLE_PREFIX . "soccer_team`, `" . TABLE_PREFIX . "phrase` AS masterphrase
		WHERE masterphrase.languageid=0 AND masterphrase.fieldname='vbsoccernames' AND masterphrase.varname=CONCAT('soccer_team_', `sd_id`)
		ORDER BY team_name
		LIMIT " . (($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage']) . ", " . $vbulletin->GPC['perpage'] . "
	");

	print_table_start();
	print_table_header($vbphrase['soccer_teams'], 4);
	print_cells_row(array($vbphrase['soccer_teamname'],
						  $vbphrase['soccer_shortname'],
						  $vbphrase['soccer_team_logo'],
						  $vbphrase['options'],
						  ), true);

	while ($team = $db->fetch_array($teams))
	{
		print_cells_row(array(htmlspecialchars_uni($team['team_name']),
							  htmlspecialchars_uni($team['team_shortname']),
							  (($team['logo'] != '') ? '<img src="../' . $vbulletin->options['vbsoccer_imgdir'] . '/team/' . $team['logo'] . '?' . TIMENOW . '" ' . $team['logo_size_html'] . ' alt="" />' : '<img src="../' . $vbulletin->options['vbsoccer_imgdir'] . '/empty.png" alt="" />'),
							  construct_link_code($vbphrase['edit'], 'vbsoccer_admin.php?do=editteam&amp;teamid=' . $team['id'] . '&amp;page=' . $vbulletin->GPC['pagenumber']),
							  ), false);
	}

	print_table_footer(4, '', '', false);
	print_cp_footer();
}

// #############################################################################
if ($_POST['do'] == 'updateteam')
{
	$vbulletin->input->clean_array_gpc('f', array(
		'logo'  => TYPE_FILE,
	));

	$vbulletin->input->clean_array_gpc('p', array(
		'teamid'       => TYPE_UINT,
		'leagueid'     => TYPE_UINT,
		'page'         => TYPE_UINT,
		'shortname'    => TYPE_STR,
		'delete_logo'  => TYPE_BOOL,
		'newicon'      => TYPE_STR,
	));

	$teaminfo = $db->query_first_slave("
		SELECT *
		FROM " . TABLE_PREFIX . "soccer_team
		WHERE `id`=" . $vbulletin->GPC['teamid'] . "
		");

	if ($vbulletin->GPC['delete_logo'])
	{
		@unlink(DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/team/' . $teaminfo['logo']);
		$unset_logo_sql = ", `logo`='', `logo_size_html`=''";
	}
	else
	{
		$unset_logo_sql = '';
	}

	if ($teaminfo['sd_shortname'] == $vbulletin->GPC['shortname'])
	{
		$vbulletin->GPC['shortname'] = '';
	}

	$db->query_write("
		UPDATE `" . TABLE_PREFIX . "soccer_team`
		SET `custom_shortname`='" . $db->escape_string($vbulletin->GPC['shortname']) . "'". $unset_logo_sql ."
		WHERE `id`=" . $vbulletin->GPC['teamid'] . "
		");

	if (empty($vbulletin->GPC['newicon']) AND $vbulletin->GPC['logo']['tmp_name'] != '')
	{
		include_once DIR . '/includes/class_upload.php';
		include_once DIR . '/includes/class_image.php';

		$upload = new vB_Upload_Image($vbulletin);
		$upload->image =& vB_Image::fetch_library($vbulletin);
		$upload->path = DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] .'/team';

		if (!file_exists($upload->path))
		{
			/**
			 * @todo schreibrechte pruefen und fehlermeldung anzeigen
			 */
			if (!(@mkdir($upload->path, 0777)))
			{
				die('Verzeichnis ' . $upload->path . ' existiert nicht oder ist schreibgeschuetzt!');
			}
		}

		if (!($imagepath = $upload->process_upload($vbulletin->GPC['logo'])))
		{
			print_stop_message('there_were_errors_encountered_with_your_upload_x', $upload->fetch_error());
		}
		$imagename = $vbulletin->GPC['teamid'] . '.' . $upload->upload['extension'];
		$imagesize = 'width="' . $upload->image->imageinfo[0] .'" height="' . $upload->image->imageinfo[1] . '"';
		rename($imagepath, DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/team/' . $imagename);

		$db->query_write("
			UPDATE `" . TABLE_PREFIX . "soccer_team`
			SET `logo`='" . $db->escape_string($imagename) . "',
				`logo_size_html`='" . $db->escape_string($imagesize) . "'
			WHERE `id`=" . $vbulletin->GPC['teamid'] . "
			");

		/** @ignore */
		define('IMAGE_UPLOADED', true);
	}

	if ($vbulletin->GPC['newicon'] != '')
	{
		$uploadpath = DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] .'/team';

		if (!file_exists($uploadpath))
		{
			/**
			 * @todo schreibrechte pruefen und fehlermeldung anzeigen
			 */
			if (!(@mkdir($uploadpath, 0777)))
			{
				die('Verzeichnis ' . $uploadpath . ' existiert nicht oder ist schreibgeschuetzt!');
			}
		}

		$imagename = $vbulletin->GPC['teamid'] . '.png';
		$imagesize = 'width="16" height="16"';
		file_put_contents($uploadpath . '/' . $imagename, base64_decode($vbulletin->GPC['newicon']));

		$db->query_write("
			UPDATE `" . TABLE_PREFIX . "soccer_team`
			SET `logo`='" . $db->escape_string($imagename) . "',
				`logo_size_html`='" . $db->escape_string($imagesize) . "'
			WHERE `id`=" . $vbulletin->GPC['teamid'] . "
			");

		/** @ignore */
		define('IMAGE_UPLOADED', true);
	}

	/** @ignore */
	if (!empty($vbulletin->GPC['leagueid']))
	{
		define('CP_REDIRECT', 'vbsoccer_admin.php?do=editleague&amp;leagueid='. $vbulletin->GPC['leagueid']);
	}
	else
	{
		define('CP_REDIRECT', 'vbsoccer_admin.php?do=teams&amp;page='. $vbulletin->GPC['page']);
	}
	print_stop_message('soccer_team_update_successfully');
}

// #############################################################################
if ($_REQUEST['do'] == 'editteam')
{
	print_cp_header($vbphrase['soccer_team_manager']);
	$vbulletin->input->clean_array_gpc('r', array(
		'teamid'    => TYPE_UINT,
		'leagueid'  => TYPE_UINT,
		'page'      => TYPE_UINT,
	));

	$teaminfo = $db->query_first("
		SELECT team.*,
			IF(team.`custom_shortname`!='', team.`custom_shortname`, team.`sd_shortname`) AS `team_shortname`,
			CONCAT('soccer_team_', team.`sd_id`) AS team_phrase
		FROM `" . TABLE_PREFIX . "soccer_team` AS team
		WHERE team.`id`=" . $vbulletin->GPC['teamid'] . "
		");

	print_form_header('vbsoccer_admin', 'updateteam', true);
	construct_hidden_code('teamid', $vbulletin->GPC['teamid']);
	construct_hidden_code('leagueid', $vbulletin->GPC['leagueid']);
	construct_hidden_code('page', $vbulletin->GPC['page']);
	print_table_header($vbphrase[$teaminfo['team_phrase']]);

	$trans_link = "phrase.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&fieldname=vbsoccernames&t=1&varname="; // has varname appended

	print_label_row($vbphrase['soccer_team_displayname'],
					htmlspecialchars_uni($vbphrase[$teaminfo['team_phrase']]) . '<dfn>' . construct_link_code($vbphrase['translations'], $trans_link . $teaminfo['team_phrase'], 1) . '</dfn>');
	print_input_row($vbphrase['soccer_team_displayshortname'], 'shortname', $teaminfo['team_shortname'], true, 5, 5);
	print_label_row($vbphrase['soccer_homepage'], ($teaminfo['sd_homepage'] != '') ? '<a href="' . $teaminfo['sd_homepage'] . '" target="_blank">' . htmlspecialchars_uni($teaminfo['sd_homepage']) . '</a>' : 'N/A');

	$showIconSrc = false;

	if (is_writable('./' . $vbulletin->options['vbsoccer_imgdir']))
	{
		$icondata = fetch_sd_TeamIcon($teaminfo['sd_id']);
		if (!empty($icondata[$teaminfo['sd_id']]['imagedata']))
		{
			// Checks for HTML tags that can be exploited via IE
			$segment_length = 256;
			$fp = fopen('php://memory', 'r+');
			fputs($fp, base64_decode($icondata[$teaminfo['sd_id']]['imagedata']));
			$total_length = ftell($fp);
			$icondata_chunk = fread ($fp, $segment_length);
			fclose($fp);

			if (!preg_match('#<html|<head|<body|<script|<pre|<plaintext|<table|<a href|<img|<title#si', $icondata_chunk))
			{
				unset($icondata_chunk);
				if ($teaminfo['logo'] != '')
				{
					if (!($local_icondata = @file_get_contents(DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/team/' . $teaminfo['logo'])))
					{
						$local_icondata = 'wtf?'; // dummy-string ;-)
					}

					$local_icondata_hash = md5(base64_encode($local_icondata));
					$icondata_hash = md5($icondata[$teaminfo['sd_id']]['imagedata']);

					if ($local_icondata_hash != $icondata_hash)
					{
						$showIconSrc = true;
					}
				}
				else
				{
					$showIconSrc = true;
				}
			}
		}

		print_upload_row($vbphrase['soccer_team_logo'], 'logo');
	}
	else
	{
		print_label_row($vbphrase['soccer_league_logo'], construct_phrase($vbphrase['soccer_uploaddir_not_writable'], realpath('./' . $vbulletin->options['vbsoccer_imgdir'])));
	}

	if ($teaminfo['logo'] != '')
	{
		fetch_row_bgclass();
		print_label_row('&nbsp;',
						'<img src="../' . $vbulletin->options['vbsoccer_imgdir'] . '/team/' . $teaminfo['logo'] .'"/>' .
						' <input id="dellogo" type="checkbox" name="delete_logo" value="1" /> <label for="dellogo">' . $vbphrase['delete'] . '</label>');

		if ($showIconSrc)
		{
			fetch_row_bgclass();
			print_label_row('&nbsp;', '<dfn>' . $vbphrase['soccer_icon_update_found'] . '</dfn><br /><img border="0" width="16" height="16" alt="icon" src="data:image/png;base64,' . $icondata[$teaminfo['sd_id']]['imagedata'] . '" /> <input type="checkbox" id="newicon" name="newicon" value="' . $icondata[$teaminfo['sd_id']]['imagedata'] .'" /> <label for="newicon">' . $vbphrase['soccer_upload_this_icon'] . '</label>');
		}
	}
	else
	{
		if ($showIconSrc)
		{
			fetch_row_bgclass();
			print_label_row('&nbsp;', '<dfn>' . $vbphrase['soccer_icon_found'] . '</dfn><br /><img border="0" width="16" height="16" alt="icon" src="data:image/png;base64,' . $icondata[$teaminfo['sd_id']]['imagedata'] . '" /> <input type="checkbox" id="newicon" name="newicon" value="' . $icondata[$teaminfo['sd_id']]['imagedata'] .'" /> <label for="newicon">' . $vbphrase['soccer_upload_this_icon'] . '</label>');
		}
	}
	print_label_row('<div style="width: 200px; text-align: right;"><img src="../' . $vbulletin->options['vbsoccer_imgdir'] . '/stop.png" border="0" width="48" height="48" alt="STOP!" /></div>', construct_phrase($vbphrase['soccer_team_icon_warning'], $vbphrase[$teaminfo['team_phrase']]));
	print_submit_row($vbphrase['save'], '_default_', 2, $vbphrase['go_back']);

	$leaguedisplay = array(
		 0 => $vbphrase['no'],
		 1 => $vbphrase['yes'],
		-1 => $vbphrase['archiv'],
		-2 => $vbphrase['yes'],
		);

	$status_icons  = array(
		 0 => 'inactive.png',
		 1 => 'active.png',
		-1 => 'archive.png',
		-2 => 'readonly.png',
		);

	$leagueTableCols = 4;
	print_table_start();
	print_table_header(construct_phrase($vbphrase['soccer_leagues_team_x'], htmlspecialchars_uni($vbphrase[$teaminfo['team_phrase']])), $leagueTableCols);


	$leagues = $db->query_read("
		SELECT soccer_league.id, soccer_league.sd_saison, soccer_league.showteamicons, logo, visible, soccer_league.sd_shortname,
			CONCAT('soccer_leaguetype_', LOWER(soccer_league.`sd_shortname`)) AS league_phrase
		FROM `" . TABLE_PREFIX . "soccer_league_team` AS soccer_league_team
		INNER JOIN `" . TABLE_PREFIX . "soccer_league` AS soccer_league ON(soccer_league_team.league_id=soccer_league.id)
		WHERE soccer_league_team.team_id=" . $vbulletin->GPC['teamid'] . "
		ORDER BY soccer_league.sd_saison DESC
		");

	while (($league = $db->fetch_array($leagues)))
	{
		if (empty($optionheader))
		{
			print_cells_row(array(
				$vbphrase['soccer_league_displayname'],
				$vbphrase['soccer_league_saison'],
				$vbphrase['soccer_league_display'],
				$vbphrase['options']), true);

			$optionheader = 1;
		}

		if (in_array($league['sd_shortname'], array('WM', 'EM', 'ASV', 'BRA')))
		{
			// bei WM und EM nur die erste jahresangabe anzeigen
			$league['sd_saison'] = substr($league['sd_saison'], 0, 4);
		}

		print_cells_row(array(
			htmlspecialchars_uni($vbphrase[$league['league_phrase']]),
			$league['sd_saison'],
			'<div style="withe-space: nowrap;">' .
			($league['logo'] != '' ? '<img src="../'. $vbulletin->options['vbsoccer_imgdir'] .'/league/' . $league['logo'] . '" width="16" height="16" alt=""/>' : '<img src="../'. $vbulletin->options['vbsoccer_imgdir'] . '/empty.png" alt=""/>') .
			' <img src="../'. $vbulletin->options['vbsoccer_imgdir'] .'/' . $status_icons[$league['visible']] . '" alt="' . htmlspecialchars_uni($leaguedisplay[$league['visible']]) . '"/>' .
				($league['showteamicons'] == 1 ? ' <img src="../'. $vbulletin->options['vbsoccer_imgdir'] . '/images.png" alt=""/>' : ' <img src="../'. $vbulletin->options['vbsoccer_imgdir'] . '/empty.png" alt=""/>') .
			'</div>',
			construct_link_code($vbphrase['edit'], 'vbsoccer_admin.php?do=editleague&amp;leagueid=' . $league['id'] .'&amp;teamid=' . $vbulletin->GPC['teamid']),
			), false);
	}

	print_table_footer($leagueTableCols, '', '', false);

	print_cp_footer();
}

if ($_REQUEST['do'] == 'diag')
{
	print_cp_header($vbphrase['diagnostics']);

	print_table_start();
	print_table_header($vbphrase['diagnostics']);

	print_cells_row(array('vBulletin', '&nbsp;'), true);

	print_label_row($vbphrase['version'], $vbulletin->options['templateversion']);

	if ($vbulletin->options['templateversion'] != ADMIN_VERSION_VBULLETIN)
	{
		print_label_row('ADMIN_VERSION_VBULLETIN', sprintf('<b>%s</b>', ADMIN_VERSION_VBULLETIN));
	}

	print_cells_row(array('vBSoccer', '&nbsp;'), true);

	$productlist = fetch_product_list(true);
	print_label_row($vbphrase['enabled'], (!empty($productlist['vbsoccer']['active']) ? $vbphrase['yes'] : $vbphrase['no']));

	if (!isset($productlist['vbsoccer']['version']))
	{
		$productlist['vbsoccer']['version'] = 'N/A';
	}

	print_label_row($vbphrase['version'], $productlist['vbsoccer']['version']);

	if ((@include DIR . "/includes/md5_sums_vbsoccer.php") === false)
	{
		print_label_row('Checksum-Version', $vbphrase['file_not_found']);
	}
	else
	{
		if (!isset($md5_sum_versions['vbsoccer']))
		{
			$md5_sum_versions['vbsoccer'] = 'N/A';
		}

		if ($productlist['vbsoccer']['version'] != $md5_sum_versions['vbsoccer'])
		{
			print_label_row('Checksum-Version', sprintf('<b>%s</b>', $md5_sum_versions['vbsoccer']));
		}

		$relative_md5_sums = array();
		$md5_sums_array = array();

		// need to fix up directories which are configurable
		foreach ($md5_sums AS $key => $val)
		{
			$admin_dir = strpos($key, '/admincp');

			// not using str_replace since it could be greedy and replace all values of admincp / modcp
			if ($vbulletin->config['Misc']['admincpdir'] !== 'admincp' AND $admin_dir === 0)
			{
				$key = substr_replace($key, $vbulletin->config['Misc']['admincpdir'], 1, strlen('admincp'));
			}

			$relative_md5_sums["$key"] = $val;
		}

		$md5_sums_array = array_merge_recursive($relative_md5_sums, $md5_sums_array);

		foreach ($md5_sums_array AS $dir => $checkfiles)
		{
			foreach ($checkfiles AS $filename => $md5sum)
			{
				$relfilepath = $dir . ($dir == '/' ? '' : '/') . $filename;
				$md5sumcheck = '';
				if (file_exists(DIR . $relfilepath))
				{
					$md5sumcheck = md5_file(DIR . $relfilepath);
				}

				if ($md5sumcheck != $md5sum)
				{
					print_label_row($relfilepath, $vbphrase['file_contents_mismatch']);
					vbflush();
				}
			}
		}
	}

	// laenderflaggen ermitteln und mit datenbank vergleichen
	$db->hide_errors();

	$country_icons = $db->query_read("
		SELECT LOWER(CONCAT(`region`, '.png')) AS `filename`
		FROM `" . TABLE_PREFIX . "soccer_league`
		");

	$db->show_errors();

	if ($db->errno)
	{
		// wtf?
	}
	else
	{
		$country_icon_files = array();

		while (($country_icon = $db->fetch_array($country_icons)))
		{
			$country_icon_files[] = $country_icon['filename'];
		}

		unset($country_icons);

		$orgfiles = glob(DIR . '/' . $vbulletin->options['vbsoccer_imgdir'] . '/org/*.png');

		if (empty($orgfiles))
		{
			print_label_row('Country-Images', sprintf('<b>N/A</b> (/%s/org)', $vbulletin->options['vbsoccer_imgdir']));
		}
		else
		{
			$orgfiles = array_map('basename', $orgfiles);

			if ($country_icon_diff = array_diff($country_icon_files, $orgfiles))
			{
				foreach ($country_icon_diff AS $iconname)
				{
					print_label_row(sprintf('/%s/org/%s', $vbulletin->options['vbsoccer_imgdir'], $iconname),
									sprintf('<b>%s</b>', $vbphrase['file_not_found']));
					vbflush();
				}
			}
		}
	}
	print_label_row('Services-Client', 'XML-RPC');
	vbflush();

	$soapClient = soccerDataClient();
	$pong = $soapClient->ping();
	print_label_row('XML-RPC Client-Test ("ping?")', sprintf('"%s"', $pong));
	vbflush();
	print_label_row('HTML-Charset', strtoupper($GLOBALS['stylevar']['charset']));
	vbflush();

	print_cells_row(array('PHP', '&nbsp;'), true);
	vbflush();
	print_label_row('PHP-Version', PHP_VERSION);
	print_label_row('PHP Server API', SAPI_NAME);
	print_label_row('PHP Safemode', (SAFEMODE ? $vbphrase['on'] : $vbphrase['off']));
	print_label_row('XML-Extension', (function_exists('xml_set_element_handler') ? $vbphrase['yes'] : $vbphrase['no']));
	print_label_row('cURL-Extension', (function_exists('curl_init') ? $vbphrase['yes'] : $vbphrase['no']));
	print_label_row('iconv-Extension', (function_exists('iconv') ? $vbphrase['yes'] : $vbphrase['no']));
	print_label_row('mbstring-Extension', (function_exists('mb_convert_encoding') ? $vbphrase['yes'] : $vbphrase['no']));
	print_label_row('default timezone', @date_default_timezone_get());
	vbflush();

	print_cells_row(array('MySQL', '&nbsp;'), true);
	list($mysqlversion) = $db->query_first("SELECT VERSION() AS version", DBARRAY_NUM);
	print_label_row('MySQL-Version', $mysqlversion);

	$db->hide_errors();
	$character_sets = $db->query_read("SHOW VARIABLES LIKE 'character\_set\_%'");
	if (!$db->errno)
	{
		while (($row = $db->fetch_array($character_sets)))
		{
			print_label_row($row['Variable_name'], $row['Value']);
		}
		$db->free_result($character_sets);
	}
	$db->show_errors();

	$db->hide_errors();
	$collations = $db->query_read("SHOW VARIABLES LIKE 'collation\_%'");
	if (!$db->errno)
	{
		while (($row = $db->fetch_array($collations)))
		{
			print_label_row($row['Variable_name'], $row['Value']);
		}
		$db->free_result($collations);
	}
	$db->show_errors();

	print_table_footer(2, '', '', false);
	print_cp_footer();
}
