<?php
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'watermark');
$MDIR = dirname(__FILE__);
define("MDIR", $MDIR);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();


// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$image = $_GET['src'];
$minwidth = $vbulletin->options[watermarkwidthdef];
$fontsize = $vbulletin->options[watermarkfontsize];
$bandheight = $vbulletin->options[watermarkbandheight];
$fontname = $vbulletin->options[watermarkfontname];
$wmrkimage = $vbulletin->options[watermarkimage];

$imagetype = getimagesize($image);
            switch ($imagetype['mime']) {
    case "image/gif":
        $im = @imagecreatefromgif($image);
        break;
    case "image/jpeg":
        $im = imagecreatefromjpeg($image);
        break;
    case "image/png":
        $im = imagecreatefrompng($image);
        break;
     case "image/bmp":
        $im = imagecreatefrombmp($image);
        break;
	}
	
if(!empty($wmrkimage)){
$wmrkimagetype = getimagesize($wmrkimage);
            switch ($wmrkimagetype['mime']) {
    case "image/gif":
        $stamp = @imagecreatefromgif($wmrkimage);
        break;
    case "image/jpeg":
        $stamp = imagecreatefromjpeg($wmrkimage);
        break;
    case "image/png":
        $stamp = imagecreatefrompng($wmrkimage);
        break;
    case "image/bmp":
        $stamp = imagecreatefrombmp($wmrkimage);
        break;
	}
}

$imagewidth = imagesx($im);

if(empty($vbulletin->options[watermarktext])){
$watermarktext = $vbulletin->options[bbtitle];
}
	else {
		$watermarktext = $vbulletin->options[watermarktext];
	}

if($imagewidth <= $minwidth){
  switch ($imagetype['mime']) {
    case "image/gif":
        header ("Content-type: image/gif");
	readfile($image); 
        break;
    default:
    	header ("Content-type: image/png");
        imagegif($im); 
	imagedestroy($im);
        break;
	}
}
else {

if(empty($wmrkimage)){
$stamp = imagecreatetruecolor($imagewidth, $bandheight);
$ypoint = $fontsize+round(($bandheight - $fontsize)/2);
$ffontname = MDIR."/includes/fonts/".$fontname;
ImageTTFText($stamp, $fontsize, 0, 15, $ypoint, 0xFFFFFF, $ffontname, $watermarktext);
}
$marge_right = 0;
$marge_bottom = 0;
$sx = imagesx($stamp);
$sy = imagesy($stamp);
imagecopymerge($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp), 50);

header ("Content-type: image/png"); 
imagepng($im);
imagedestroy($im);
 }
?>