<?php
/*======================================================================*\
|| #################################################################### ||
|| # Moderation Auto-PM v4.0.6 for vBulletin 4.0.x by kastak          # ||
|| # ---------------------------------------------------------------- # ||
|| # This is a port of this for vBulletin 3.7.x:					  # ||
|| # http://www.vbulletin.org/forum/showthread.php?t=192344			  # ||
|| # ---------------------------------------------------------------- # ||
|| # This is not part of vBulletin                                    # ||
|| # This is a free software!							              # ||
|| # Copyright 2011 kastak (kastak@gmail.com). All Rights Reserved.   # ||
|| #################################################################### ||
\*======================================================================*/

function mod_pm($itemid, $action, $type, $source_id, $dest = 0, $reason = '', $extra = '')
{
	global $vbulletin, $vbphrase;

	if (!$modpm_checker = new modpm_checker($vbulletin, $action, $type))
	{
		return false;
	}

	if (!$modpm_checker->check_send_status($vbulletin))
	{
		return false;
	}

	if ($modpm_checker->exclude !== false)
	{
		if ($type != 'thread')
		{
			$sourceid = $vbulletin->db->query_first("
				SELECT thread.forumid AS source_id
				FROM " . TABLE_PREFIX . "thread AS thread
				LEFT JOIN " . TABLE_PREFIX . "post AS post ON (post.threadid = thread.threadid)
				WHERE post.threadid='" . $vbulletin->db->escape_string($source_id) . "'
			");
			if ($dest)
			{
				$destid = $vbulletin->db->query_first("
					SELECT thread.forumid AS dest_id
					FROM " . TABLE_PREFIX . "thread AS thread
					LEFT JOIN " . TABLE_PREFIX . "post AS post ON (post.threadid = thread.threadid)
					WHERE post.threadid='" . $vbulletin->db->escape_string($dest) . "'
				");
			}
		}
		$source = (($type == 'thread') ? $source_id : $sourceid['source_id']);

		if ($dest)
		{
			$destination = (($type == 'thread') ? $dest : $destid['dest_id']);
		}
		else
		{
			$destination = $dest;
		}

		if (in_array($source, $modpm_checker->exclude) OR in_array($destination, $modpm_checker->exclude))
		{
			return false;
		}
	}

	if(!$vbulletin->userinfo['userid'])
	{
		return false;
	}

	switch($type)
	{
		case 'thread':
		{
			$info = $vbulletin->db->query_first("
				SELECT title AS item_name, postuserid AS userid, postusername AS username, dateline
				FROM " . TABLE_PREFIX . "thread
				WHERE threadid = '" . $vbulletin->db->escape_string($itemid) . "'
			");
 			break;
		}
		case 'post':
		case 'attachment':
		{
			$info = $vbulletin->db->query_first("
				SELECT post.pagetext AS item_name, post.userid AS userid, post.username AS username, thread.threadid AS source_id, thread.title AS source_name, post.dateline AS dateline
				FROM " . TABLE_PREFIX . "post AS post
				LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid)
				WHERE postid='" . $vbulletin->db->escape_string($itemid) . "'
			");
 			break;
		}
 		default:
		{
 			$info = '';
		}
	}

	if ($info['userid'] == $vbulletin->userinfo['userid'])
	{
		return false;
	}

	if ($vbulletin->options['be_modpm_exclude_usergroup'] != '')
	{
		$user_info = fetch_userinfo($info['userid']);
		
		if (is_member_of($user_info, explode(',', $vbulletin->options['be_modpm_exclude_usergroup'])))
		{
			return false;
		}
	}

	if ($type == 'thread')
	{
		$canview = explode(':', $modpm_checker->canview($vbulletin, $info['userid'], $source_id, $dest));

		if ($canview[0]) $source_name = $vbulletin->db->query_first("SELECT title_clean FROM " . TABLE_PREFIX . "forum WHERE forumid= '" . $vbulletin->db->escape_string($source_id) . "'");
		if ($canview[1]) $dest_name = $vbulletin->db->query_first("SELECT title_clean FROM " . TABLE_PREFIX . "forum WHERE forumid= '" . $vbulletin->db->escape_string($dest) . "'");
	}

	if ($type == 'post' AND $dest)
	{
		$dest_name = $vbulletin->db->query_first("SELECT title AS title_clean FROM " . TABLE_PREFIX . "thread WHERE threadid=" . $vbulletin->input->clean($dest, TYPE_UINT));
	}

	if ($type == 'thread' AND $action == 'edit_title')
	{
		$title_old = $info['item_name'];
		$info['item_name'] = $extra;
	}

	if ($dest AND $vbulletin->options['be_modpm_recyclebin'])
	{
		if ($type == 'post')
		{
			$dest_forum = $vbulletin->db->query_first("SELECT forumid FROM " . TABLE_PREFIX . "thread WHERE threadid=" . $vbulletin->input->clean($dest, TYPE_UINT));
		}

		if (($dest == $vbulletin->options['be_modpm_recyclebin'] AND $type == 'thread') OR ($dest_forum['forumid'] == $vbulletin->options['be_modpm_recyclebin'] AND $type == 'post'))
		{
			if ($action == 'move')
			{
				$action = 'delete';
				// $reason = $vbphrase['modpm_text_moved_to_trash'];
				$recipient = fetch_userinfo($info['userid']);
				eval($modpm_checker->fetch_proper_phrases('modpm_text_moved_to_trash', 'reason', $recipient['languageid']));
			}
		}
	}

	if ($vbulletin->options['be_modpm_agecutoff'])
	{
		$cutoff = TIMENOW - $vbulletin->options['be_modpm_agecutoff'] * 86400;

		if ($info['dateline'] < $cutoff)
		{
			return false;
		}
	}

	// $title = $vbphrase['modpm_title_' . $type . '_' . $action];
	// $message = construct_phrase($vbphrase['modpm_text_' . $type . '_' . $action], $info['username'], $itemid, $info['item_name'], $info['source_id'], $info['source_name'], $dest, $dest_name['title_clean'], $reason, $title_old, $info['forum_url'], $info['bbtitle']);

	// set some required variables (for the pm)
	$modpm[username] = $info['username'];
	$modpm[itemid] = $itemid;
	$modpm[item_name] = htmlspecialchars_uni(fetch_censored_text(fetch_trimmed_title(strip_bbcode($info['item_name'], true, true), 60))) . ($type == 'post' ? '...' : '');
	$modpm[source_id] = (($type == 'thread') ? $source_id : $info['source_id']);
	$modpm[source_name] = (($type == 'thread') ? $source_name['title_clean'] : $info['source_name']);
	$modpm[dest] = $dest;
	$modpm[destname] = $dest_name['title_clean'];
	$modpm[reason] = $reason;
	$modpm[title_old] = $title_old;
	$modpm[forum_url] = $vbulletin->options['bburl'];
	$modpm[bbtitle] = $vbulletin->options['bbtitle'];

	if($vbulletin->options['be_modpm_fromid'])
	{
		$pmsender = fetch_userinfo($vbulletin->options['be_modpm_fromid']);
	}
	else
	{
		$pmsender = fetch_userinfo($vbulletin->userinfo['userid']);
	}

	$pmrecipient = fetch_userinfo($info['userid']);
	eval($modpm_checker->fetch_proper_phrases('modpm_title_' . $type . '_' . $action, 'title', $pmrecipient['languageid']));
	eval($modpm_checker->fetch_proper_phrases('modpm_text_' . $type . '_' . $action, 'message', $pmrecipient['languageid']));

	// create the DM to do error checking and insert the new PM
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
	$pmperms['adminpermissions'] = 2;
	$pmdm->overridequota = true;
	$pmdm->set_info('is_automated', true);
	$pmdm->set('fromuserid', $pmsender['userid']);
	$pmdm->set('fromusername', $pmsender['username']);
	$pmdm->set_info('receipt', false);
	$pmdm->set_info('savecopy', false);
	$pmdm->set('title', $title);
	$pmdm->set('message', $message);
	$pmdm->set_recipients($info['username'], $pmperms, 'cc');
	$pmdm->set('dateline', TIMENOW);
	$pmdm->set('showsignature', 1);
	$pmdm->set('allowsmilie', 1);

	$pmdm->pre_save();
	if (!empty($pmdm->errors))
	{
		// print_r($pmdm->errors);
		unset($pmdm);
		return false;
	}
	else
	{
		$pmdm->save();
	}
	unset($pmdm);
	return true;
}

/*======================================================================*\
|| #################################################################### ||
|| # Moderation Auto-PM v4.0.6 for vBulletin 4.0.x by kastak          # ||
|| #################################################################### ||
\*======================================================================*/
?>