<?php
/*======================================================================*\
|| #################################################################### ||
|| # Moderation Auto-PM v4.0.6 for vBulletin 4.0.x by kastak          # ||
|| # ---------------------------------------------------------------- # ||
|| # This is a port of this for vBulletin 3.7.x:					  # ||
|| # http://www.vbulletin.org/forum/showthread.php?t=192344			  # ||
|| # ---------------------------------------------------------------- # ||
|| # This is not part of vBulletin                                    # ||
|| # This is a free software!							              # ||
|| # Copyright 2011 kastak (kastak@gmail.com). All Rights Reserved.   # ||
|| #################################################################### ||
\*======================================================================*/ 

class modpm_checker
{
	var $actions = array(
		'delete',
		'physicaldelete',
		'undelete',
		'open',
		'close',
		'approve',
		'unapprove',
		'stick',
		'unstick',
		'move',
		'merge',
		'edit_title',
		'ajax_edit'
	);

	var $action = '';
	var $type = '';
	var $exclude = false;
	var $registry = null;

	function modpm_checker(&$registry, $action = '', $type = '')
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error('Registry object is not an object', E_USER_ERROR);
		}

		if ($this->registry->options['be_modpm_exclude'] != '')
		{
			$this->exclude = explode(',', $this->registry->options['be_modpm_exclude']);
		}

		if (in_array($action, $this->actions))
		{
			$this->action = $action;
		}
		else 
		{
			return false;
		}

		if (($type == 'thread') OR ($type == 'post') OR ($type == 'attachment'))
		{
			$this->type = $type;
		}
		else
		{
			return false;
		}
	}

	function canview(&$registry, $userid = 0, $source = 0, $dest = 0)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error('Registry object is not an object', E_USER_ERROR);
		}

		$userinfo = fetch_userinfo($userid);
		cache_permissions($userinfo);

		$this->view_source = ($userinfo['forumpermissions']["$source"] & $this->registry->bf_ugp_forumpermissions['canview']);
		$this->view_dest = ($userinfo['forumpermissions']["$dest"] & $this->registry->bf_ugp_forumpermissions['canview']);

		return $this->view_source . ':' . $this->view_dest;
	}

	function check_send_status(&$registry)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error('Registry object is not an object', E_USER_ERROR);
		}

		if (!$this->registry->options['enablepms'])
		{
			return false;
		}

		if (!$this->registry->options['be_modpm_' . $this->type . '_' . $this->action])
		{
			return false;
		}
		return true;
	}

	function fetch_proper_phrases($phrase, $variable, $languageid = -1, $phrase_type = 'global', $phrase_prefix = '')
	{
		if (!function_exists('fetch_phrase'))
		{
			require_once(DIR . '/includes/functions_misc.php');
		}

		return '$' . $variable . ' = "' . fetch_phrase($phrase_prefix . $phrase, $phrase_type, '', true, iif($languageid >= 0, true, ''), $languageid, false) . '";';
	}
}

/*======================================================================*\
|| #################################################################### ||
|| # Moderation Auto-PM v4.0.6 for vBulletin 4.0.x by kastak          # ||
|| #################################################################### ||
\*======================================================================*/
?>