<?php
/*========================================================================*\
|| ###################################################################### ||
|| # Video-Directory 1.1.3 (videotag.php)	 					# ||
|| # -------------------------------------------------------------------# ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		# ||
|| # 		With significant modification by Jason Axelrod.			# ||
|| # This file may not be redistributed in whole or significant part.	# ||
|| # -------------------------------------------------------------------# ||
|| # 												# ||
|| ###################################################################### ||
\*========================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'videotag');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('posting', 'showthread');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'newpost_errormessage',
	'video_tag_edit',
	'tag_managebit',
	'tagbit',
	'tagbit_wrapper'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_videodirectory.php');
require_once(DIR . '/includes/functions_videotags.php');

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage';
}

$vbulletin->input->clean_array_gpc('r', array(
	'videoid'		=> TYPE_UINT
));

$videoinfo = verify_id('video', $vbulletin->GPC['videoid'], 1, 1);

$caneditvideo = (((($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canadd']) AND $videoinfo['userid'] == $vbulletin->userinfo['userid']) OR ($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canmoderate'])) ? true : false);

if (!$caneditvideo)
{
	print_no_permission();
}

$show['manage_existing_option'] = 'true';

// ##############################################################################
if ($_POST['do'] == 'managetags')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'tagskept' => TYPE_ARRAY_UINT,
		'tagsshown' => TYPE_ARRAY_UINT,
		'taglist' => TYPE_NOHTML,
		'ajax' => TYPE_BOOL
	));

	if ($vbulletin->GPC['ajax'])
	{
		$vbulletin->GPC['taglist'] = convert_urlencoded_unicode($vbulletin->GPC['taglist']);
	}

	if ($vbulletin->GPC['tagsshown'] AND $show['manage_existing_option'])
	{
		$tags_sql = $db->query_read("
			SELECT videotag.*, videotagvideo.userid
			FROM " . TABLE_PREFIX . "videotagvideo AS videotagvideo
			INNER JOIN " . TABLE_PREFIX . "videotag AS videotag ON (videotag.tagid = videotagvideo.tagid)
			WHERE videotagvideo.videoid = $videoinfo[videoid]
				AND videotagvideo.tagid IN (" . implode(',', $vbulletin->GPC['tagsshown']) . ")
		");

		$delete = array();
		while ($tag = $db->fetch_array($tags_sql))
		{
			if (($tag['userid'] == $vbulletin->userinfo['userid']) OR ($videoinfo['userid'] == $vbulletin->userinfo['userid']) OR $caneditvideo)
			{
				if (!in_array($tag['tagid'], $vbulletin->GPC['tagskept']))
				{
					$delete[] = $tag['tagid'];
				}
			}
		}

		if ($delete)
		{
			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "videotagvideo
				WHERE videoid = $videoinfo[videoid]
					AND tagid IN (" . implode(',', $delete) . ")
			");

			$videoinfo['taglist'] = rebuild_video_taglist($videoinfo);
		}
	}

	if ($vbulletin->GPC['taglist'])
	{
		$errors = add_tags_to_video($videoinfo, $vbulletin->GPC['taglist']);
	}
	else
	{
		$errors = array();
	}

	if ($vbulletin->GPC['ajax'])
	{ 
		$videoinfo = $db->query_first("
			SELECT video.*
			FROM " . TABLE_PREFIX . "video AS video
			WHERE video.videoid = '" . $videoinfo['videoid'] . "'
		");
		$taglist = rebuild_video_taglist($videoinfo);

		$tagcount = ($taglist ? count(explode(', ', $taglist)) : 0);

		require_once(DIR . '/includes/class_xml.php');

		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('tag');
			$xml->add_tag('taghtml', process_replacement_vars(rebuild_video_taglist($videoinfo)));
			if ($errors)
			{
				$errorlist = '';
				foreach ($errors AS $error)
				{
					$errorlist .= "\n   * $error";
				}
				$xml->add_tag('warning', fetch_error('tag_add_failed_plain', $errorlist));
			}
		$xml->close_group();
		$xml->print_xml();
	}
	else
	{
		if ($errors)
		{
			$errorlist = '';
			foreach ($errors AS $key => $errormessage)
			{
				eval('$errorlist .= "' . fetch_template('newpost_errormessage') . '";');
			}

			$errorlist = fetch_error('tag_add_failed_html', $errorlist, 'video.php?do=viewdetails&' . $vbulletin->session->vars['sessionurl'] . "videoid=$videoinfo[videoid]#taglist");

			$_REQUEST['do'] = 'manage';
			define('ADD_ERROR', true);
		}
		else
		{
			$vbulletin->url = 'video.php?do=viewdetails&' . $vbulletin->session->vars['sessionurl'] . "videoid=$videoinfo[videoid]#taglist";
			eval(print_standard_redirect(fetch_error('tags_edited_successfully'), false));
		}
	}
}

// ##############################################################################
if ($_REQUEST['do'] == 'manage')
{
	$tags_sql = $db->query_read("
		SELECT videotag.*, videotagvideo.userid, user.username
		FROM " . TABLE_PREFIX . "videotagvideo AS videotagvideo
		INNER JOIN " . TABLE_PREFIX . "videotag AS videotag ON (videotag.tagid = videotagvideo.tagid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = videotagvideo.userid)
		WHERE videotagvideo.videoid = $videoinfo[videoid]
		ORDER BY videotag.tagtext
	");
	$total_tags = $db->num_rows($tags_sql);

	$cat_sql = $db->query_read("
		SELECT videocategory.*
		FROM " . TABLE_PREFIX . "videocategory AS videocategory
		WHERE videocategoryid = $videoinfo[videocategoryid]
	");

	$catinfo = $db->fetch_array($cat_sql);

	while ($tag = $db->fetch_array($tags_sql))
	{
		$tag['ismine'] = ($tag['userid'] == $vbulletin->userinfo['userid']);
		$show['tag_checkbox'] = ($tag['ismine']
			OR ($videoinfo['userid'] == $vbulletin->userinfo['userid'])
			OR ($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canmoderate'])
		);

		if ($show['tag_checkbox'])
		{
			$have_removal_tags = true;
		}

		eval('$tag_manage_options .= "' . fetch_template('tag_managebit') . '";');
	}

	if ($vbulletin->GPC['ajax'])
	{
		eval('$html = "' . fetch_template('video_tag_edit_ajax') . '";');

		require_once(DIR . '/includes/class_xml.php');

		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('tag');
			$xml->add_tag('html', process_replacement_vars($html));
			$xml->add_tag('delimiters', $vbulletin->options['tagdelimiter']);
		$xml->close_group();
		$xml->print_xml();
	}

	$videoinfo['url'] = construct_video_url($videoinfo);

	$navbits = array();
	$navbits['video.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['videos'];
	$navbits[construct_category_url($catinfo)] = $catinfo['title'];
	$navbits[construct_video_url($videoinfo)] = $videoinfo['title'];
	$navbits[''] = $vbphrase['tag_management'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('video_tag_edit') . '");');
}

?>