<?php
/*========================================================================*\
|| ###################################################################### ||
|| # Video-Directory 1.2.2 (functions_videodirectory.php)			# ||
|| # -------------------------------------------------------------------# ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		# ||
|| # 		With significant modification by Jason Axelrod.			# ||
|| # This file may not be redistributed in whole or significant part.	# ||
|| # -------------------------------------------------------------------# ||
|| # 												# ||
|| ###################################################################### ||
\*========================================================================*/

function fetch_videothumbnail(&$video)
{
	global $vbulletin;

	$video['thumbnailpath'] = $vbulletin->options['videodirectory_thumbnaildir'] . '/' . $video['videoservice'] . '/' . $video['videoidservice'] . '.jpg';

	return $video['thumbnailpath'];
}

function build_video_counters($videoid)
{
	global $vbulletin;

	if (!$videoinfo = $vbulletin->db->query_first("
		SELECT video.*
		FROM " . TABLE_PREFIX . "video AS video
		WHERE video.videoid = '" . intval($videoid) . "'")
	)
	{
		return false;
	}

	$count = $vbulletin->db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "videocomment
		WHERE videoid = '" . intval($videoinfo['videoid']) . "' AND state = 'visible'
	");

	//We don't need to initialize the dastamanager fpr this update
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "video SET commentcount = '" . $count['total'] . "' WHERE videoid = '" . $videoinfo['videoid'] . "'");
}

function construct_small_video_bit(&$video)
{
	global $vbphrase, $vbulletin, $bgclass, $show, $stylevar;

	$bgclass = exec_switch_bg();
	fetch_videothumbnail($video);

	if ($vbulletin->options['videodirectory_titlepreviewlen'])
	{
		$video['title'] = fetch_trimmed_title($video['title'], $vbulletin->options['videodirectory_titlepreviewlen']);
	}

	$video['url'] = construct_video_url($video);

	if ($video['timelength'] == 0)
	{
		$video['timelength'] = "???";
	}
	else
	{
		$duration = $video['timelength'];
		$minutes = floor($duration / 60);
		$seconds = $duration % 60;
		$seconds = str_pad($seconds, 2, "0", STR_PAD_LEFT); 
		$video['timelength'] = "$minutes:$seconds";
	}

	eval('$bit = "' . fetch_template('video_bit_small') . '";');

	return $bit;
}

function construct_video_bit(&$video, $showcat = true, $perrow = 1)
{
	global $vbphrase, $vbulletin, $bgclass, $show, $stylevar;

	if(preg_match("/HD/", $video['videoservice']))
	{
		$video['isHD'] = true;
	}
	else
	{
		$video['isHD'] = false;
	}

	$video['description'] = htmlspecialchars_uni(strip_bbcode($video['description']));

	if ($vbulletin->options['videodirectory_descpreviewlen'])
	{
		$video['description'] = fetch_trimmed_title($video['description'], $vbulletin->options['videodirectory_descpreviewlen']);
	}

	if ($vbulletin->options['videodirectory_titlepreviewlen'])
	{
		$video['title'] = fetch_trimmed_title($video['title'], $vbulletin->options['videodirectory_titlepreviewlen']);
	}

	$video['views'] = vb_number_format($video['views']);

	$video['date'] = vbdate($vbulletin->options['dateformat'], $video['dateline']);
	$video['time'] = vbdate($vbulletin->options['timeformat'], $video['dateline']);

	fetch_musername($video);

	if ($showcat)
	{
		$video['cattitle'] =& $vbulletin->videocats["$video[videocategoryid]"]['title'];
		$video['caturl'] = construct_category_url($vbulletin->videocats["$video[videocategoryid]"]);
	}

	if ($video['ratingnum'])
	{
		$video['ratingavg'] = vb_number_format($video['ratingtotal'] / $video['ratingnum'], 2);
		$video['rating'] = intval(round($video['ratingtotal'] / $video['ratingnum']));
		$show['video_rating'] = true;
	}
	else
	{
		$show['video_rating'] = false;
	}

	$video['url'] = construct_video_url($video);
	$video['userurl'] = construct_user_url($video);

	if ($video['timelength'] == 0)
	{
		$video['timelength'] = "???";
	}
	else
	{
		$duration = $video['timelength'];
		$minutes = floor($duration / 60);
		$seconds = $duration % 60;
		$seconds = str_pad($seconds, 2, "0", STR_PAD_LEFT); 
		$video['timelength'] = "$minutes:$seconds";
	}

	fetch_videothumbnail($video);

	$taglist = $video['cachetags'];

	if ($perrow == 1) { eval('$bit .= "<tr>";'); }
	if ($vbulletin->options['videodirectory_vidbitsperrow'] > 1)
	{
		eval('$bit .= "' . fetch_template('video_bit_more') . '";');
	}
	else
	{
		eval('$bit .= "' . fetch_template('video_bit') . '";');
	}
	if ($perrow == $vbulletin->options['videodirectory_vidbitsperrow']) { eval('$bit .= "</tr>";'); }

	return $bit;
}

function construct_video_url(&$video)
{
	global $vbulletin;
	if (defined('VBSEO_ENABLED'))
	{
		$cat =& $vbulletin->videocats["$video[videocategoryid]"];
		$url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewdetails&categoryid=' . $video['videocategoryid'] . '&categorytitle=' . vbseo_filter_text($cat['title']) . '&videoid=' . $video['videoid'] . '&videotitle=' . vbseo_filter_text($video['title']);
	}
	elseif (defined('SEO_ENABLED'))
	{
		global $vbulletin;
		$title = $video['title'];
		$title = strtolower($title);
		$title = unhtmlspecialchars($title);
		$title = str_replace("'", '', $title);
		$title = preg_split("#[^a-z0-9]#", $title, -1, PREG_SPLIT_NO_EMPTY);
		$title = array_slice($title, 0, 8);
		$title = implode("-",$title);
		$url = 'video-' . $title . '-v' . $video['videoid'];
		unset($title);
	}
	else
	{
		$url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewdetails&videoid=' . $video['videoid'];
	}

	return $url;
}

function construct_category_url(&$category)
{
	global $vbulletin;
	if (defined('VBSEO_ENABLED'))
	{
		$url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewcategory&amp;categoryid=' . $category['videocategoryid'] . '&amp;categorytitle=' . vbseo_filter_text($category['title']);
	}
	elseif (defined('SEO_ENABLED'))
	{
		global $vbulletin;
		$title = $category['title'];
		$title = strtolower($title);
		$title = unhtmlspecialchars($title);
		$title = str_replace("'", '', $title);
		$title = preg_split("#[^a-z0-9]#", $title, -1, PREG_SPLIT_NO_EMPTY);
		$title = array_slice($title, 0, 8);
		$title = implode("-",$title);
		$url = 'video-' . $title . '-c' . $category['videocategoryid'];
		unset($title);
	}
	else
	{
		$url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewcategory&amp;categoryid=' . $category['videocategoryid'];
	}

	return $url;
}

function construct_user_url(&$user)
{
	global $vbulletin;
	if (defined('VBSEO_ENABLED'))
	{
		$url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewuser&amp;userid=' . $user['userid'] . '&amp;username=' . vbseo_filter_text($user['username']);
	}
	elseif (defined('SEO_ENABLED'))
	{
		global $vbulletin;
		$title = $user['username'];
		$title = strtolower($title);
		$title = unhtmlspecialchars($title);
		$title = str_replace("'", '', $title);
		$title = preg_split("#[^a-z0-9]#", $title, -1, PREG_SPLIT_NO_EMPTY);
		$title = array_slice($title, 0, 8);
		$title = implode("-",$title);
		$url = 'video-' . $title . '-u' . $user['userid'];
		unset($title);
	}
	else
	{
		$url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewuser&amp;userid=' . $user['userid'];
	}

	return $url;
}

?>