<?php
/*========================================================================*\
|| ###################################################################### ||
|| # Video-Directory 1.1.3 (class_dm_videocategory.php)			# ||
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		# ||
|| # 		With significant modification by Jason Axelrod.			# ||
|| # This file may not be redistributed in whole or significant part.	# ||
|| # -------------------------------------------------------------------# ||
|| # 												# ||
|| ###################################################################### ||
\*========================================================================*/

/**
* Class to do data save/delete operations for Video Categories
*
*/

class vB_DataManager_VideoCategory extends vB_DataManager
{
	/**
	* Array of recognised and required fields for video categories
	*
	* @var	array
	*/
	var $validfields = array(
		'videocategoryid'	=> array(TYPE_UINT,		REQ_INCR),
		'active'		=> array(TYPE_BOOL,		REQ_NO),
		'title'			=> array(TYPE_NOHTML,		REQ_YES,	VF_METHOD),
		'description'		=> array(TYPE_STR,		REQ_YES,	VF_METHOD),
		'usergroups'		=> array(TYPE_NOCLEAN,		REQ_NO,		VF_METHOD),
		'displayorder'		=> array(TYPE_INT,		REQ_NO),
		'level'			=> array(TYPE_INT,		REQ_YES)
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	* For example: var $bitfields = array('options' => 'bf_misc_useroptions', 'permissions' => 'bf_misc_moderatorpermissions')
	*
	* @var	array
	*/
	var $bitfields = array();

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'videocategory';

	/**
	* Array to store stuff to save to videocategory table
	*
	* @var	array
	*/
	var $videocategory = array();

	/**
	* Condition template for update query
	*
	* @var	array
	*/
	var $condition_construct = array('videocategoryid = %1$d', 'videocategoryid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vB_DataManager_VideoCategory(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	/**
	* Verifys the Value for the usergroup-Field
	*
	* @param	array		Array of Usergroups
	*
	* @return	bool		True on success, else false
	*/
	function verify_usergroups(&$usergroups)
	{
		if (!is_array($usergroups))
		{
			return true;
		}

		$ugs = array();
		foreach ($usergroups AS $usergroupid)
		{
			if ($this->registry->usergroupcache["$usergroupid"]['usergroupid'])
			{
				$ugs[] = $usergroupid;
			}
		}

		$usergroups = implode(',', $ugs);
		return true;
	}

	/**
	* Verifys the title
	*
	* @param	string		Title
	*
	* @return	bool		True if title is okay
	*/
	function verify_title(&$title)
	{
		if (!strlen(trim($title)))
		{
			$this->error('notitle');
			return false;
		}

		return true;
	}

	/**
	* Verifys the description
	*
	* @param	string		description
	*
	* @return	bool		True if description is okay
	*/
	function verify_description(&$desc)
	{
		if (!strlen(trim($desc)))
		{
			$this->error('nodescription');
			return false;
		}

		return true;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean
	*/
	function post_save_once($doquery = true)
	{
		$this->build_category_cache();
		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean
	*/
	function post_delete($doquery = true)
	{
		$this->build_category_cache();

		$this->dbobject->query_write("
			DELETE FROM " . TABLE_PREFIX . "video WHERE videocategoryid = '" . $this->fetch_field('videocategoryid') . "'
		");

		return true;
	}

	/**
	* Builds the Category Cache
	*
	*/
	function build_category_cache()
	{
		$cats = $this->dbobject->query_read("SELECT * FROM " . TABLE_PREFIX . "videocategory ORDER BY displayorder ASC");
		$cache = array();

		while ($cat = $this->dbobject->fetch_array($cats))
		{
			$cat['usergroups'] = explode(',', $cat['usergroups']);
			$cache["$cat[videocategoryid]"] = $cat;
		}

		build_datastore('videocats', serialize($cache), true);
	}
}

?>