/*==========================================================================*\
|| ######################################################################## ||
|| # Video-Directory 1.1.8 (vbulletin_ajax_videodirectory.js)		  # ||
|| # -------------------------------------------------------------------- # ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		  # ||
|| # 		With significant modification by Jason Axelrod.			  # ||
|| # This file may not be redistributed in whole or significant part.	  # ||
|| # -------------------------------------------------------------------- # ||
|| # 												  # ||
|| ######################################################################## ||
\*==========================================================================*/

function request_videoinfo()
{
	if (!fetch_object('videourl').value)
	{
		return false;
	}

	YAHOO.util.Connect.asyncRequest("POST", "video.php?do=videoinfo", {
		success: handel_videoinfo,
		failure: vBulletin_AJAX_Error_Handler,
		timeout: 15000
	}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + "&url=" + PHP.urlencode(fetch_object('videourl').value) + "&wysiwyg=" + vB_Editor[editor_id].wysiwyg_mode);

	fetch_object('videoajaxbutton').value = vbphrase['requesting_information_please_wait'];
	fetch_object('videoajaxbutton').disabled = true;

	return false;
}

function handel_videoinfo(ajax)
{
	if (ajax.responseXML)
	{
		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			fetch_object('thumbnail').setAttribute('src', '');
			fetch_object('thumbnail_border').style.display = 'none';
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			try
			{
				var description = ajax.responseXML.getElementsByTagName('description')[0].firstChild.nodeValue;
				vB_Editor[editor_id].insert_text(description);
			}
			catch (e)
			{
			}

			try
			{
				var title = ajax.responseXML.getElementsByTagName('title')[0].firstChild.nodeValue;
				fetch_object('videotitle').value = title;
			}
			catch (e)
			{
			}

			try
			{
				var embedpreview = ajax.responseXML.getElementsByTagName('embedpreview')[0].firstChild.nodeValue;
				fetch_object('vidpreview').innerHTML = embedpreview;
			}
			catch (e)
			{
			}

			try
			{
				var duration = ajax.responseXML.getElementsByTagName('duration')[0].firstChild.nodeValue;

				var minutes = Math.floor(duration/60);
				var seconds = duration % 60;
				fetch_object('timekeyM').value = minutes;
				fetch_object('timekeyS').value = seconds;
			}
			catch (e)
			{
			}

			try
			{
				var videothumbnailpath = ajax.responseXML.getElementsByTagName('thumbnailpath')[0].firstChild.nodeValue;
				fetch_object('thumbnail').setAttribute('src', videothumbnailpath);
				fetch_object('thumbnail_border').style.display = '';
			}
			catch (e)
			{
			}

			try
			{
				var keywords = ajax.responseXML.getElementsByTagName('keywords')[0].firstChild.nodeValue;
				if (fetch_object('retrievetags').value) { fetch_object('taglist').value = keywords; }
			}
			catch (e)
			{
			}
		}
	}
	fetch_object('videoajaxbutton').value = vbphrase['request_videoinfo_from_service'];
	fetch_object('videoajaxbutton').disabled = false;
}