<?php
/*========================================================================*\
|| ###################################################################### ||
|| # Video-Directory 1.1.3 (videoajax.php)					# ||
|| # -------------------------------------------------------------------# ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		# ||
|| # 		With significant modification by Jason Axelrod.			# ||
|| # This file may not be redistributed in whole or significant part.	# ||
|| # -------------------------------------------------------------------# ||
|| # 												# ||
|| ###################################################################### ||
\*========================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'ajax');
define('CSRF_PROTECTION', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array(
	'video',
	'posting'
);

// get special data templates from the datastore
$specialtemplates = array('bbcodecache');

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array(
	'fetchuserfield' => array(

	)
);

$_POST['ajax'] = 1;

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_bbcode.php');
require_once(DIR . '/includes/class_xml.php');
require_once(DIR . '/includes/functions_videodirectory.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// #############################################################################
// tag search

if ($_POST['do'] == 'tagsearch')
{
	$vbulletin->input->clean_array_gpc('p', array('fragment' => TYPE_STR));

	$vbulletin->GPC['fragment'] = convert_urlencoded_unicode($vbulletin->GPC['fragment']);

	if ($vbulletin->GPC['fragment'] != '' AND strlen($vbulletin->GPC['fragment']) >= 3)
	{
		$fragment = htmlspecialchars_uni($vbulletin->GPC['fragment']);
	}
	else
	{
		$fragment = '';
	}

	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('tags');

	if ($fragment != '')
	{
		$tags = $db->query_read_slave("
			SELECT tagtext
			FROM " . TABLE_PREFIX . "videotag
			WHERE tagtext LIKE '" . $db->escape_string_like($fragment) . "%'
			ORDER BY tagtext
			LIMIT 15
		");
		while ($tag = $db->fetch_array($tags))
		{
			$xml->add_tag('tag', $tag['tagtext']);
		}
	}

	$xml->close_group();
	$xml->print_xml();
}

if ($_REQUEST['do'] == 'postcomment')
{
	$videoid = $vbulletin->input->clean_gpc('r', 'videoid', TYPE_UINT);
	$message = $vbulletin->input->clean_gpc('r', 'message', TYPE_STR);

	$message = convert_urlencoded_unicode($message);

	$dm =& datamanager_init('VideoComment', $vbulletin, ERRTYPE_STANDARD);
	$dm->setr('videoid', $videoid);
	$dm->setr('message', $message);
	$dm->set('state', 'visible');
	$dm->save();

	echo '1';
}

if ($_REQUEST['do'] == 'deletecomment')
{
	$commentid = $vbulletin->input->clean_gpc('r', 'cmntid', TYPE_UINT);

	$videocomment = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "videocomment WHERE videocommentid = '" . $commentid . "'");

	$dm =& datamanager_init('VideoComment', $vbulletin);
	$dm->set_existing($videocomment);
	$dm->delete();
}

if ($_REQUEST['do'] == 'getcomments')
{
	$videoid = $vbulletin->input->clean_gpc('r', 'videoid', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'page', TYPE_UINT);

	$commentcount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "videocomment
		WHERE state = 'visible' AND videoid = '" . $videoid . "'
	");

	sanitize_pageresults($commentcount['total'], $pagenumber, $perpage, 100, $vbulletin->options['videodirectory_commentsperpage']);

	// Default lower and upper limit variables
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $commentcount['total'])
	{
		// Too many for upper limit
		$limitupper = $commentcount['total'];
		if ($limitlower > $commentcount['total'])
		{
			// Too many for lower limit
			$limitlower = $commentcount['total'] - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		// Can't have negative or null lower limit
		$limitlower = 1;
	}
	$comments = $db->query_read("
		SELECT comment.*, IF(NOT ISNULL(user.userid), user.username, comment.postusername) AS username,
			user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, 
			customavatar.dateline AS avatardateline, customavatar.width_thumb AS width_thumb, customavatar.height_thumb AS height_thumb
		FROM " . TABLE_PREFIX . "videocomment AS comment
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = comment.postuserid)
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid)
		WHERE comment.videoid = '" . $videoid . "' AND comment.state = 'visible'
		ORDER BY comment.dateline DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
	");

	$bbcode_parser_comment =& new vB_BbcodeParser($vbulletin, fetch_tag_list());

	$thumb = true;
	while ($comment = $db->fetch_array($comments))
	{
		$bgclass = exec_switch_bg();
		$comment['message'] = $bbcode_parser_comment->parse($comment['message'], 'videodirectory_reply');

		$show['deletionlink'] = ($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canmoderate']);

		$comment['date'] = vbdate($vbulletin->options['dateformat'], $comment['dateline']);
		$comment['time'] = vbdate($vbulletin->options['timeformat'], $comment['dateline']);

		fetch_musername($comment);

			if (!empty($comment['avatarpath'])) {
				$comment['avatar'] = array($comment['avatarpath']);
			} else if ($comment['hascustom']) {
				$avatarurl = array('hascustom' => 1);
				if ($vbulletin->options['usefileavatar']) {
					$comment['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$comment['postuserid']}_{$comment['avatarrevision']}.gif";
				} else {
					$comment['avatarurl'] = "image.php?u=$comment[postuserid]&amp;dateline=$comment[avatardateline]" . ($thumb ? '&type=thumb' : '') ;
				}
			}
			if ($thumb) {
				if ($comment['width_thumb'] AND $comment['height_thumb']) {
					$avatarwidth = $comment['width_thumb'];
					$avatarheight = $comment['height_thumb'];
				}
			}
			if (empty($comment['avatarurl'])) {
				$comment['avatarurl'] = $stylevar['imgdir_misc'] . '/unknown.gif';
			}

		eval('$commentbits .= "' . fetch_template('video_commentbit') . '";');
	}

	$commentbits = preg_replace('/href="[\w\.\?\=\&\;]+?commentid=(\d+)"/i', 'href="#comments" onclick="delComment($2)"', $commentbits);

	echo '<ol class="list_no_decoration alt1 block_row" id="message_list">'.$commentbits.'</ol>';
}

if ($_REQUEST['do'] == 'getpagesel')
{
	$videoid = $vbulletin->input->clean_gpc('r', 'videoid', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'page', TYPE_UINT);
	$perpage = $vbulletin->options['videodirectory_commentsperpage'];

	$commentcount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "videocomment
		WHERE state = 'visible' AND videoid = '" . $videoid . "'
	");

	sanitize_pageresults($commentcount['total'], $pagenumber, $perpage, 100, $vbulletin->options['videodirectory_commentsperpage']);

	$pagenav = construct_page_nav($pagenumber, $perpage, $commentcount['total'], "video.php?do=viewdetails&videoid=", $videoid);
	$pagenav = preg_replace('/href="[\w\.\?\=\&\;]+?videoid=\d+"/i', 'href="#comments" onclick="getComments(1)"', $pagenav);
	$pagenav = preg_replace('/href="[\w\.\?\=\&\;]+?videoid=\d+&amp;page=(\d+)"/i', 'href="#comments" onclick="getComments($1)"', $pagenav);

	echo $pagenav;
}

?>