<?php
/*========================================================================*\
|| ###################################################################### ||
|| # Video-Directory 1.2.3 (video.php)						# ||
|| # -------------------------------------------------------------------# ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		# ||
|| # 		With significant modification by Jason Axelrod.			# ||
|| # This file may not be redistributed in whole or significant part.	# ||
|| # -------------------------------------------------------------------# ||
|| # 												# ||
|| ###################################################################### ||
\*========================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
// define('SEO_ENABLED', true);
define('THIS_SCRIPT', 'video');
define('CSRF_PROTECTION', true);
define('GET_EDIT_TEMPLATES', 'addvideo,editvideo,viewdetails');

if ($_POST['ajax'])
{
	define('LOCATION_BYPASS', 1);
	define('NOPMPOPUP', 1);
}

if ($_REQUEST['do'] == 'rss')
{
	define('NOSHUTDOWNFUNC', 1);
	define('SKIP_SESSIONCREATE', 1);
	define('DIE_QUIETLY', 1);
}

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array(
	'video',
	'posting'
);

$specialtemplates = array(
	'videocats',
	'videohosters',
	'bbcodecache'
);

$globaltemplates = array(
	'video_catbit_small',
	'video_catbit_small_sub',
	'VIDEO_SHELL',
	'VIDEO_SHELL_SIDE',
	'video_bit_small',
	'video_contributorbit',
	'memberinfo_css'
);

$actiontemplates = array(
	'addvideo' => array(
		'video_add',
		'humanverify'
	),
	'editvideo' => array(
		'video_edit'
	),
	'main' => array(
		'video_home',
		'video_bit',
		'video_bit_more'
	),
	'viewdetails' => array(
		'video_details',
		'video_details_embed',
		'showthread_quickreply',
		'video_commentbit',
		'humanverify',
		'forumdisplay_loggedinuser'
	),
	'viewrecent' => array(
		'video_bit',
		'video_bit_more',
		'video_recent'
	),
	'viewcategory' => array(
		'video_bit',
		'video_bit_more',
		'video_category'
	),
	'viewtag' => array(
		'video_bit',
		'video_bit_more',
		'video_tag'
	),
	'viewuser' => array(
		'video_bit',
		'video_bit_more',
		'video_user'
	),
	'deletecomment' => array(
		'video_delete_comment'
	),
	'search' => array(
		'video_searchresults',
		'video_bit',
		'video_bit_more'
	)
);

$actiontemplates['none'] =& $actiontemplates['main'];

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_videosharingservice.php');
require_once(DIR . '/includes/class_vurl.php');
require_once(DIR . '/includes/class_bbcode.php');
require_once(DIR . '/includes/functions_videodirectory.php');
require_once(DIR . '/includes/functions_videotags.php');

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'main';
}

if (!($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canview']))
{
	print_no_permission();
}

$show['newvideo'] = ($vbulletin->bf_ugp_videodirectorypermissions['canadd'] ? true : false);

$vbulletin->input->clean_array_gpc('r', array(
	'categoryid'	=> TYPE_UINT,
	'videoid'		=> TYPE_UINT,
	'commentid'		=> TYPE_UINT,
	'userid'		=> TYPE_UINT,
	'tag'			=> TYPE_STR,
	'categoryids'	=> TYPE_STR,
	'sort'		=> TYPE_STR,
	'order'		=> TYPE_STR
));

$sort = "dateline";
$order = "DESC";
if ($vbulletin->GPC['sort'] == "ratingavg")	{ $sort = "ratingavg"; }
if ($vbulletin->GPC['sort'] == "title")		{ $sort = "title"; }
if ($vbulletin->GPC['order'] == "ASC")		{ $order = "ASC"; }

if ($vbulletin->GPC['categoryid'])
{
	$catinfo =& $vbulletin->videocats["{$vbulletin->GPC['categoryid']}"];
}
else
{
	$catinfo = array();
}

if ($vbulletin->GPC['userid'])
{
	$userinfo = $db->query_first("SELECT user.* FROM " . TABLE_PREFIX . "user AS user WHERE userid = '" . $vbulletin->GPC['userid'] . "'");
}

if ($vbulletin->GPC['tag'])
{
	$taginfo = $db->query_first("SELECT videotag.* FROM " . TABLE_PREFIX . "videotag AS videotag WHERE tagtext = '" . $db->escape_string($vbulletin->GPC['tag']) . "'");
	$tagrss .= '<link rel="alternate" type="application/rss+xml" title="' .  $vbulletin->options['bbtitle'] . ' ' . $vbphrase[videos] . ' - ' . $taginfo[tagtext] . '" href="video.php?do=rss&tag=' . $taginfo[tagtext] . '" />';
}

$catvideocounts_query = $db->query_read("
	SELECT videocategoryid, COUNT(videoid) AS video_count
	FROM " . TABLE_PREFIX . "video
	GROUP BY videocategoryid
	");

$catvideocounts = array();
while ($count = $db->fetch_array($catvideocounts_query))
{
	$catvideocounts["$count[videocategoryid]"] = $count['video_count'];
}

$allowedcats = array(0);
foreach ($vbulletin->videocats AS $catid => $cat)
{
	if (!is_member_of($vbulletin->userinfo, $cat['usergroups']) OR !$cat['active'])
	{
		continue;
	}
	$allowedcats[] = $catid;

	$cat['url'] = construct_category_url($cat);
	$cat['videocount'] = vb_number_format($catvideocounts["$cat[videocategoryid]"]);

	eval('$catbits .= "' . fetch_template('video_catbit_small') . '";');
}

if ($_REQUEST['do'] == 'deletecomment' OR $_POST['do'] == 'killcomment')
{
	if (!($videocomment = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "videocomment WHERE videocommentid = '" . $vbulletin->GPC['commentid'] . "'")))
	{
		eval(standard_error(fetch_error('invalid_videocomment_specified')));
	}

	if (!$videoinfo = $db->query_first("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE video.videoid = '" . $videocomment['videoid'] . "'")
		)
	{
		eval(standard_error(fetch_error('invalid_video_specified')));
	}

	$catinfo =& $vbulletin->videocats["$videoinfo[videocategoryid]"];

	if (!($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canmoderate']))
	{
		print_no_permission();
	}
}

if ($_REQUEST['do'] == 'postcomment')
{
	if (!$videoinfo = $db->query_first("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE video.videoid = '" . $vbulletin->GPC['videoid'] . "'")
	)
	{
		eval(standard_error(fetch_error('invalid_video_specified')));
	}

	$catinfo =& $vbulletin->videocats["$videoinfo[videocategoryid]"];

	if (!($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['cancomment']))
	{
		print_no_permission();
	}
}

if ($_REQUEST['do'] == 'random')
{
	$random = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "video AS video ORDER BY RAND() LIMIT 1");

	header('Location: video.php?do=viewdetails&videoid='.$random['videoid']);
	exit;
}

if ($_REQUEST['do'] == 'viewdetails')
{
	if (!$videoinfo = $db->query_first("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE video.videoid = '" . $vbulletin->GPC['videoid'] . "'")
	)
	{
		eval(standard_error(fetch_error('invalid_video_specified')));
	}
	
	$catinfo =& $vbulletin->videocats["$videoinfo[videocategoryid]"];

	$userinfo = $db->query_first("SELECT user.* FROM " . TABLE_PREFIX . "user AS user WHERE userid = '" . $videoinfo['userid'] . "'");

	$tags = $vbulletin->db->query_read("SELECT videotag.tagtext
			FROM " . TABLE_PREFIX . "videotagvideo AS videotagvideo
			INNER JOIN " . TABLE_PREFIX . "videotag AS videotag ON (videotag.tagid = videotagvideo.tagid)
			WHERE videotagvideo.videoid = $videoinfo[videoid]
			ORDER BY videotag.tagtext
		");

	while ($taginfo = $vbulletin->db->fetch_array($tags))
	{
		$tagrss .= '<link rel="alternate" type="application/rss+xml" title="' .  $vbulletin->options['bbtitle'] . ' ' . $vbphrase[videos] . ' - ' . $taginfo[tagtext] . '" href="video.php?do=rss&tag=' . $taginfo[tagtext] . '" />
';
	}
}

if ($_REQUEST['do'] == 'editvideo' OR $_POST['do'] == 'updatevideo')
{
	if (!$videoinfo = $db->query_first("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE video.videoid = '" . $vbulletin->GPC['videoid'] . "'")
	)
	{
		eval(standard_error(fetch_error('invalid_video_specified')));
	}

	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	if ((!($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['caneditown']) OR $videoinfo['userid'] != $vbulletin->userinfo['userid']) AND !($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canmoderate']))
	{
		print_no_permission();
	}

	$videoinfo[thumbnailpath] = fetch_videothumbnail($videoinfo);
	$catinfo =& $vbulletin->videocats["$videoinfo[videocategoryid]"];
}

if ($_POST['do'] == 'reportvideo')
{
	if (!$videoinfo = $db->query_first("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE video.videoid = '" . $vbulletin->GPC['videoid'] . "'")
		)
	{
		eval(standard_error(fetch_error('invalid_video_specified')));
	}

	//Check Prems
	if (!($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canreport']) OR !$vbulletin->userinfo['userid'] OR !$vbulletin->forumcache["{$vbulletin->options['videodirectory_report_forumid']}"])
	{
		print_no_permission();
	}

	$catinfo =& $vbulletin->videocats["$videoinfo[videocategoryid]"];
}

if ($_POST['do'] == 'ratevideo')
{
	if (!$videoinfo = $db->query_first("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE video.videoid = '" . $vbulletin->GPC['videoid'] . "'")
		)
	{
		eval(standard_error(fetch_error('invalid_video_specified')));
	}

	//Check Prems
	if (!($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canrate']) OR !$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$catinfo =& $vbulletin->videocats["$videoinfo[videocategoryid]"];

	$videorating = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "videorate
		WHERE userid = " . $vbulletin->userinfo['userid'] . "
			AND videoid = '" . $videoinfo['videoid'] . "'
	");
}

if ($_REQUEST['do'] == 'viewcategory')
{
	if (!$catinfo)
	{
		eval(standard_error(fetch_error('invalid_video_category_specified')));
	}
}

if ($_REQUEST['do'] == 'viewuser')
{
	if (!$userinfo)
	{
		eval(standard_error(fetch_error('invalid_user_specified')));
	}
}

if ($_REQUEST['do'] == 'viewtag')
{
	if (!$taginfo)
	{
		eval(standard_error(fetch_error('invalid_tag_specified')));
	}
}

if ($_REQUEST['do'] == 'addvideo' OR $_POST['do'] == 'insertvideo')
{
	if (!($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canadd']))
	{
		print_no_permission();
	}
}

if ($_REQUEST['do'] == 'rss')
{
	if (!$vbulletin->options['videodirectory_rssfeed'])
	{
		//RSS-Feed disabled by adnministzrator
		exit;
	}

	$include_ids = array(0);
	$cat_sql = '';

	if (!empty($vbulletin->GPC['categoryid']))
	{
		$cat_sql = 'AND video.videocategoryid IN(' . $vbulletin->GPC['categoryid'] . ')';
		$cat_inf = ' - ' . $catinfo['title'];
	}

	if (!empty($vbulletin->GPC['userid']))
	{
		$cat_sql = 'AND video.userid IN(' . $vbulletin->GPC['userid'] . ')';
		$cat_inf = ' - ' . $userinfo['username'];
	}

	if (!empty($vbulletin->GPC['tag']))
	{
		$cat_sql = 'AND videotagvideo.tagid = ' . "'$taginfo[tagid]'";
		$cat_inf = ' - ' . $taginfo['tagtext'];
	}
}

if ($catinfo AND !is_member_of($vbulletin->userinfo, $catinfo['usergroups']))
{
	print_no_permission();
}

$totalvideos = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "video");
$totalvideos = vb_number_format($totalvideos['total']);

// Fixed in 1.1.0 RC 2: Don't count ina ctive cats, or cats the user may not access (Substract 1 becazuse the array contains 0)
$catcount = vb_number_format(sizeof(array_unique($allowedcats)) - 1);
$contriblimit = $vbulletin->options['videodirectory_limits']['contributors'];

if ($vbulletin->options['videodirectory_limits']['contributors'])
{
	$contributors = $db->query_read("
		SELECT user.*, COUNT(video.videoid) AS videocount
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE NOT ISNULL(user.userid)
		GROUP BY video.userid
		ORDER BY videocount DESC
		LIMIT " . $vbulletin->options['videodirectory_limits']['contributors'] . "
	");

	while ($user = $vbulletin->db->fetch_array($contributors))
	{
		if (!$user['videocount'])
		{
			continue;
		}
		fetch_musername($user);
		$user['videocount'] = vb_number_format($user['videocount']);
		$user['userurl'] = construct_user_url($user);
		eval('$contributorbits .= "' . fetch_template('video_contributorbit') . '";');
	}
}

// ########################################################################
// View Details (Description, Rating, Comments, etc.) about a video
if ($_REQUEST['do'] == 'viewdetails')
{
	if ($vbulletin->options['videodirectory_limits']['related'])
	{
		$related_videos = $db->query_read("
			SELECT video.*
			FROM " . TABLE_PREFIX . "video AS video
			WHERE video.videocategoryid = '" . $catinfo['videocategoryid'] . "' AND video.videoid <> '" . $videoinfo['videoid'] . "'
			ORDER BY RAND()
			LIMIT " . $vbulletin->options['videodirectory_limits']['related'] . "
		");

		if ($db->num_rows($related_videos))
		{
			$show['relatedvideos'] = true;
		}

		while ($video = $vbulletin->db->fetch_array($related_videos))
		{
			$relatedbits .= construct_small_video_bit($video);
		}
	}

	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);

	$bbcode_parser =& new vB_BbcodeParser($vbulletin, fetch_tag_list());
	$videoinfo['description'] = $bbcode_parser->parse($videoinfo['description'], 'video');

	$videoinfo['date'] = vbdate($vbulletin->options['dateformat'], $videoinfo['dateline']);
	$videoinfo['time'] = vbdate($vbulletin->options['timeformat'], $videoinfo['dateline']);

	if (!fetch_bbarray_cookie('videoviews', $videoinfo['videoid']))
	{
		$db->shutdown_query("UPDATE " . TABLE_PREFIX . "video SET views = views + 1 WHERE videoid = '$videoinfo[videoid]'");
		$videoinfo['views']++;
	}

	set_bbarray_cookie('videoviews', $videoinfo['videoid'], 1, false);

	$videoinfo['views'] = vb_number_format($videoinfo['views']);

	$show['editvideo'] = (((($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canadd']) AND $videoinfo['userid'] == $vbulletin->userinfo['userid']) OR ($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canmoderate'])) ? true : false);

	require_once(DIR . '/includes/videoserviceapi/class_' . strtolower($videoinfo['videoservice']) . '.php');

	$classname = "vB_VideoSharingService_$videoinfo[videoservice]";
	$obj = new $classname($vbulletin);

	$showurl = $vbulletin->options['videodirectory_showurl'];
	$showbbc = $vbulletin->options['videodirectory_showbbc'];
	$showemb = $vbulletin->options['videodirectory_showemb'];
	$showaut = $vbulletin->options['videodirectory_showaut'];
	$showful = $vbulletin->options['videodirectory_showful'];
	$showrel = $vbulletin->options['videodirectory_showrel'];
	$showsta = $vbulletin->options['videodirectory_showsta'];

	$embedhtml = $obj->fetch_embedcode($videoinfo['videoidservice'], $showaut, $showful, $showrel, $showsta);
	$videourl = $obj->fetch_videourl($videoinfo['videoidservice']);
	$videobbcode = $obj->fetch_videobbcode($videoinfo['videoid'], $videoinfo['videoidservice'], $videoinfo['title']);
	$embedcopy = htmlspecialchars_uni($embedhtml);

	$hostername = $vbulletin->videohosters[$obj->fetch_hoster_varname()]['title'];

	fetch_musername($videoinfo);

	$videoinfo['userurl'] = construct_user_url($videoinfo);
	$catinfo['caturl'] = construct_category_url($catinfo);

	$commentcount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "videocomment
		WHERE state = 'visible' AND videoid = '" . $videoinfo['videoid'] . "'
	");

	sanitize_pageresults($commentcount['total'], $pagenumber, $perpage, 100, $vbulletin->options['videodirectory_commentsperpage']);

	// Default lower and upper limit variables
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $commentcount['total'])
	{
		// Too many for upper limit
		$limitupper = $commentcount['total'];
		if ($limitlower > $commentcount['total'])
		{
			// Too many for lower limit
			$limitlower = $commentcount['total'] - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		// Can't have negative or null lower limit
		$limitlower = 1;
	}

	$comments = $db->query_read("
		SELECT comment.*, IF(NOT ISNULL(user.userid), user.username, comment.postusername) AS username,
			user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, 
			customavatar.dateline AS avatardateline, customavatar.width_thumb AS width_thumb, customavatar.height_thumb AS height_thumb
		FROM " . TABLE_PREFIX . "videocomment AS comment
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = comment.postuserid)
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid)
		WHERE comment.videoid = '" . $videoinfo['videoid'] . "' AND comment.state = 'visible'
		ORDER BY comment.dateline DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
	");

	$bbcode_parser_comment =& new vB_BbcodeParser($vbulletin, fetch_tag_list());

	$thumb = true;
	while ($comment = $db->fetch_array($comments))
	{
		$bgclass = exec_switch_bg();
		$comment['message'] = $bbcode_parser_comment->parse($comment['message'], 'videodirectory_reply');

		$show['deletionlink'] = ($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canmoderate']);

		$comment['date'] = vbdate($vbulletin->options['dateformat'], $comment['dateline']);
		$comment['time'] = vbdate($vbulletin->options['timeformat'], $comment['dateline']);

		fetch_musername($comment);

			if (!empty($comment['avatarpath'])) {
				$comment['avatar'] = array($comment['avatarpath']);
			} else if ($comment['hascustom']) {
				$avatarurl = array('hascustom' => 1);
				if ($vbulletin->options['usefileavatar']) {
					$comment['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$comment['postuserid']}_{$comment['avatarrevision']}.gif";
				} else {
					$comment['avatarurl'] = "image.php?u=$comment[postuserid]&amp;dateline=$comment[avatardateline]" . ($thumb ? '&type=thumb' : '') ;
				}
			}
			if ($thumb) {
				if ($comment['width_thumb'] AND $comment['height_thumb']) {
					$avatarwidth = $comment['width_thumb'];
					$avatarheight = $comment['height_thumb'];
				}
			}
			if (empty($comment['avatarurl'])) {
				$comment['avatarurl'] = $stylevar['imgdir_misc'] . '/unknown.gif';
			}

		eval('$commentbits .= "' . fetch_template('video_commentbit') . '";');
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $commentcount['total'], construct_video_url($videoinfo));

	$pagetitle = $catinfo['title'] . ' - ' . $videoinfo['title'];

	$show['quickreply'] = (($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['cancomment']) ? true : false);
	if ($show['quickreply'])
	{
		require_once(DIR . '/includes/functions_editor.php');

		$show['qr_require_click'] = 0;
		$editorid = construct_edit_toolbar('', false, 'videodirectory_reply', true, true, false, 'qr');

		$messagearea = "
			<script type=\"text/javascript\">
			<!--
				var threaded_mode = 0;
				var require_click = 0;
				var is_last_page = 0;
			// -->
			</script>
			$messagearea
		";

		if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_videos'])
		{
			require_once(DIR . '/includes/class_humanverify.php');
			$verification =& vB_HumanVerify::fetch_library($vbulletin);
			$human_verify = $verification->output_token();
		}

		$show['quickreply_collapse'] = true;
	}

	$show['videorating'] = true;
	$show['ratevideo'] = ($show['videorating'] AND $vbulletin->userinfo['userid'] AND (!$rated OR $vbulletin->options['votechange']) AND ($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canrate']));

	if (!$show['ratevideo'])
	{
		if (($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canrate']))
		{
			$rateerror_phrase = $vbphrase['already_rated_this_video'];
		}
		else
		{
			$rateerror_phrase = $vbphrase['may_not_rate_videos'];
		}
	}

	if ($videoinfo['ratingnum'] >= 1)
	{
		$videoinfo['ratingavg'] = vb_number_format($videoinfo['ratingtotal'] / $videoinfo['ratingnum'], 2);
		$videoinfo['rating'] = intval(round($videoinfo['ratingtotal'] / $videoinfo['ratingnum']));
		$show['rating'] = true;
	}
	else
	{
		$show['rating'] = false;
	}

	$show['reportvideo'] = ((($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canreport']) AND $vbulletin->forumcache["{$vbulletin->options['videodirectory_report_forumid']}"]) ? true : false);

	if ($show['reportvideo'])
	{
		$report_categories = explode("\n", $vbulletin->options['videodirectory_reportcategories']);
		$i = 0;

		foreach ($report_categories AS $cat)
		{
			$i++;
			$cat = htmlspecialchars_uni($cat);
			$report_categories_html .= ($i != 1 ? '<br />' : '') . '<label for="report_cat_' . $i . '"><input' . ($i == 1 ? ' checked="checked"' : '') . ' type="radio" name="reportcategory" value="' . urlencode($cat) . '" id="report_cat_' . $i . '" /> ' . $cat . '</label>';
		}
	}

	if (($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canseewatchingusers']) AND !$show['search_engine'])
	{
		$users = $db->query_read_slave("
			SELECT user.username, user.usergroupid, user.membergroupids, session.userid, session.invideo, session.lastactivity, IF(user.displaygroupid = 0, user.usergroupid, user.displaygroupid) AS displaygroupid, infractiongroupid, IF(user.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ", 1, 0) AS invisible
			FROM " . TABLE_PREFIX . "session AS session
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = session.userid)
			WHERE session.lastactivity > " . (TIMENOW - $vbulletin->options['cookietimeout']) . " AND invideo = '" . $videoinfo['videoid'] . "' AND user.userid <> '" . $vbulletin->userinfo['userid'] . "'
			ORDER BY lastactivity DESC
		");

		$numberguest = 0;
		$numberregistered = 0;
		$doneuser = $activeusers = array();

		require_once(DIR . '/includes/functions_bigthree.php');

		while ($loggedin = $db->fetch_array($users))
		{
			if (!empty($doneuser["$loggedin[userid]"]))
			{
				continue;
			}

			if (!$loggedin['userid'])
			{
				$numberguest++;
			}
			else
			{
				fetch_musername($loggedin);
				$numberregistered++;

				if (fetch_online_status($loggedin))
				{
					eval('$activeusers[] = "' . fetch_template('forumdisplay_loggedinuser') . '";');
				}
			}

			if ($loggedin['userid'])
			{
				$doneuser["$loggedin[userid]"] = 1;
			}
		}

		if (!$vbulletin->userinfo['userid'])
		{
			$numberguest = ($numberguest == 0) ? 1 : $numberguest;
		}
		$totalonline = $numberregistered + $numberguest;

		$activeusers = implode(', ', $activeusers);
	}

	if ($videoinfo['timelength'] == 0)
	{
		$videoinfo['timelength'] = "???";
	}
	else
	{
		$duration = $videoinfo['timelength'];
		$minutes = floor($duration / 60);
		$seconds = $duration % 60;
		$seconds = str_pad($seconds, 2, "0", STR_PAD_LEFT); 
		$videoinfo['timelength'] = "$minutes:$seconds";
	}

	$taglist = rebuild_video_taglist($videoinfo);

	if ($show['editvideo'])
	{
		$canedittags = true;
	}

	if ($permissions['videodirectorypermissions'] & $vbulletin->bf_ugp_videodirectorypermissions['canwatchvideos'])
	{
		$canwatchvids = true;
	}

	if(preg_match("/HD/", $videoinfo['videoservice']))
	{
		$videoinfo['isHD'] = true;
	}

	eval('$HTML = "' . fetch_template('video_details') . '";');
	eval('$HTMLembed = "' . fetch_template('video_details_embed') . '";');
	eval('$memberinfo_css = "' . fetch_template('memberinfo_css') . '";');
	eval('$HTMLside = "' . fetch_template('VIDEO_SHELL_SIDE') . '";');

	$navbits = array();
	$navbits['video.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['videos'];
	$navbits[construct_category_url($catinfo)] = $catinfo['title'];
	$navbits[] = $videoinfo['title'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('VIDEO_SHELL') . '");');
}

// ########################################################################
// Homepage (Recent Videos, most viewed, radnom, etx)
if ($_REQUEST['do'] == 'main')
{
	if ($vbulletin->options['videodirectory_limits']['random'])
	{
		$random_videos = $db->query_read("
			SELECT video.*
			FROM " . TABLE_PREFIX . "video AS video
			WHERE video.videocategoryid IN(" . implode(',', $allowedcats) . ")
			ORDER BY RAND()
			LIMIT " . $vbulletin->options['videodirectory_limits']['random'] . "
		");

		if ($db->num_rows($random_videos))
		{
			$show['randomvideos'] = true;
		}

		while ($video = $vbulletin->db->fetch_array($random_videos))
		{
			$randombits .= construct_small_video_bit($video);
		}

	}

	if ($vbulletin->options['videodirectory_limits']['bestrated'])
	{
		$best_rated_videos = $db->query_read("
			SELECT video.*, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg
			FROM " . TABLE_PREFIX . "video AS video
			WHERE video.videocategoryid IN(" . implode(',', $allowedcats) . ")
			ORDER BY ratingavg DESC, ratingnum DESC
			LIMIT " . $vbulletin->options['videodirectory_limits']['bestrated'] . "
		");

		if ($db->num_rows($best_rated_videos))
		{
			$show['bestratedvideos'] = true;
		}

		while ($video = $vbulletin->db->fetch_array($best_rated_videos))
		{
			$bestratedbits .= construct_small_video_bit($video);
		}
	}

	if ($vbulletin->options['videodirectory_limits']['recent'])
	{
		$recent_videos = $db->query_read("
			SELECT video.*, user.*, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
			FROM " . TABLE_PREFIX . "video AS video
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
			WHERE video.videocategoryid IN(" . implode(',', $allowedcats) . ")
			ORDER BY dateline DESC
			LIMIT " . $vbulletin->options['videodirectory_limits']['recent'] . "
		");

		$bitper = 1;
		while ($video = $vbulletin->db->fetch_array($recent_videos))
		{
			$recentbits .= construct_video_bit($video, true, $bitper);
			if ($bitper == $vbulletin->options['videodirectory_vidbitsperrow'])
			{
				$bitper = 0;
			}
			$bitper++;
		}
	}

	if ($vbulletin->options['videodirectory_limits']['most_viewed'])
	{
		$most_viewed_videos = $db->query_read("
			SELECT video.*, user.*, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
			FROM " . TABLE_PREFIX . "video AS video
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
			WHERE video.videocategoryid IN(" . implode(',', $allowedcats) . ") AND video.views > 0
			ORDER BY views DESC
			LIMIT " . $vbulletin->options['videodirectory_limits']['most_viewed'] . "
		");

		$bitper = 1;
		while ($video = $vbulletin->db->fetch_array($most_viewed_videos))
		{
			$most_viewedbits .= construct_video_bit($video, true, $bitper);
			if ($bitper == $vbulletin->options['videodirectory_vidbitsperrow'])
			{
				$bitper = 0;
			}
			$bitper++;
		}
	}

	if ($vbulletin->options['videodirectory_limits']['top_rated'])
	{
		$toprated_videos = $db->query_read("
			SELECT video.*, user.*, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
			FROM " . TABLE_PREFIX . "video AS video
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
			WHERE video.videocategoryid IN(" . implode(',', $allowedcats) . ") AND IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) > 0
			ORDER BY ratingavg DESC
			LIMIT " . $vbulletin->options['videodirectory_limits']['top_rated'] . "
		");

		$bitper = 1;
		while ($video = $vbulletin->db->fetch_array($toprated_videos))
		{
			$top_ratedbits .= construct_video_bit($video, true, $bitper);
			if ($bitper == $vbulletin->options['videodirectory_vidbitsperrow'])
			{
				$bitper = 0;
			}
			$bitper++;
		}
	}

	$bbcode_parser =& new vB_BbcodeParser($vbulletin, fetch_tag_list());
	$announcement = $bbcode_parser->parse($vbulletin->options['videodirectory_announcement']);

	$tagcloud = construct_video_cloud();

	eval('$HTML = "' . fetch_template('video_home') . '";');
	eval('$HTMLside = "' . fetch_template('VIDEO_SHELL_SIDE') . '";');

	$navbits = array();
	$navbits[''] = $vbphrase['videos'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('VIDEO_SHELL') . '");');
}

// ########################################################################
// View RSS-Feed of Videos
if ($_REQUEST['do'] == 'rss')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'count'	=> TYPE_UINT,
		'full'	=> TYPE_BOOL
	));

	if (!$vbulletin->GPC['count'] OR $vbulletin->GPC['count'] > 100)
	{
		$vbulletin->GPC['count'] = intval($vbulletin->options['externalcount']);
	}

	header('Content-Type: text/xml' . ($stylevar['charset'] != '' ? '; charset=' .  $stylevar['charset'] : ''));

	$output = '<?xml version="1.0" encoding="' . $stylevar['charset'] . '"?>' . "\r\n\r\n";

	require_once(DIR . '/includes/class_xml.php');

	$xml = new vB_XML_Builder($vbulletin);
	$rsstag = array(
		'version'	   => '2.0',
		'xmlns:dc'	  => 'http://purl.org/dc/elements/1.1/',
		'xmlns:content' => 'http://purl.org/rss/1.0/modules/content/'
	);

	$xml->add_group('rss', $rsstag);
		$xml->add_group('channel');
			$xml->add_tag('title', $vbulletin->options['bbtitle'] . ' - ' . $vbphrase['video_directory'] . $cat_inf);
			$xml->add_tag('link', $vbulletin->options['bburl'] . '/video.php', array(), false, true);
			$xml->add_tag('description', $vbulletin->options['description']);
			$xml->add_tag('language', $stylevar['languagecode']);
			$xml->add_tag('lastBuildDate', gmdate('D, d M Y H:i:s') . ' GMT');
			$xml->add_tag('generator', 'vBulletin Video-Directory');
			$xml->add_tag('category', $vbphrase['videos']);
			if ($vbulletin->options['copyrighttext'])
			{
				$xml->add_tag('copyright', $vbulletin->options['copyrighttext']);
			}
			$xml->add_group('image');
				$xml->add_tag('url', create_full_url($stylevar['imgdir_misc'] . '/rss.jpg'));
				$xml->add_tag('title', $vbulletin->options['bbtitle']);
				$xml->add_tag('link', $vbulletin->options['bburl'] . '/video.php', array(), false, true);
			$xml->close_group('image');

			if (!$vbulletin->GPC['nohtml'])
			{
				require_once(DIR . '/includes/class_postbit.php');
				$postbit_factory =& new vB_Postbit_Factory();
				$postbit_factory->registry =& $vbulletin;
				$postbit_factory->bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
				$postbit_factory->bbcode_parser->printable = true;
			}
			require_once(DIR . '/includes/class_bbcode_alt.php');

			$cutoff = (!$vbulletin->options['externalcutoff']) ? 0 : TIMENOW - $vbulletin->options['externalcutoff'] * 86400;


		if (!empty($vbulletin->GPC['tag']))
		{
			$videos = $db->query_read("
				SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
				FROM " . TABLE_PREFIX . "video AS video
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
				INNER JOIN " . TABLE_PREFIX . "videotagvideo AS videotagvideo ON (videotagvideo.videoid = video.videoid)
				WHERE video.videocategoryid IN(" . implode(',', $allowedcats) . ") AND video.dateline > $cutoff $cat_sql
				ORDER BY video.dateline DESC
				LIMIT " . $vbulletin->GPC['count'] . "
			");
		}
		else
		{
			$videos = $db->query_read("
				SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
				FROM " . TABLE_PREFIX . "video AS video
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
				WHERE video.videocategoryid IN(" . implode(',', $allowedcats) . ") AND video.dateline > $cutoff $cat_sql
				ORDER BY video.dateline DESC
				LIMIT " . $vbulletin->GPC['count'] . "
			");
		}

			while ($video = $db->fetch_array($videos))
			{
				$xml->add_group('item');
					$xml->add_tag('title', unhtmlspecialchars($video['title']));
					$xml->add_tag('link', create_full_url(construct_video_url($video)));
					$xml->add_tag('pubDate', gmdate('D, d M Y H:i:s', $video['dateline']) . ' GMT');

					$plaintext_parser =& new vB_BbCodeParser_PlainText($vbulletin, fetch_tag_list());
					$plainmessage = $plaintext_parser->parse($video['description'], 'video');
					unset($plaintext_parser);

					if ($vbulletin->GPC['full'])
					{
						$xml->add_tag('description', $plainmessage);
					}
					else
					{
						$xml->add_tag('description', fetch_trimmed_title($plainmessage, $vbulletin->options['videodirectory_descpreviewlen']));
					}

					require_once(DIR . '/includes/videoserviceapi/class_' . strtolower($video['videoservice']) . '.php');

					$classname = "vB_VideoSharingService_$video[videoservice]";
					$obj = new $classname($vbulletin);

					$videourl = $obj->fetch_videourl($video['videoidservice']);
					$hostername = $vbulletin->videohosters[$obj->fetch_hoster_varname()]['title'];

					$xml->add_tag('source', $hostername, array('url' => htmlspecialchars_uni($videourl)));

					$xml->add_tag('category', '-- '.$vbulletin->videocats["$video[videocategoryid]"]['title'], array('domain' => create_full_url(construct_category_url($video))));
					$xml->add_tag('category', '+ '.$video[username], array('domain' => create_full_url(construct_user_url($video))));

					$tags_sql = $vbulletin->db->query_read("SELECT videotag.tagtext
						FROM " . TABLE_PREFIX . "videotagvideo AS videotagvideo
						INNER JOIN " . TABLE_PREFIX . "videotag AS videotag ON (videotag.tagid = videotagvideo.tagid)
						WHERE videotagvideo.videoid = $video[videoid]
						ORDER BY videotag.tagtext
					");

					while ($tag = $vbulletin->db->fetch_array($tags_sql))
					{
						$xml->add_tag('category', $tag[tagtext], array('domain' => create_full_url(construct_tag_url($tag))));
					}

					$xml->add_tag('dc:creator', unhtmlspecialchars($video['username']));
					$xml->add_tag('guid', create_full_url(construct_video_url($video)), array('isPermaLink' => 'true'));
					$xml->add_tag('comments', create_full_url(construct_video_url($video)) . '#comments');

					// Include Video-Thumbnail in the feed
					$video_thumb = fetch_videothumbnail($video);

					switch (file_extension($video_thumb))
					{
						case 'gif':
							$thumb_mime = 'image/gif';
							break;
						case 'png':
							$thumb_mime = 'image/png';
							break;
						case 'jpg':
						case 'jpeg':
						default:
							$thumb_mime = 'image/jpeg';
					}

					$xml->add_tag('enclosure', '', array(
						'url' => create_full_url($video_thumb),
						'length' => intval(@filesize(DIR . '/' . $video_thumb)),
						'type' => $thumb_mime
					));

				$xml->close_group('item');
			}

		$xml->close_group('channel');
	$xml->close_group('rss');

	$output .= $xml->output();

	//Close Database Connection manuelly because no shotdown function is called.
	$db->close();

	echo $output;
	exit;
}

// ########################################################################
// Recent Videos
if ($_REQUEST['do'] == 'viewrecent')
{
	$videos = $db->query_read("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE video.videocategoryid IN(" . implode(',', $allowedcats) . ")
		ORDER BY dateline DESC
		LIMIT " . $vbulletin->options['videodirectory_videosperpage'] . "
	");


	$bitper = 1;
	while ($video = $vbulletin->db->fetch_array($videos))
	{
		$videobits .= construct_video_bit($video, true, $bitper);
		if ($bitper == $vbulletin->options['videodirectory_vidbitsperrow'])
		{
			$bitper = 0;
		}
		$bitper++;
	}

	eval('$HTML = "' . fetch_template('video_recent') . '";');
	eval('$HTMLside = "' . fetch_template('VIDEO_SHELL_SIDE') . '";');

	$pagetitle = $vbphrase['recent_videos'];

	$navbits = array();
	$navbits['video.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['videos'];
	$navbits[] = $pagetitle;
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('VIDEO_SHELL') . '");');
}

// ########################################################################
// View all videos in a category
if ($_REQUEST['do'] == 'viewcategory')
{
	if ($vbulletin->options['videodirectory_limits']['random_samecat'])
	{
		$random_videos = $db->query_read("
			SELECT video.*
			FROM " . TABLE_PREFIX . "video AS video
			WHERE video.videocategoryid = '" . $catinfo['videocategoryid'] . "'
			ORDER BY RAND()
			LIMIT " . $vbulletin->options['videodirectory_limits']['random_samecat'] . "
		");

		if ($db->num_rows($random_videos))
		{
			$show['randomsamecatvideos'] = true;
		}

		while ($video = $vbulletin->db->fetch_array($random_videos))
		{
			$randomscbits .= construct_small_video_bit($video);
		}
	}

	if ($vbulletin->options['videodirectory_limits']['bestrated_samecat'])
	{
		$best_rated_videos = $db->query_read("
			SELECT video.*, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg
			FROM " . TABLE_PREFIX . "video AS video
			WHERE video.videocategoryid = '" . $catinfo['videocategoryid'] . "'
			ORDER BY ratingavg DESC, ratingnum DESC
			LIMIT " . $vbulletin->options['videodirectory_limits']['bestrated_samecat'] . "
		");

		if ($db->num_rows($best_rated_videos))
		{
			$show['bestratedsamecatvideos'] = true;
		}

		while ($video = $vbulletin->db->fetch_array($best_rated_videos))
		{
			$bestratedscbits .= construct_small_video_bit($video);
		}
	}

	$show['catdesc'] = ($catinfo['description'] ? true : false);

	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$videocount = $db->query_first("SELECT COUNT(videoid) AS count FROM " . TABLE_PREFIX . "video WHERE videocategoryid = '$catinfo[videocategoryid]'");
	sanitize_pageresults($videocount['count'], $pagenumber, $perpage, 250, $vbulletin->options['videodirectory_videosperpage']);

	// Default lower and upper limit variables
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $videocount['count'])
	{
		// Too many for upper limit
		$limitupper = $videocount['count'];
		if ($limitlower > $videocount['count'])
		{
			// Too many for lower limit
			$limitlower = $videocount['count'] - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		// Can't have negative or null lower limit
		$limitlower = 1;
	}

	$videos = $db->query_read("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE video.videocategoryid = '$catinfo[videocategoryid]'
		ORDER BY $sort $order, dateline DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
	");

	$bitper = 1;
	while ($video = $vbulletin->db->fetch_array($videos))
	{
		$videobits .= construct_video_bit($video, true, $bitper);
		if ($bitper == $vbulletin->options['videodirectory_vidbitsperrow'])
		{
			$bitper = 0;
		}
		$bitper++;
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $videocount['count'], construct_category_url($catinfo)."&sort=$sort&order=$order");

	eval('$HTML = "' . fetch_template('video_category') . '";');
	eval('$HTMLside = "' . fetch_template('VIDEO_SHELL_SIDE') . '";');

	$pagetitle = $catinfo['title'];

	$navbits = array();
	$navbits['video.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['videos'];
	$navbits[] = $catinfo['title'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('VIDEO_SHELL') . '");');
}

// ########################################################################
// View all videos from a user
if ($_REQUEST['do'] == 'viewuser')
{
	if ($vbulletin->options['videodirectory_limits']['random_samecat'])
	{
		$random_videos = $db->query_read("
			SELECT video.*
			FROM " . TABLE_PREFIX . "video AS video
			WHERE video.userid = '" . $userinfo['userid'] . "' AND videocategoryid IN(" . implode(',', $allowedcats) . ")
			ORDER BY RAND()
			LIMIT " . $vbulletin->options['videodirectory_limits']['random_samecat'] . "
		");

		if ($db->num_rows($random_videos))
		{
			$show['randomsamecatvideos'] = true;
		}

		while ($video = $vbulletin->db->fetch_array($random_videos))
		{
			$randomscbits .= construct_small_video_bit($video);
		}
	}

	if ($vbulletin->options['videodirectory_limits']['bestrated_samecat'])
	{
		$best_rated_videos = $db->query_read("
			SELECT video.*, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg
			FROM " . TABLE_PREFIX . "video AS video
			WHERE video.userid = '" . $userinfo['userid'] . "' AND videocategoryid IN(" . implode(',', $allowedcats) . ")
			ORDER BY ratingavg DESC, ratingnum DESC
			LIMIT " . $vbulletin->options['videodirectory_limits']['bestrated_samecat'] . "
		");

		if ($db->num_rows($best_rated_videos))
		{
			$show['bestratedsamecatvideos'] = true;
		}

		while ($video = $vbulletin->db->fetch_array($best_rated_videos))
		{
			$bestratedscbits .= construct_small_video_bit($video);
		}
	}

	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$videocount = $db->query_first("SELECT COUNT(videoid) AS count FROM " . TABLE_PREFIX . "video WHERE userid = '$userinfo[userid]' AND videocategoryid IN(" . implode(',', $allowedcats) . ")");
	sanitize_pageresults($videocount['count'], $pagenumber, $perpage, 250, $vbulletin->options['videodirectory_videosperpage']);

	// Default lower and upper limit variables
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $videocount['count'])
	{
		// Too many for upper limit
		$limitupper = $videocount['count'];
		if ($limitlower > $videocount['count'])
		{
			// Too many for lower limit
			$limitlower = $videocount['count'] - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		// Can't have negative or null lower limit
		$limitlower = 1;
	}

	$videos = $db->query_read("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE video.userid = '$userinfo[userid]' AND videocategoryid IN(" . implode(',', $allowedcats) . ")
		ORDER BY $sort $order, dateline DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
	");

	$bitper = 1;
	while ($video = $vbulletin->db->fetch_array($videos))
	{
		$videobits .= construct_video_bit($video, true, $bitper);
		if ($bitper == $vbulletin->options['videodirectory_vidbitsperrow'])
		{
			$bitper = 0;
		}
		$bitper++;
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $videocount['count'], construct_user_url($userinfo)."&sort=$sort&order=$order");

	eval('$HTML = "' . fetch_template('video_user') . '";');
	eval('$HTMLside = "' . fetch_template('VIDEO_SHELL_SIDE') . '";');

	$pagetitle = $catinfo['title'];

	$navbits = array();
	$navbits['video.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['videos'];
	$navbits[] = $userinfo['username'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('VIDEO_SHELL') . '");');
}

// ########################################################################
// View all videos from a tag
if ($_REQUEST['do'] == 'viewtag')
{
	if ($vbulletin->options['videodirectory_limits']['random_samecat'])
	{
		$random_videos = $db->query_read("
			SELECT video.*
			FROM " . TABLE_PREFIX . "video AS video
			INNER JOIN " . TABLE_PREFIX . "videotagvideo AS videotagvideo ON
				(videotagvideo.tagid = $taginfo[tagid] AND videotagvideo.videoid = video.videoid)
			WHERE videotagvideo.tagid = '$taginfo[tagid]' AND video.videocategoryid IN(" . implode(',', $allowedcats) . ")
			ORDER BY RAND()
			LIMIT " . $vbulletin->options['videodirectory_limits']['random_samecat'] . "
		");

		if ($db->num_rows($random_videos))
		{
			$show['randomsamecatvideos'] = true;
		}

		while ($video = $vbulletin->db->fetch_array($random_videos))
		{
			$randomscbits .= construct_small_video_bit($video);
		}
	}

	if ($vbulletin->options['videodirectory_limits']['bestrated_samecat'])
	{
		$best_rated_videos = $db->query_read("
			SELECT video.*, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg
			FROM " . TABLE_PREFIX . "video AS video
			INNER JOIN " . TABLE_PREFIX . "videotagvideo AS videotagvideo ON
				(videotagvideo.tagid = $taginfo[tagid] AND videotagvideo.videoid = video.videoid)
			WHERE videotagvideo.tagid = '$taginfo[tagid]' AND video.videocategoryid IN(" . implode(',', $allowedcats) . ")
			ORDER BY ratingavg DESC, ratingnum DESC
			LIMIT " . $vbulletin->options['videodirectory_limits']['bestrated_samecat'] . "
		");

		if ($db->num_rows($best_rated_videos))
		{
			$show['bestratedsamecatvideos'] = true;
		}

		while ($video = $vbulletin->db->fetch_array($best_rated_videos))
		{
			$bestratedscbits .= construct_small_video_bit($video);
		}
	}

	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
	$videocount = $db->query_first("SELECT COUNT(video.videoid) AS count FROM " . TABLE_PREFIX . "video AS video
			INNER JOIN " . TABLE_PREFIX . "videotagvideo AS videotagvideo ON
				(videotagvideo.tagid = $taginfo[tagid] AND videotagvideo.videoid = video.videoid)
			WHERE videotagvideo.tagid = '$taginfo[tagid]' AND video.videocategoryid IN(" . implode(',', $allowedcats) . ")");
	sanitize_pageresults($videocount['count'], $pagenumber, $perpage, 250, $vbulletin->options['videodirectory_videosperpage']);

	// Default lower and upper limit variables
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $videocount['count'])
	{
		// Too many for upper limit
		$limitupper = $videocount['count'];
		if ($limitlower > $videocount['count'])
		{
			// Too many for lower limit
			$limitlower = $videocount['count'] - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		// Can't have negative or null lower limit
		$limitlower = 1;
	}

	$videos = $db->query_read("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username, IF(video.ratingnum > 0, video.ratingtotal / video.ratingnum, 0) AS ratingavg
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		INNER JOIN " . TABLE_PREFIX . "videotagvideo AS videotagvideo ON
			(videotagvideo.tagid = $taginfo[tagid] AND videotagvideo.videoid = video.videoid)
		WHERE videotagvideo.tagid = '$taginfo[tagid]' AND video.videocategoryid IN(" . implode(',', $allowedcats) . ")
		ORDER BY $sort $order, dateline DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
	");

	$bitper = 1;
	while ($video = $vbulletin->db->fetch_array($videos))
	{
		$videobits .= construct_video_bit($video, true, $bitper);
		if ($bitper == $vbulletin->options['videodirectory_vidbitsperrow'])
		{
			$bitper = 0;
		}
		$bitper++;
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $videocount['count'], construct_tag_url($taginfo)."&sort=$sort&order=$order");

	eval('$HTML = "' . fetch_template('video_tag') . '";');
	eval('$HTMLside = "' . fetch_template('VIDEO_SHELL_SIDE') . '";');

	$navbits = array();
	$navbits['video.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['videos'];
	$navbits[] = $taginfo['tagtext'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('VIDEO_SHELL') . '");');
}

// ########################################################################
// Add Video to the directory
if ($_REQUEST['do'] == 'addvideo')
{
	$editorid = construct_edit_toolbar('', false, 'video');

	eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');

	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_videos'])
	{
		require_once(DIR . '/includes/class_humanverify.php');
		$verification =& vB_HumanVerify::fetch_library($vbulletin);
		$human_verify = $verification->output_token();
	}

	foreach ($vbulletin->videocats AS $catid => $cat)
	{
		if (!$cat['active'] OR !is_member_of($vbulletin->userinfo, $cat['usergroups']))
		{
			continue;
		}

		for ($i = 0; $i < $cat['level']; $i++)
		{
			$cat['title'] = '- '.$cat['title'];
		}

		$optionvalue = $cat['videocategoryid'];
		$optiontitle = $cat['title'];
		$optionselected = (($cat['videocategoryid'] == $catinfo['videocategoryid']) ? 'selected="selected"' : '');

		eval('$catoptions .= "' . fetch_template('option') . '";');
	}

	if ($vbulletin->options['videodirectory_retrievekeywords'])
	{
		$retrievetags = true;
	}

	$forum = fetch_foruminfo($vbulletin->options['videodirectory_new_forumid']);

	$navbits = array();
	$navbits['video.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['videos'];
	$navbits[construct_category_url($catinfo)] = $catinfo['title'];
	$navbits[''] = $vbphrase['add_new_video'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('video_add') . '");');
}

// ########################################################################
// Edit an existing video
if ($_REQUEST['do'] == 'editvideo')
{
	$editorid = construct_edit_toolbar($videoinfo['description'], false, 'video');

	eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');

	foreach ($vbulletin->videocats AS $catid => $cat)
	{
		if (!$cat['active'] OR !is_member_of($vbulletin->userinfo, $cat['usergroups']))
		{
			continue;
		}

		for ($i = 0; $i < $cat['level']; $i++)
		{
			$cat['title'] = '- '.$cat['title'];
		}

		$optionvalue = $cat['videocategoryid'];
		$optiontitle = $cat['title'];
		$optionselected = (($cat['videocategoryid'] == $catinfo['videocategoryid']) ? 'selected="selected"' : '');

		eval('$catoptions .= "' . fetch_template('option') . '";');
	}

	if ($videoinfo['timelength'] == 0)
	{
		$videoinfo['timekeyM'] = "0";
		$videoinfo['timekeyS'] = "00";
	}
	else
	{
		$duration = $videoinfo['timelength'];
		$minutes = floor($duration / 60);
		$seconds = $duration % 60;
		$seconds = str_pad($seconds, 2, "0", STR_PAD_LEFT);
		$videoinfo['timekeyM'] = $minutes;
		$videoinfo['timekeyS'] = $seconds;
	}

	$navbits = array();
	$navbits['video.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['videos'];
	$navbits[construct_category_url($catinfo)] = $catinfo['title'];
	$navbits[construct_video_url($videoinfo)] = $videoinfo['title'];
	$navbits[''] = $vbphrase['edit_video'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('video_edit') . '");');
}

// ########################################################################
// Fetch Title, Description (and later Tags) from a video url
if ($_REQUEST['do'] == 'videoinfo' AND $_POST['ajax'])
{
	$vbulletin->input->clean_array_gpc('p', array(
		'url'		=> TYPE_STR,
		'wysiwyg'	=> TYPE_BOOL
	));

	$vbulletin->GPC['url'] = convert_urlencoded_unicode($vbulletin->GPC['url']);

	if (!$vbulletin->GPC['url'])
	{
		eval(standard_error(fetch_error('invalid_url_specified')));
	}

	$hasservice = false;

	foreach ($vbulletin->videohosters AS $varname => $hoster)
	{
		if (!$hoster['active'])
		{
			continue;
		}

		require_once(DIR . '/includes/videoserviceapi/class_' . strtolower($hoster['classname']) . '.php');
		$classname = "vB_VideoSharingService_$hoster[classname]";

		$obj =& new $classname($vbulletin);

		if ($obj->verify_service($vbulletin->GPC['url']))
		{
			if (!$obj->prepare_data())
			{
				switch($obj->fetch_error())
				{
					case VSS_ERROR_CONNECTION:
						eval(standard_error(fetch_error('videoservice_connection_problems')));
						break;
					case VSS_ERROR_RESPONSE:
						eval(standard_error(fetch_error('videoservice_invalid_serverresponse')));
						break;
					case VSS_ERROR_SERVICELOGIN:
						eval(standard_error(fetch_error('videoservice_login_problems')));
						break;
					case VSS_ERROR_NOEMBEDING:
						eval(standard_error(fetch_error('video_may_not_be_embed')));
						break;
				}
			}
			$title = $obj->fetch_videotitle();
			$description = $obj->fetch_videodescription();
			$thumbnailpath = $obj->fetch_thumbnailpath();
			$keywords = $obj->fetch_taglist();
			$duration = $obj->fetch_timelength();
			$embedpreview = $obj->fetch_embedcode();
			$hasservice = true;
			break;
		}
	}

	if (!$hasservice)
	{
		eval(standard_error(fetch_error('invalid_url_specified')));
	}

	require_once(DIR . '/includes/class_xml.php');

	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('response');
	$xml->add_tag('description', ($vbulletin->GPC['wysiwyg'] ? nl2br($description) : $description));
	$xml->add_tag('title', $title);
	$xml->add_tag('keywords', $keywords);
	$xml->add_tag('duration', $duration);
	$xml->add_tag('embedpreview', $embedpreview);
	$xml->add_tag('thumbnailpath', $thumbnailpath);
	$xml->close_group();
	$xml->print_xml();
}

// ########################################################################
// Insert New Video into the Database
if ($_POST['do'] == 'insertvideo')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'title'		=> TYPE_STR,
		'videourl'		=> TYPE_STR,
		'message'		=> TYPE_STR,
		'taglist'		=> TYPE_STR,
		'videocategoryid'	=> TYPE_UINT,
		'timekeyM'		=> TYPE_UINT,
		'timekeyS'		=> TYPE_UINT,
		'wysiwyg'		=> TYPE_BOOL,
		'humanverify'	=> TYPE_ARRAY,
		'newthread'		=> TYPE_UINT,
	));

	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$vbulletin->GPC['message'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}

	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_videos'])
	{
		require_once(DIR . '/includes/class_humanverify.php');
		$verify =& vB_HumanVerify::fetch_library($vbulletin);
		if (!$verify->verify_token($vbulletin->GPC['humanverify']))
		{
			eval(standard_error(fetch_error($verify->fetch_error())));
		}
	}

	$minutes = $vbulletin->GPC['timekeyM'] * 60;
	$seconds = $vbulletin->GPC['timekeyS'];
	$duration = $minutes + $seconds;
	$cachetags = "None...";

	$dm =& datamanager_init('Video', $vbulletin);
	$dm->setr('videocategoryid', $vbulletin->GPC['videocategoryid']);
	$dm->setr('title', $vbulletin->GPC['title']);
	$dm->setr('description', $vbulletin->GPC['message']);
	$dm->setr('videourl', $vbulletin->GPC['videourl']);
	$dm->setr('timelength', $duration);
	$dm->setr('cachetags', $cachetags);
	$dm->pre_save();
	$videoid = $dm->save();

	$videoinfo = $db->query_first("
		SELECT video.*, user.*, IF(NOT ISNULL(user.userid), user.username, video.username) AS username
		FROM " . TABLE_PREFIX . "video AS video
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = video.userid)
		WHERE video.videoid = '" . $videoid . "'
		");

	add_tags_to_video($videoinfo, $vbulletin->GPC['taglist']);

	if (($forum = fetch_foruminfo($vbulletin->options['videodirectory_new_forumid'])) && ($vbulletin->GPC['newthread']))
	{
		$url =& $vbulletin->options['bburl'];
		$catinfo =& $vbulletin->videocats["$videoinfo[videocategoryid]"];

		eval(fetch_email_phrases('videodirectory_newthread'));

		// put data into datamanger
		$threadman =& datamanager_init('Thread_FirstPost', $vbulletin, ERRTYPE_STANDARD, 'threadpost');
		$threadman->set_info('forum', $forum);
		$threadman->set_info('skip_moderator_email', true);
		$threadman->set_info('skip_floodcheck', true);
		$threadman->set_info('skip_charcount', true);
		$threadman->set_info('mark_thread_read', true);
		$threadman->set_info('skip_title_error', true);
		$threadman->set_info('parseurl', true);
		$threadman->set('allowsmilie', true);
		$threadman->set('userid', $vbulletin->userinfo['userid']);
		$threadman->setr_info('user', $vbulletin->userinfo);
		$threadman->set('title', $subject);
		$threadman->set('pagetext', $message);
		$threadman->set('forumid', $vbulletin->options['videodirectory_new_forumid']);
		$threadman->set('visible', 1);
		$nthreadid = $threadman->save();

		$vbulletin->url = 'showthread.php?' . $vbulletin->session->vars['sessionurl'] . 't=' . $nthreadid;
		eval(print_standard_redirect('redirect_video_saved'));
	}

	$vbulletin->url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewdetails&amp;videoid=' . $videoid;
	eval(print_standard_redirect('redirect_video_saved'));
}

// ########################################################################
// Update existing Video
if ($_POST['do'] == 'updatevideo')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'title'		=> TYPE_STR,
		'message'		=> TYPE_STR,
		'taglist'		=> TYPE_STR,
		'videoid'		=> TYPE_UINT,
		'timekeyM'		=> TYPE_UINT,
		'timekeyS'		=> TYPE_UINT,
		'wysiwyg'		=> TYPE_BOOL,
		'delete'		=> TYPE_BOOL,
		'videocategoryid'	=> TYPE_UINT
	));

	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$vbulletin->GPC['message'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}

	$minutes = $vbulletin->GPC['timekeyM'] * 60;
	$seconds = $vbulletin->GPC['timekeyS'];
	$duration = $minutes + $seconds;

	$dm =& datamanager_init('Video', $vbulletin);
	$dm->set_existing($videoinfo);
	if ($vbulletin->GPC['delete'])
	{
		delete_video_tags($videoinfo['videoid']);
		$thumbnail = DIR . '/' . $vbulletin->options['videodirectory_thumbnaildir'] . '/' . $videoinfo['videoservice'] . '/' . $videoinfo['videoidservice'] . '.jpg';
		if (file_exists($thumbnail)) { unlink ($thumbnail); }

		$dm->delete();
		$vbulletin->url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewcategory&amp;categoryid=' . $videoinfo['videocategoryid'];
		eval(print_standard_redirect('redirect_video_deleted', true, true));
	}
	else
	{
		$dm->setr('title', $vbulletin->GPC['title']);
		$dm->setr('description', $vbulletin->GPC['message']);
		$dm->setr('videocategoryid', $vbulletin->GPC['videocategoryid']);
		$dm->setr('timelength', $duration);
		$dm->pre_save();
		$dm->save();
		$vbulletin->url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewdetails&amp;videoid=' . $videoinfo['videoid'];
		eval(print_standard_redirect('redirect_video_saved'));
	}
}

// #######################################################################
// Search for a video
if ($_REQUEST['do'] == 'search')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'q'	=> TYPE_STR
	));

	$keyword = preg_replace('#[()"\'!\#{};]|\\\\|:(?!//)#s', '', $vbulletin->GPC['q']);

	require_once(DIR . '/includes/functions_search.php');
	$keyword = sanitize_word_for_sql($keyword);

	if (!$vbulletin->options['allowwildcards'])
	{
		$keyword = str_replace('*', '', $keyword);
	}

	if (vbstrlen($keyword) < 3)
	{
		eval(standard_error(fetch_error('videodirectory_search_string_too_short')));
	}

	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);

	$video_ids_query = $db->query_read_slave("
		SELECT videoid
		FROM " . TABLE_PREFIX . "video
		WHERE
		(
			description LIKE '%" . $db->escape_string_like($keyword) . "%'
			OR
			title LIKE '%" . $db->escape_string_like($keyword) . "%'
		)
		AND videocategoryid IN(" . implode(',', $allowedcats) . ")
	");

	$videoids = array();

	while ($v = $db->fetch_array($video_ids_query))
	{
		$videoids[] = $v['videoid'];
	}

	$video_count = sizeof($videoids);

	if (!$video_count)
	{
		eval(standard_error(fetch_error('videodirectory_no_searchresults_found')));
	}

	sanitize_pageresults($video_count, $pagenumber, $perpage, 250, $vbulletin->options['videodirectory_videosperpage']);

	$result_count = vb_number_format($video_count);

	// Default lower and upper limit variables
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $video_count)
	{
		// Too many for upper limit
		$limitupper = $video_count;
		if ($limitlower > $video_count)
		{
			// Too many for lower limit
			$limitlower = $video_count - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		// Can't have negative or null lower limit
		$limitlower = 1;
	}

	$videos = $db->query_read_slave("
		SELECT *
		FROM " . TABLE_PREFIX . "video
		WHERE videoid IN(" . implode(',', $videoids) . ")
		ORDER BY dateline DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
	");

	$bitper = 1;
	while ($video = $vbulletin->db->fetch_array($videos))
	{
		$videobits .= construct_video_bit($video, true, $bitper);
		if ($bitper == $vbulletin->options['videodirectory_vidbitsperrow'])
		{
			$bitper = 0;
		}
		$bitper++;
	}

	$search_query = htmlspecialchars_uni($vbulletin->GPC['q']);

	$pagenav = construct_page_nav($pagenumber, $perpage, $video_count, 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=search&amp;q=' . urlencode(htmlspecialchars_uni($vbulletin->GPC['q'])) . '&amp;pp=' . $perpage);

	eval('$HTML = "' . fetch_template('video_searchresults') . '";');
	eval('$HTMLside = "' . fetch_template('VIDEO_SHELL_SIDE') . '";');

	if ($vbulletin->options['videodirectory_limits']['random'])
	{
		$random_videos = $db->query_read("
			SELECT video.*
			FROM " . TABLE_PREFIX . "video AS video
			WHERE video.videocategoryid IN(" . implode(',', $allowedcats) . ")
			ORDER BY RAND()
			LIMIT " . $vbulletin->options['videodirectory_limits']['random'] . "
		");

		if ($db->num_rows($random_videos))
		{
			$show['randomvideos'] = true;
		}

		while ($video = $vbulletin->db->fetch_array($random_videos))
		{
			$randombits .= construct_small_video_bit($video);
		}
	}

	$navbits = array();
	$navbits['video.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['videos'];
	$navbits[] = $vbphrase['video_search_results'];
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('VIDEO_SHELL') . '");');
}

// #######################################################################
// Report a video
if ($_POST['do'] == 'reportvideo')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'comment'		=> TYPE_STR,
		'reportcategory'	=> TYPE_STR
	));

	$report_categories = explode("\n", $vbulletin->options['videodirectory_reportcategories']);
	$vbulletin->GPC['reportcategory'] = urldecode($vbulletin->GPC['reportcategory']);

	foreach ($report_categories AS $cat)
	{
		if ($cat == $vbulletin->GPC['reportcategory'])
		{
			$cat_found = true;
			break;
		}
	}

	if (!$cat_found)
	{
		eval(standard_error(fetch_error('invalid_report_reason_specified')));
	}

	if ($videoinfo['reportthreadid'])
	{
		$vbulletin->url = 'showthread.php?' . $vbulletin->session->vars['sessionurl'] . 't=' . $videoinfo[reportthreadid];
		eval(print_standard_redirect('redirect_video_report', true, true));
	}

	$userid =& $vbulletin->userinfo['userid'];
	$username =& $vbulletin->userinfo['username'];
	$comment = $vbulletin->GPC['comment'];
	$category =& $vbulletin->GPC['reportcategory'];
	$url =& $vbulletin->options['bburl'];

	$forum = fetch_foruminfo($vbulletin->options['videodirectory_report_forumid']);

	eval(fetch_email_phrases('videodirectory_reportthread'));

	// put data into datamanger
	$threadman =& datamanager_init('Thread_FirstPost', $vbulletin, ERRTYPE_STANDARD, 'threadpost');
	$threadman->set_info('forum', $forum);
	$threadman->set_info('skip_moderator_email', true);
	$threadman->set_info('skip_floodcheck', true);
	$threadman->set_info('skip_charcount', true);
	$threadman->set_info('mark_thread_read', true);
	$threadman->set_info('skip_title_error', true);
	$threadman->set_info('parseurl', true);
	$threadman->set('allowsmilie', true);
	$threadman->set('userid', $vbulletin->userinfo['userid']);
	$threadman->setr_info('user', $vbulletin->userinfo);
	$threadman->set('title', $subject);
	$threadman->set('pagetext', $message);
	$threadman->set('forumid', $vbulletin->options['videodirectory_report_forumid']);
	$threadman->set('visible', 1);
	$rpthreadid = $threadman->save();

	//Update Video
	$dm =& datamanager_init('Video', $vbulletin);
	$dm->set_existing($videoinfo);
	$dm->setr('reportthreadid', $rpthreadid);
	$dm->save();

	$vbulletin->url = 'showthread.php?' . $vbulletin->session->vars['sessionurl'] . 't=' . $rpthreadid;
	eval(print_standard_redirect('redirect_video_report', true, true));
}

// #######################################################################
// Rate a video
if ($_POST['do'] == 'ratevideo')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'vote'	   => TYPE_UINT,
		'ajax'	   => TYPE_BOOL
	));

	if ($vbulletin->GPC['vote'] < 1 OR $vbulletin->GPC['vote'] > 5)
	{
		standard_error(fetch_error('invalidvote'));
	}

	$update = false;

	if ($videorating)
	{
		//User has already voted
		if ($vbulletin->options['votechange'])
		{
			if ($vbulletin->GPC['vote'] != $videorating['vote'])
			{
				$videorate =& datamanager_init('VideoRate', $vbulletin, ERRTYPE_STANDARD);
				$videorate->set_info('video', $videoinfo);
				$videorate->set_existing($videorating);
				$videorate->set('vote', $vbulletin->GPC['vote']);
				$videorate->save();
			}

			$update = true;

			if (!$vbulletin->GPC['ajax'])
			{
				$vbulletin->url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . "do=viewdetails&amp;videoid=$videoinfo[videoid]";
				eval(print_standard_redirect('redirect_video_rate_add'));
			}
		}
		else if (!$vbulletin->GPC['ajax'])
		{
			standard_error(fetch_error('video_rate_voted'));
		}
	}
	else
	{
		$videorate =& datamanager_init('VideoRate', $vbulletin, ERRTYPE_STANDARD);
		$videorate->set_info('video', $videoinfo);
		$videorate->set('videoid', $videoinfo['videoid']);
		$videorate->set('userid', $vbulletin->userinfo['userid']);
		$videorate->set('vote', $vbulletin->GPC['vote']);
		$videorate->save();

		$update = true;

		if (!$vbulletin->GPC['ajax'])
		{
			$vbulletin->url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . "do=viewdetails&amp;videoid=$videoinfo[videoid]";
			eval(print_standard_redirect('redirect_video_rate_add'));
		}
	}

	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('threadrating');
	if ($update)
	{
		$video_ratings = $db->query_first_slave("
			SELECT ratingtotal, ratingnum
			FROM " . TABLE_PREFIX . "video
			WHERE videoid = $videoinfo[videoid]
		");

		if ($video_ratings['ratingnum'] > 0 AND $video_ratings['ratingnum'] >= 1)
		{
			$video_ratings['ratingavg'] = vb_number_format($video_ratings['ratingtotal'] / $video_ratings['ratingnum'], 2);
			$video_ratings['rating'] = intval(round($video_ratings['ratingtotal'] / $video_ratings['ratingnum']));
			$xml->add_tag('voteavg', "<img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$video_ratings[rating].gif\" alt=\"" . construct_phrase($vbphrase['rating_x_votes_y_average'], $video_ratings['ratingnum'], $video_ratings['ratingavg']) . "\" border=\"0\" />");
		}
		else
		{
			$xml->add_tag('voteavg', '');
		}

		if (!function_exists('fetch_phrase'))
		{
			require_once(DIR . '/includes/functions_misc.php');
		}
		$xml->add_tag('message', fetch_phrase('redirect_video_rate_add', 'frontredirect', 'redirect_'));
	}
	else
	{
		$xml->add_tag('error', fetch_error('video_rate_voted'));
	}
	$xml->close_group();
	$xml->print_xml();
}

// ########################################################################
// Insert Comment into the Database
if ($_REQUEST['do'] == 'postcomment')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'videoid'		=> TYPE_UINT,
		'message'		=> TYPE_STR,
		'wysiwyg'		=> TYPE_BOOL,
		'humanverify'	=> TYPE_ARRAY
	));

	if ($vbulletin->GPC['ajax'])
	{
		$vbulletin->GPC['message'] = convert_urlencoded_unicode($vbulletin->GPC['message']);
	}

	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$vbulletin->GPC['message'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}

	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_videos'])
	{
		require_once(DIR . '/includes/class_humanverify.php');
		$verify =& vB_HumanVerify::fetch_library($vbulletin);
		if (!$verify->verify_token($vbulletin->GPC['humanverify']))
		{
			if ($vbulletin->GPC['ajax'])
			{
				require_once(DIR . '/includes/class_xml.php');
				$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
				$xml->add_group('errors');
				$xml->add_tag('error', 'hv_check');
				$xml->close_group();
				$xml->print_xml(true);
			}
			else
			{
				eval(standard_error(fetch_error($verify->fetch_error())));
			}
		}
	}

	$dm =& datamanager_init('VideoComment', $vbulletin, ($vbulletin->GPC['ajax'] ? ERRTYPE_ARRAY : ERRTYPE_STANDARD));
	$dm->setr('videoid', $vbulletin->GPC['videoid']);
	$dm->setr('message', $vbulletin->GPC['message']);
	$dm->set('state', 'visible');
	$dm->pre_save();

	if ($vbulletin->GPC['ajax'] AND sizeof($dm->errors))
	{
		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('errors');
		foreach ($dm->errors AS $error)
		{
			$xml->add_tag('error', $error);
		}
		$xml->close_group();
		$xml->print_xml(true);
	}

	$videoid = $dm->save();

	$vbulletin->url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewdetails&amp;videoid=' . $vbulletin->GPC['videoid'] . '#comments';
	eval(print_standard_redirect('redirect_videocomment_saved'));
}

// ########################################################################
// Delete a comment
if ($_REQUEST['do'] == 'deletecomment')
{
	$navbits = array();
	$navbits['video.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['videos'];
	$navbits[construct_category_url($catinfo)] = $catinfo['title'];
	$navbits[construct_video_url($videoinfo)] = $videoinfo['title'];
	$navbits[] = $vbphrase['delete_video_comment'];
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('video_delete_comment') . '");');
}

// ########################################################################
// Remove a comment from the database
if ($_POST['do'] == 'killcomment')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'dodelete'	=> TYPE_BOOL
	));

	if (!$vbulletin->GPC['dodelete'])
	{
		eval(standard_error(fetch_error('you_didnt_choose_delete_comment')));
	}

	$dm =& datamanager_init('VideoComment', $vbulletin);
	$dm->set_existing($videocomment);
	$dm->delete();

	$vbulletin->url = 'video.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewdetails&amp;videoid=' . $videoinfo['videoid'] . '#comments';
	eval(print_standard_redirect('redirect_videocomment_deleted'));
}

?>