<?php
/*========================================================================*\
|| ###################################################################### ||
|| # Video-Directory 1.1.3 (class_videosharingservice.php)			# ||
|| # -------------------------------------------------------------------# ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		# ||
|| # 		With significant modification by Jason Axelrod.			# ||
|| # This file may not be redistributed in whole or significant part.	# ||
|| # -------------------------------------------------------------------# ||
|| # 												# ||
|| ###################################################################### ||
\*========================================================================*/

define('VSS_ERROR_CONNECTION', 1);
define('VSS_ERROR_RESPONSE', 2);
define('VSS_ERROR_SERVICELOGIN', 4);
define('VSS_ERROR_NOEMBEDING', 8);
define('VSS_ERROR_MEDIATYPE', 32);
define('VSS_ERROR_INVALID_MEDIA', 16);

/**
 * Class to Fetch Video Informations
 *
 * @package VideoDirectory
 */
class vB_VideoSharingService
{
	/**
	* Url to work with
	*
	* @var	Url
	*/
	var $url;

	/**
	* Name of the Service
	*
	* @var	string
	*/
	var $hostername;

	/**
	* Error-Code
	*
	* @var	int
	*/
	var $error;

	/**
	* ID of the processed Video
	*
	* @var	Video-ID
	*/
	var $video_id;

	/**
	* Path to the Thumbnail
	*
	* @var	Thumbnail-Path
	*/
	var $thumbnailpath;

	/**
	* Title of the Video
	*
	* @var	Video-Title
	*/
	var $videotitle;

	/**
	* Description of the Video
	*
	* @var	Video-Description
	*/
	var $videodescription;

	/**
	* Keywords of the Video
	*
	* @var	Tag-List
	*/
	var $taglist;

	/**
	* Duration of the Video
	*
	* @var	Time-Length
	*/
	var $timelength;

	/**
	* Embed Preview
	*
	* @var	Embed-Preview
	*/
	var $embedpreview;

	/**
	* Registry object for any options we need
	*
	* @var	vB_Registry
	*/
	var $registry;

	/**
	* Constructor. Checks if the registry object was passed correctly.
	*
	* @param	vB_Registry		vBulletin Registry
	*/
	function vB_VideoSharingService(&$registry)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error('Registry object is not an object', E_USER_ERROR);
		}
	}

	/**
	* Verifys, if url is a service the class works with
	*
	* @param	string		Url
	*
	* @return	bool		Is the url of the service the class works with?
	*/
	function verify_service(&$url)
	{
		return false;
	}

	function fetch_hoster_varname()
	{
		return $this->hostername;
	}

	/**
	* Fetchs the ID of the Video
	*
	* @return	string		VideoID
	*/
	function fetch_videoid()
	{
		return $this->video_id;
	}

	/**
	* Fetchs the Url of the Video
	*
	* @return	string		Video-Url
	*/
	function fetch_videourl()
	{
		return $this->url;
	}

	/**
	* Path to Thumbnail of the Video
	*
	* @param	type		desc
	*
	* @return	type		desc
	*/
	function fetch_thumbnailpath()
	{
		return trim($this->thumbnailpath);
	}

	/**
	* Checks the Video ID
	*
	* @return	bool		True, if Video ID is correct
	*/
	function verify_videoid()
	{
		return true;
	}

	/**
	* Prepares the Data recieved from the Service
	*
	* @return	bool		True, if data could be prepared
	*/
	function prepare_data()
	{
		return false;
	}

	/**
	* Fetches the Discription of the video of the service
	*
	* @return	string		Returns the Original Video Description
	*/
	function fetch_videodescription()
	{
		return $this->videodescription;
	}

	/**
	* Fetches the Title of the video
	*
	* @return	string		Returns the Original Title of the video
	*/
	function fetch_videotitle()
	{
		return $this->videotitle;
	}

	/**
	* Fetches the Keywords of the video
	*
	* @return	string		Returns the Original Keywords of the video
	*/
	function fetch_taglist()
	{
		return $this->taglist;
	}

	/**
	* Fetches the Duration of the video
	*
	* @return	string		Returns the Original Duration of the video
	*/
	function fetch_timelength()
	{
		return $this->timelength;
	}

	function set_error($error)
	{
		$this->error = $error;
	}

	function fetch_error()
	{
		return $this->error;
	}

	function fetch_embedcode($videoid = '')
	{
		return false;
	}

	function fetch_videobbcode($videoid = '')
	{
		return false;
	}
}

?>