<?php
/*========================================================================*\
|| ###################################################################### ||
|| # Video-Directory 1.1.3 (class_dm_videorate.php)				# ||
|| # -------------------------------------------------------------------# ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		# ||
|| # 		With significant modification by Jason Axelrod.			# ||
|| # This file may not be redistributed in whole or significant part.	# ||
|| # -------------------------------------------------------------------# ||
|| # 												# ||
|| ###################################################################### ||
\*========================================================================*/

if (!class_exists('vB_DataManager'))
{
	exit;
}

/**
 * Class to do data save/delete operations for video ratings
 *
 *
 * @package		Video Directory
 * @date		11/14/2008 15:49
 */
class vB_DataManager_VideoRate extends vB_DataManager
{
	/**
	 * Array of recognised and required fields for videorate, and their types
	 *
	 * @var	array
	 */
	var $validfields = array(
		'videorateid' => array(TYPE_UINT, REQ_INCR, VF_METHOD, 'verify_nonzero'),
		'videoid'     => array(TYPE_UINT, REQ_YES),
		'userid'      => array(TYPE_UINT, REQ_YES,  VF_METHOD, 'verify_userid'),
		'vote'        => array(TYPE_INT,  REQ_YES,  VF_METHOD, 'verify_vote'),
		'ipaddress'   => array(TYPE_STR,  REQ_AUTO, VF_METHOD, 'verify_ipaddress')
	);

	/**
	 * Condition for update query
	 *
	 * @var	array
	 */
	var $condition_construct = array('videorateid = %1$s', 'videorateid');

	/**
	 * The main table this class deals with
	 *
	 * @var	string
	 */
	var $table = 'videorate';

	/**
	 * The maximum vote
	 *
	 * @var	int
	 */
	var $max_vote = 5;

	/**
	 * Array to store stuff to save to videorate table
	 *
	 * @var	array
	 */
	var $videorate = array();

	/**
	 * Constructor - checks that the registry object has been passed correctly.
	 *
	 * @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	 * @param	integer		One of the ERRTYPE_x constants
	 */
	function vB_DataManager_VideoRate(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		if (!$this->condition AND $this->fetch_field('userid') == $this->registry->userinfo['userid'] AND !$this->fetch_field('ipaddress'))
		{
			$this->set('ipaddress', IPADDRESS);
		}

		if (!$this->condition AND empty($this->info['skip_dupe_check']))
		{
			if ($userid = intval($this->fetch_field('userid')))
			{
				$exists = $this->dbobject->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "videorate
					WHERE userid = $userid
						AND videoid = " . intval($this->videorate['videoid'])
				);
			}

			if ($exists)
			{
				$this->set_existing($exists);
			}
		}

		$return_value = true;
		$this->presave_called = $return_value;
		return $return_value;
	}


	/**
	 * Removing 1 from the rating count for the video entry
	 *
	 * @param	boolean	Do the query?
	 */
	function post_delete($doquery = true)
	{
		if ($this->info['video'])
		{
			$videoinfo =& $this->info['video'];
		}
		else
		{
			trigger_error('Video-Info has not been passed correctly.');
		}

		$videoman =& datamanager_init('Video', $vbulletin, ERRTYPE_SILENT);
		$videoman->set_existing($videoinfo);
		$videoman->set('ratingtotal', 'ratingtotal - ' . intval($this->fetch_field('vote')), false);
		$videoman->set('ratingnum', 'ratingnum - 1', false);
		$videoman->set('rating', 'ratingtotal / ratingnum', false);
		$videoman->save();

		return true;
	}


	/**
	 * Updating the votecount for that thread
	 *
	 * @param	boolean	Do the query?
	 */
	function post_save_each($doquery = true)
	{
		// Are we handleing a multi DM
		if (!$this->condition OR $this->existing['vote'] != $this->fetch_field('vote'))
		{
			if ($this->info['video'])
			{
				$videoinfo =& $this->info['video'];
			}
			else
			{
				trigger_error('Video-Info has not been passed correctly.');
			}

			if (!$this->condition)
			{
				// Increment the vote count for the thread that has just been voted on
				$videoman =& datamanager_init('Video', $this->registry, ERRTYPE_SILENT);
				$videoman->set_existing($videoinfo);
				$videoman->set('ratingtotal', 'ratingtotal + ' . intval($this->fetch_field('vote')), false);
				$videoman->set('ratingnum', 'ratingnum + 1', false);
				$videoman->set('rating', 'ratingtotal / ratingnum', false);
				$videoman->save();
			}
			else
			{
				// this is an update
				$votediff = $this->fetch_field('vote') - $this->existing['vote'];

				$videoman =& datamanager_init('Video', $this->registry, ERRTYPE_SILENT);
				$videoman->set_existing($videoinfo);
				$videoman->set('ratingtotal', "ratingtotal + $votediff", false);
				$videoman->set('rating', 'ratingtotal / ratingnum', false);
				$videoman->save();
			}

		}
	}


	/**
	 * Verifies that the specified user exists
	 *
	 * @param	integer	User ID
	 *
	 * @return 	boolean	Returns true if user exists
	 */
	function verify_userid(&$userid)
	{
		if ($userid == 0 OR $userid == $this->registry->userinfo['userid'] OR $this->dbobject->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid = $userid"))
		{
			return true;
		}
		else
		{
			global $vbphrase;
			$this->error('invalidid', $vbphrase['user'], $this->registry->options['contactuslink']);
			return false;
		}
	}


	/**
	 * Checks that the vote is between 0 and 5
	 *
	 * @param	integer	The vote
	 *
	 * @return	boolean	Returns true on success
	 */
	function verify_vote(&$vote)
	{
		if (is_int($vote) AND $vote >= 0 AND $vote <= $this->max_vote)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
}

?>