<?php
/*========================================================================*\
|| ###################################################################### ||
|| # Video-Directory 1.1.3 (class_dm_hosterapi.php)				# ||
|| # -------------------------------------------------------------------# ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		# ||
|| # 		With significant modification by Jason Axelrod.			# ||
|| # This file may not be redistributed in whole or significant part.	# ||
|| # -------------------------------------------------------------------# ||
|| # 												# ||
|| ###################################################################### ||
\*========================================================================*/

/**
 * Class to do data save/delete operations for Video Hoster
 *
 */

class vB_DataManager_VideoHosterApi extends vB_DataManager
{
	/**
	 * Array of recognised and required fields for video hoster
	 *
	 * @var	array
	 */
	var $validfields = array(
		'videohosterapiid'	=> array(TYPE_UINT,	REQ_INCR),
		'title'			=> array(TYPE_STR,	REQ_YES),
		'varname'			=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'classname'			=> array(TYPE_STR,	REQ_YES),
		'regex'			=> array(TYPE_STR,	REQ_YES),
		'active'			=> array(TYPE_BOOL,	REQ_NO),
		'version'			=> array(TYPE_STR,	REQ_YES),
		'settings'			=> array(TYPE_STR,	REQ_NO),
		'author'			=> array(TYPE_STR,	REQ_NO)
	);

	/**
	 * Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	 * For example: var $bitfields = array('options' => 'bf_misc_useroptions', 'permissions' => 'bf_misc_moderatorpermissions')
	 *
	 * @var	array
	 */
	var $bitfields = array();

	/**
	 * The main table this class deals with
	 *
	 * @var	string
	 */
	var $table = 'videohosterapi';

	/**
	 * Array to store stuff to save to videohosterapi table
	 *
	 * @var	array
	 */
	var $videohosterapi = array();

	/**
	 * Condition template for update query
	 *
	 * @var	array
	 */
	var $condition_construct = array('videohosterapiid = %1$d', 'videohosterapiid');

	/**
	 * Constructor - checks that the registry object has been passed correctly.
	 *
	 * @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	 * @param	integer		One of the ERRTYPE_x constants
	 */
	function vB_DataManager_VideoHosterApi(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function verify_varname(&$varname)
	{
		if (!$this->condition AND $hoster = $this->dbobject->query_first("SELECT * FROM " . TABLE_PREFIX . "videohosterapi WHERE varname = '" . $this->dbobject->escape_string($varname) . "'"))
		{
			$this->error('videodirectory_hoster_already_exists');
			return false;
		}

		return true;
	}

	function build_hoster_cache()
	{
		if ($this->info['skip_cacherebuild'])
		{
			return;
		}

		$hosters = $this->dbobject->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "videohosterapi
		");

		$cache = array();

		while ($hoster = $this->dbobject->fetch_array($hosters))
		{
			$settings = unserialize($hoster['settings']);
			unset($hoster['settings']);

			if ($settings)
			{
				foreach ($settings AS $varname => $setting)
				{
					$hoster['settings']["$varname"] = $setting['value'];
				}
			}
			$cache["$hoster[varname]"] = $hoster;
		}

		build_datastore('videohosters', serialize($cache), true);
	}

	/**
	 * Additional data to update after a save call (such as denormalized values in other tables).
	 * In batch updates, is executed for each record updated.
	 *
	 * @param	boolean	Do the query?
	 */
	function post_save_once($doquery = true)
	{
		$this->build_hoster_cache();
		return true;
	}

	/**
	 * Additional data to update after a delete call (such as denormalized values in other tables).
	 *
	 * @param	boolean	Do the query?
	 */
	function post_delete($doquery = true)
	{
		$this->build_hoster_cache();
		return true;
	}
}

?>