<?php
/*========================================================================*\
|| ###################################################################### ||
|| # Video-Directory 1.1.3 (class_dm_videocomment.php)			# ||
|| # -------------------------------------------------------------------# ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		# ||
|| # 		With significant modification by Jason Axelrod.			# ||
|| # This file may not be redistributed in whole or significant part.	# ||
|| # -------------------------------------------------------------------# ||
|| # 												# ||
|| ###################################################################### ||
\*========================================================================*/

/**
 * Class to do data save/delete operations for videocomments
 *
 */
class vB_DataManager_VideoComment extends vB_DataManager
{
	/**
	 * Array of recognised and required fields for videos
	 *
	 * @var    array
	 */
	var $validfields = array(
		'videocommentid'	=> array(TYPE_UINT,		REQ_INCR),
		'videoid'			=> array(TYPE_UINT,		REQ_YES,	VF_METHOD),
		'message'			=> array(TYPE_STR,		REQ_YES,	VF_METHOD),
		'dateline'			=> array(TYPE_UINT,		REQ_AUTO),
		'postuserid'		=> array(TYPE_UINT,		REQ_AUTO),
		'postusername'		=> array(TYPE_STR,		REQ_AUTO),
		'state'				=> array(TYPE_STR,		REQ_NO,		VF_METHOD),
		'ipaddress'			=> array(TYPE_STR,		REQ_AUTO),
	);

	/**
	 * Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	 * For example: var $bitfields = array('options' => 'bf_misc_useroptions', 'permissions' => 'bf_misc_moderatorpermissions')
	 *
	 * @var    array
	 */
	var $bitfields = array();

	/**
	 * The main table this class deals with
	 *
	 * @var    string
	 */
	var $table = 'videocomment';

	/**
	 * Condition template for update query
	 *
	 * @var    array
	 */
	var $condition_construct = array('videocommentid = %1$d', 'videocommentid');

	/**
	 * Array to store stuff to save to video table
	 *
	 * @var    array
	 */
	var $videocomment = array();

	/**
	 * Constructor - checks that the registry object has been passed correctly.
	 *
	 * @param    vB_Registry    Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	 * @param    integer        One of the ERRTYPE_x constants
	 */
	function vB_DataManager_VideoComment(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	function verify_message(&$desc)
	{
		if (!$this->registry->options['videodirectory_commentminlength'])
		{
			$this->registry->options['videodirectory_commentminlength'] = 1;
		}

		require_once(DIR . '/includes/functions_newpost.php');

		$desc = preg_replace('/&#(0*32|x0*20);/', ' ', $desc);
		$desc = trim($desc);

		// add # to color tags using hex if it's not there
		$desc = preg_replace('#\[color=(&quot;|"|\'|)([a-f0-9]{6})\\1]#i', '[color=\1#\2\1]', $desc);

		// strip alignment codes that are closed and then immediately reopened
		$desc = preg_replace('#\[/(left|center|right)]((\r\n|\r|\n)*)\[\\1]#si', '\\2', $desc);

		// censor main message text
		$desc = fetch_censored_text($desc);

		if (vbstrlen($desc) < $this->registry->options['videodirectory_commentminlength'])
		{
			$this->error('comment_too_short', vbstrlen($desc), $this->registry->options['videodirectory_commentminlength']);
			return false;
		}

		return true;
	}

	function verify_videoid(&$videoid)
	{

		if (!$videoinfo = $this->dbobject->query_first("
		SELECT video.*
		FROM " . TABLE_PREFIX . "video AS video
		WHERE video.videoid = '" . intval($videoid) . "'")
		)
		{
			$this->error('invalid_video_specified');
			return false;
		}

		return true;
	}

	function verify_state(&$state)
	{
		if (!in_array($state, array('visible', 'moderation', 'deleted')))
		{
			$state = 'moderation';
		}

		return true;
	}

	/**
	 * Additional data to update after a delete call (such as denormalized values in other tables).
	 *
	 * @param	boolean	Do the query?
	 */
	function post_delete($doquery = true)
	{
		build_video_counters($this->fetch_field('videoid'));
		return true;
	}

	/**
	 * Additional data to update after a save call (such as denormalized values in other tables).
	 * In batch updates, is executed once after all records are updated.
	 *
	 * @param	boolean	Do the query?
	 */
	function post_save_once($doquery = true)
	{
		build_video_counters($this->fetch_field('videoid'));
	}

	function pre_save($doquery = true)
	{
		if (!$this->condition)
		{
			$this->set('dateline', TIMENOW);
			$this->set('ipaddress', IPADDRESS);
			$this->set('postusername', $this->registry->userinfo['username']);
			$this->set('postuserid', $this->registry->userinfo['userid']);
		}

		return parent::pre_save($doquery);
	}
}

?>