<?php
/*==========================================================================*\
|| ######################################################################## ||
|| # Video-Directory 1.2.2 (class_dm.php)						  # ||
|| # -------------------------------------------------------------------- # ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		  # ||
|| # 		With significant modification by Jason Axelrod.			  # ||
|| # This file may not be redistributed in whole or significant part.	  # ||
|| # -------------------------------------------------------------------- # ||
|| # 												  # ||
|| ######################################################################## ||
\*==========================================================================*/

/**
* Class to do data save/delete operations for videos
*
*/
class vB_DataManager_Video extends vB_DataManager
{
	/**
    * Array of recognised and required fields for videos
    *
    * @var    array
    */
	var $validfields = array(
		'videoid'			=> array(TYPE_UINT,	REQ_INCR),
		'title'			=> array(TYPE_NOHTML,	REQ_YES,	VF_METHOD),
		'description'		=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'videourl'			=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'videocategoryid'		=> array(TYPE_UINT,	REQ_YES,	VF_METHOD),
		'timelength'		=> array(TYPE_UINT,	REQ_YES),
		'dateline'			=> array(TYPE_UINT,	REQ_AUTO),
		'userid'			=> array(TYPE_UINT,	REQ_AUTO),
		'videoservice'		=> array(TYPE_STR,	REQ_AUTO),
		'videoidservice'		=> array(TYPE_STR,	REQ_AUTO),
		'views'			=> array(TYPE_UINT,	REQ_NO),
		'commentcount'		=> array(TYPE_UINT,	REQ_NO),
		'ratingtotal'		=> array(TYPE_UINT,	REQ_NO),
		'ratingnum'			=> array(TYPE_UINT,	REQ_NO),
		'rating'			=> array(TYPE_NUM,	REQ_NO),
		'reportthreadid'		=> array(TYPE_UINT,	REQ_NO),
		'username'			=> array(TYPE_STR,	REQ_AUTO),
		'cachetags'			=> array(TYPE_STR,	REQ_YES)
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	* For example: var $bitfields = array('options' => 'bf_misc_useroptions', 'permissions' => 'bf_misc_moderatorpermissions')
	*
	* @var	array
	*/
	var $bitfields = array();

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'video';

	/**
	* Condition template for update query
	*
	* @var	array
	*/
	var $condition_construct = array('videoid = %1$d', 'videoid');

	/**
	* Array to store stuff to save to video table
	*
	* @var	array
	*/
	var $video = array();

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vB_DataManager_Video(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);
	}

	/**
	 * Verifys the Title of an Video
	 *
	 * @param	string	Title of the Video
	 *
	 * @return	boolean	Is the Title ok?
	 */
	function verify_title(&$title)
	{
		$title = trim($title);
		if (!$title)
		{
			$this->error('notitle');
			return false;
		}

		return true;
	}

	/**
	 * Verifys the Description of an Video
	 *
	 * @param	string	Description of the Video
	 *
	 * @return	boolean	Is the Description ok?
	 */
	function verify_description(&$desc)
	{
		$desc = trim($desc);

		if (strlen($desc) < $this->registry->options['videodirectory_description_minlen'])
		{
			$this->error('nodescription');
			return false;
		}

		require_once(DIR . '/includes/functions_newpost.php');

		$desc = preg_replace('/&#(0*32|x0*20);/', ' ', $desc);
		$desc = trim($desc);

		// add # to color tags using hex if it's not there
		$desc = preg_replace('#\[color=(&quot;|"|\'|)([a-f0-9]{6})\\1]#i', '[color=\1#\2\1]', $desc);

		// strip alignment codes that are closed and then immediately reopened
		$desc = preg_replace('#\[/(left|center|right)]((\r\n|\r|\n)*)\[\\1]#si', '\\2', $desc);

		// censor main message text
		$desc = fetch_censored_text($desc);

		return true;
	}

	/**
	 * Verifys the Url of the Video of an Video and checks if it may be embeded
	 *
	 * @param	string	Url
	 *
	 * @return	boolean	Is the url a valid videourl?
	 */
	function verify_videourl(&$url)
	{
		$url = trim($url);
		if (!$url OR !sizeof($this->registry->videohosters))
		{
			$this->error('invalid_url_specified');
			return false;
		}

		foreach ($this->registry->videohosters AS $varname => $hoster)
		{
			if (!$hoster['active'])
			{
				continue;
			}

			require_once(DIR . '/includes/videoserviceapi/class_' . strtolower($hoster['classname']) . '.php');
			$classname = "vB_VideoSharingService_$hoster[classname]";

			$obj =& new $classname($this->registry);

			if ($obj->verify_service($url))
			{
				if (!$obj->prepare_data())
				{
					switch($obj->fetch_error())
					{
						case VSS_ERROR_CONNECTION:
							$this->error('videoservice_connection_problems');
							return false;
							break;
						case VSS_ERROR_RESPONSE:
							$this->error('videoservice_invalid_serverresponse');
							return false;
							break;
						case VSS_ERROR_SERVICELOGIN:
							$this->error('videoservice_login_problems');
							return false;
							break;
						case VSS_ERROR_NOEMBEDING:
							$this->error('video_may_not_be_embed');
							return false;
							break;
					}
				}

				if ($video = $this->dbobject->query_first("SELECT * FROM " . TABLE_PREFIX . "video WHERE videoservice = '" . $hoster['varname'] . "' AND videoidservice = '" . $this->dbobject->escape_string($obj->fetch_videoid()) . "'"))
				{
					$this->error('video_already_exists');
					return false;
				}

				$this->set('videoservice', $varname);
				$this->set('videoidservice', $obj->fetch_videoid());
				if ($obj->fetch_thumbnailpath())
				{
					$obj->file_save_thumbnail();
				}

				$this->setr_info('hosterobj', $obj);
				$this->set_info('service', $varname);

				$hasservice = true;
				break;
			}
		}

		if (!$hasservice)
		{
			$this->error('invalid_url_specified');
			return false;
		}

		return true;
	}

	/**
	 * Verifys the ID of the Category
	 *
	 * @param	integer	ID of the Categotry
	 *
	 * @return	boolean	Is the category ok?
	 */
	function verify_videocategoryid(&$catid)
	{
		if (!$this->registry->videocats["$catid"] OR !is_member_of($this->registry->userinfo, $this->registry->videocats["$catid"]['usergroups']) OR !$this->registry->videocats["$catid"]['active'])
		{
			$this->error('invalid_video_category_specified');
			return false;
		}
		return true;
	}

	/**
	 * Any checks to run immediately before saving. If returning false, the save will not take place.
	 *
	 * @param	boolean	Do the query?
	 *
	 * @return	boolean	True on success; false if an error occurred
	 */
	function pre_save($doquery = true)
	{
		if (!$this->condition)
		{
			$this->set('dateline', TIMENOW);
			$this->set('userid', $this->registry->userinfo['userid']);
			$this->set('username', $this->registry->userinfo['username']);
		}

		return parent::pre_save($doquery);
	}
}

?>