<?php
/*==========================================================================*\
|| ######################################################################## ||
|| # Video-Directory 1.1.7 (admincp/video_admin.php)				  # ||
|| # -------------------------------------------------------------------- # ||
|| # Copyright 2007-2008 Julian Schuh. All Rights Reserved.		  # ||
|| # 		With significant modification by Jason Axelrod.			  # ||
|| # This file may not be redistributed in whole or significant part.	  # ||
|| # -------------------------------------------------------------------- # ||
|| # 												  # ||
|| ######################################################################## ||
\*==========================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('video', 'thread');
$specialtemplates = array('videocats', 'videohosters');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'modifycategories';
}

// ########################################################################

if ($_REQUEST['do'] == 'modifycategories')
{
	print_cp_header($vbphrase['manage_video_categories']);

	$cats = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "videocategory ORDER BY displayorder ASC");

	print_form_header('video_admin', 'categoryorderupdate');
	print_table_header($vbphrase['manage_video_categories'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['display_order'], $vbphrase['display_level'], $vbphrase['action']), true);

	while ($cat = $db->fetch_array($cats))
	{
		$cell = array();
		$cell[] = ($cat['active'] ? $cat['title'] : '<strike>' . $cat['title'] . '</strike>');
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$cat[videocategoryid]]\" value=\"$cat[displayorder]\" tabindex=\"1\" size=\"3\" title=\"$vbphrase[edit_display_order]\" />";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"level[$cat[videocategoryid]]\" value=\"$cat[level]\" tabindex=\"1\" size=\"3\" title=\"$vbphrase[edit_display_level]\" />";
		$cell[] = '<span class="smallfont">' . construct_link_code($vbphrase['edit'], 'video_admin.php?' . $vbulletin->session->vars['sessionhash'] . 'do=categoryedit&amp;categoryid=' . $cat['videocategoryid']) . construct_link_code($vbphrase['delete'], 'video_admin.php?' . $vbulletin->session->vars['sessionhash'] . 'do=categoryremove&amp;categoryid=' . $cat['videocategoryid']) . '</span>';

		print_cells_row($cell);
	}

	print_submit_row($vbphrase['save_display_order'], false, 4);

	echo('<br /><div class="smallfont" align="center">' . construct_link_code($vbphrase['add_video_category'], 'video_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=categoryadd') . '</span>');

	print_cp_footer();
}

// ########################################################################

if ($_REQUEST['do'] == 'categoryadd')
{
	print_cp_header($vbphrase['add_video_category']);

	print_form_header('video_admin', 'categoryinsert');
	print_table_header($vbphrase['add_video_category']);

	print_input_row($vbphrase['title'], 'title');
	print_input_row($vbphrase['display_order'], 'displayorder', 50);
	print_input_row($vbphrase['display_level'], 'level', 0);
	print_yes_no_row($vbphrase['active'], 'active');
	print_textarea_row($vbphrase['description'], 'description');
	print_membergroup_row($vbphrase['usergroups'], 'usergroups', 3);

	print_submit_row();

	print_cp_footer();
}

// ########################################################################

if ($_REQUEST['do'] == 'categoryinsert')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'title'		=> TYPE_STR,
		'active'	=> TYPE_BOOL,
		'description'	=> TYPE_STR,
		'usergroups'	=> TYPE_ARRAY_INT,
		'displayorder'	=> TYPE_INT,
		'level'		=> TYPE_INT
	));

	$dm =& datamanager_init('VideoCategory', $vbulletin, ERRTYPE_CP);
	$dm->setr('title', $vbulletin->GPC['title']);
	$dm->setr('description', $vbulletin->GPC['description']);
	$dm->setr('active', $vbulletin->GPC['active']);
	$dm->setr('displayorder', $vbulletin->GPC['displayorder']);
	$dm->setr('level', $vbulletin->GPC['level']);
	$dm->setr('usergroups', $vbulletin->GPC['usergroups']);
	$dm->save();

	define('CP_REDIRECT', 'video_admin.php?do=modifycategories');
	print_stop_message('video_category_successfully_saved');
}

// ########################################################################

if ($_REQUEST['do'] == 'categoryremove')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'categoryid'	=> TYPE_UINT
	));

	print_cp_header($vbphrase['remove_video_category']);

	print_delete_confirmation('videocategory', $vbulletin->GPC['categoryid'], 'video_admin', 'categorykill');

	print_cp_footer();
}

// ########################################################################

if ($_REQUEST['do'] == 'categoryedit')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'categoryid'	=> TYPE_UINT
	));

	if (!$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "videocategory WHERE videocategoryid = '" . $vbulletin->GPC['categoryid'] . "'"))
	{
		print_stop_message('invalid_video_category_specified');
	}

	print_cp_header($vbphrase['edit_video_category']);

	print_form_header('video_admin', 'categoryupdate');
	print_table_header($vbphrase['edt_video_category']);

	print_input_row($vbphrase['title'], 'title', $cat['title']);
	print_input_row($vbphrase['display_order'], 'displayorder', $cat['displayorder']);
	print_input_row($vbphrase['display_level'], 'level', $cat['level']);
	print_yes_no_row($vbphrase['active'], 'active', $cat['active']);
	print_textarea_row($vbphrase['description'], 'description', $cat['description']);
	print_membergroup_row($vbphrase['usergroups'], 'usergroups', 3, array('membergroupids' => $cat['usergroups']));

	construct_hidden_code('categoryid', $cat['videocategoryid']);

	print_submit_row();

	print_cp_footer();
}

// ########################################################################

if ($_REQUEST['do'] == 'categoryupdate')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'title'		=> TYPE_STR,
		'active'	=> TYPE_BOOL,
		'description'	=> TYPE_STR,
		'usergroups'	=> TYPE_ARRAY_INT,
		'displayorder'	=> TYPE_INT,
		'categoryid'	=> TYPE_UINT,
		'level'		=> TYPE_INT
	));

	if (!$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "videocategory WHERE videocategoryid = '" . $vbulletin->GPC['categoryid'] . "'"))
	{
		print_stop_message('invalid_video_category_specified');
	}

	$dm =& datamanager_init('VideoCategory', $vbulletin, ERRTYPE_CP);
	$dm->set_existing($cat);
	$dm->setr('title', $vbulletin->GPC['title']);
	$dm->setr('description', $vbulletin->GPC['description']);
	$dm->setr('active', $vbulletin->GPC['active']);
	$dm->setr('displayorder', $vbulletin->GPC['displayorder']);
	$dm->setr('level', $vbulletin->GPC['level']);
	$dm->setr('usergroups', $vbulletin->GPC['usergroups']);
	$dm->save();

	define('CP_REDIRECT', 'video_admin.php?do=modifycategories');
	print_stop_message('video_category_successfully_saved');
}

// ########################################################################

if ($_REQUEST['do'] == 'categorykill')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'videocategoryid'	=> TYPE_UINT
	));

	if (!$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "videocategory WHERE videocategoryid = '" . $vbulletin->GPC['videocategoryid'] . "'"))
	{
		print_stop_message('invalid_video_category_specified');
	}

	$dm =& datamanager_init('VideoCategory', $vbulletin, ERRTYPE_CP);
	$dm->set_existing($cat);
	$dm->delete();

	define('CP_REDIRECT', 'video_admin.php?do=modifycategories');
	print_stop_message('video_category_successfully_removed');
}

// ########################################################################

if ($_REQUEST['do'] == 'categoryorderupdate')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'order'	=> TYPE_ARRAY_INT,
		'level'	=> TYPE_ARRAY_INT
	));

	$sql = array();

	foreach ($vbulletin->videocats AS $catid => $cat)
	{
		if ($vbulletin->GPC['order']["$catid"] != $cat['displayorder'])
		{
			$sql1[] = "WHEN $catid THEN " . intval($vbulletin->GPC['order']["$catid"]);
		}
		if ($vbulletin->GPC['level']["$catid"] != $cat['level'])
		{
			$sql2[] = "WHEN $catid THEN " . intval($vbulletin->GPC['level']["$catid"]);
		}
	}

	if (sizeof($sql1))
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "videocategory SET displayorder = CASE videocategoryid " . implode(' ', $sql1) . " ELSE displayorder END;");
		$dm =& datamanager_init('VideoCategory', $vbulletin, ERRTYPE_CP);
		$dm->build_category_cache();
	}

	if (sizeof($sql2))
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "videocategory SET level = CASE videocategoryid " . implode(' ', $sql2) . " ELSE level END;");
		$dm =& datamanager_init('VideoCategory', $vbulletin, ERRTYPE_CP);
		$dm->build_category_cache();
	}

	define('CP_REDIRECT', 'video_admin.php?do=modifycategories');
	print_stop_message('saved_display_order_successfully');
}

// ########################################################################

if ($_REQUEST['do'] == 'modifyhosters')
{
	print_cp_header($vbphrase['manage_video_hosters']);

	$hosters = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "videohosterapi");

	print_form_header('', '');
	print_table_header($vbphrase['manage_video_hosters'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['version'], $vbphrase['varname'], $vbphrase['action']), true);

	while ($hoster = $db->fetch_array($hosters))
	{
		$cell = array();
		$cell[] = (!$hoster['active'] ? '<strike>' : '<b>') . $hoster['title'] . (!$hoster['active'] ? '</strike>' : '</b>');
		$cell[] = $hoster['version'];
		$cell[] = $hoster['varname'];
		$cell[] = '<span class="smallfont">' . construct_link_code($vbphrase['edit'], 'video_admin.php?' . $vbulletin->session->vars['sessionhash'] . 'do=hosteredit&amp;hosterid=' . $hoster['videohosterapiid']) . construct_link_code($vbphrase['delete'], 'video_admin.php?' . $vbulletin->session->vars['sessionhash'] . 'do=hosterremove&amp;hosterid=' . $hoster['videohosterapiid']) . construct_link_code($vbphrase['export'], 'video_admin.php?' . $vbulletin->session->vars['sessionhash'] . 'do=hosterexport&amp;hosterid=' . $hoster['videohosterapiid']) . '</span>';

		print_cells_row($cell);
	}

	print_table_footer();

	echo('<br /><div class="smallfont" align="center">' . ($vbulletin->debug ? construct_link_code($vbphrase['add_video_hoster'], 'video_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=hosteredit') : '') . construct_link_code($vbphrase['import_video_hoster'], 'video_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=hosterimport') . '</span>');

	print_cp_footer();
}

// ########################################################################

if ($_REQUEST['do'] == 'hosterremove')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'hosterid'	=> TYPE_UINT
	));

	print_cp_header($vbphrase['remove_video_hoster']);

	print_delete_confirmation('videohosterapi', $vbulletin->GPC['hosterid'], 'video_admin', 'hosterkill');

	print_cp_footer();
}

// ########################################################################

if ($_REQUEST['do'] == 'hosterkill')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'videohosterapiid'	=> TYPE_UINT
	));

	if (!$hoster = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "videohosterapi WHERE videohosterapiid = '" . $vbulletin->GPC['videohosterapiid'] . "'"))
	{
		print_stop_message('invalid_video_hoster_specified');
	}

	$dm =& datamanager_init('VideoHosterApi', $vbulletin, ERRTYPE_CP);
	$dm->set_existing($hoster);
	$dm->delete();

	$file = DIR . '/includes/videoserviceapi/class_' . strtolower($hoster['classname']) . '.php';
	if (@file_exists($file))
	{
		@unlink($file);
	}

	define('CP_REDIRECT', 'video_admin.php?do=modifyhosters');
	print_stop_message('video_hoster_successfully_removed');
}

// ########################################################################

if ($_REQUEST['do'] == 'hosteredit')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'hosterid'	=> TYPE_UINT
	));

	if ($vbulletin->GPC['hosterid'] AND !$hoster = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "videohosterapi WHERE videohosterapiid = '" . $vbulletin->GPC['hosterid'] . "'"))
	{
		print_stop_message('invalid_video_hoster_specified');
	}
	else if (!$vbulletin->GPC['hosterid'])
	{
		$hoster = array('author' => $vbulletin->userinfo['username']);

		$title = $vbphrase['add_video_hoster'];
	}
	else
	{
		$title = $vbphrase['edit_video_hoster'];
	}

	print_cp_header($title);

	print_form_header('video_admin', 'hosterupdate');
	print_table_header($title);

	print_input_row($vbphrase['varname'], 'varname', $hoster['varname']);
	print_input_row($vbphrase['title'], 'title', $hoster['title']);
	print_input_row($vbphrase['class_name'], 'classname', $hoster['classname']);
	print_input_row($vbphrase['regex'], 'regex', $hoster['regex']);
	print_input_row($vbphrase['version'], 'version', $hoster['version']);
	print_yes_no_row($vbphrase['active'], 'active', $hoster['active']);
	print_input_row($vbphrase['author'], 'author', $hoster['author']);

	if ($hoster['videohosterapiid'])
	{
		construct_hidden_code('hosterid', $hoster['videohosterapiid']);
	}

	$settings = unserialize($hoster['settings']);

	if ($settings)
	{
		print_description_row($vbphrase['hoster_specific_settings'], false, 2, 'thead');

		foreach ($settings AS $varname => $setting)
		{
			switch ($setting['type'])
			{
				case 'yesno':
					print_yes_no_row($setting['title'] . '<dfn>' . $setting['description'] . '</dfn>', 'settings[' . $setting['varname'] . ']', $setting['value']);
					break;
				case 'textarea':
					print_textarea_row($setting['title'] . '<dfn>' . $setting['description'] . '</dfn>', 'settings[' . $setting['varname'] . ']', $setting['value']);
					break;
				case '':
				case 'input':
				default:
					print_input_row($setting['title'] . '<dfn>' . $setting['description'] . '</dfn>', 'settings[' . $setting['varname'] . ']', $setting['value']);
					break;
			}
		}
	}

	print_submit_row();

	print_cp_footer();
}

// ########################################################################

if ($_REQUEST['do'] == 'hosterupdate')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'title'			=> TYPE_STR,
		'varname'		=> TYPE_STR,
		'classname'		=> TYPE_STR,
		'regex'			=> TYPE_STR,
		'hosterid'		=> TYPE_UINT,
		'active'		=> TYPE_BOOL,
		'version'		=> TYPE_STR,
		'settings'		=> TYPE_ARRAY,
		'author'		=> TYPE_STR
	));

	if ($vbulletin->GPC['hosterid'] AND !$hoster = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "videohosterapi WHERE videohosterapiid = '" . $vbulletin->GPC['hosterid'] . "'"))
	{
		print_stop_message('invalid_video_hoster_specified');
	}

	$dm =& datamanager_init('VideoHosterApi', $vbulletin, ERRTYPE_CP);
	if ($hoster)
	{
		$settings = unserialize($hoster['settings']);
		$dm->set_existing($hoster);

		foreach ($vbulletin->GPC['settings'] AS $varname => $value)
		{
			if ($settings["$varname"])
			{
				$settings["$varname"]['value'] = ($settings["$varname"]['type'] == 'yesno' ? ($value ? 1 : 0) : $value);
			}
		}

		$dm->set('settings', serialize($settings));
	}
	$dm->setr('title', $vbulletin->GPC['title']);
	$dm->setr('varname', $vbulletin->GPC['varname']);
	$dm->setr('classname', $vbulletin->GPC['classname']);
	$dm->setr('regex', $vbulletin->GPC['regex']);
	$dm->setr('active', $vbulletin->GPC['active']);
	$dm->setr('version', $vbulletin->GPC['version']);
	$dm->setr('author', $vbulletin->GPC['author']);
	$dm->save();

	define('CP_REDIRECT', 'video_admin.php?do=modifyhosters');
	print_stop_message('video_hoster_successfully_saved');
}

// ########################################################################

if ($_REQUEST['do'] == 'hosterinstall')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'frominstall'	=> TYPE_BOOL
	));

	if (!$vbulletin->GPC['frominstall'] OR !($handle = opendir(DIR . '/includes/xml')) OR sizeof($vbulletin->videohosters))
	{
		exec_header_redirect('video_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifyhosters');
		exit;
	}

	require_once(DIR . '/includes/class_xml.php');

	$apis = array();

	while (($file = readdir($handle)) !== false)
	{
		if (in_array($file, array('.', '..', 'thumbs.db')))
		{
			continue;
		}

		if (!preg_match('/videohoster-(.*)/i', $file))
		{
			continue;
		}

		if (!($xml = file_read(DIR . '/includes/xml/' . $file)))
		{
			continue;
		}

		$xmlobj = new vB_XML_Parser($xml);
		if ($xmlobj->error_no OR (!$arr = $xmlobj->parse()))
		{
			continue;
		}

		$apis["$arr[varname]"] = $arr['title'];
	}

	closedir($handle);

	print_cp_header($vbphrase['install_video_hosters']);

	print_table_start(true, '50%');
	print_table_header($vbphrase['installation_update_successfull_step1_title']);
	print_description_row($vbphrase['installation_update_successfull_step1_text']);
	print_table_footer(2, '', '', false);

	print_form_header('video_admin', 'dohosterinstall');
	print_table_header($vbphrase['install_video_hosters']);

	foreach ($apis AS $varname => $title)
	{
		print_checkbox_row($title, 'install_hosters[' . $varname . ']');
	}

	print_submit_row($vbphrase['go'], 0);

	print_cp_footer();
}

// ########################################################################

if ($_REQUEST['do'] == 'dohosterinstall')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'install_hosters'	=> TYPE_ARRAY
	));

	if (!($handle = opendir(DIR . '/includes/xml')) OR sizeof($vbulletin->videohosters))
	{
		exec_header_redirect('video_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifyhosters');
		exit;
	}

	if (!is_writable(DIR . '/includes/videoserviceapi'))
	{
		print_stop_message('hoster_api_directory_not_writable');
	}

	require_once(DIR . '/includes/class_xml.php');

	while (($file = readdir($handle)) !== false)
	{
		if (in_array($file, array('.', '..', 'thumbs.db')))
		{
			continue;
		}

		if (!preg_match('/videohoster-(.*)/i', $file))
		{
			continue;
		}

		if (!($xml = file_read(DIR . '/includes/xml/' . $file)))
		{
			continue;
		}

		$xmlobj = new vB_XML_Parser($xml);
		if ($xmlobj->error_no OR (!$arr = $xmlobj->parse()))
		{
			continue;
		}

		if (!$vbulletin->GPC['install_hosters']["$arr[varname]"])
		{
			continue;
		}

		// Create Hoster
		$dm =& datamanager_init('VideoHosterApi', $vbulletin, ERRTYPE_CP);

		$file = DIR . '/includes/videoserviceapi/class_' . strtolower($arr['classname']) . '.php';

		if (!$c = @fopen($file, 'w'))
		{
			print_stop_message('hoster_api_file_not_writable');
		}

		foreach ($arr AS $prop => $val)
		{
			if (in_array($prop, array('class_file', 'settings')))
			{
				continue;
			}

			$dm->set($prop, $val);
		}

		$settings = array();
		if ($arr['settings'])
		{
			foreach ($arr['settings']['setting'] AS $key => $setting)
			{
				$settings["$setting[varname]"] = $setting;
			}
		}

		$dm->set('settings', serialize($settings));

		if (!@fwrite($c, $arr['class_file']))
		{
			print_stop_message('hoster_api_file_not_writable');
		}
		@fclose($c);

		$dm->save();

		$hosterinstalled = true;
	}

	closedir($handle);

	define('CP_REDIRECT', 'video_admin.php?do=hostersettings&amp;frominstall=1');
	print_stop_message('videodirectory_selected_hosters_successfully_installed');
}

// ########################################################################

if ($_REQUEST['do'] == 'hostersettings')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'frominstall'	=> TYPE_BOOL
	));

	$hosters = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "videohosterapi");

	if (!$db->num_rows($hosters))
	{
		if ($vbulletin->GPC['frominstall'])
		{
			exec_header_redirect('options.php?do=options&amp;dogroup=videodirectory&amp;frominstall=1');
			exit;
		}
		else
		{
			print_stop_message('videodirectory_no_hosters_require_settings');
		}
	}

	print_cp_header($vbphrase['video_hoster_settings']);

	if ($vbulletin->GPC['frominstall'])
	{
		print_table_start(true, '50%');
		print_table_header($vbphrase['installation_update_successfull_step2_title']);
		print_description_row($vbphrase['installation_update_successfull_step2_text']);
		print_table_footer(2, '', '', false);
	}

	print_form_header('video_admin', 'hostersettingsupdate');
	print_table_header($vbphrase['video_hoster_settings']);

	while ($hoster = $db->fetch_array($hosters))
	{
		print_description_row('<a href="video_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=hosteredit&amp;hosterid=' . $hoster['videohosterapiid'] . '">' . $hoster['title'] . '</b></a>', false, 2, 'thead');

		$hoster['settings'] = unserialize($hoster['settings']);

		if (empty($hoster['settings']))
		{
			print_description_row($vbphrase['hoster_has_no_settings']);
			continue;
		}

		foreach ($hoster['settings'] AS $varname => $setting)
		{
			switch ($setting['type'])
			{
				case 'yesno':
					print_yes_no_row($setting['title'] . '<dfn>' . $setting['description'] . '</dfn>', 'settings[' . $hoster['varname'] . '][' . $setting['varname'] . ']', $setting['value']);
					break;
				case 'textarea':
					print_textarea_row($setting['title'] . '<dfn>' . $setting['description'] . '</dfn>', 'settings[' . $hoster['varname'] . '][' . $setting['varname'] . ']', $setting['value']);
					break;
				case '':
				case 'input':
				default:
					print_input_row($setting['title'] . '<dfn>' . $setting['description'] . '</dfn>', 'settings[' . $hoster['varname'] . '][' . $setting['varname'] . ']', $setting['value']);
					break;
			}
		}
	}

	construct_hidden_code('frominstall', $vbulletin->GPC['frominstall']);

	print_submit_row();

	print_cp_footer();
}

// ########################################################################

if ($_REQUEST['do'] == 'hostersettingsupdate')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'settings'		=> TYPE_ARRAY,
		'frominstall'	=> TYPE_BOOL
	));

	$hosters_query = $db->query_read("SELECT varname, settings, videohosterapiid FROM " . TABLE_PREFIX . "videohosterapi WHERE settings != ''");

	if (!$db->num_rows($hosters_query))
	{
		print_stop_message('videodirectory_no_hosters_require_settings');
	}

	$hosters = array();

	while ($hoster = $db->fetch_array($hosters_query))
	{
		$hosters["$hoster[varname]"] = $hoster;
	}

	foreach ($vbulletin->GPC['settings'] AS $hoster_varname => $settings)
	{
		if (!$hosters["$hoster_varname"])
		{
			continue;
		}

		$dm = datamanager_init('VideoHosterApi', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($hosters["$hoster_varname"]);

		$hosters["$hoster_varname"]['settings'] = unserialize($hosters["$hoster_varname"]['settings']);

		foreach ($settings AS $varname => $value)
		{
			$hosters["$hoster_varname"]['settings']["$varname"]['value'] = $value;
		}

		$dm->set('settings', serialize($hosters["$hoster_varname"]['settings']));
		$dm->set_info('skip_cacherebuild', true);
		$dm->save();
	}

	$dm =& datamanager_init('VideoHosterApi', $vbulletin, ERRTYPE_CP);
	$dm->build_hoster_cache();

	if ($vbulletin->GPC['frominstall'])
	{
		define('CP_REDIRECT', 'options.php?do=options&amp;dogroup=videodirectory&amp;frominstall=1');
	}
	else
	{
		define('CP_REDIRECT', 'video_admin.php?do=modifyhosters');
	}
	print_stop_message('video_hoster_settings_successfully_saved');
}

// ########################################################################

if ($_REQUEST['do'] == 'hosterexport')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'hosterid'	=> TYPE_UINT
	));

	if (!$hoster = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "videohosterapi WHERE videohosterapiid = '" . $vbulletin->GPC['hosterid'] . "'"))
	{
		print_stop_message('invalid_video_hoster_specified');
	}

	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_XML_Builder($vbulletin);

	$xml->add_group('videohoster', array(
		'varname' => $hoster['varname'],
		'classname' => $hoster['classname'],
		'active' => $hoster['active']
	));

	$xml->add_tag('title', $hoster['title']);
	$xml->add_tag('regex', $hoster['regex']);
	$xml->add_tag('author', $hoster['author']);
	$xml->add_tag('version', $hoster['version']);

	$con = @file_get_contents(DIR . '/includes/videoserviceapi/class_' . strtolower($hoster['classname']) . '.php');

	if (!$con)
	{
		print_stop_message('videodirectory_class_file_error');
	}

	$xml->add_tag('class_file', $con);

	$settings = unserialize($hoster['settings']);

	if ($settings)
	{
		$xml->add_group('settings');

		foreach ($settings AS $setting)
		{
			$xml->add_group('setting', array(
				'varname'	=> $setting['varname'],
				'type'		=> $setting['type']
			));

			$xml->add_tag('title', $setting['title']);
			$xml->add_tag('description', $setting['description']);

			$xml->close_group();
		}

		$xml->close_group();
	}

	$xml->close_group();

	$doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n" . $xml->output();

	require_once(DIR . '/includes/functions_file.php');
	file_download($doc, 'videohoster-' . $hoster['varname'] . '.xml', 'text/xml');
}

// ########################################################################

if ($_REQUEST['do'] == 'hosterimport')
{
	print_cp_header($vbphrase['import_video_hoster_xml_file']);

	?>
	<script type="text/javascript">
	<!--
	function js_confirm_upload(tform, filefield)
	{
		if (filefield.value == "")
		{
			return confirm("<?php echo construct_phrase($vbphrase['you_did_not_specify_a_file_to_upload'], '" + tform.serverfile.value + "'); ?>");
		}
		return true;
	}
	//-->
	</script>
	<?php

	print_form_header('video_admin', 'dohosterimport', 1, 1, 'uploadform" onsubmit="return js_confirm_upload(this, this.videofile);');
	print_table_header($vbphrase['import_video_hoster_xml_file']);

	print_upload_row($vbphrase['upload_xml_file'], 'videofile', 999999999);
	print_input_row($vbphrase['import_xml_file'], 'serverfile', './includes/xml/videohoster.xml');

	print_submit_row($vbphrase['import'], 0);

	print_cp_footer();
}

// ########################################################################

if ($_REQUEST['do'] == 'dohosterimport')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'serverfile' => TYPE_STR,
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'videofile' => TYPE_FILE
	));

	if (file_exists($vbulletin->GPC['videofile']['tmp_name']))
	{
		$xml = file_read($vbulletin->GPC['videofile']['tmp_name']);
	}
	else if (file_exists($vbulletin->GPC['serverfile']))
	{
		$xml = file_read($vbulletin->GPC['serverfile']);
	}
	else
	{
		print_stop_message('no_file_uploaded_and_no_local_file_found');
	}

	require_once(DIR . '/includes/class_xml.php');

	$xmlobj = new vB_XML_Parser($xml);
	if ($xmlobj->error_no == 1)
	{
		print_stop_message('no_xml_and_no_path');
	}

	if (!$arr = $xmlobj->parse())
	{
		print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
	}

	if (!is_writable(DIR . '/includes/videoserviceapi'))
	{
		print_stop_message('hoster_api_directory_not_writable');
	}

	$dm =& datamanager_init('VideoHosterApi', $vbulletin, ERRTYPE_CP);

	$file = DIR . '/includes/videoserviceapi/class_' . strtolower($arr['classname']) . '.php';
	if (@file_exists($file))
	{
		@unlink($file);
	}

	if (!$c = @fopen($file, 'w'))
	{
		print_stop_message('hoster_api_file_not_writable');
	}

	$hoster = ($vbulletin->videohosters["$arr[varname]"] ? $vbulletin->videohosters["$arr[varname]"] : false);

	require_once(DIR . '/includes/adminfunctions_template.php');
	if ($hoster AND is_newer_version($hoster['version'], $arr['version']))
	{
		print_stop_message('installed_version_newer_as_imported');
	}

	if ($hoster)
	{
		$dm->set_existing($hoster);
	}

	foreach ($arr AS $prop => $val)
	{
		if (in_array($prop, array('class_file', 'settings')))
		{
			continue;
		}

		$dm->set($prop, $val);
	}

	$settings = array();
	if ($arr['settings'])
	{
		foreach ($arr['settings']['setting'] AS $key => $setting)
		{
			$settings["$setting[varname]"] = $setting;
		}
	}

	$dm->set('settings', serialize($settings));

	if (!@fwrite($c, $arr['class_file']))
	{
		print_stop_message('hoster_api_file_not_writable');
	}
	@fclose($c);

	$id = $dm->save();

	if ($arr['settings'])
	{
		define('CP_REDIRECT', 'video_admin.php?do=hosteredit&amp;hosterid=' . ($hoster ? $hoster['videohosterapiid'] : $id));
	}
	else
	{
		define('CP_REDIRECT', 'video_admin.php?do=modifyhosters');
	}

	print_stop_message('video_hoster_x_successfully_imported', $arr['title']);
}

// ########################################################################

if ($_POST['do'] == 'taginsert')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'tagtext' => TYPE_NOHTML
	));

	if ($db->query_first("
		SELECT tagid
		FROM " . TABLE_PREFIX . "videotag
		WHERE tagtext = '" . $db->escape_string($vbulletin->GPC['tagtext']) . "'
	"))
	{
		print_stop_message('tag_exists');
	}

	$video = array();
	$video['videoid'] = 0;

	require_once(DIR . '/includes/functions_videotags.php');
	$valid = fetch_video_tags($video, array($vbulletin->GPC['tagtext']), $errors, false);

	if ($errors)
	{
		print_stop_message('generic_error_x', implode('<br /><br />', $errors));
	}

	if (!empty($valid))
	{
		$db->query_write("
			INSERT IGNORE INTO " . TABLE_PREFIX . "videotag
				(tagtext, dateline)
			VALUES
				('" . $db->escape_string($valid[0]) . "', " . TIMENOW . ")
		");
	}

	define('CP_REDIRECT', 'video_admin.php?do=tags');
	print_stop_message('tag_saved');
}

// ########################################################################

if ($_POST['do'] == 'tagkill')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'tag' => TYPE_ARRAY_KEYS_INT
	));

	if ($vbulletin->GPC['tag'])
	{
		$tags_result = $vbulletin->db->query_read("
			SELECT tagtext
			FROM " . TABLE_PREFIX . "videotag
			WHERE tagid IN (" . implode(',', $vbulletin->GPC['tag']) . ")
		");

		$tagstodelete = array();
		while ($tag = $vbulletin->db->fetch_array($tags_result))
		{
			$tagstodelete[] = $tag['tagtext'];
		}
		unset($tag);

		if (!empty($tagstodelete))
		{
			require_once(DIR . "/includes/functions_newpost.php");

			$threads_result = $vbulletin->db->query_read("
				SELECT DISTINCT video.*
				FROM " . TABLE_PREFIX . "videotagvideo AS videotagvideo
				INNER JOIN " . TABLE_PREFIX . "video AS video ON (video.videoid = videotagvideo.videoid)
				WHERE videotagvideo.tagid IN (" . implode(',', $vbulletin->GPC['tag']) . ")
			");
			while ($thread = $vbulletin->db->fetch_array($threads_result))
			{
				$newtags = array();
				foreach (explode(',', trim($thread['taglist'])) AS $oldtag)
				{
					$oldtag = trim($oldtag);
					if (!in_array($oldtag, $tagstodelete))
					{
						$newtags[] = $oldtag;
					}
				}

				$newtags_string = implode(', ', $newtags);
/*
				if ($newtags_string != $thread['taglist'])
				{
					// if efficiency is needed, this could be changed to a direct query
					$threaddm =& datamanager_init('Thread', $vbulletin, ERRTYPE_SILENT, 'threadpost');
					$threaddm->set_existing($thread);
					$threaddm->set('taglist', $newtags_string);
					$threaddm->save();

					unset($threaddm);
				}
*/
			}
		}

		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "videotag
			WHERE tagid IN (" . implode(',', $vbulletin->GPC['tag']) . ")
		");

		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "videotagvideo
			WHERE tagid IN (" . implode(',', $vbulletin->GPC['tag']) . ")
		");

		// need to invalidate the search and tag cloud caches
		build_datastore('tagcloud', '', 1);
		build_datastore('searchcloud', '', 1);
	}

	define('CP_REDIRECT', 'video_admin.php?do=tags');
	print_stop_message('tags_edited_successfully');
}

// ########################################################################

if ($_REQUEST['do'] == 'tags')
{
	print_cp_header($vbphrase['manage_video_tags']);

	$vbulletin->input->clean_array_gpc('r', array(
		'pagenumber' => TYPE_UINT,
		'sort'       => TYPE_NOHTML
	));

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}

	$column_count = 3;
	$max_per_column = 15;

	$perpage = $column_count * $max_per_column;
	$start = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;

	$tags = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "videotag
		ORDER BY " . ($vbulletin->GPC['sort'] == 'dateline' ? 'dateline DESC' : 'tagtext') . "
		LIMIT $start, $perpage
	");
	list($tag_count) = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "videotag", DBARRAY_NUM);

	print_form_header('video_admin', 'tagkill');
	print_table_header($vbphrase['tag_list'], 3);
	if ($db->num_rows($tags))
	{
		$columns = array();
		$counter = 0;

		// build page navigation
		$total_pages = ceil($tag_count / $perpage);
		if ($total_pages > 1)
		{
			$pagenav = '<strong>' . $vbphrase['go_to_page'] . '</strong>';
			for ($thispage = 1; $thispage <= $total_pages; $thispage++)
			{
				if ($thispage == $vbulletin->GPC['pagenumber'])
				{
					$pagenav .= " <strong>[$thispage]</strong> ";
				}
				else
				{
					$pagenav .= " <a href=\"video_admin.php?$session[sessionurl]do=tags&amp;page=$thispage\" class=\"normal\">$thispage</a> ";
				}
			}

		}
		else
		{
			$pagenav = '';
		}

		if ($vbulletin->GPC['sort'] == 'dateline')
		{
			$sort_link = '<a href="video_admin.php?do=tags">' . $vbphrase['display_alphabetically'] . '</a>';
		}
		else
		{
			$sort_link = '<a href="video_admin.php?do=tags&amp;sort=dateline">' . $vbphrase['display_newest'] . '</a>';
		}

		print_description_row(
			"<div style=\"float: $stylevar[left]\">$sort_link</div>$pagenav",
			false, 3, 'thead', 'right'
		);

		// build columns
		while ($tag = $db->fetch_array($tags))
		{
			$columnid = floor($counter++ / $max_per_column);
			$columns["$columnid"][] = '<label for="tag' . $tag['tagid'] . '_1"><input type="checkbox" name="tag[' . $tag['tagid'] . ']" id="tag' . $tag['tagid'] . '_1" value="1" tabindex="1" /> ' . $tag['tagtext'] . '</label>';
		}

		// make column values printable
		$cells = array();
		for ($i = 0; $i < $column_count; $i++)
		{
			if ($columns["$i"])
			{
				$cells[] = implode("<br />\n", $columns["$i"]);
			}
			else
			{
				$cells[] = '&nbsp;';
			}
		}

		print_column_style_code(array(
			'width: 33%',
			'width: 33%',
			'width: 34%'
		));
		print_cells_row($cells, false, false, -3);
		print_submit_row($vbphrase['delete_selected'], '', 3);
	}
	else
	{
		print_description_row($vbphrase['no_tags_defined'], false, 3, '', 'center');
		print_table_footer();
	}

	print_form_header('video_admin', 'taginsert');
	print_input_row($vbphrase['add_tag'], 'tagtext');
	print_submit_row();

	print_cp_footer();
}

?>