<?php
/*======================================================================*\
|| #################################################################### ||
|| # v3 Arcade - CyberMama`s                                     # ||
|| # Support: http://vbsupport.org/forum/showthread.php?t=33126       # ||
|| #                                                                  # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array(
	'cpuser',
	'v3arcade',
	'v3arcade_admin',
	'user'
);

$specialtemplates = array(
	'arcade_bitdef'
);
require_once('./global.php');
require_once(DIR . '/includes/v3arcade_functions.php');
require_once(DIR . '/includes/v3arcade_functions_admin.php');

// Check Admin Permissions
if (!can_administer('canadminforums'))
{
	print_cp_no_permission();
}

// ############################################################################
// CyberMama`s Mass Settings Games
// ############################################################################
if ($_REQUEST['do'] == 'massettings')
{	

	print_cp_header($vbphrase['domassgameset']);
	print_form_header('v3arcade_admin_cmaddon', 'domassgameset',false, true, 'newgameform5');
	print_table_header($vbphrase['domassgameset']);
	print_description_row($vbphrase['msvar1']);
	print_input_row($vbphrase['setids'], 'idarr', '');
    print_description_row($vbphrase['msvar2']);
	print_input_row($vbphrase['setidrange1'], 'idstart', '');
	print_input_row($vbphrase['setidrange2'], 'idend', '');
	print_description_row($vbphrase['msvar3']);
	print_select_row($vbphrase['setcat'], 'catid', fetch_arcade_cats(array()));
	print_description_row($vbphrase['msvar4']);
	print_description_row($vbphrase['msvar5']);
	print_time_row($vbphrase['start_date'], 'start', '', false);
	print_time_row($vbphrase['end_date'], 'end', '', false);
	print_table_break();
	print_table_header($vbphrase['setthis']);
	print_select_row($vbphrase['varselect'], 'varset', array('0'=>$vbphrase['idvar'],'1'=>$vbphrase['rangevar'],'2'=>$vbphrase['catvar'],'3'=>$vbphrase['zerovar'],'4'=>$vbphrase['datevar']));
	print_yes_no_row($vbphrase['active'] . $vbphrase['is_active_dfn'], 'gamepermissions[isactive]','');
	print_yes_no_row($vbphrase['disable_high_scores'], 'gamepermissions[disablescoring]', '');
	print_yes_no_row($vbphrase['show_award'], 'gamepermissions[showaward]','');
	print_yes_no_row($vbphrase['enable_challenges'], 'gamepermissions[enablechallenges]','');
	print_yes_no_row($vbphrase['use_reverse'], 'game[isreverse]', '');
	print_input_row($vbphrase['minpoststotal'], 'game[minpoststotal]', '0');
	print_input_row($vbphrase['minpostsperday'], 'game[minpostsperday]', '0');
	print_input_row($vbphrase['minpoststhisday'], 'game[minpoststhisday]', '0');
	print_input_row($vbphrase['minreglength'], 'game[minreglength]', '0');
	print_input_row($vbphrase['minrep'], 'game[minrep]','-1000');
	print_submit_row($vbphrase['start'], false);
}

// ############################################################################
// DO CyberMama`s Mass Game Settings
// ############################################################################
if ($_REQUEST['do'] == 'domassgameset')
{
		$vbulletin->input->clean_array_gpc('r', array(
		'idarr' => TYPE_NOHTML,
		'idstart' => TYPE_UINT,
		'idend' => TYPE_UINT,
		'catid' => TYPE_UINT,
		'varset' => TYPE_UINT,
		'game' => TYPE_ARRAY,
		'gamepermissions' => TYPE_ARRAY_BOOL,
		'start'      => TYPE_ARRAY_UINT,
	    'end'        => TYPE_ARRAY_UINT,
	));
	switch($vbulletin->GPC['varset'])
	{
		case '0':
	    {
			if (!empty($vbulletin->GPC['idarr']))
			{
				require_once(DIR . '/includes/functions_misc.php');
				$vbulletin->GPC['game']['gamepermissions'] = convert_array_to_bits($vbulletin->GPC['gamepermissions'], $vbulletin->bf_misc_gamepermissions);

				$db->query_write(fetch_query_sql(
				$vbulletin->GPC['game'],
				'v3arcade_games',
				('WHERE gameid IN ('. $vbulletin->GPC['idarr'].')')
												));
				 print_cp_message($vbphrase['idvar'].$vbphrase['Good']);
			     break;
		  }
		  else
	      {
			print_cp_message($vbphrase['idvar'].$vbphrase['Bad']);
			break;
		  }
	 }
	 case '1':
	 {
		 if (!empty($vbulletin->GPC['idstart']) AND !empty($vbulletin->GPC['idend']) AND ($vbulletin->GPC['idstart'] < $vbulletin->GPC['idend']))
	      {
				require_once(DIR . '/includes/functions_misc.php');
				$vbulletin->GPC['game']['gamepermissions'] = convert_array_to_bits($vbulletin->GPC['gamepermissions'], $vbulletin->bf_misc_gamepermissions);

				$db->query_write(fetch_query_sql(
				$vbulletin->GPC['game'],
				'v3arcade_games',
				('WHERE gameid >= ' .$db->escape_string($vbulletin->GPC['idstart']).' AND gameid  <= ' . $db->escape_string($vbulletin->GPC['idend']))
															));
			  	print_cp_message($vbphrase['rangevar'].$vbphrase['Good']);
			  	break;
	      }
	      else
	      {
			  print_cp_message($vbphrase['rangevar'].$vbphrase['Bad']);
			  break;
		  }
	 }
	case '2':
	{ 
		 require_once(DIR . '/includes/functions_misc.php');
		$vbulletin->GPC['game']['gamepermissions'] = convert_array_to_bits($vbulletin->GPC['gamepermissions'], $vbulletin->bf_misc_gamepermissions);

		$db->query_write(fetch_query_sql(
		$vbulletin->GPC['game'],
		'v3arcade_games',
		('WHERE categoryid = ' .$vbulletin->GPC['catid'])
											));
		 print_cp_message($vbphrase['catvar'].$vbphrase['Good']);
		 break;
	}
	case '3':
	{
		 require_once(DIR . '/includes/functions_misc.php');
		$vbulletin->GPC['game']['gamepermissions'] = convert_array_to_bits($vbulletin->GPC['gamepermissions'], $vbulletin->bf_misc_gamepermissions);

	    $db->query_write(fetch_query_sql(
		$vbulletin->GPC['game'],
		'v3arcade_games',
		('WHERE highscore = 0')
										));
		 print_cp_message($vbphrase['zerovar'].$vbphrase['Good']);
		 break;
	}
   case '4':
   {
	    require_once(DIR . '/includes/functions_misc.php');
		$startdate = vbmktime(0, 0, 0, $vbulletin->GPC['start']['month'], $vbulletin->GPC['start']['day'], $vbulletin->GPC['start']['year']);
		$enddate= vbmktime(23, 59, 59, $vbulletin->GPC['end']['month'], $vbulletin->GPC['end']['day'], $vbulletin->GPC['end']['year']);
		if ($startdate<$enddate)
		{
			$vbulletin->GPC['game']['gamepermissions'] = convert_array_to_bits($vbulletin->GPC['gamepermissions'], $vbulletin->bf_misc_gamepermissions);

			$db->query_write(fetch_query_sql(
			$vbulletin->GPC['game'],
			'v3arcade_games',
			('WHERE dateadded <= '.$enddate.' AND dateadded >='.$startdate)
												));
			print_cp_message($vbphrase['datevar'].$vbphrase['Good']);
			break;
	   }
	  else
	  {
		  print_cp_message($vbphrase['datevar'].$vbphrase['Bad']);
		  break;
	   }
  }
}
}
// ############################################################################
// CyberMama`s Mass Move AND Delete Games
// ############################################################################

if ($_REQUEST['do'] == 'masscatchange')
{

		// Mass process categories CyberMama Edition
	print_cp_header($vbphrase['mass_process_game_cats']);
	print_form_header('v3arcade_admin_cmaddon', 'domasscat',false, true, 'newgameform2');
	print_table_header($vbphrase['mass_process_game_cats']);
	print_description_row($vbphrase['mcvar1']);
	print_input_row($vbphrase['setids'], 'idarr', '');
     print_description_row($vbphrase['mcvar2']);
	print_input_row($vbphrase['setidrange1'], 'idstart', '');
	print_input_row($vbphrase['setidrange2'], 'idend', '');
	print_select_row($vbphrase['fromcat'], 'fromcatid', fetch_arcade_cats(array()));
	print_description_row($vbphrase['mcvar4']);
	print_description_row($vbphrase['mcvar5']);
	print_time_row($vbphrase['start_date'], 'start', '', false);
	print_time_row($vbphrase['end_date'], 'end','', false);
		print_table_break();
	print_select_row($vbphrase['varselect'], 'varset', array('0'=>$vbphrase['idvar'],'1'=>$vbphrase['rangevar'],'2'=>$vbphrase['catvar'],'3'=>$vbphrase['zerovar'],'4'=>$vbphrase['datevar'],'5'=>$vbphrase['catdatevar']));
	print_checkbox_row($vbphrase['delnomove'], 'isdel', '0');
	print_select_row($vbphrase['tocat'], 'catid', fetch_arcade_cats(array()));
	print_submit_row($vbphrase['start'], false);
 
}
// ############################################################################
// DO CyberMama`s Mass Move AND Delete Games
// ############################################################################

if ($_REQUEST['do'] == 'domasscat')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'idarr' => TYPE_NOHTML,
		'idstart' => TYPE_UINT,
		'idend' => TYPE_UINT,
		'fromcatid' => TYPE_UINT,
		'catid' => TYPE_UINT,
		'start'      => TYPE_ARRAY_UINT,
	'end'        => TYPE_ARRAY_UINT,
	'varset' => TYPE_UINT,
	'isdel' => TYPE_BOOL,
	));
	
		switch($vbulletin->GPC['varset'])
	{
		case '0':
	    {
			if (!empty($vbulletin->GPC['idarr']))
			{
			$idarr=array();
			$idarr=explode(',',$vbulletin->GPC['idarr']);	
				   if (!$vbulletin->GPC['isdel'])	
				   {
						$sql = $db->query_write("UPDATE ".TABLE_PREFIX."v3arcade_games SET categoryid='".$vbulletin->GPC['catid']."'
						WHERE FIND_IN_SET(gameid,'".$vbulletin->GPC['idarr']."')");
					}
					else
					{
						$sql = $db->query_write("DELETE FROM ".TABLE_PREFIX."v3arcade_games
						WHERE FIND_IN_SET(gameid,'".$vbulletin->GPC['idarr']."')");
					}
			print_cp_message($vbphrase['idvar'].$vbphrase['Good']); break;
			}
			else 
			{
			print_cp_message($vbphrase['idvar'].$vbphrase['Bad']); break;
			}
				
		}
		case '1':
	    {
			if (!empty($vbulletin->GPC['idstart']) AND !empty($vbulletin->GPC['idend']) AND ($vbulletin->GPC['idstart'] < $vbulletin->GPC['idend']))
	       {
			   if (!$vbulletin->GPC['isdel'])	
				  {
					$sql = $db->query_write("UPDATE ".TABLE_PREFIX."v3arcade_games SET categoryid='".$vbulletin->GPC['catid']."'
					WHERE gameid >='".$db->escape_string($vbulletin->GPC['idstart'])."' AND gameid <='".$db->escape_string($vbulletin->GPC['idend'])."'");
				}
				else
				{
					$sql = $db->query_write("DELETE FROM  ".TABLE_PREFIX."v3arcade_games 
					WHERE gameid >='".$db->escape_string($vbulletin->GPC['idstart'])."' AND gameid <='".$db->escape_string($vbulletin->GPC['idend'])."'");
				}
			  print_cp_message($vbphrase['rangevar'].$vbphrase['Good']);break;
	        }
	      else
	       {
	   	   print_cp_message($vbphrase['rangevar'].$vbphrase['Bad']);
			break;
	     	}
		}
		case '2':
	    {
			if (!$vbulletin->GPC['isdel'])	
				  {
					$sql = $db->query_write("UPDATE ".TABLE_PREFIX."v3arcade_games SET categoryid='".$vbulletin->GPC['catid']."'
					WHERE categoryid='".$vbulletin->GPC['fromcatid']."'");
				  }
				  else
				  {
					$sql = $db->query_write("DELETE FROM ".TABLE_PREFIX."v3arcade_games 
					WHERE categoryid='".$vbulletin->GPC['fromcatid']."'");
				  }
		   print_cp_message($vbphrase['catvar'].$vbphrase['Good']);
			break;
		}
		case '3':
	    {
			if (!$vbulletin->GPC['isdel'])	
				  {
					$sql = $db->query_write("UPDATE ".TABLE_PREFIX."v3arcade_games SET categoryid='".$vbulletin->GPC['catid']."'
					WHERE highscore=0");
				  }
				  else
				  {
					$sql = $db->query_write("DELETE FROM  ".TABLE_PREFIX."v3arcade_games
					WHERE highscore=0");
				  }
		     print_cp_message($vbphrase['zerovar'].$vbphrase['Good']);
			 break;
		}
		case '4':
	    {
			 require_once(DIR . '/includes/functions_misc.php');
			$startdate = vbmktime(0, 0, 0, $vbulletin->GPC['start']['month'], $vbulletin->GPC['start']['day'], $vbulletin->GPC['start']['year']);
			$enddate= vbmktime(23, 59, 59, $vbulletin->GPC['end']['month'], $vbulletin->GPC['end']['day'], $vbulletin->GPC['end']['year']);
			if ($startdate<$enddate)
			{
				if (!$vbulletin->GPC['isdel'])	
				  {
					$sql = $db->query_write("UPDATE ".TABLE_PREFIX."v3arcade_games SET categoryid='".$vbulletin->GPC['catid']."'
					WHERE dateadded >=".$startdate." AND dateadded <= ".$enddate."");
				  }
				  else
				  {
					  $sql = $db->query_write("DELETE FROM ".TABLE_PREFIX."v3arcade_games
					WHERE dateadded >=".$startdate." AND dateadded <= ".$enddate."");
				  }
				print_cp_message($vbphrase['datevar'].$vbphrase['Good']);
				break;
			}
			else
			{
				print_cp_message($vbphrase['datevar'].$vbphrase['Bad']);
				break;
			}
		}
		case '5':
	    {
			 require_once(DIR . '/includes/functions_misc.php');
			$startdate = vbmktime(0, 0, 0, $vbulletin->GPC['start']['month'], $vbulletin->GPC['start']['day'], $vbulletin->GPC['start']['year']);
			$enddate= vbmktime(23, 59, 59, $vbulletin->GPC['end']['month'], $vbulletin->GPC['end']['day'], $vbulletin->GPC['end']['year']);
			if ($startdate<$enddate)
			{
				if (!$vbulletin->GPC['isdel'])	
				  {
					$sql = $db->query_write("UPDATE ".TABLE_PREFIX."v3arcade_games SET categoryid='".$vbulletin->GPC['catid']."'
					WHERE categoryid='".$vbulletin->GPC['fromcatid']."' AND dateadded >=".$startdate." AND dateadded <= ".$enddate."");
				  }
				  else
				  {
					  $sql = $db->query_write("DELETE FROM ".TABLE_PREFIX."v3arcade_games
					WHERE categoryid='".$vbulletin->GPC['fromcatid']."' AND dateadded >=".$startdate." AND dateadded <= ".$enddate."");
				  }
				print_cp_message($vbphrase['catdatevar'].$vbphrase['Good']);
				break;
			}
			else
			{
				print_cp_message($vbphrase['catdatevar'].$vbphrase['Bad']);
				break;
			}
		}
	}
	
	
	
}
// ############################################################################
// CyberMama`s variant manage games
// ############################################################################
if ($_REQUEST['do'] == 'mymanagegame')
{
$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_UINT,
		'lastsearch' => TYPE_NOHTML,
		'orderby' => TYPE_NOHTML,
		'orderdir' => TYPE_NOHTML,
		'pagenumber' => TYPE_UINT,
		'perpage' => TYPE_UINT,
		'title' => TYPE_NOHTML
	));

	$showprev = false;
	$shownext = false;
	$sorturl = '';
	$orderby =& $vbulletin->GPC['orderby'];
	$orderdir =& $vbulletin->GPC['orderdir'];

	// search by title
	if ($vbulletin->GPC['title'])
	{
		$wherequery = "WHERE games.title LIKE '%" . $db->escape_string($vbulletin->GPC['title']) . "%'";
		$sorturl .= '&amp;title=' . $vbulletin->GPC['title'];
	}

	// limit by category
	if ($vbulletin->GPC['catid'])
	{
		$wherequery = 'WHERE games.categoryid = ' . $vbulletin->GPC['catid'];
		$sorturl .= '&amp;catid=' . $vbulletin->GPC['catid'];
	}

	$gamecount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "v3arcade_games AS games
		$wherequery
	");

	if (($vbulletin->GPC['pagenumber'] < 1) OR ($vbulletin->GPC['lastsearch'] != $vbulletin->GPC['title']))
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	
	if (!$vbulletin->GPC['perpage'])
	{
		$vbulletin->GPC['perpage'] = $vbulletin->options['gamesperpage'];
	}
	
	$sorturl .= '&amp;perpage=' . $vbulletin->GPC['perpage'];

	$totalpages = ceil($gamecount['total'] / $vbulletin->GPC['perpage']);
	if ($totalpages < 1)
	{
		$totalpages = 1;
	}

	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	if (!$orderby)
	{
		$orderby = 'title';
	}

	if ($orderdir != 'DESC')
	{
		$orderdir = 'ASC';
	}

	$sortarrow[$orderby] = ' <a href="v3arcade_admin_cmaddon.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mymanagegame&amp;orderby=' . $orderby . '&amp;orderdir=' . ($orderdir == 'DESC' ? 'ASC' : 'DESC') . $sorturl . '"><img src="../cpstyles/' . $vbulletin->options['cpstylefolder'] . '/move_' . ($orderdir == 'ASC' ? 'up' : 'down') . '.gif" alt="" border="0" /></a>';

	$showprev = ($vbulletin->GPC['pagenumber'] > 1);
	$shownext = ($vbulletin->GPC['pagenumber'] < $totalpages);

	$pageoptions = array();
	for ($i = 1; $i <= $totalpages; $i++)
	{
		$pageoptions[$i] = "$vbphrase[page] $i / $totalpages";
	}

	$gameoptions = array(
		'edit' => $vbphrase['edit'],
		'delete' => $vbphrase['delete']
	);

	$pagenavigation = '
		<input type="button"' . iif(!$showprev, ' disabled="disabled"') . ' class="button" value="&laquo; ' . $vbphrase['prev'] . '" tabindex="1" onclick="document.cpform.page.selectedIndex -= 1; document.cpform.submit()" />
		<select name="page" tabindex="1" onchange="document.cpform.submit()" class="bginput">' . construct_select_options($pageoptions, $vbulletin->GPC['pagenumber']) . '</select>
		<input type="button"' . iif(!$shownext, ' disabled="disabled"') . ' class="button" value="' . $vbphrase['next'] . ' &raquo;" tabindex="1" onclick="document.cpform.page.selectedIndex += 1; document.cpform.submit()" />
	';

	print_cp_header($vbphrase['arcade_games']);

	?>
<script type="text/javascript">
<!--
function js_game_jump(gameid)
{
	action = eval("document.cpform.g" + gameid + ".options[document.cpform.g" + gameid + ".selectedIndex].value");

	switch (action)
	{
		case 'edit':
			page = "editgame";
		break;

		case 'delete':
			page = "deletegame";
			confirmdelete = confirm('<?php echo $vbphrase['are_you_sure_delete_game']; ?>');

			if (confirmdelete != true)
			{
				return;
			}
		break;
	}

	document.cpform.reset();
	jumptopage = "v3arcade_admin_cmaddon.php?do=" + page + "&gameid=" + gameid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";

	window.location = jumptopage;
}
-->
</script>

	<?php

	// Game search / Pagenav / Games per page
	print_form_header('v3arcade_admin_cmaddon', 'mymanagegame', false, true, 'cpform', '90%', '', true, 'get');
	construct_hidden_code('lastsearch', $vbulletin->GPC['title']);
	construct_hidden_code('orderby', $orderby);
	construct_hidden_code('orderdir', $orderdir);
	
	echo '
	<colgroup span="5">
		<col style="white-space:nowrap"></col>
		<col></col>
		<col width="100%" align="center"></col>
		<col style="white-space:nowrap"></col>
		<col></col>
	</colgroup>
	<tr>
		<td class="thead" nowrap>' . $vbphrase['game_search'] . ':</td>
		<td class="thead"><input type="text" name="title" class="bginput" tabindex="1" value="' . $vbulletin->GPC['title'] . '" /></td>
		<td class="thead">
			' . $vbphrase['show_games_from'] . ' <select name="catid">' . construct_select_options(fetch_arcade_cats(array(0 => $vbphrase['all_categories'])), $vbulletin->GPC['catid']) . '</select>
		</td>
		<td class="thead" nowrap>' . $vbphrase['games_per_page'] . ':</td>
		<td class="thead"><input type="text" class="bginput" name="perpage" value="' . $vbulletin->GPC['perpage'] . '" tabindex="1" size="5" /></td>
		<td class="thead"><input type="submit" class="button" value=" ' . $vbphrase['go'] . ' " tabindex="1" accesskey="s" /></td>
	</tr>'; 

	print_table_footer(2, '', '', false);

	// Start the games table
	print_table_start();
	print_table_header('<span style="float: ' . $stylevar['right'] . '">' . $pagenavigation . '</span><div align="' . $stylevar['left'] . '">' . $vbphrase['arcade_games'] . '</div>', 8);

	echo '<tr valign="top" align="center">
	<td class="thead" align="left" width="1%">&nbsp;</td>
	<td class="thead" align="left"><a href="v3arcade_admin_cmaddon.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mymanagegame&amp;orderby=gameid' . $sorturl . '">ID</a>' . $sortarrow['gameid'] . '</td>
	<td class="thead" align="left"><a href="v3arcade_admin_cmaddon.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mymanagegame&amp;orderby=title' . $sorturl . '">' . $vbphrase['title'] . '</a>' . $sortarrow['title'] . '</td>
	<td class="thead"><a href="v3arcade_admin_cmaddon.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mymanagegame&amp;orderby=username' . $sorturl . '">' . $vbphrase['high_scorer'] . '</a>' . $sortarrow['username'] . '</td>
	<td class="thead"><a href="v3arcade_admin_cmaddon.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mymanagegame&amp;orderby=highscore' . $sorturl . '">' . $vbphrase['high_score'] . '</a>' . $sortarrow['highscore'] . '</td>
	<td class="thead"><a href="v3arcade_admin_cmaddon.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mymanagegame&amp;orderby=sessioncount' . $sorturl . '">' . $vbphrase['times_played'] . '</a>' . $sortarrow['sessioncount'] . '</td>
	<td class="thead"><a href="v3arcade_admin_cmaddon.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mymanagegame&amp;orderby=dateadded' . $sorturl . '">' . $vbphrase['dateadded'] . '</a>' . $sortarrow['dateadded'] . '</td>
	<td class="thead">' . $vbphrase['options'] . '</td>
</tr>';

	$games = $db->query_read("
		SELECT games.*, cats.catname, user.username
		FROM " . TABLE_PREFIX . "v3arcade_games AS games
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_categories AS cats ON (games.categoryid = cats.categoryid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.highscorerid = user.userid)
		$wherequery
		ORDER BY " . ($orderby == 'username' ? 'user' : 'games') . ".$orderby $orderdir
		LIMIT $startat, " . $vbulletin->GPC['perpage']
	);
	while ($game = $db->fetch_array($games))
	{
		$game['link'] = '<a ' . (($game['gamepermissions'] & $vbulletin->bf_misc_gamepermissions['isactive']) ? '' : 'style="text-decoration: line-through;" title="' . $vbphrase['inactive'] . '" ') . 'href="v3arcade_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editgame&amp;gameid=' . $game['gameid'] . '">' . $game['title'] . '</a>';

		print_cells_row(array(
			$game['gameid'],'<a href="'.$vbulletin->options['bburl'].'/arcade.php?do=play&gameid='.$game['gameid'].'" target="_blank"><img src="../' . $vbulletin->options['arcadeimages'] . '/' . $game['miniimage'] . '" align="absmiddle" height="' . $vbulletin->options['arcadethumbsize'] . '" width="' . $vbulletin->options['arcadethumbsize'] . '" alt=""/></a>',
			$game['link'] . '<div class="smallfont"><em>' . $game['catname'] . '</em></div>',
			($game['highscorerid'] ? 
				'<div class="smallfont"><a href="../member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $game['highscorerid'] . '" target="_blank">' . $game['username'] . '</a></div>' :
				''
			),
			vb_number_format($game['highscore']),
			vb_number_format($game['sessioncount']),
			vbdate($vbulletin->options['dateformat'].' '.$vbulletin->options['timeformat'],$game['dateadded'], true,'', false, true),
			"<select name=\"g$game[gameid]\" onchange=\"js_game_jump($game[gameid]);\" class=\"bginput\">\n" . construct_select_options($gameoptions) . "\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_game_jump($game[gameid]);\" />"
		), false, false, -1);
	}

	print_table_footer();
	
}
?>
